/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.wsdl2as;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.URI;

public class TypeNamer {
    private Map names = new HashMap();

    public String getNameFor(QName name) {
        String existing = (String)this.names.get(name);
        if (existing != null) {
            return existing;
        }
        String pkg = this.packageNameFor(name.getNamespaceURI());
        String clazz = this.classNameFor(name.getLocalPart());
        String baseName = String.valueOf(pkg) + "." + clazz;
        int count = 1;
        while (this.names.containsValue(baseName)) {
            String mangled = String.valueOf(baseName) + "_" + count++;
            if (!this.names.containsValue(baseName)) {
                this.names.put(name, baseName);
                return mangled;
            }
            if (count <= 5000) continue;
            throw new Error("Couldn't assign a unique name after 5000 iterations");
        }
        this.names.put(name, baseName);
        return baseName;
    }

    public String packageNameFor(String namespaceURI) {
        String path;
        URI uri = URI.createURI(namespaceURI);
        String name = TypeNamer.reverseJoin(TypeNamer.sanitize(uri.host().split("\\.")), ".");
        if (uri.hasPath() && (path = uri.path().replaceAll("/+", "/").replaceFirst("\\A/", "")).length() > 0) {
            name = String.valueOf(name) + "." + TypeNamer.join(TypeNamer.sanitize(path.split("/")), ".");
        }
        return name;
    }

    private String classNameFor(String localPart) {
        return TypeNamer.sanitize(localPart);
    }

    private static String[] sanitize(String[] strings) {
        int i = 0;
        while (i < strings.length) {
            strings[i] = TypeNamer.sanitize(strings[i]);
            ++i;
        }
        return strings;
    }

    public static String sanitize(String string) {
        StringBuffer result = new StringBuffer();
        if (!Character.isJavaIdentifierStart(string.charAt(0)) && Character.isJavaIdentifierPart(string.charAt(0))) {
            result.append("_");
        }
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                result.append(c);
            } else {
                result.append("_");
            }
            ++i;
        }
        return result.toString();
    }

    private static String reverseJoin(String[] strings, String delimiter) {
        StringBuffer result = new StringBuffer();
        int i = strings.length - 1;
        while (i >= 0) {
            result.append(strings[i]);
            if (i > 0) {
                result.append(delimiter);
            }
            --i;
        }
        return result.toString();
    }

    private static String join(String[] strings, String delimiter) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            if (i > 0) {
                result.append(delimiter);
            }
            result.append(strings[i]);
            ++i;
        }
        return result.toString();
    }
}

