/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.wsdl2as;

import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.wst.wsdl.internal.util.WSDLResourceFactoryImpl;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;
import uk.co.badgersinfoil.metaas.ASProject;
import uk.co.badgersinfoil.metaas.ASSourceFactory;
import uk.co.badgersinfoil.wsdl2as.ASXSDTypeMappingStrategy;
import uk.co.badgersinfoil.wsdl2as.ActionScript3Builder;
import uk.co.badgersinfoil.wsdl2as.NoTypeMappingStrategy;
import uk.co.badgersinfoil.wsdl2as.TypeMappingStrategy;

public class Main {
    public static void main(String[] args) {
        List arguments;
        CommandLine cmdLine;
        Options opts = Main.createOptions();
        String exeName = "wsdl2as";
        try {
            cmdLine = Main.parseArgs(opts, args);
        }
        catch (ParseException e) {
            Main.reportError(e);
            Main.showHelp(exeName, opts);
            System.exit(-1);
            return;
        }
        if (cmdLine.hasOption("help")) {
            Main.showHelp(exeName, opts);
            System.exit(0);
        }
        if ((arguments = cmdLine.getArgList()).isEmpty()) {
            System.err.println("A WSDL file name must be specified");
            System.exit(-1);
            return;
        }
        String wsdlFileName = (String)arguments.get(0);
        String outputDir = cmdLine.getOptionValue("o");
        String mappingStrategy = cmdLine.getOptionValue("mapping");
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("wsdl", new WSDLResourceFactoryImpl());
        try {
            Main.process(wsdlFileName, outputDir, mappingStrategy);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    private static TypeMappingStrategy createStrategy(String strategyName, ASProject project) {
        if (strategyName == null || strategyName.equals("none")) {
            return new NoTypeMappingStrategy();
        }
        if (strategyName.equals("asxsd")) {
            return new ASXSDTypeMappingStrategy(project);
        }
        throw new IllegalArgumentException("Invalid type mapping strategy: " + strategyName);
    }

    private static void process(String wsdlFileName, String outputDir, String strategyName) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        WSDLResourceImpl resource = (WSDLResourceImpl)resourceSet.createResource(URI.createURI("*.wsdl"));
        resource.setURI(URI.createURI(wsdlFileName));
        resource.load(resourceSet.getLoadOptions());
        ASSourceFactory factory = new ASSourceFactory();
        ASProject project = factory.newEmptyASProject(outputDir);
        ActionScript3Builder builder = new ActionScript3Builder(project);
        TypeMappingStrategy typeMappingStrategy = Main.createStrategy(strategyName, project);
        builder.setTypeMappingStrategy(typeMappingStrategy);
        builder.build(resource.getDefinition());
        typeMappingStrategy.commit();
    }

    private static void reportError(ParseException e) {
        System.err.println(e.toString());
    }

    private static void showHelp(String exeName, Options opts) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(exeName, opts, true);
    }

    private static CommandLine parseArgs(Options opts, String[] args) throws ParseException {
        PosixParser parser = new PosixParser();
        return parser.parse(opts, args);
    }

    private static Options createOptions() {
        Options opts = new Options();
        OptionBuilder.withLongOpt("output");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withArgName("dir");
        OptionBuilder.withDescription("Output directory for generated code");
        opts.addOption(OptionBuilder.create("o"));
        OptionBuilder.withLongOpt("mapping");
        OptionBuilder.withDescription("Strategy to map XML to AS3 values: 'none' (the default) or 'asxsd'");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("strategy");
        Option mapping = OptionBuilder.create();
        mapping.addValue("none");
        mapping.addValue("asxsd");
        opts.addOption(mapping);
        return opts;
    }
}

