/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.wsdl2as;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Element;
import uk.co.badgersinfoil.metaas.ASArg;
import uk.co.badgersinfoil.metaas.ASClassType;
import uk.co.badgersinfoil.metaas.ASField;
import uk.co.badgersinfoil.metaas.ASIfStatement;
import uk.co.badgersinfoil.metaas.ASMethod;
import uk.co.badgersinfoil.metaas.ASPackage;
import uk.co.badgersinfoil.metaas.ASProject;
import uk.co.badgersinfoil.metaas.ASSourceFactory;
import uk.co.badgersinfoil.metaas.CompilationUnit;
import uk.co.badgersinfoil.metaas.StatementContainer;
import uk.co.badgersinfoil.metaas.Visibility;
import uk.co.badgersinfoil.wsdl2as.NoTypeMappingStrategy;
import uk.co.badgersinfoil.wsdl2as.TypeMappingStrategy;
import uk.co.badgersinfoil.wsdl2as.TypeNamer;

public class ActionScript3Builder {
    private static final String NS_SOAP = "http://schemas.xmlsoap.org/wsdl/soap/";
    private TypeNamer namer = new TypeNamer();
    private TypeMappingStrategy typeMappingStrategy = new NoTypeMappingStrategy();
    private ASProject project;

    public ActionScript3Builder(ASProject project) {
        this.project = project;
    }

    public void setTypeMappingStrategy(TypeMappingStrategy typeMappingStrategy) {
        this.typeMappingStrategy = typeMappingStrategy;
    }

    public void build(Definition definition) throws IOException {
        this.initializeTypeMapping(definition);
        this.buildCallObjectClass(definition);
        this.buildAllServices(definition.getEServices());
        this.buildAllBindings(definition.getEBindings());
        this.project.writeAll();
    }

    private void initializeTypeMapping(Definition definition) {
        Types types = definition.getETypes();
        List schemas = types.getSchemas();
        Iterator i = schemas.iterator();
        while (i.hasNext()) {
            this.typeMappingStrategy.processSchema((XSDSchema)i.next());
        }
    }

    private void buildCallObjectClass(Definition definition) {
        String pkgName = this.namer.packageNameFor(definition.getTargetNamespace());
        CompilationUnit unit = this.project.newClass(String.valueOf(pkgName) + "." + "Call");
        ASPackage pkg = unit.getPackage();
        pkg.addImport("flash.events.Event");
        pkg.addImport("flash.events.IOErrorEvent");
        pkg.addImport("flash.net.URLLoader");
        pkg.addImport("flash.net.URLRequest");
        pkg.addImport("flash.net.URLRequestHeader");
        pkg.addImport("flash.net.URLRequestMethod");
        pkg.addImport("flash.net.URLRequestMethod");
        ASClassType callClass = (ASClassType)unit.getType();
        callClass.newField("request", Visibility.PRIVATE, "flash.net.URLRequest");
        callClass.newField("responseHandler", Visibility.PRIVATE, "Function");
        ASMethod ctor = callClass.newMethod("Call", Visibility.PUBLIC, null);
        ctor.addParam("endpoint", "String");
        ctor.addParam("action", "String");
        ctor.addParam("soapLiteralDocumentBody", "XML");
        ctor.addParam("responseHandler", "Function");
        ctor.addStmt("default xml namespace = \"http://schemas.xmlsoap.org/soap/envelope/\"");
        ctor.addStmt("request = new flash.net.URLRequest(endpoint)");
        ctor.addStmt("var headers:Array = [new URLRequestHeader(\"SOAPAction\", action)]");
        ctor.addStmt("request.requestHeaders = headers");
        ctor.addStmt("request.method = URLRequestMethod.POST");
        ctor.addStmt("request.contentType = " + ASSourceFactory.str("text/xml"));
        ctor.addStmt("var soapEnvelope:XML = <Envelope encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><Header/><Body/></Envelope>");
        ctor.addStmt("soapEnvelope.Body.appendChild(soapLiteralDocumentBody)");
        ctor.addStmt("request.data = soapEnvelope.toXMLString()");
        ctor.addStmt("this.responseHandler = responseHandler");
        callClass.newField("onData", Visibility.PUBLIC, "Function").setDocComment("callback used to process server answer");
        callClass.newField("onFault", Visibility.PUBLIC, "Function").setDocComment("callback used to process server errors");
        callClass.newField("onSecurityError", Visibility.PUBLIC, "Function").setDocComment("callback used to process security errors");
        ASMethod callMeth = callClass.newMethod("call", Visibility.PUBLIC, "void");
        callMeth.addStmt("var loader:flash.net.URLLoader = new flash.net.URLLoader(request)");
        callMeth.addStmt("loader.addEventListener(flash.events.Event.COMPLETE, completeHandler)");
        callMeth.addStmt("loader.addEventListener(flash.events.SecurityErrorEvent.SECURITY_ERROR, securityErrorHandler)");
        callMeth.addStmt("loader.addEventListener(flash.events.IOErrorEvent.IO_ERROR, ioErrorHandler)");
        callMeth.addStmt("loader.load(this.request)");
        ASMethod completeHandler = callClass.newMethod("completeHandler", Visibility.PRIVATE, "void");
        completeHandler.addParam("event", "flash.events.Event");
        completeHandler.addStmt("default xml namespace = \"http://schemas.xmlsoap.org/soap/envelope/\"");
        completeHandler.addStmt("var loader:URLLoader = URLLoader(event.target)");
        completeHandler.addStmt("var soapEnvelope:XML = XML(loader.data)");
        completeHandler.addStmt("var bodyElement:XML = soapEnvelope.Body[0].*[0]");
        ASIfStatement ifResponseHandler = completeHandler.newIf("responseHandler == null");
        ifResponseHandler.addComment(" indicates we spotted void return value");
        ifResponseHandler.addStmt("onData()");
        ifResponseHandler.getElse().addStmt("onData(responseHandler(bodyElement))");
        ASMethod securityErrorHandler = callClass.newMethod("securityErrorHandler", Visibility.PRIVATE, "void");
        securityErrorHandler.addParam("event", "flash.events.SecurityErrorEvent");
        securityErrorHandler.addStmt("onFault(event.text)");
        ASMethod ioErrorHandler = callClass.newMethod("ioErrorHandler", Visibility.PRIVATE, "void");
        ioErrorHandler.addParam("event", "flash.events.IOErrorEvent");
        ioErrorHandler.addStmt("onFault(event.text)");
    }

    private void buildAllServices(List services) {
        Iterator i = services.iterator();
        while (i.hasNext()) {
            this.buildService((Service)i.next());
        }
    }

    private void buildService(Service service) {
        this.buildLocator(service);
    }

    private void buildLocator(Service service) {
        String baseTypeName = this.nameFor(service.getQName());
        String locatorTypeName = String.valueOf(baseTypeName) + "Locator";
        CompilationUnit unit = this.project.newClass(locatorTypeName);
        ASClassType locator = (ASClassType)unit.getType();
        String doc = this.toDocs(service.getDocumentationElement());
        locator.setDocComment(doc);
        Iterator i = service.getEPorts().iterator();
        while (i.hasNext()) {
            Port port = (Port)i.next();
            ASField addressProp = this.buildPortAddressProperty(locator, port);
            this.buildPortLocatorMethod(locator, port, addressProp);
        }
    }

    private ASField buildPortAddressProperty(ASClassType locator, Port port) {
        String portName = TypeNamer.sanitize(port.getName());
        String addressPropertyName = String.valueOf(portName) + "Address";
        ASField addressProp = locator.newField(addressPropertyName, Visibility.PUBLIC, "String");
        String soapAddress = this.findSoapAddress(port);
        if (soapAddress != null) {
            addressProp.setInitializer(ASSourceFactory.str(soapAddress));
        }
        addressProp.setDocComment("Endpoint address for the " + port.getName() + " port.");
        return addressProp;
    }

    private void buildPortLocatorMethod(ASClassType locator, Port port, ASField addressProp) {
        String portName = TypeNamer.sanitize(port.getName());
        String getterName = "get" + portName;
        Binding binding = port.getEBinding();
        if (!this.assertDocumentSOAPStyleHTTPSOAPTransport(binding)) {
            return;
        }
        String bindingName = this.nameFor(binding.getQName());
        String stubName = String.valueOf(bindingName) + "Stub";
        ASMethod getter = locator.newMethod(getterName, Visibility.PUBLIC, stubName);
        String docs = this.toDocs(port.getDocumentationElement());
        getter.setDocComment(docs);
        String ctorArg = addressProp == null ? "" : addressProp.getName();
        getter.addStmt("return new " + stubName + "(" + ctorArg + ")");
    }

    private String findSoapAddress(Port port) {
        EList extensibilityElements = port.getEExtensibilityElements();
        Element address = ActionScript3Builder.findSoapElement(extensibilityElements, "address");
        if (address == null) {
            return null;
        }
        return address.getAttribute("location");
    }

    private static Element findSoapElement(List extensibilityElements, String name) {
        Iterator i = extensibilityElements.iterator();
        while (i.hasNext()) {
            ExtensibilityElement ext = (ExtensibilityElement)i.next();
            Element el = ext.getElement();
            if (!ActionScript3Builder.elementMatches(el, NS_SOAP, name)) continue;
            return el;
        }
        return null;
    }

    private void buildAllBindings(EList bindings) {
        int bindingCount = 0;
        Iterator i = bindings.iterator();
        while (i.hasNext()) {
            if (!this.buildBinding((Binding)i.next())) continue;
            ++bindingCount;
        }
        if (bindingCount == 0) {
            this.warn("No SOAP-1.1 bindings found");
        }
    }

    private boolean buildBinding(Binding binding) {
        if (!this.assertDocumentSOAPStyleHTTPSOAPTransport(binding)) {
            return false;
        }
        String baseTypeName = this.nameFor(binding.getQName());
        CompilationUnit unit = this.project.newClass(String.valueOf(baseTypeName) + "Stub");
        ASClassType bindingClass = (ASClassType)unit.getType();
        String docs = this.toDocs(binding.getDocumentationElement());
        bindingClass.setDocComment(docs);
        bindingClass.newField("address", Visibility.PRIVATE, "String");
        ASMethod ctor = bindingClass.newMethod(String.valueOf(TypeNamer.sanitize(binding.getQName().getLocalPart())) + "Stub", Visibility.PUBLIC, null);
        ctor.addParam("address", "String");
        ctor.addStmt("this.address = address");
        Iterator i = binding.getEBindingOperations().iterator();
        while (i.hasNext()) {
            BindingOperation operation = (BindingOperation)i.next();
            this.buildBindingOperationMethod(bindingClass, operation);
        }
        return true;
    }

    private void buildBindingOperationMethod(ASClassType bindingClass, BindingOperation operation) {
        String methodName = TypeNamer.sanitize(operation.getName());
        String returnTypeName = "Call";
        ASMethod meth = bindingClass.newMethod(methodName, Visibility.PUBLIC, returnTypeName);
        String docs = this.toDocs(operation.getDocumentationElement());
        meth.setDocComment(docs);
        this.buildOperationParameterList(meth, operation);
        Element soapOperation = ActionScript3Builder.findSoapElement(operation.getExtensibilityElements(), "operation");
        String actionStr = ASSourceFactory.str(soapOperation.getAttribute("soapAction"));
        String responseHandlerName = this.buildOperationResponseHandler(bindingClass, operation);
        meth.addStmt("return new Call(address, " + actionStr + ", parameters, " + responseHandlerName + ")");
    }

    private String buildOperationResponseHandler(ASClassType bindingClass, BindingOperation bindingOperation) {
        String returnExpr;
        String asTypeName;
        Operation portOperation = bindingOperation.getEOperation();
        Part parameters = this.findOutputParametersPart(portOperation);
        String methodName = String.valueOf(TypeNamer.sanitize(bindingOperation.getName())) + "_ResponseHandler";
        if (parameters.getElementName() != null) {
            if (this.canUseWrappedResponse(parameters, portOperation)) {
                ASMethod meth = this.buildWrappedResponseHandling(bindingClass, methodName, parameters);
                return meth == null ? null : meth.getName();
            }
            asTypeName = this.typeMappingStrategy.typeNameForElement(parameters.getElementDeclaration());
            returnExpr = this.typeMappingStrategy.convertExprFromXML("response", parameters.getElementDeclaration());
        } else {
            asTypeName = this.typeMappingStrategy.typeNameForType(parameters.getTypeDefinition());
            returnExpr = this.typeMappingStrategy.convertExprFromXML("response", parameters.getTypeDefinition());
        }
        ASMethod meth = bindingClass.newMethod(methodName, Visibility.PRIVATE, asTypeName);
        meth.addParam("response", "XML");
        meth.addStmt("return " + returnExpr);
        return methodName;
    }

    private ASMethod buildWrappedResponseHandling(ASClassType bindingClass, String methodName, Part parameters) {
        XSDElementDeclaration decl = parameters.getElementDeclaration();
        XSDTypeDefinition typeDef = decl.getTypeDefinition();
        if (!(typeDef instanceof XSDComplexTypeDefinition)) {
            throw new IllegalArgumentException("Was expecting type " + decl.getQName() + " used by part " + parameters.getName() + " to have complexType content; I don't handle other types, sorry");
        }
        XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)typeDef;
        XSDParticle cTypeParticle = complexType.getComplexType();
        if (cTypeParticle == null) {
            return null;
        }
        XSDParticleContent particleContent = cTypeParticle.getContent();
        if (!(particleContent instanceof XSDModelGroup)) {
            throw new IllegalArgumentException("Was expecting type " + decl.getQName() + " used by part " + parameters.getName() + " to have a model-group element in its complexType");
        }
        XSDModelGroup modelGroup = (XSDModelGroup)particleContent;
        if (!modelGroup.getCompositor().equals(XSDCompositor.SEQUENCE_LITERAL)) {
            throw new IllegalArgumentException("Was expecting type " + decl.getQName() + " used by part " + parameters.getName() + " to have a sequence in its complexType; other compositors aren't handled, sorry");
        }
        EList particles = modelGroup.getParticles();
        if (particles.size() != 1) {
            throw new IllegalArgumentException("Was expecting type " + decl.getQName() + " used by part " + parameters.getName() + " to have a sequence declaring exactly one element; multiple return values aren't handled, sorry");
        }
        XSDParticle part = (XSDParticle)particles.get(0);
        XSDParticleContent partContent = part.getContent();
        if (!(partContent instanceof XSDElementDeclaration)) {
            throw new IllegalArgumentException("Was expecting type " + decl.getQName() + " used by part " + parameters.getName() + " to have a sequence of elements only; other values in the sequence aren't handled, sorry");
        }
        XSDElementDeclaration wrappedElementDecl = (XSDElementDeclaration)partContent;
        String asTypeName = this.typeMappingStrategy.typeNameForElement(wrappedElementDecl);
        ASMethod meth = bindingClass.newMethod(methodName, Visibility.PRIVATE, asTypeName);
        meth.addParam("response", "XML");
        String elNameStr = ASSourceFactory.str(wrappedElementDecl.getName());
        String elNamespaceStr = ASSourceFactory.str(wrappedElementDecl.getTargetNamespace());
        String qname = "new QName(" + elNamespaceStr + ", " + elNameStr + ")";
        meth.addStmt("var wrappedElement:XML = response.elements(" + qname + ")[0]");
        meth.addStmt("return " + this.typeMappingStrategy.convertExprFromXML("wrappedElement", wrappedElementDecl));
        return meth;
    }

    private void buildOperationParameterList(ASMethod meth, BindingOperation bindingOperation) {
        String converted;
        String paramName;
        String asTypeName;
        BindingInput input = bindingOperation.getEBindingInput();
        List extensibilityElements = input.getExtensibilityElements();
        this.assertLiteralSOAPBody(bindingOperation, extensibilityElements, "input");
        Operation portOperation = bindingOperation.getEOperation();
        Part parameters = this.findInputParametersPart(portOperation);
        if (parameters.getElementName() != null) {
            if (this.canUseWrapped(parameters, portOperation)) {
                this.buildWrappedParameterHandling(meth, parameters);
                return;
            }
            asTypeName = this.typeMappingStrategy.typeNameForElement(parameters.getElementDeclaration());
            paramName = TypeNamer.sanitize(parameters.getElementName().getLocalPart());
            converted = this.typeMappingStrategy.convertExprToXML(paramName, parameters.getElementDeclaration());
        } else {
            asTypeName = this.typeMappingStrategy.typeNameForType(parameters.getTypeDefinition());
            paramName = TypeNamer.sanitize(parameters.getTypeName().getLocalPart());
            converted = this.typeMappingStrategy.convertExprToXML(paramName, parameters.getTypeDefinition());
        }
        meth.addParam(paramName, asTypeName);
        meth.addStmt("var parameters:XML = " + converted);
    }

    private Part findInputParametersPart(Operation portOperation) {
        Input portInput = portOperation.getEInput();
        Message inputMessage = portInput.getEMessage();
        EList parts = inputMessage.getEParts();
        if (parts.size() != 1) {
            throw new IllegalArgumentException("Expected exactly one input part, with name=\"parameters\" in message " + inputMessage.getQName());
        }
        return (Part)parts.get(0);
    }

    private Part findOutputParametersPart(Operation portOperation) {
        Output portOutput = portOperation.getEOutput();
        Message outputMessage = portOutput.getEMessage();
        EList parts = outputMessage.getEParts();
        if (parts.size() != 1) {
            throw new IllegalArgumentException("Expected exactly one output part, with name=\"parameters\" in message " + outputMessage.getQName());
        }
        return (Part)parts.get(0);
    }

    private void buildWrappedParameterHandling(ASMethod meth, Part parameters) {
        XSDElementDeclaration decl = parameters.getElementDeclaration();
        String nsPrefix = "ns0";
        meth.addComment(" wrapped-style parameter handling");
        meth.addStmt("var parameters:XML = <" + nsPrefix + ":" + decl.getName() + " xmlns:" + nsPrefix + "=\"" + decl.getTargetNamespace() + "\"/>");
        XSDTypeDefinition typeDef = decl.getTypeDefinition();
        if (!(typeDef instanceof XSDComplexTypeDefinition)) {
            throw new IllegalArgumentException("Was expecting type " + decl.getQName() + " used by part " + parameters.getName() + " to have complexType content; I don't handle other types, sorry (" + typeDef.getClass().getName() + ")");
        }
        XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)typeDef;
        XSDParticle cTypeParticle = complexType.getComplexType();
        if (cTypeParticle == null) {
            meth.addComment(" (no parameters)");
            return;
        }
        XSDParticleContent particleContent = cTypeParticle.getContent();
        if (!(particleContent instanceof XSDModelGroup)) {
            throw new IllegalArgumentException("Was expecting type " + decl.getQName() + " used by part " + parameters.getName() + " to have a model-group element in its complexType");
        }
        XSDModelGroup modelGroup = (XSDModelGroup)particleContent;
        if (!modelGroup.getCompositor().equals(XSDCompositor.SEQUENCE_LITERAL)) {
            throw new IllegalArgumentException("Was expecting type " + decl.getQName() + " used by part " + parameters.getName() + " to have a sequence in its complexType; other compositors aren't handled, sorry");
        }
        EList particles = modelGroup.getParticles();
        UniqueNameGenerator names = new UniqueNameGenerator();
        Iterator i = particles.iterator();
        while (i.hasNext()) {
            StatementContainer paramHandler;
            XSDParticle part = (XSDParticle)i.next();
            XSDParticleContent partContent = part.getContent();
            if (!(partContent instanceof XSDElementDeclaration)) {
                throw new IllegalArgumentException("Was expecting type " + decl.getQName() + " used by part " + parameters.getName() + " to have a sequence of elements only; other values in the sequence aren't handled, sorry");
            }
            XSDElementDeclaration paramElementDecl = (XSDElementDeclaration)partContent;
            String paramElementLocalName = paramElementDecl.isElementDeclarationReference() ? paramElementDecl.getResolvedElementDeclaration().getName() : paramElementDecl.getName();
            String paramName = names.uniqueVariationOn(paramElementLocalName);
            ASArg arg = meth.addParam(paramName, this.typeMappingStrategy.typeNameForElement(paramElementDecl));
            if (this.isOptional(part)) {
                arg.setDefault("null");
                paramHandler = meth.newIf(String.valueOf(paramName) + " != null");
            } else {
                paramHandler = meth;
            }
            String converted = this.typeMappingStrategy.convertExprToXML(paramName, paramElementDecl);
            paramHandler.addStmt("parameters.appendChild(" + converted + ")");
        }
    }

    private boolean isOptional(XSDParticle part) {
        return part.getMinOccurs() == 0;
    }

    private boolean canUseWrapped(Part parameters, Operation portOperation) {
        return parameters.getElementName().getLocalPart().equals(portOperation.getName());
    }

    private boolean canUseWrappedResponse(Part parameters, Operation portOperation) {
        if (!parameters.getElementName().getLocalPart().equals(String.valueOf(portOperation.getName()) + "Response")) {
            return false;
        }
        XSDElementDeclaration decl = parameters.getElementDeclaration();
        XSDTypeDefinition typeDef = decl.getTypeDefinition();
        if (!(typeDef instanceof XSDComplexTypeDefinition)) {
            return false;
        }
        XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)typeDef;
        XSDParticle cTypeParticle = complexType.getComplexType();
        if (cTypeParticle == null) {
            return true;
        }
        XSDParticleContent particleContent = cTypeParticle.getContent();
        if (!(particleContent instanceof XSDModelGroup)) {
            return false;
        }
        XSDModelGroup modelGroup = (XSDModelGroup)particleContent;
        if (!modelGroup.getCompositor().equals(XSDCompositor.SEQUENCE_LITERAL)) {
            return false;
        }
        EList particles = modelGroup.getParticles();
        if (particles.size() != 1) {
            return false;
        }
        XSDParticle part = (XSDParticle)particles.get(0);
        XSDParticleContent partContent = part.getContent();
        return partContent instanceof XSDElementDeclaration;
    }

    private boolean assertDocumentSOAPStyleHTTPSOAPTransport(Binding binding) {
        List extensibilityElements = binding.getExtensibilityElements();
        Element el = ActionScript3Builder.findSoapElement(extensibilityElements, "binding");
        if (el == null) {
            return false;
        }
        if (!"http://schemas.xmlsoap.org/soap/http".equals(el.getAttribute("transport"))) {
            throw new IllegalArgumentException("Expected <binding transport=\"http://schemas.xmlsoap.org/soap/http\"> for operation " + binding.getQName());
        }
        return true;
    }

    private void warn(String text) {
        System.err.println(text);
    }

    private void assertLiteralSOAPBody(BindingOperation bindingOperation, List extensibilityElements, String direction) {
        Element el = ActionScript3Builder.findSoapElement(extensibilityElements, "body");
        if (el == null) {
            throw new IllegalArgumentException("Expected extension element '{http://schemas.xmlsoap.org/wsdl/soap/}body' in <" + direction + "> for operation " + bindingOperation.getName());
        }
        if (!"literal".equals(el.getAttribute("use"))) {
            throw new IllegalArgumentException("Expected <body use=\"literal\"> in <" + direction + "> for operation " + bindingOperation.getName());
        }
    }

    private static boolean elementMatches(Element el, String namespace, String localname) {
        return localname.equals(el.getLocalName()) && namespace.equals(el.getNamespaceURI());
    }

    private String toDocs(Element doc) {
        return doc == null ? null : doc.getTextContent();
    }

    private String nameFor(QName name) {
        return this.namer.getNameFor(name);
    }

    private static class UniqueNameGenerator {
        private Set seen = new HashSet();

        private UniqueNameGenerator() {
        }

        public String uniqueVariationOn(String baseName) {
            String name = baseName;
            int seq = 2;
            while (this.seen.contains(name)) {
                name = String.valueOf(baseName) + seq++;
            }
            this.seen.add(name);
            return name;
        }
    }
}

