/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.metaas.impl.antlr;

import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListToken;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListTree;
import uk.co.badgersinfoil.metaas.impl.antlr.TreeTokenListUpdateDelegate;

public class BasicListUpdateDelegate
implements TreeTokenListUpdateDelegate {
    public void addedChild(LinkedListTree parent, LinkedListTree child) {
        LinkedListToken stop = this.findTokenInsertionPointForChildWithinParent(parent, child);
        if (parent.getStartToken() == null) {
            parent.setStartToken(child.getStartToken());
        }
        if (stop != null) {
            BasicListUpdateDelegate.insertAfter(stop, stop.getNext(), child.getStartToken(), child.getStopToken());
        }
        if (child.getStopToken() != null) {
            parent.setStopToken(child.getStopToken());
        }
    }

    private LinkedListToken findTokenInsertionPointForChildWithinParent(LinkedListTree parent, LinkedListTree child) {
        while (parent != null) {
            int index;
            if (parent.getChildCount() == 1) {
                if (parent.getStopToken() != null) {
                    return parent.getStopToken();
                }
                if (parent.getStartToken() != null) {
                    return parent.getStartToken();
                }
            }
            if ((index = parent.getIndexOfChild(child)) > 0 && index < parent.getChildCount() - 1) {
                LinkedListTree precedent = (LinkedListTree)parent.getChild(index - 1);
                if (precedent.getStopToken() == null) {
                    return this.findTokenInsertionPointForChildWithinParent(parent, precedent);
                }
                return precedent.getStopToken();
            }
            if (index == 0 && parent.getStartToken() != null) {
                return parent.getStartToken();
            }
            if (parent.getStopToken() != null) {
                return parent.getStopToken();
            }
            child = parent;
            parent = parent.getParent();
        }
        return null;
    }

    public void addedChild(LinkedListTree parent, int index, LinkedListTree child) {
        LinkedListToken target;
        LinkedListToken targetNext;
        if (index == 0) {
            targetNext = parent.getFirstChild().getStartToken();
            target = targetNext.getPrev();
        } else {
            target = ((LinkedListTree)parent.getChild(index - 1)).getStopToken();
            targetNext = target.getNext();
        }
        BasicListUpdateDelegate.insertAfter(target, targetNext, child.getStartToken(), child.getStopToken());
    }

    protected static void insertAfter(LinkedListToken target, LinkedListToken targetNext, LinkedListToken start, LinkedListToken stop) {
        if (target == null && targetNext == null) {
            throw new IllegalArgumentException("At least one of target and targetNext must be non-null");
        }
        if (start != null) {
            if (target != null) {
                target.setNext(start);
            }
            stop.setNext(targetNext);
            if (targetNext != null) {
                targetNext.setPrev(stop);
            }
        }
    }

    public void appendToken(LinkedListTree parent, LinkedListToken append) {
        if (parent.getStopToken() == null) {
            parent.setStartToken(append);
            parent.setStopToken(append);
        } else {
            append.setNext(parent.getStopToken().getNext());
            parent.getStopToken().setNext(append);
            append.setPrev(parent.getStopToken());
            parent.setStopToken(append);
        }
    }

    public void addToken(LinkedListTree parent, int index, LinkedListToken append) {
        if (parent.getStopToken() == null) {
            parent.setStartToken(append);
            parent.setStopToken(append);
        } else {
            LinkedListToken target;
            LinkedListToken targetNext;
            if (index == 0) {
                targetNext = parent.getStartToken();
                target = targetNext.getPrev();
                parent.setStartToken(append);
            } else if (index == parent.getChildCount()) {
                target = parent.getStopToken();
                targetNext = target.getNext();
                parent.setStopToken(append);
            } else {
                LinkedListTree beforeChild = (LinkedListTree)parent.getChild(index);
                targetNext = beforeChild.getStartToken();
                target = targetNext.getPrev();
            }
            BasicListUpdateDelegate.insertAfter(target, targetNext, append, append);
        }
    }

    public void deletedChild(LinkedListTree parent, int index, LinkedListTree child) {
        LinkedListToken start = child.getStartToken();
        LinkedListToken stop = child.getStopToken();
        LinkedListToken startPrev = start.getPrev();
        LinkedListToken stopNext = stop.getNext();
        if (startPrev == null) {
            throw new IllegalArgumentException("No start.prev: " + child);
        }
        if (stopNext == null) {
            throw new IllegalArgumentException("No stop.next: " + child + " (stop=" + stop + ")");
        }
        if (startPrev != null) {
            startPrev.setNext(stopNext);
        } else if (stopNext != null) {
            stopNext.setPrev(startPrev);
        }
        start.setPrev(null);
        stop.setNext(null);
    }

    public void replacedChild(LinkedListTree tree, int index, LinkedListTree child, LinkedListTree oldChild) {
        if (child.getStartToken() == null) {
            throw new IllegalArgumentException("No startToken: " + child);
        }
        if (child.getStopToken() == null) {
            throw new IllegalArgumentException("No stopToken: " + child);
        }
        LinkedListToken oldBefore = oldChild.getStartToken().getPrev();
        LinkedListToken oldAfter = oldChild.getStopToken().getNext();
        oldBefore.setNext(child.getStartToken());
        oldAfter.setPrev(child.getStopToken());
        oldChild.getStartToken().setPrev(null);
        oldChild.getStopToken().setNext(null);
        if (tree.getStartToken() == oldChild.getStartToken()) {
            tree.setStartToken(child.getStartToken());
        }
        if (tree.getStopToken() == oldChild.getStopToken()) {
            tree.setStopToken(child.getStopToken());
        }
    }
}

