/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.metaas.impl.antlr;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.IdentityHashMap;
import java.util.Map;
import org.asdt.core.internal.antlr.AS3Parser;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListToken;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListTree;

public class ASTDot {
    private PrintWriter out;
    private Map doneTokens = new IdentityHashMap();
    private int runSeq = 0;

    public ASTDot(Writer writer) {
        this.out = new PrintWriter(writer);
    }

    public void dotify(LinkedListTree ast) {
        this.println("digraph ast_diagram {");
        this.println("  node [fontsize=12];");
        this.nodeSubGraph(ast);
        this.tokenSubGraph(ast);
        this.startStopTokenEdges(ast);
        this.println("}");
    }

    private void nodeSubGraph(LinkedListTree ast) {
        this.println("  subgraph tree {");
        this.treeNodes(ast);
        this.println("  }");
    }

    private void treeNodes(LinkedListTree ast) {
        this.println("    " + this.nodeName(ast) + " [label=" + this.label(ast) + ",shape=invhouse];");
        int i = 0;
        while (i < ast.getChildCount()) {
            LinkedListTree child = (LinkedListTree)ast.getChild(i);
            this.println("    " + this.nodeName(ast) + " -> " + this.nodeName(child) + " [weight=10,style=bold];");
            this.treeNodes(child);
            ++i;
        }
    }

    private String label(LinkedListTree ast) {
        return this.label(AS3Parser.tokenNames[ast.getType()]);
    }

    private String nodeName(LinkedListTree ast) {
        return "ast_0x" + Integer.toHexString(System.identityHashCode(ast));
    }

    private void tokenSubGraph(LinkedListTree ast) {
        this.println("  subgraph cluster_tokens {");
        this.println("    rankdir=LR;");
        this.tokenNodes(ast);
        this.println("  }");
    }

    private void tokenNodes(LinkedListTree ast) {
        LinkedListToken tok = ast.getStartToken();
        while (tok != null) {
            this.tokenNode(tok);
            tok = tok.getNext();
        }
        int i = 0;
        while (i < ast.getChildCount()) {
            LinkedListTree child = (LinkedListTree)ast.getChild(i);
            this.tokenNodes(child);
            ++i;
        }
    }

    private void tokenNode(LinkedListToken tok) {
        if (this.doneTokens.containsKey(tok)) {
            return;
        }
        Integer runId = new Integer(this.runSeq++);
        this.out.print("    tok_" + runId + " [label=\"");
        while (tok != null) {
            this.out.print("<" + this.fieldName(tok) + "> " + this.label(tok));
            this.doneTokens.put(tok, runId);
            if (tok.getNext() != null) {
                this.out.print("|");
            }
            tok = tok.getNext();
        }
        this.out.println("\",shape=record];");
    }

    private String label(LinkedListToken tok) {
        if (tok.getType() == -1) {
            return "EOF";
        }
        String txt = tok.getText();
        if (txt.length() > 10) {
            txt = String.valueOf(txt.substring(0, 7)) + "...";
        }
        return "\\\"" + txt.replaceAll("\\|", "\\\\|").replaceAll("\"", "\\\\\"").replaceAll("\\{", "\\\\{").replaceAll("\\}", "\\\\}").replaceAll("<", "\\\\<").replaceAll(">", "\\\\>").replaceAll("\n", "\\\\\\\\n").replaceAll("\t", "\\\\\\\\t") + "\\\"";
    }

    private String nodeName(LinkedListToken tok) {
        return "tok_" + this.doneTokens.get(tok) + ":" + this.fieldName(tok);
    }

    private String fieldName(LinkedListToken tok) {
        return "f" + Integer.toHexString(System.identityHashCode(tok));
    }

    private void startStopTokenEdges(LinkedListTree ast) {
        if (ast.getStartToken() != null) {
            this.println("  " + this.nodeName(ast) + " -> " + this.nodeName(ast.getStartToken()) + " [minlen=2,color=green,tailport=w];");
        }
        if (ast.getStopToken() != null) {
            this.println("  " + this.nodeName(ast) + " -> " + this.nodeName(ast.getStopToken()) + " [minlen=2,color=red,tailport=e];");
        }
        int i = 0;
        while (i < ast.getChildCount()) {
            LinkedListTree child = (LinkedListTree)ast.getChild(i);
            this.startStopTokenEdges(child);
            ++i;
        }
    }

    private String label(String str) {
        if (str.length() > 15) {
            str = str.substring(0, 15);
        }
        StringBuffer res = new StringBuffer("\"");
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    res.append("\\\\n");
                    break;
                }
                case '\r': {
                    res.append("\\\\r");
                    break;
                }
                case '\t': {
                    res.append("\\\\t");
                    break;
                }
                case '\"': {
                    res.append("\\\\\\\"");
                    break;
                }
                default: {
                    res.append(c);
                }
            }
            ++i;
        }
        res.append("\"");
        return res.toString();
    }

    private void println(String txt) {
        this.out.println(txt);
    }
}

