/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.metaas.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import uk.co.badgersinfoil.metaas.ASMetaTag;
import uk.co.badgersinfoil.metaas.SyntaxException;
import uk.co.badgersinfoil.metaas.impl.ASTASMetaTag;
import uk.co.badgersinfoil.metaas.impl.ASTFactory;
import uk.co.badgersinfoil.metaas.impl.ASTIterator;
import uk.co.badgersinfoil.metaas.impl.ASTUtils;
import uk.co.badgersinfoil.metaas.impl.TokenBuilder;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListToken;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListTree;

public class TagUtils {
    public static List getAllMetaTags(LinkedListTree ast) {
        ASTIterator i = TagUtils.iterTags(ast);
        LinkedList<ASTASMetaTag> result = new LinkedList<ASTASMetaTag>();
        while (i.hasNext()) {
            result.add(TagUtils.toMetaTag(i.next()));
        }
        return Collections.unmodifiableList(result);
    }

    public static ASMetaTag getFirstMetaTag(LinkedListTree ast, String name) {
        ASTIterator i = TagUtils.iterTags(ast);
        while (i.hasNext()) {
            ASTASMetaTag tag = TagUtils.toMetaTag(i.next());
            if (!tag.getName().equals(name)) continue;
            return tag;
        }
        return null;
    }

    public static List getMetaTagWithName(LinkedListTree ast, String name) {
        ASTIterator i = TagUtils.iterTags(ast);
        LinkedList<ASTASMetaTag> result = new LinkedList<ASTASMetaTag>();
        while (i.hasNext()) {
            ASTASMetaTag tag = TagUtils.toMetaTag(i.next());
            if (!tag.getName().equals(name)) continue;
            result.add(tag);
        }
        return Collections.unmodifiableList(result);
    }

    public static ASMetaTag newMetaTag(LinkedListTree ast, String name) {
        LinkedListTree tag = ASTFactory.newMetadataTag(name);
        LinkedListToken trailingnl = TokenBuilder.newNewline();
        tag.getStopToken().afterInsert(trailingnl);
        tag.setStopToken(trailingnl);
        String indent = ASTUtils.findIndent(ast);
        if (indent.length() > 0) {
            LinkedListToken startToken = tag.getStartToken();
            LinkedListToken indentTok = TokenBuilder.newWhiteSpace(indent);
            startToken.beforeInsert(indentTok);
            tag.setStartToken(indentTok);
        }
        TagUtils.findTags(ast).addChildWithTokens(tag);
        return TagUtils.toMetaTag(tag);
    }

    private static ASTIterator iterTags(LinkedListTree ast) {
        return new ASTIterator(TagUtils.findTags(ast));
    }

    private static LinkedListTree findTags(LinkedListTree ast) {
        return ASTUtils.findChildByType(ast, 8);
    }

    private static ASTASMetaTag toMetaTag(LinkedListTree tag) {
        if (tag.getType() != 9) {
            throw new SyntaxException("Expected ANNOTATION, got " + ASTUtils.tokenName(tag));
        }
        return new ASTASMetaTag(tag);
    }
}

