/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.metaas.impl;

import uk.co.badgersinfoil.metaas.Visibility;
import uk.co.badgersinfoil.metaas.impl.ASTIterator;
import uk.co.badgersinfoil.metaas.impl.ASTUtils;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListToken;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListTree;

class ModifierUtils {
    ModifierUtils() {
    }

    public static Visibility getVisibility(LinkedListTree modifiers) {
        ASTIterator i = new ASTIterator(modifiers);
        while (i.hasNext()) {
            LinkedListTree mod = i.next();
            if (mod.getType() == 83) {
                return Visibility.PRIVATE;
            }
            if (mod.getType() != 82) continue;
            return Visibility.PUBLIC;
        }
        return Visibility.DEFAULT;
    }

    public static void setVisibility(LinkedListTree modifiers, Visibility protection) {
        LinkedListTree node;
        ASTIterator i = new ASTIterator(modifiers);
        while (i.hasNext()) {
            LinkedListTree mod = i.next();
            if (mod.getType() != 83 && mod.getType() != 82) continue;
            if (Visibility.PRIVATE == protection) {
                mod.token.setType(83);
                mod.token.setText("private");
            } else if (Visibility.PUBLIC == protection) {
                mod.token.setType(82);
                mod.token.setText("public");
            } else if (Visibility.DEFAULT == protection) {
                i.remove();
                if (modifiers.getChildCount() == 0) {
                    ModifierUtils.deleteAllChildTokens(modifiers);
                }
            }
            return;
        }
        if (Visibility.PRIVATE == protection) {
            node = ASTUtils.newAST(83, "private");
            modifiers.addChildWithTokens(node);
            return;
        }
        if (Visibility.PUBLIC == protection) {
            node = ASTUtils.newAST(82, "public");
            modifiers.addChildWithTokens(node);
            return;
        }
    }

    private static void deleteAllChildTokens(LinkedListTree modifiers) {
        LinkedListToken tok = modifiers.getStartToken();
        while (tok != null && tok != modifiers.getStopToken()) {
            LinkedListToken next = tok.getNext();
            tok.delete();
            tok = next;
        }
        modifiers.setStartToken(null);
        modifiers.setStopToken(null);
    }
}

