/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.metaas.impl;

import uk.co.badgersinfoil.metaas.impl.ASTUtils;
import uk.co.badgersinfoil.metaas.impl.TokenBuilder;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListToken;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListTree;

class DocCommentUtils {
    private DocCommentUtils() {
    }

    public static String getDocComment(LinkedListTree node) {
        LinkedListToken tok = DocCommentUtils.findDocCommentToken(node);
        if (tok == null) {
            return null;
        }
        return DocCommentUtils.commentToString(tok);
    }

    private static LinkedListToken findDocCommentToken(LinkedListTree node) {
        LinkedListToken tok = node.getStartToken();
        if (tok == null) {
            return null;
        }
        tok = tok.getPrev();
        while (tok != null) {
            switch (tok.getType()) {
                case 135: 
                case 136: {
                    break;
                }
                case 139: {
                    if (tok.getText().startsWith("/**")) {
                        return tok;
                    }
                }
                default: {
                    return null;
                }
            }
            tok = tok.getPrev();
        }
        return null;
    }

    private static String commentToString(LinkedListToken tok) {
        return tok.getText().replaceFirst("\\A/\\*+", "").replaceFirst("(?:(?<=[\n\r])[ \t]+)?\\*+/\\Z", "").replaceAll("([\n\r])\\s*\\*", "$1");
    }

    public static void setDocComment(LinkedListTree node, String text) {
        LinkedListToken tok = DocCommentUtils.findDocCommentToken(node);
        if (text == null) {
            if (tok != null) {
                LinkedListToken next = tok.getNext();
                LinkedListToken prev = tok.getPrev();
                tok.delete();
                if (next.getType() == 136) {
                    next.getNext();
                }
                if (prev.getType() == 135) {
                    prev.getPrev();
                }
            }
            return;
        }
        String indent = ASTUtils.findIndent(node);
        if (!(text = "/**" + text.replaceAll("(\n|\r\n|\r)", "$1" + indent + " *")).endsWith("*")) {
            text = String.valueOf(text) + "*";
        }
        text = String.valueOf(text) + "/";
        if (tok == null) {
            LinkedListToken comment = TokenBuilder.newMLComment(text);
            LinkedListToken nl = TokenBuilder.newNewline();
            node.getStartToken().beforeInsert(comment);
            comment.beforeInsert(nl);
            if (indent.length() > 0) {
                LinkedListToken indentTok = TokenBuilder.newWhiteSpace(indent);
                comment.beforeInsert(indentTok);
            }
        } else {
            tok.setText(text);
        }
    }

    public static void increaseCommentIndent(LinkedListToken tok, String indent) {
        tok.setText(tok.getText().replaceAll("(\n|\r\n|\r)", "$1" + indent));
    }
}

