/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.metaas.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import uk.co.badgersinfoil.metaas.ASArg;
import uk.co.badgersinfoil.metaas.ASClassType;
import uk.co.badgersinfoil.metaas.ASInterfaceType;
import uk.co.badgersinfoil.metaas.ASMember;
import uk.co.badgersinfoil.metaas.ASMethod;
import uk.co.badgersinfoil.metaas.ASPackage;
import uk.co.badgersinfoil.metaas.ASType;
import uk.co.badgersinfoil.metaas.impl.ASTASMethod;
import uk.co.badgersinfoil.metaas.impl.ASTASProject;
import uk.co.badgersinfoil.metaas.impl.ASTUtils;
import uk.co.badgersinfoil.metaas.impl.ASVisitor;
import uk.co.badgersinfoil.metaas.impl.ASWalker;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListTree;

public class AutoImporter {
    private List visibleQNames = new ArrayList();
    private Set possiblyAmbigLocalNames = new HashSet();

    public void performAutoImport(ASTASProject project) {
        this.loadAccessableLanguageElements(project);
        this.processSources(project);
    }

    private void loadAccessableLanguageElements(ASTASProject project) {
        final HashSet seenLocalNames = new HashSet();
        ASVisitor.Null visitor = new ASVisitor.Null(){

            public void visit(ASPackage pkg) {
                ASType type = pkg.getType();
                ASQName name = new ASQName(pkg.getName(), type.getName());
                AutoImporter.this.visibleQNames.add(name);
                if (seenLocalNames.contains(type.getName())) {
                    AutoImporter.this.possiblyAmbigLocalNames.add(type.getName());
                } else {
                    seenLocalNames.add(type.getName());
                }
            }
        };
        new ASWalker(visitor).walk(project);
    }

    private void processSources(ASTASProject project) {
        new ASWalker(new ImportSourceProcessor()).walk(project);
    }

    private class ImportSourceProcessor
    extends ASVisitor.Null {
        private String currentPackageName;
        private ASQName currentTypeName;
        private ASPackage currentPackage;
        private Set currentPackageImports = new HashSet();

        private ImportSourceProcessor() {
        }

        public void visit(ASPackage pkg) {
            this.currentPackage = pkg;
            this.currentPackageName = pkg.getName();
            this.inspectImports(pkg);
        }

        private void inspectImports(ASPackage pkg) {
            this.currentPackageImports.clear();
            List imports = pkg.findImports();
            Iterator i = imports.iterator();
            while (i.hasNext()) {
                ASQName imp = new ASQName((String)i.next());
                if (imp.getLocalName().equals("*")) {
                    this.importNamesFromPackage(imp.getPackagePrefix());
                    continue;
                }
                this.currentPackageImports.add(imp);
            }
        }

        private void importNamesFromPackage(String packagePrefix) {
            Iterator i = AutoImporter.this.visibleQNames.iterator();
            while (i.hasNext()) {
                ASQName name = (ASQName)i.next();
                if (!packagePrefix.equals(name.getPackagePrefix())) continue;
                this.currentPackageImports.add(name);
            }
        }

        public void visit(ASType type) {
            this.currentTypeName = new ASQName(this.currentPackageName, type.getName());
        }

        public void visit(ASClassType clazz) {
            String superClassName = clazz.getSuperclass();
            String processed = this.processTypeName(superClassName);
            if (processed != null) {
                clazz.setSuperclass(processed);
            }
            List interfaceNames = clazz.getImplementedInterfaces();
            Iterator i = interfaceNames.iterator();
            while (i.hasNext()) {
                String interfaceName = (String)i.next();
                processed = this.processTypeName(interfaceName);
                if (processed == null) continue;
                clazz.removeImplementedInterface(interfaceName);
                clazz.addImplementedInterface(processed);
            }
        }

        public void visit(ASInterfaceType iface) {
            List interfaceNames = iface.getSuperInterfaces();
            Iterator i = interfaceNames.iterator();
            while (i.hasNext()) {
                String interfaceName = (String)i.next();
                String processed = this.processTypeName(interfaceName);
                if (processed == null) continue;
                iface.removeSuperInterface(interfaceName);
                iface.addSuperInterface(processed);
            }
        }

        public void visit(ASMember member) {
            String processedName = this.processTypeName(member.getType());
            if (processedName != null) {
                member.setType(processedName);
            }
        }

        private String processTypeName(String typeName) {
            ASQName qname;
            if (typeName != null && (qname = new ASQName(typeName)).isQualified() && AutoImporter.this.visibleQNames.contains(qname)) {
                if (this.importRequired(qname)) {
                    this.addImport(qname);
                }
                if (!AutoImporter.this.possiblyAmbigLocalNames.contains(qname.getLocalName())) {
                    return qname.getLocalName();
                }
            }
            return null;
        }

        private boolean importRequired(ASQName qname) {
            if (this.currentPackageName != null && this.currentPackageName.equals(qname.getPackagePrefix())) {
                return false;
            }
            return !this.currentPackageImports.contains(qname);
        }

        private void addImport(ASQName qname) {
            this.currentPackage.addImport(qname.toString());
            this.currentPackageImports.add(qname);
        }

        public void visit(ASMethod method) {
            this.processAllArgs(method);
            this.processBody(method);
        }

        private void processAllArgs(ASMethod method) {
            List args = method.getArgs();
            Iterator i = args.iterator();
            while (i.hasNext()) {
                this.processArg((ASArg)i.next());
            }
        }

        private void processArg(ASArg arg) {
            String processedName = this.processTypeName(arg.getType());
            if (processedName != null) {
                arg.setType(processedName);
            }
        }

        private void processBody(ASMethod method) {
            LinkedListTree ast = ((ASTASMethod)method).getAST();
            LinkedListTree body = (LinkedListTree)ast.getFirstChildWithType(19);
            this.processTreeForImports(body);
        }

        private void processTreeForImports(LinkedListTree ast) {
            if (this.processNodeForImports(ast)) {
                int i = 0;
                while (i < ast.getChildCount()) {
                    LinkedListTree child = (LinkedListTree)ast.getChild(i);
                    this.processTreeForImports(child);
                    ++i;
                }
            }
        }

        private boolean processNodeForImports(LinkedListTree ast) {
            switch (ast.getType()) {
                case 18: {
                    this.processTypeSpecForImports(ast);
                    return false;
                }
                case 44: {
                    this.processIdentifierForImports(ast);
                    return false;
                }
                case 26: {
                    this.processPropertyOrIdentifierForImports(ast);
                    return false;
                }
            }
            return true;
        }

        private void processTypeSpecForImports(LinkedListTree ast) {
            String typeName = ASTUtils.typeSpecText(ast);
            String processedName = this.processTypeName(typeName);
            if (processedName != null) {
                LinkedListTree newTypeSpec = ASTUtils.newTypeSpec(processedName);
                ast.setChildWithTokens(0, newTypeSpec.getFirstChild());
            }
        }

        private void processIdentifierForImports(LinkedListTree ast) {
            System.out.println(ASTUtils.identText(ast));
        }

        private ASQName processPropertyOrIdentifierForImports(LinkedListTree ast) {
            LinkedListTree target = ast.getFirstChild();
            LinkedListTree name = ast.getLastChild();
            if (name.getType() != 54) {
                return null;
            }
            ASQName qname = null;
            if (target.getType() == 26) {
                ASQName tmp = this.processPropertyOrIdentifierForImports(target);
                if (tmp != null) {
                    qname = new ASQName(tmp.toString(), name.getText());
                }
            } else if (target.getType() == 54) {
                qname = new ASQName(target.getText(), name.getText());
            }
            if (qname == null) {
                ast.token.setType(27);
            } else {
                String processedName = this.processTypeName(qname.toString());
                if (processedName != null) {
                    int myIndex = ast.getParent().getIndexOfChild(ast);
                    ast.getParent().setChildWithTokens(myIndex, ASTUtils.newAST(54, processedName));
                    qname = null;
                }
            }
            return qname;
        }
    }

    private static class ASQName {
        private String packagePrefix;
        private String localName;

        public ASQName(String packagePrefix, String localName) {
            this.packagePrefix = packagePrefix;
            this.localName = localName;
        }

        public boolean isQualified() {
            return this.packagePrefix != null;
        }

        public ASQName(String qname) {
            int pos = qname.lastIndexOf(46);
            if (pos != -1) {
                this.packagePrefix = qname.substring(0, pos);
                this.localName = qname.substring(pos + 1);
            } else {
                this.packagePrefix = null;
                this.localName = qname;
            }
        }

        public String getLocalName() {
            return this.localName;
        }

        public void setLocalName(String localName) {
            this.localName = localName;
        }

        public String getPackagePrefix() {
            return this.packagePrefix;
        }

        public void setPackagePrefix(String packagePrefix) {
            this.packagePrefix = packagePrefix;
        }

        public String toString() {
            if (this.isQualified()) {
                return String.valueOf(this.packagePrefix) + "." + this.localName;
            }
            return this.localName;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.localName == null ? 0 : this.localName.hashCode());
            result = 31 * result + (this.packagePrefix == null ? 0 : this.packagePrefix.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ASQName other = (ASQName)obj;
            if (this.localName == null ? other.localName != null : !this.localName.equals(other.localName)) {
                return false;
            }
            return !(this.packagePrefix == null ? other.packagePrefix != null : !this.packagePrefix.equals(other.packagePrefix));
        }
    }
}

