/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.metaas.impl;

import java.util.Iterator;
import uk.co.badgersinfoil.metaas.ASClassType;
import uk.co.badgersinfoil.metaas.ASField;
import uk.co.badgersinfoil.metaas.ASInterfaceType;
import uk.co.badgersinfoil.metaas.ASMember;
import uk.co.badgersinfoil.metaas.ASMethod;
import uk.co.badgersinfoil.metaas.ASPackage;
import uk.co.badgersinfoil.metaas.ASProject;
import uk.co.badgersinfoil.metaas.ASType;
import uk.co.badgersinfoil.metaas.CompilationUnit;
import uk.co.badgersinfoil.metaas.impl.ASTCompilationUnit;
import uk.co.badgersinfoil.metaas.impl.ASVisitor;

public class ASWalker {
    private ASVisitor visitor;

    public ASWalker(ASVisitor visitor) {
        this.visitor = visitor;
    }

    public void walk(ASProject project) {
        this.visitor.visit(project);
        Iterator i = project.getCompilationUnits().iterator();
        while (i.hasNext()) {
            ASTCompilationUnit cu = (ASTCompilationUnit)i.next();
            this.walk(cu);
        }
    }

    public void walk(CompilationUnit cu) {
        this.visitor.visit(cu);
        this.walk(cu.getPackage());
    }

    public void walk(ASPackage pkg) {
        this.visitor.visit(pkg);
        this.walk(pkg.getType());
    }

    public void walk(ASType type) {
        this.visitor.visit(type);
        if (type instanceof ASClassType) {
            this.walk((ASClassType)type);
        }
        if (type instanceof ASInterfaceType) {
            this.walk((ASInterfaceType)type);
        }
    }

    public void walk(ASClassType clazz) {
        this.visitor.visit(clazz);
        Iterator i = clazz.getMethods().iterator();
        while (i.hasNext()) {
            ASMethod method = (ASMethod)i.next();
            this.walk((ASMember)method);
            this.walk(method);
        }
        i = clazz.getFields().iterator();
        while (i.hasNext()) {
            ASField field = (ASField)i.next();
            this.walk((ASMember)field);
            this.walk(field);
        }
    }

    public void walk(ASInterfaceType iface) {
        this.visitor.visit(iface);
        Iterator i = iface.getMethods().iterator();
        while (i.hasNext()) {
            ASMethod method = (ASMethod)i.next();
            this.walk((ASMember)method);
            this.walk(method);
        }
    }

    public void walk(ASMember member) {
        this.visitor.visit(member);
    }

    public void walk(ASMethod method) {
        this.visitor.visit(method);
    }

    public void walk(ASField field) {
        this.visitor.visit(field);
    }
}

