/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.metaas.impl;

import org.antlr.runtime.RecognitionException;
import org.asdt.core.internal.antlr.AS3Parser;
import uk.co.badgersinfoil.metaas.ASBlock;
import uk.co.badgersinfoil.metaas.ASIfStatement;
import uk.co.badgersinfoil.metaas.ASSwitchStatement;
import uk.co.badgersinfoil.metaas.StatementContainer;
import uk.co.badgersinfoil.metaas.SyntaxException;
import uk.co.badgersinfoil.metaas.impl.ASTASIfStatement;
import uk.co.badgersinfoil.metaas.impl.ASTASSwitchStatement;
import uk.co.badgersinfoil.metaas.impl.ASTFactory;
import uk.co.badgersinfoil.metaas.impl.ASTUtils;
import uk.co.badgersinfoil.metaas.impl.TokenBuilder;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListToken;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListTree;

public class ASTStatementList
implements ASBlock {
    private LinkedListTree ast;

    public ASTStatementList(LinkedListTree ast) {
        this.ast = ast;
    }

    public void addStmt(String statement) {
        LinkedListTree stmt;
        AS3Parser parser = ASTUtils.parse(String.valueOf(statement) + ";;");
        try {
            stmt = ASTUtils.tree(parser.statement());
        }
        catch (RecognitionException e) {
            throw ASTUtils.buildSyntaxException(statement, parser, e);
        }
        stmt.getStopToken().setNext(null);
        this.addStatement(stmt);
    }

    public void addComment(String text) {
        LinkedListToken comment = TokenBuilder.newSLComment("//" + text);
        String indent = this.findIndentForComment();
        this.ast.appendToken(TokenBuilder.newNewline());
        this.ast.appendToken(TokenBuilder.newWhiteSpace(indent));
        this.ast.appendToken(comment);
    }

    private String findIndentForComment() {
        LinkedListTree last = this.ast.getLastChild();
        String indent = last == null ? "\t" + ASTUtils.findIndent(this.ast) : ASTUtils.findIndent(last);
        return indent;
    }

    public ASIfStatement newIf(String condition) {
        LinkedListTree ifStmt = ASTUtils.newAST(68, "if");
        ifStmt.appendToken(TokenBuilder.newSpace());
        ifStmt.addChildWithTokens(ASTUtils.parseCondition(condition));
        ifStmt.appendToken(TokenBuilder.newSpace());
        ifStmt.addChildWithTokens(ASTFactory.newBlock());
        this.addStatement(ifStmt);
        return new ASTASIfStatement(ifStmt);
    }

    private LinkedListTree parseForInit(String expr) {
        AS3Parser parser = ASTUtils.parse(String.valueOf(expr) + ";");
        try {
            return ASTUtils.tree(parser.forInit());
        }
        catch (RecognitionException e) {
            throw new SyntaxException(e);
        }
    }

    private LinkedListTree parseForCond(String expr) {
        AS3Parser parser = ASTUtils.parse(String.valueOf(expr) + ";");
        try {
            return ASTUtils.tree(parser.forCond());
        }
        catch (RecognitionException e) {
            throw new SyntaxException(e);
        }
    }

    private LinkedListTree parseForIter(String expr) {
        AS3Parser parser = ASTUtils.parse(String.valueOf(expr) + ")");
        try {
            return ASTUtils.tree(parser.forIter());
        }
        catch (RecognitionException e) {
            throw new SyntaxException(e);
        }
    }

    public StatementContainer newFor(String init, String condition, String iterate) {
        LinkedListTree forStmt = ASTUtils.newAST(74, "for");
        forStmt.appendToken(TokenBuilder.newSpace());
        forStmt.appendToken(TokenBuilder.newLParen());
        if (init != null) {
            forStmt.addChildWithTokens(this.parseForInit(init));
        } else {
            LinkedListTree initStmt = ASTUtils.newAST(39);
            forStmt.addChildWithTokens(initStmt);
        }
        forStmt.appendToken(TokenBuilder.newSemi());
        forStmt.appendToken(TokenBuilder.newSpace());
        if (condition != null) {
            forStmt.addChildWithTokens(this.parseForCond(condition));
        } else {
            LinkedListTree condStmt = ASTUtils.newAST(40);
            forStmt.addChildWithTokens(condStmt);
        }
        forStmt.appendToken(TokenBuilder.newSemi());
        forStmt.appendToken(TokenBuilder.newSpace());
        if (iterate != null) {
            forStmt.addChildWithTokens(this.parseForIter(iterate));
        } else {
            LinkedListTree iterStmt = ASTUtils.newAST(41);
            forStmt.addChildWithTokens(iterStmt);
        }
        forStmt.appendToken(TokenBuilder.newRParen());
        forStmt.appendToken(TokenBuilder.newSpace());
        LinkedListTree block = ASTFactory.newBlock();
        forStmt.addChildWithTokens(block);
        this.addStatement(forStmt);
        return new ASTStatementList(block);
    }

    private LinkedListTree parseDeclaration(String decl) {
        AS3Parser parser = ASTUtils.parse(String.valueOf(decl) + ";");
        try {
            return ASTUtils.tree(parser.declaration());
        }
        catch (RecognitionException e) {
            throw new SyntaxException(e);
        }
    }

    public StatementContainer newForIn(String declaration, String expression) {
        LinkedListTree forStmt = ASTUtils.newAST(74, "for");
        forStmt.appendToken(TokenBuilder.newSpace());
        this.genForInSetup(forStmt, declaration, expression);
        forStmt.appendToken(TokenBuilder.newSpace());
        LinkedListTree block = ASTFactory.newBlock();
        forStmt.addChildWithTokens(block);
        this.addStatement(forStmt);
        return new ASTStatementList(block);
    }

    public StatementContainer newForEachIn(String declaration, String expression) {
        LinkedListTree forStmt = ASTUtils.newAST(42, "for");
        forStmt.appendToken(TokenBuilder.newSpace());
        forStmt.appendToken(TokenBuilder.newEach());
        this.genForInSetup(forStmt, declaration, expression);
        forStmt.appendToken(TokenBuilder.newSpace());
        LinkedListTree block = ASTFactory.newBlock();
        forStmt.addChildWithTokens(block);
        this.addStatement(forStmt);
        return new ASTStatementList(block);
    }

    private void genForInSetup(LinkedListTree forStmt, String declaration, String expression) {
        forStmt.appendToken(TokenBuilder.newLParen());
        forStmt.addChildWithTokens(this.parseDeclaration(declaration));
        forStmt.appendToken(TokenBuilder.newSpace());
        forStmt.appendToken(TokenBuilder.newIn());
        forStmt.appendToken(TokenBuilder.newSpace());
        forStmt.addChildWithTokens(ASTUtils.parseExpr(expression));
        forStmt.appendToken(TokenBuilder.newRParen());
    }

    public StatementContainer newWhile(String condition) {
        LinkedListTree whileStmt = ASTUtils.newAST(66, "while");
        whileStmt.appendToken(TokenBuilder.newSpace());
        whileStmt.addChildWithTokens(ASTUtils.parseCondition(condition));
        whileStmt.appendToken(TokenBuilder.newSpace());
        LinkedListTree block = ASTFactory.newBlock();
        whileStmt.addChildWithTokens(block);
        this.addStatement(whileStmt);
        return new ASTStatementList(block);
    }

    public StatementContainer newDoWhile(String condition) {
        LinkedListTree doWhileStmt = ASTUtils.newAST(67, "do");
        doWhileStmt.appendToken(TokenBuilder.newSpace());
        LinkedListTree block = ASTFactory.newBlock();
        doWhileStmt.addChildWithTokens(block);
        doWhileStmt.appendToken(TokenBuilder.newSpace());
        doWhileStmt.appendToken(TokenBuilder.newWhile());
        doWhileStmt.appendToken(TokenBuilder.newSpace());
        doWhileStmt.addChildWithTokens(ASTUtils.parseCondition(condition));
        doWhileStmt.appendToken(TokenBuilder.newSemi());
        this.addStatement(doWhileStmt);
        return new ASTStatementList(block);
    }

    public ASSwitchStatement newSwitch(String condition) {
        LinkedListTree switchStmt = ASTUtils.newAST(70, "switch");
        switchStmt.appendToken(TokenBuilder.newSpace());
        switchStmt.addChildWithTokens(ASTUtils.parseCondition(condition));
        switchStmt.appendToken(TokenBuilder.newSpace());
        LinkedListTree block = ASTFactory.newBlock();
        switchStmt.addChildWithTokens(block);
        this.addStatement(switchStmt);
        return new ASTASSwitchStatement(block);
    }

    private void addStatement(LinkedListTree stmt) {
        ASTUtils.addChildWithIndentation(this.ast, stmt);
    }

    public boolean containsCode() {
        return this.ast.getFirstChild() != null;
    }

    public LinkedListTree getAST() {
        return this.ast;
    }
}

