/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.metaas.impl;

import uk.co.badgersinfoil.metaas.CompilationUnit;
import uk.co.badgersinfoil.metaas.SyntaxException;
import uk.co.badgersinfoil.metaas.Visibility;
import uk.co.badgersinfoil.metaas.impl.AS3ASTCompilationUnit;
import uk.co.badgersinfoil.metaas.impl.ASTASField;
import uk.co.badgersinfoil.metaas.impl.ASTASMethod;
import uk.co.badgersinfoil.metaas.impl.ASTUtils;
import uk.co.badgersinfoil.metaas.impl.TokenBuilder;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListToken;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListTree;

public class ASTFactory {
    private ASTFactory() {
    }

    public static AS3ASTCompilationUnit synthesizeClass(String qualifiedName) {
        LinkedListTree unit = ASTUtils.newAST(4);
        LinkedListTree pkg = ASTUtils.newAST(48, "package");
        pkg.appendToken(TokenBuilder.newSpace());
        unit.addChildWithTokens(pkg);
        String packageName = ASTFactory.packageNameFrom(qualifiedName);
        if (packageName != null) {
            pkg.addChildWithTokens(ASTUtils.newIdent(packageName));
        }
        LinkedListTree packageBlock = ASTFactory.newBlock();
        pkg.addChildWithTokens(packageBlock);
        String className = ASTFactory.typeNameFrom(qualifiedName);
        LinkedListTree clazz = ASTFactory.synthesizeAS3Class(className);
        ASTUtils.addChildWithIndentation(packageBlock, clazz);
        return new AS3ASTCompilationUnit(unit);
    }

    public static CompilationUnit synthesizeInterface(String qualifiedName) {
        LinkedListTree unit = ASTUtils.newAST(4);
        LinkedListTree pkg = ASTUtils.newAST(48, "package");
        unit.addChildWithTokens(pkg);
        String packageName = ASTFactory.packageNameFrom(qualifiedName);
        if (packageName != null) {
            pkg.addChildWithTokens(ASTUtils.newIdent(packageName));
        }
        LinkedListTree packageBlock = ASTFactory.newBlock();
        pkg.addChildWithTokens(packageBlock);
        LinkedListTree clazz = ASTUtils.newAST(15);
        LinkedListTree modifiers = ASTUtils.newAST(12);
        clazz.addChildWithTokens(modifiers);
        modifiers.addChildWithTokens(ASTUtils.newAST(82, "public"));
        clazz.addChildWithTokens(ASTUtils.newAST(55, "interface"));
        packageBlock.addChildWithTokens(clazz);
        clazz.addChildWithTokens(ASTUtils.newAST(54, ASTFactory.typeNameFrom(qualifiedName)));
        LinkedListTree typeBlock = ASTUtils.newParentheticAST(5, 49, "{", 50, "}");
        clazz.addChildWithTokens(typeBlock);
        return new AS3ASTCompilationUnit(unit);
    }

    private static String typeNameFrom(String qualifiedName) {
        int p = qualifiedName.lastIndexOf(46);
        if (p == -1) {
            return qualifiedName;
        }
        return qualifiedName.substring(p + 1);
    }

    private static LinkedListTree synthesizeAS3Class(String className) {
        LinkedListTree clazz = ASTUtils.newAST(14);
        LinkedListTree annos = ASTUtils.newAST(8);
        annos.appendToken(TokenBuilder.newNewline());
        clazz.addChildWithTokens(annos);
        LinkedListTree modifiers = ASTUtils.newAST(12);
        clazz.addChildWithTokens(modifiers);
        LinkedListTree modPublic = ASTUtils.newAST(82, "public");
        modifiers.addChildWithTokens(modPublic);
        modifiers.appendToken(TokenBuilder.newSpace());
        clazz.appendToken(TokenBuilder.newClass());
        clazz.appendToken(TokenBuilder.newSpace());
        clazz.addChildWithTokens(ASTUtils.newAST(54, className));
        clazz.appendToken(TokenBuilder.newSpace());
        LinkedListTree typeBlock = ASTUtils.newParentheticAST(5, 49, "{", 50, "}");
        LinkedListToken typeBlockNL = TokenBuilder.newNewline();
        typeBlock.getInitialInsertionAfter().afterInsert(typeBlockNL);
        typeBlock.setInitialInsertionAfter(typeBlockNL);
        clazz.addChildWithTokens(typeBlock);
        return clazz;
    }

    private static String packageNameFrom(String qualifiedName) {
        int p = qualifiedName.lastIndexOf(46);
        if (p == -1) {
            return null;
        }
        return qualifiedName.substring(0, p);
    }

    public static ASTASMethod newClassMethod(String name, Visibility visibility, String returnType) {
        LinkedListTree def = ASTUtils.newImaginaryAST(6);
        LinkedListTree annos = ASTUtils.newAST(8);
        def.addChildWithTokens(annos);
        def.addChildWithTokens(ASTUtils.toModifiers(visibility));
        LinkedListTree decl = ASTUtils.newAST(59, "function");
        def.addChildWithTokens(decl);
        decl.appendToken(TokenBuilder.newSpace());
        LinkedListTree methName = ASTUtils.newAST(54, name);
        def.addChildWithTokens(methName);
        def.addChildWithTokens(ASTUtils.newParentheticAST(16, 63, "(", 64, ")"));
        if (returnType != null) {
            def.addChildWithTokens(ASTUtils.newTypeSpec(returnType));
        }
        def.appendToken(TokenBuilder.newSpace());
        LinkedListTree block = ASTFactory.newBlock();
        def.addChildWithTokens(block);
        return new ASTASMethod(def);
    }

    public static ASTASField newField(String name, Visibility visibility, String type) {
        if (name.indexOf(46) != -1) {
            throw new SyntaxException("field name must not contain '.'");
        }
        LinkedListTree decl = ASTUtils.newImaginaryAST(7);
        LinkedListTree annos = ASTUtils.newAST(8);
        decl.addChildWithTokens(annos);
        decl.addChildWithTokens(ASTUtils.toModifiers(visibility));
        decl.addChildWithTokens(ASTUtils.newAST(60, "var"));
        decl.appendToken(TokenBuilder.newSpace());
        LinkedListTree def = ASTUtils.newAST(54, name);
        decl.addChildWithTokens(def);
        if (type != null) {
            def.addChildWithTokens(ASTUtils.newTypeSpec(type));
        }
        decl.appendToken(TokenBuilder.newSemi());
        return new ASTASField(decl);
    }

    public static ASTASMethod newInterfaceMethod(String name, Visibility visibility, String returnType) {
        LinkedListTree def = ASTUtils.newImaginaryAST(6);
        LinkedListTree annos = ASTUtils.newAST(8);
        def.addChildWithTokens(annos);
        LinkedListTree meth = ASTUtils.newAST(59, "function");
        def.addChildWithTokens(meth);
        LinkedListTree methName = ASTUtils.newAST(54, name);
        def.addChildWithTokens(methName);
        def.addChildWithTokens(ASTUtils.newParentheticAST(16, 63, "(", 64, ")"));
        if (returnType != null) {
            def.addChildWithTokens(ASTUtils.newTypeSpec(returnType));
        }
        def.addChildWithTokens(ASTUtils.toModifiers(visibility));
        return new ASTASMethod(def);
    }

    public static LinkedListTree newBlock() {
        LinkedListTree ast = ASTUtils.newParentheticAST(19, 49, "{", 50, "}");
        LinkedListToken nl = TokenBuilder.newNewline();
        ast.getInitialInsertionAfter().afterInsert(nl);
        ast.setInitialInsertionAfter(nl);
        return ast;
    }

    public static LinkedListTree newMetadataTag(String name) {
        LinkedListTree ast = ASTUtils.newParentheticAST(9, 80, "[", 81, "]");
        ast.addChildWithTokens(ASTUtils.newAST(54, name));
        return ast;
    }
}

