/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.metaas.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import uk.co.badgersinfoil.metaas.ASProject;
import uk.co.badgersinfoil.metaas.ASSourceFactory;
import uk.co.badgersinfoil.metaas.CompilationUnit;
import uk.co.badgersinfoil.metaas.impl.AutoImporter;

public class ASTASProject
implements ASProject {
    private List classpath;
    private List compilationUnits = new ArrayList();
    private String outputLocation;
    private ASSourceFactory fact;

    public ASTASProject(ASSourceFactory fact) {
        this.fact = fact;
    }

    public void addClasspathEntry(String classpathEntry) {
        this.classpath.add(classpathEntry);
    }

    public void removeClasspathEntry(String classpathEntry) {
        this.classpath.remove(classpathEntry);
    }

    public List getClasspathEntries() {
        return Collections.unmodifiableList(this.classpath);
    }

    public void addCompilationUnit(CompilationUnit cu) {
        this.compilationUnits.add(cu);
    }

    public void removeCompilationUnit(CompilationUnit cu) {
        this.compilationUnits.remove(cu);
    }

    public CompilationUnit newClass(String qualifiedClassName) {
        CompilationUnit cu = this.fact.newClass(qualifiedClassName);
        this.addCompilationUnit(cu);
        return cu;
    }

    public CompilationUnit newInterface(String qualifiedInterfaceName) {
        CompilationUnit cu = this.fact.newInterface(qualifiedInterfaceName);
        this.addCompilationUnit(cu);
        return cu;
    }

    public List getCompilationUnits() {
        return Collections.unmodifiableList(this.compilationUnits);
    }

    public String getOutputLocation() {
        return this.outputLocation;
    }

    public void setOutputLocation(String outputLocation) {
        this.outputLocation = outputLocation;
    }

    public void writeAll() throws IOException {
        AutoImporter autoImporter = new AutoImporter();
        autoImporter.performAutoImport(this);
        Iterator i = this.compilationUnits.iterator();
        while (i.hasNext()) {
            CompilationUnit cu = (CompilationUnit)i.next();
            this.write(this.outputLocation, cu);
        }
    }

    private void write(String destinationDir, CompilationUnit cu) throws IOException {
        String filename = ASTASProject.filenameFor(cu);
        File destFile = new File(destinationDir, filename);
        destFile.getParentFile().mkdirs();
        FileOutputStream os = new FileOutputStream(destFile);
        OutputStreamWriter out = new OutputStreamWriter(os);
        this.fact.newWriter().write(out, cu);
        out.close();
    }

    private static String filenameFor(CompilationUnit unit) {
        String name = unit.getPackageName().equals("") ? unit.getType().getName() : String.valueOf(unit.getPackageName()) + "." + unit.getType().getName();
        return String.valueOf(name.replace('.', File.separatorChar)) + ".as";
    }
}

