/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.metaas.impl;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.RecognitionException;
import org.asdt.core.internal.antlr.AS3Parser;
import uk.co.badgersinfoil.metaas.ASPackage;
import uk.co.badgersinfoil.metaas.ASType;
import uk.co.badgersinfoil.metaas.SyntaxException;
import uk.co.badgersinfoil.metaas.impl.ASTASClassType;
import uk.co.badgersinfoil.metaas.impl.ASTASInterfaceType;
import uk.co.badgersinfoil.metaas.impl.ASTIterator;
import uk.co.badgersinfoil.metaas.impl.ASTUtils;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListTree;

public class ASTASPackage
implements ASPackage {
    private LinkedListTree ast;

    public ASTASPackage(LinkedListTree ast) {
        this.ast = ast;
    }

    public String getName() {
        LinkedListTree first = this.ast.getFirstChild();
        if (first.getType() == 44) {
            return ASTUtils.identText(first);
        }
        return null;
    }

    public void setName(String name) {
        ASTIterator i = new ASTIterator(this.ast);
        if (name == null && i.next().getType() == 44) {
            i.remove();
            return;
        }
        LinkedListTree newName = ASTUtils.newIdent(name);
        if (i.next().getType() == 44) {
            i.replace(newName);
        } else {
            i.insertBeforeCurrent(newName);
        }
    }

    public void addImport(String name) {
        LinkedListTree imp = this.createImport(name);
        int pos = this.findNextImportInsertionPoint();
        ASTUtils.addChildWithIndentation(this.getPkgBlockNode(), pos, imp);
    }

    private int findNextImportInsertionPoint() {
        ASTIterator i = this.getPkgBlockIter();
        int index = 0;
        while (i.search(52) != null) {
            index = i.getCurrentIndex() + 1;
        }
        return index;
    }

    private LinkedListTree createImport(String name) {
        AS3Parser parser = ASTUtils.parse("import " + name + ";");
        try {
            LinkedListTree result = ASTUtils.tree(parser.importDefinition());
            parser.endOfFile();
            return result;
        }
        catch (RecognitionException e) {
            throw new SyntaxException(e);
        }
    }

    public List findImports() {
        LinkedListTree imp;
        ASTIterator i = this.getPkgBlockIter();
        ArrayList<String> result = new ArrayList<String>();
        while ((imp = i.search(52)) != null) {
            result.add(this.importText(imp));
        }
        return result;
    }

    private String importText(LinkedListTree imp) {
        return ASTUtils.identText(imp.getFirstChild());
    }

    public boolean removeImport(String name) {
        LinkedListTree imp;
        ASTIterator i = this.getPkgBlockIter();
        while ((imp = i.search(52)) != null) {
            if (!this.importText(imp).equals(name)) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public ASType getType() {
        LinkedListTree block = ASTUtils.findChildByType(this.ast, 19);
        LinkedListTree type = ASTUtils.findChildByType(block, 14);
        if (type != null) {
            return new ASTASClassType(type);
        }
        type = ASTUtils.findChildByType(block, 15);
        if (type != null) {
            return new ASTASInterfaceType(type);
        }
        return null;
    }

    private LinkedListTree getPkgBlockNode() {
        return ASTUtils.findChildByType(this.ast, 19);
    }

    private ASTIterator getPkgBlockIter() {
        return new ASTIterator(this.getPkgBlockNode());
    }
}

