/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.metaas.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import uk.co.badgersinfoil.metaas.ASArg;
import uk.co.badgersinfoil.metaas.ASIfStatement;
import uk.co.badgersinfoil.metaas.ASMethod;
import uk.co.badgersinfoil.metaas.ASSwitchStatement;
import uk.co.badgersinfoil.metaas.StatementContainer;
import uk.co.badgersinfoil.metaas.SyntaxException;
import uk.co.badgersinfoil.metaas.impl.ASTASArg;
import uk.co.badgersinfoil.metaas.impl.ASTASMember;
import uk.co.badgersinfoil.metaas.impl.ASTIterator;
import uk.co.badgersinfoil.metaas.impl.ASTStatementList;
import uk.co.badgersinfoil.metaas.impl.ASTUtils;
import uk.co.badgersinfoil.metaas.impl.DocCommentUtils;
import uk.co.badgersinfoil.metaas.impl.TokenBuilder;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListToken;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListTree;

public class ASTASMethod
extends ASTASMember
implements ASMethod {
    private ASTStatementList stmtList;

    public ASTASMethod(LinkedListTree ast) {
        super(ast);
        this.stmtList = new ASTStatementList(ASTUtils.findChildByType(ast, 19));
    }

    public String getName() {
        ASTIterator i = new ASTIterator(this.ast);
        LinkedListTree name = i.find(54);
        return name.getText();
    }

    public void setName(String name) {
        if (name.indexOf(46) != -1) {
            throw new SyntaxException("Method name must not contain '.'");
        }
        if (name.indexOf(58) != -1) {
            throw new SyntaxException("Method name must not contain ':'");
        }
        ASTIterator i = new ASTIterator(this.ast);
        i.find(54);
        LinkedListTree newName = ASTUtils.newIdent(name).getFirstChild();
        i.replace(newName);
    }

    private boolean isGetSet(LinkedListTree tok) {
        int type = tok.getType();
        return type == 45 || type == 46;
    }

    public List getArgs() {
        LinkedList<ASTASArg> results = new LinkedList<ASTASArg>();
        LinkedListTree params = ASTUtils.findChildByType(this.ast, 16);
        ASTIterator i = new ASTIterator(params);
        while (i.hasNext()) {
            results.add(new ASTASArg(i.next()));
        }
        return Collections.unmodifiableList(results);
    }

    public String getType() {
        LinkedListTree typeSpec = ASTUtils.findChildByType(this.ast, 18);
        if (typeSpec == null) {
            return null;
        }
        return ASTUtils.typeSpecText(typeSpec);
    }

    public void setType(String typeName) {
        LinkedListTree type = ASTUtils.findChildByType(this.ast, 18);
        if (typeName == null) {
            if (type != null) {
                this.ast.deleteChild(this.ast.getIndexOfChild(type));
            }
            return;
        }
        LinkedListTree newType = ASTUtils.newTypeSpec(typeName);
        if (type == null) {
            this.ast.addChildWithTokens(this.ast.getChildCount() - 1, newType);
        } else {
            type.setChildWithTokens(0, newType.getFirstChild());
        }
    }

    public void addStmt(String statement) {
        this.stmtList.addStmt(statement);
    }

    private LinkedListTree findParams() {
        return ASTUtils.findChildByType(this.ast, 16);
    }

    public ASArg addParam(String name, String type) {
        LinkedListTree params;
        LinkedListTree param = ASTUtils.newAST(17);
        param.addChildWithTokens(ASTUtils.newAST(54, name));
        if (type != null) {
            param.addChildWithTokens(ASTUtils.newTypeSpec(type));
        }
        if ((params = this.findParams()).getChildCount() > 0) {
            params.appendToken(TokenBuilder.newComma());
            params.appendToken(TokenBuilder.newSpace());
        }
        params.addChildWithTokens(param);
        return new ASTASArg(param);
    }

    public ASArg removeParam(String name) {
        LinkedListTree params = ASTUtils.findChildByType(this.ast, 16);
        int count = 0;
        ASTIterator i = new ASTIterator(params);
        while (i.hasNext()) {
            LinkedListTree ast = i.next();
            ASTASArg arg = new ASTASArg(ast);
            if (arg.getName().equals(name)) {
                if (i.hasNext()) {
                    this.removeTrailingComma(ast.getStopToken());
                }
                i.remove();
                return arg;
            }
            ++count;
        }
        return null;
    }

    private void removeTrailingComma(LinkedListToken stopToken) {
        LinkedListToken tok = stopToken.getNext();
        while (tok != null) {
            if (tok.getChannel() != 99) {
                if (tok.getType() == 57) {
                    stopToken.setNext(tok.getNext());
                    break;
                }
                throw new SyntaxException("Unexpected token: " + tok);
            }
            stopToken.setNext(tok.getNext());
            tok = tok.getNext();
        }
    }

    public void addComment(String text) {
        this.stmtList.addComment(text);
    }

    public ASMethod.AccessorRole getAccessorRole() {
        LinkedListTree decl = ASTUtils.findChildByType(this.ast, 59);
        LinkedListTree roleNode = decl.getFirstChild();
        if (roleNode == null) {
            return ASMethod.AccessorRole.NORMAL_METHOD;
        }
        switch (roleNode.getType()) {
            case 45: {
                return ASMethod.AccessorRole.GETTER;
            }
            case 46: {
                return ASMethod.AccessorRole.SETTER;
            }
        }
        throw new SyntaxException("expected GET or SET; got " + roleNode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAccessorRole(ASMethod.AccessorRole role) {
        LinkedListTree decl = ASTUtils.findChildByType(this.ast, 59);
        LinkedListTree roleNode = decl.getFirstChild();
        if (roleNode != null) {
            if (role == ASMethod.AccessorRole.NORMAL_METHOD) {
                decl.deleteChild(0);
                return;
            } else if (role == ASMethod.AccessorRole.GETTER) {
                roleNode.token.setType(45);
                roleNode.token.setText("get");
                return;
            } else {
                if (role != ASMethod.AccessorRole.SETTER) throw new IllegalArgumentException("bad role: " + role);
                roleNode.token.setType(46);
                roleNode.token.setText("set");
            }
            return;
        } else if (role == ASMethod.AccessorRole.GETTER) {
            LinkedListTree node = ASTUtils.newAST(45, "get");
            node.appendToken(TokenBuilder.newSpace());
            decl.addChildWithTokens(node);
            return;
        } else {
            if (role != ASMethod.AccessorRole.SETTER) return;
            LinkedListTree node = ASTUtils.newAST(46, "set");
            node.appendToken(TokenBuilder.newSpace());
            decl.addChildWithTokens(node);
        }
    }

    public ASIfStatement newIf(String condition) {
        return this.stmtList.newIf(condition);
    }

    public StatementContainer newFor(String init, String condition, String update) {
        return this.stmtList.newFor(init, condition, update);
    }

    public StatementContainer newForIn(String init, String list) {
        return this.stmtList.newForIn(init, list);
    }

    public StatementContainer newForEachIn(String init, String list) {
        return this.stmtList.newForEachIn(init, list);
    }

    public StatementContainer newWhile(String condition) {
        return this.stmtList.newWhile(condition);
    }

    public StatementContainer newDoWhile(String condition) {
        return this.stmtList.newDoWhile(condition);
    }

    public ASSwitchStatement newSwitch(String condition) {
        return this.stmtList.newSwitch(condition);
    }

    public boolean containsCode() {
        return this.stmtList.containsCode();
    }

    public String getDocComment() {
        return DocCommentUtils.getDocComment(this.ast);
    }

    public void setDocComment(String text) {
        DocCommentUtils.setDocComment(this.ast, text);
    }
}

