/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.metaas.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.co.badgersinfoil.metaas.ASMetaTag;
import uk.co.badgersinfoil.metaas.ASSourceFactory;
import uk.co.badgersinfoil.metaas.SyntaxException;
import uk.co.badgersinfoil.metaas.impl.ASTIterator;
import uk.co.badgersinfoil.metaas.impl.ASTUtils;
import uk.co.badgersinfoil.metaas.impl.TokenBuilder;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListToken;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListTree;

public class ASTASMetaTag
implements ASMetaTag {
    private LinkedListTree ast;

    public ASTASMetaTag(LinkedListTree ast) {
        this.ast = ast;
    }

    public void addParam(String constant) {
        this.addParam(this.toAST(constant));
    }

    private LinkedListTree toAST(String constant) {
        return ASTUtils.newAST(125, ASSourceFactory.str(constant));
    }

    private void addParam(LinkedListTree str) {
        LinkedListTree param = ASTUtils.newImaginaryAST(11);
        param.addChildWithTokens(str);
        LinkedListTree params = this.findOrAddParams();
        if (params.getChildCount() > 0) {
            params.appendToken(TokenBuilder.newComma());
            params.appendToken(TokenBuilder.newSpace());
        }
        params.addChildWithTokens(param);
    }

    public void addParam(int constant) {
        this.addParam(this.toAST(constant));
    }

    private LinkedListTree toAST(int constant) {
        return ASTUtils.newAST(129, String.valueOf(constant));
    }

    public void addParam(boolean constant) {
        this.addParam(this.toAST(constant));
    }

    private LinkedListTree toAST(boolean constant) {
        LinkedListTree str = constant ? ASTUtils.newAST(126, "true") : ASTUtils.newAST(127, "false");
        return str;
    }

    public void addParam(String name, String constant) {
        this.addParam(name, this.toAST(constant));
    }

    private void addParam(String name, LinkedListTree val) {
        LinkedListTree assign = ASTUtils.newImaginaryAST(62);
        LinkedListTree ident = ASTUtils.newAST(54, name);
        assign.addChildWithTokens(ident);
        assign.appendToken(new LinkedListToken(62, "="));
        assign.addChildWithTokens(val);
        this.addParam(assign);
    }

    public void addParam(String name, int constant) {
        this.addParam(name, this.toAST(constant));
    }

    public void addParam(String name, boolean constant) {
        this.addParam(name, this.toAST(constant));
    }

    public String getName() {
        return this.ast.getFirstChild().getText();
    }

    public Object getParamValue(String name) {
        LinkedListTree params = this.findParams();
        if (params == null) {
            return null;
        }
        ASTIterator i = new ASTIterator(params);
        while (i.hasNext()) {
            LinkedListTree param = i.next();
            LinkedListTree child = param.getFirstChild();
            if (child.getType() != 62 || !child.getFirstChild().getText().equals(name)) continue;
            return ASTASMetaTag.toParamValue(child.getLastChild());
        }
        return null;
    }

    public List getParams() {
        LinkedListTree params = this.findParams();
        if (params == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        ASTIterator i = new ASTIterator(params);
        while (i.hasNext()) {
            LinkedListTree param = i.next();
            result.add(ASTASMetaTag.toParam(param));
        }
        return result;
    }

    private static Object toParam(LinkedListTree param) {
        if (param.getType() != 11) {
            throw new SyntaxException("Expected ANNOTATION_PARAM, got " + ASTUtils.tokenName(param));
        }
        LinkedListTree child = param.getFirstChild();
        return ASTASMetaTag.toParamValue(child);
    }

    private static Object toParamValue(LinkedListTree child) {
        switch (child.getType()) {
            case 125: {
                return ASTUtils.decodeStringLiteral(child.getText());
            }
            case 126: {
                return Boolean.TRUE;
            }
            case 127: {
                return Boolean.FALSE;
            }
            case 129: {
                return Integer.valueOf(child.getText());
            }
            case 62: {
                return new ASTParam(child);
            }
        }
        throw new SyntaxException("Unexpected type " + ASTUtils.tokenName(child));
    }

    private LinkedListTree findOrAddParams() {
        LinkedListTree params = this.findParams();
        if (params == null) {
            params = ASTUtils.newParentheticAST(10, 63, "(", 64, ")");
            this.ast.addChildWithTokens(params);
        }
        return params;
    }

    private LinkedListTree findParams() {
        return ASTUtils.findChildByType(this.ast, 10);
    }

    public static class ASTParam
    implements ASMetaTag.Param {
        private LinkedListTree param;

        public ASTParam(LinkedListTree param) {
            this.param = param;
        }

        public String getName() {
            return this.param.getFirstChild().getText();
        }

        public Object getValue() {
            return ASTASMetaTag.toParam(this.param.getLastChild());
        }
    }
}

