/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.metaas.impl;

import java.util.List;
import uk.co.badgersinfoil.metaas.ASMember;
import uk.co.badgersinfoil.metaas.ASMetaTag;
import uk.co.badgersinfoil.metaas.Visibility;
import uk.co.badgersinfoil.metaas.impl.ASTIterator;
import uk.co.badgersinfoil.metaas.impl.ASTUtils;
import uk.co.badgersinfoil.metaas.impl.ModifierUtils;
import uk.co.badgersinfoil.metaas.impl.TagUtils;
import uk.co.badgersinfoil.metaas.impl.TokenBuilder;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListTree;

public abstract class ASTASMember
implements ASMember {
    protected LinkedListTree ast;

    public ASTASMember(LinkedListTree ast) {
        this.ast = ast;
    }

    public LinkedListTree getAST() {
        return this.ast;
    }

    public Visibility getVisibility() {
        return ModifierUtils.getVisibility(this.findModifiers());
    }

    public void setVisibility(Visibility protection) {
        ModifierUtils.setVisibility(this.findModifiers(), protection);
    }

    public boolean isStatic() {
        LinkedListTree modifiers = this.findModifiers();
        return ASTUtils.findChildByType(modifiers, 84) != null;
    }

    private LinkedListTree findModifiers() {
        return ASTUtils.findChildByType(this.ast, 12);
    }

    private ASTIterator modifierIter() {
        return new ASTIterator(this.findModifiers());
    }

    public void setStatic(boolean s) {
        ASTIterator i = this.modifierIter();
        while (i.hasNext()) {
            LinkedListTree mod = i.next();
            if (mod.getType() != 84) continue;
            if (!s) {
                i.remove();
            }
            return;
        }
        if (s) {
            LinkedListTree modifiers = this.findModifiers();
            LinkedListTree modStatic = ASTUtils.newAST(84, "static");
            modStatic.appendToken(TokenBuilder.newSpace());
            modifiers.addChildWithTokens(modStatic);
        }
    }

    public List getAllMetaTags() {
        return TagUtils.getAllMetaTags(this.ast);
    }

    public ASMetaTag getFirstMetatag(String name) {
        return TagUtils.getFirstMetaTag(this.ast, name);
    }

    public List getMetaTagsWithName(String name) {
        return TagUtils.getMetaTagWithName(this.ast, name);
    }

    public ASMetaTag newMetaTag(String name) {
        return TagUtils.newMetaTag(this.ast, name);
    }
}

