/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.metaas.impl;

import uk.co.badgersinfoil.metaas.ASBlock;
import uk.co.badgersinfoil.metaas.ASIfStatement;
import uk.co.badgersinfoil.metaas.ASSwitchStatement;
import uk.co.badgersinfoil.metaas.StatementContainer;
import uk.co.badgersinfoil.metaas.impl.ASTFactory;
import uk.co.badgersinfoil.metaas.impl.ASTIterator;
import uk.co.badgersinfoil.metaas.impl.ASTStatementList;
import uk.co.badgersinfoil.metaas.impl.ASTUtils;
import uk.co.badgersinfoil.metaas.impl.TokenBuilder;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListTree;

public class ASTASIfStatement
implements ASIfStatement {
    private LinkedListTree ast;

    public ASTASIfStatement(LinkedListTree ast) {
        ASTASIfStatement.assertType(ast, 68);
        this.ast = ast;
    }

    private static void assertType(LinkedListTree ast, int type) {
        if (ast.getType() != type) {
            throw new IllegalArgumentException(ASTUtils.tokenName(ast));
        }
    }

    private StatementContainer getThen() {
        return new ASTStatementList((LinkedListTree)this.ast.getChild(1));
    }

    public ASBlock getElse() {
        LinkedListTree elseStmt = (LinkedListTree)this.ast.getChild(2);
        if (elseStmt == null) {
            String indent = ASTUtils.findIndent(this.ast);
            elseStmt = ASTUtils.newAST(69, "else");
            this.ast.appendToken(TokenBuilder.newSpace());
            this.ast.addChildWithTokens(elseStmt);
            elseStmt.appendToken(TokenBuilder.newSpace());
            LinkedListTree block = ASTFactory.newBlock();
            elseStmt.addChildWithTokens(block);
            ASTUtils.increaseIndentAfterFirstLine(block, indent);
        }
        return new ASTStatementList(elseStmt.getFirstChild());
    }

    public void addStmt(String statement) {
        this.getThen().addStmt(statement);
    }

    public void addComment(String text) {
        this.getThen().addComment(text);
    }

    public ASIfStatement newIf(String condition) {
        return this.getThen().newIf(condition);
    }

    public StatementContainer newFor(String init, String condition, String update) {
        return this.getThen().newFor(init, condition, update);
    }

    public StatementContainer newForIn(String init, String list) {
        return this.getThen().newForIn(init, list);
    }

    public StatementContainer newForEachIn(String init, String list) {
        return this.getThen().newForEachIn(init, list);
    }

    public StatementContainer newWhile(String condition) {
        return this.getThen().newWhile(condition);
    }

    public StatementContainer newDoWhile(String condition) {
        return this.getThen().newDoWhile(condition);
    }

    public ASSwitchStatement newSwitch(String condition) {
        return this.getThen().newSwitch(condition);
    }

    public boolean containsCode() {
        return this.getThen().containsCode();
    }

    public void setThen(ASBlock block) {
        LinkedListTree theBlock = ((ASTStatementList)block).getAST();
        ASTIterator i = new ASTIterator(this.ast);
        i.next();
        i.next();
        i.replace(theBlock);
        String indent = ASTUtils.findIndent(this.ast);
        ASTUtils.increaseIndentAfterFirstLine(theBlock, indent);
    }
}

