/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.metaas.impl;

import uk.co.badgersinfoil.metaas.ASField;
import uk.co.badgersinfoil.metaas.SyntaxException;
import uk.co.badgersinfoil.metaas.impl.ASTASMember;
import uk.co.badgersinfoil.metaas.impl.ASTUtils;
import uk.co.badgersinfoil.metaas.impl.DocCommentUtils;
import uk.co.badgersinfoil.metaas.impl.TokenBuilder;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListToken;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListTree;

public class ASTASField
extends ASTASMember
implements ASField {
    private static int INDEX_DEF = 2;
    private static int INDEX_DECL = 3;

    public ASTASField(LinkedListTree ast) {
        super(ast);
    }

    public String getName() {
        return this.findDecl().getText();
    }

    public void setName(String name) {
        if (name.indexOf(46) != -1) {
            throw new SyntaxException("field name must not contain '.'");
        }
        LinkedListTree newName = ASTUtils.newAST(54, name);
        this.ast.setChild(INDEX_DECL, newName);
    }

    public void setInitializer(String expr) {
        LinkedListTree exp = ASTUtils.parseExpr(expr);
        LinkedListTree decl = this.findDecl();
        LinkedListTree init = ASTUtils.findChildByType(decl, 62);
        if (init == null) {
            init = ASTUtils.newAST(62, "=");
            decl.addChildWithTokens(init);
        }
        init.addChildWithTokens(exp);
    }

    public String getDocComment() {
        return DocCommentUtils.getDocComment(this.ast);
    }

    public void setDocComment(String text) {
        DocCommentUtils.setDocComment(this.ast, text);
    }

    public boolean isConst() {
        return this.ast.getChild(INDEX_DEF).getType() == 61;
    }

    public void setConst(boolean isConst) {
        if (this.isConst() == isConst) {
            return;
        }
        LinkedListToken node = isConst ? TokenBuilder.newCost() : TokenBuilder.newVar();
        this.ast.setChild(INDEX_DEF, new LinkedListTree(node));
    }

    public String getType() {
        LinkedListTree decl = this.findDecl();
        LinkedListTree typeSpec = decl.getFirstChild();
        if (typeSpec == null) {
            return null;
        }
        return ASTUtils.typeSpecText(typeSpec);
    }

    private LinkedListTree findDecl() {
        return (LinkedListTree)this.ast.getChild(INDEX_DECL);
    }

    public void setType(String typeName) {
        LinkedListTree decl = this.findDecl();
        LinkedListTree typeSpec = decl.getFirstChild();
        if (typeSpec == null) {
            if (typeName != null) {
                decl.addChildWithTokens(ASTUtils.newTypeSpec(typeName));
            }
        } else if (typeName == null) {
            decl.deleteChild(0);
        } else {
            decl.setChildWithTokens(0, ASTUtils.newTypeSpec(typeName));
        }
    }
}

