/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.metaas.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import uk.co.badgersinfoil.metaas.ASClassType;
import uk.co.badgersinfoil.metaas.ASField;
import uk.co.badgersinfoil.metaas.ASMethod;
import uk.co.badgersinfoil.metaas.Visibility;
import uk.co.badgersinfoil.metaas.impl.ASTASField;
import uk.co.badgersinfoil.metaas.impl.ASTASMethod;
import uk.co.badgersinfoil.metaas.impl.ASTASType;
import uk.co.badgersinfoil.metaas.impl.ASTFactory;
import uk.co.badgersinfoil.metaas.impl.ASTIterator;
import uk.co.badgersinfoil.metaas.impl.ASTUtils;
import uk.co.badgersinfoil.metaas.impl.TokenBuilder;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListToken;
import uk.co.badgersinfoil.metaas.impl.antlr.LinkedListTree;

public class ASTASClassType
extends ASTASType
implements ASClassType {
    private static final int EXTENDS_INDEX = 3;

    public ASTASClassType(LinkedListTree clazz) {
        super(clazz);
    }

    public ASMethod newMethod(String name, Visibility visibility, String returnType) {
        ASTASMethod method = ASTFactory.newClassMethod(name, visibility, returnType);
        this.addMethod(method);
        return method;
    }

    public void addMethod(ASTASMethod method) {
        ASTUtils.addChildWithIndentation(this.findTypeBlock(), method.getAST());
    }

    public String getSuperclass() {
        LinkedListTree ext = ASTUtils.findChildByType(this.ast, 56);
        if (ext == null) {
            return null;
        }
        return ASTUtils.identText(ext.getFirstChild());
    }

    public void setSuperclass(String superclassName) {
        if (superclassName == null) {
            this.removeExtendsClause();
            return;
        }
        LinkedListTree ext = ASTUtils.findChildByType(this.ast, 56);
        if (ext == null) {
            ext = ASTUtils.newAST(56, "extends");
            ext.appendToken(TokenBuilder.newSpace());
            LinkedListToken sp = TokenBuilder.newSpace();
            ext.getStartToken().beforeInsert(sp);
            ext.setStartToken(sp);
            this.ast.addChildWithTokens(3, ext);
        }
        ext.addChildWithTokens(ASTUtils.newIdent(superclassName));
        ext.appendToken(TokenBuilder.newSpace());
    }

    private void removeExtendsClause() {
        ASTIterator i = new ASTIterator(this.ast);
        while (i.hasNext()) {
            LinkedListTree node = i.next();
            if (node.getType() != 56) continue;
            i.remove();
            break;
        }
    }

    public List getImplementedInterfaces() {
        LinkedList<String> results = new LinkedList<String>();
        LinkedListTree impls = ASTUtils.findChildByType(this.ast, 58);
        if (impls != null) {
            ASTIterator i = new ASTIterator(impls);
            while (i.hasNext()) {
                results.add(ASTUtils.identText(i.next()));
            }
        }
        return Collections.unmodifiableList(results);
    }

    public void addImplementedInterface(String interfaceName) {
        LinkedListTree iface = ASTUtils.newIdent(interfaceName);
        LinkedListTree impls = ASTUtils.findChildByType(this.ast, 58);
        if (impls == null) {
            ASTIterator i = new ASTIterator(this.ast);
            i.find(5);
            impls = ASTUtils.newAST(58, "implements");
            i.insertBeforeCurrent(impls);
        }
        impls.addChildWithTokens(iface);
    }

    public void removeImplementedInterface(String interfaceName) {
        LinkedListTree impls = ASTUtils.findChildByType(this.ast, 58);
        ASTIterator i = new ASTIterator(impls);
        while (i.hasNext()) {
            LinkedListTree iface = i.next();
            String name = ASTUtils.identText(iface);
            if (!name.equals(interfaceName)) continue;
            i.remove();
            break;
        }
    }

    public ASField newField(String name, Visibility visibility, String type) {
        ASTASField field = ASTFactory.newField(name, visibility, type);
        this.addField(field);
        return field;
    }

    public void addField(ASTASField field) {
        ASTUtils.addChildWithIndentation(this.findTypeBlock(), field.getAST());
    }

    public ASField getField(String name) {
        ASTIterator i = this.blockIter();
        while (i.hasNext()) {
            ASTASField field;
            LinkedListTree member = i.next();
            if (member.getType() != 7 || !(field = new ASTASField(member)).getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public List getFields() {
        LinkedList<ASTASField> results = new LinkedList<ASTASField>();
        ASTIterator i = this.blockIter();
        while (i.hasNext()) {
            LinkedListTree member = i.next();
            if (member.getType() != 7) continue;
            results.add(new ASTASField(member));
        }
        return Collections.unmodifiableList(results);
    }

    public void removeField(String name) {
        ASTIterator i = this.blockIter();
        while (i.hasNext()) {
            ASTASField field;
            LinkedListTree member = i.next();
            if (member.getType() != 7 || !(field = new ASTASField(member)).getName().equals(name)) continue;
            i.remove();
            return;
        }
    }
}

