/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.asxsd;

import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDTypeDefinition;

public class XSDUtils {
    public static final String SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";

    public static boolean isMultiplyOccuring(XSDParticle part) {
        int max = part.getMaxOccurs();
        return max == -1 || max > 1;
    }

    public static boolean isXSDAnyType(XSDNamedComponent named) {
        return "anyType".equals(named.getName()) && named.getTargetNamespace().equals(SCHEMA_NAMESPACE);
    }

    public static XSDElementDeclaration getElementIfContainerForList(XSDElementDeclaration decl) {
        XSDTypeDefinition typeDef = decl.getTypeDefinition();
        return XSDUtils.getElementIfContainerForList(typeDef);
    }

    public static XSDElementDeclaration getElementIfContainerForList(XSDTypeDefinition typeDef) {
        XSDParticle part;
        XSDParticleContent partContent;
        EList particles;
        XSDModelGroup modelGroup;
        if (typeDef == null || !(typeDef instanceof XSDComplexTypeDefinition)) {
            return null;
        }
        XSDComplexTypeDefinition ctypeDef = (XSDComplexTypeDefinition)typeDef;
        XSDParticle ctype = ctypeDef.getComplexType();
        if (ctype == null) {
            return null;
        }
        XSDParticleContent particleContent = ctype.getContent();
        if (particleContent instanceof XSDModelGroup && (modelGroup = (XSDModelGroup)particleContent).getCompositor().equals(XSDCompositor.SEQUENCE_LITERAL) && (particles = modelGroup.getParticles()).size() == 1 && (partContent = (part = (XSDParticle)particles.get(0)).getContent()) instanceof XSDElementDeclaration && XSDUtils.isMultiplyOccuring(part)) {
            return (XSDElementDeclaration)partContent;
        }
        return null;
    }

    public static boolean typeIsA(XSDTypeDefinition type, String namespace, String name) {
        return type.hasNameAndTargetNamespace(name, namespace) || type.getBaseType() != null && type.getBaseType() != type && XSDUtils.typeIsA(type.getBaseType(), namespace, name);
    }
}

