/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.asxsd;

import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import uk.co.badgersinfoil.asxsd.MarshalUnmarshalBuilder;
import uk.co.badgersinfoil.asxsd.MarshalUnmarshalCodeGenStrategy;
import uk.co.badgersinfoil.asxsd.StringUtils;
import uk.co.badgersinfoil.asxsd.TypeBuilder;
import uk.co.badgersinfoil.asxsd.VariableNameGenerator;
import uk.co.badgersinfoil.asxsd.XSDUtils;
import uk.co.badgersinfoil.metaas.ASArg;
import uk.co.badgersinfoil.metaas.ASIfStatement;
import uk.co.badgersinfoil.metaas.ASMethod;
import uk.co.badgersinfoil.metaas.ASSourceFactory;
import uk.co.badgersinfoil.metaas.StatementContainer;

public class UnmarshalingCodeGenStrategy
implements MarshalUnmarshalCodeGenStrategy {
    private MarshalUnmarshalBuilder builder;
    private VariableNameGenerator varGen;
    private TypeBuilder typeBuilder;

    public UnmarshalingCodeGenStrategy(VariableNameGenerator varGen, TypeBuilder typeBuilder) {
        this.varGen = varGen;
        this.typeBuilder = typeBuilder;
    }

    public void setBuilder(MarshalUnmarshalBuilder builder) {
        this.builder = builder;
    }

    public void createElementDeclInit(XSDElementDeclaration elementDecl, ASMethod meth) {
        String typeName = this.typeBuilder.typeNameFor(elementDecl);
        meth.addStmt("var _result:" + typeName + " = new " + typeName + "()");
    }

    public void createTypeDefInit(XSDTypeDefinition typeDef, ASMethod meth) {
        String typeName = this.typeBuilder.typeNameFor(typeDef);
        meth.addStmt("var _result:" + typeName + " = new " + typeName + "()");
    }

    public String conversionTargetTypeName(XSDTypeDefinition typeDef) {
        return this.typeBuilder.typeNameFor(typeDef);
    }

    public String conversionTargetTypeName(XSDElementDeclaration elementDecl) {
        return this.typeBuilder.typeNameFor(elementDecl);
    }

    public String converterMethodNameFor(XSDTypeDefinition typeDef) {
        return "unmarshal" + StringUtils.sanitize(typeDef.getName());
    }

    public String converterMethodNameFor(XSDElementDeclaration elementDecl) {
        return "unmarshalElement_" + StringUtils.sanitize(elementDecl.getName());
    }

    public String converterClassNameForNamespace(String uri) {
        return String.valueOf(StringUtils.toPackageName(uri)) + ".Unmarshaler";
    }

    public void addConversionFromParameter(XSDComplexTypeDefinition ctype, ASMethod meth) {
        meth.addParam("thisElement", "XML");
    }

    public ASArg addConvertionFromParameter(XSDSimpleTypeDefinition stype, ASMethod meth) {
        return meth.addParam("thisValue", "String");
    }

    public void processList(XSDComplexTypeDefinition ctype, XSDElementDeclaration listElement, ASMethod meth) {
        meth.addComment(" process child sequence elements,");
        meth.addStmt("var _children:XMLList = thisElement.children()");
        meth.addStmt("var _seq:int = 0");
        String accessExpr = "_children[_seq++]";
        String fieldAccess = "_result";
        StatementContainer loop = meth.newForEachIn("var _child:XML", String.valueOf(accessExpr) + ".elements()");
        String converted = this.builder.convertedFrom(listElement.getType(), "_child");
        loop.addStmt(String.valueOf(fieldAccess) + ".push(" + converted + ")");
    }

    public ASArg addConversionFromParameter(XSDElementDeclaration elementDecl, ASMethod meth) {
        return meth.addParam("thisElement", "XML");
    }

    public String convertSimpleTypeElement(String expr, XSDSimpleTypeDefinition stype) {
        return this.builder.convertedFrom(stype, String.valueOf(expr) + ".text()");
    }

    public void buildBuiltinMethodBody(XSDTypeDefinition typeDef, ASMethod meth) {
        if (typeDef instanceof XSDSimpleTypeDefinition) {
            meth.addParam("thisValue", "String");
            XSDSimpleTypeDefinition stype = (XSDSimpleTypeDefinition)typeDef;
            if (XSDUtils.typeIsA(stype, "http://www.w3.org/2001/XMLSchema", "dateTime")) {
                this.buildBuiltinDatatimeConversion(meth, "thisValue", stype);
            } else {
                meth.addStmt("return " + this.doBasicTypeCoercion("thisValue", stype));
            }
        } else {
            throw new IllegalArgumentException("Expected a simpleType " + typeDef);
        }
    }

    private void buildBuiltinDatatimeConversion(ASMethod meth, String expr, XSDSimpleTypeDefinition stype) {
        String re = "^(\\-?)(\\d+)\\-(\\d+)\\-(\\d+)[Tt](\\d+):(\\d+):(\\d+)(\\.\\d+)?\\s*(.+)?$";
        meth.addStmt("var _rs:RegExp = new RegExp(" + ASSourceFactory.str(re) + ", \"\")");
        meth.addStmt("var _match:Object = _rs.exec(" + expr + ")");
        ASIfStatement yearSign = meth.newIf("_match[1] == \"\"");
        yearSign.addStmt("_result.fullYearUTC = Number(_match[2])");
        yearSign.getElse().addStmt("_result.fullYearUTC = -Number(_match[2])");
        meth.addStmt("_result.monthUTC = Number(_match[3])-1");
        meth.addStmt("_result.dateUTC = Number(_match[4])");
        meth.addStmt("_result.hoursUTC = Number(_match[5])");
        meth.addStmt("_result.minutesUTC = Number(_match[6])");
        meth.addStmt("_result.secondsUTC = Number(_match[7])");
        ASIfStatement secondsFraction = meth.newIf("_match[8] == \"\"");
        secondsFraction.addStmt("_result.millisecondsUTC = Number(\"0\"+_match[8])*1000");
        ASIfStatement timezoneOffset = meth.newIf("_match[9] == \"\"");
        String tzre = "(\\d\\d):(\\d\\d)";
        timezoneOffset.addStmt("var _tzrs:RegExp = new RegExp(" + ASSourceFactory.str(tzre) + ", \"\")");
        timezoneOffset.addStmt("_match = _tzrs.exec(_match[9])");
        ASIfStatement timezoneOffsetPresent = timezoneOffset.newIf("_match != null");
        timezoneOffsetPresent.addComment(" Eeek!  handle timezone offset!");
        meth.addStmt("return _result");
    }

    private String doBasicTypeCoercion(String expr, XSDTypeDefinition type) {
        if (XSDUtils.typeIsA(type, "http://www.w3.org/2001/XMLSchema", "boolean")) {
            return "Boolean(" + expr + ")";
        }
        if (XSDUtils.typeIsA(type, "http://www.w3.org/2001/XMLSchema", "int")) {
            return "Number(" + expr + ")";
        }
        if (XSDUtils.typeIsA(type, "http://www.w3.org/2001/XMLSchema", "float")) {
            return "Number(" + expr + ")";
        }
        if (XSDUtils.typeIsA(type, "http://www.w3.org/2001/XMLSchema", "string")) {
            return expr;
        }
        if (XSDUtils.typeIsA(type, "http://www.w3.org/2001/XMLSchema", "double")) {
            return expr;
        }
        if (XSDUtils.typeIsA(type, "http://www.w3.org/2001/XMLSchema", "decimal")) {
            return expr;
        }
        if (XSDUtils.typeIsA(type, "http://www.w3.org/2001/XMLSchema", "long")) {
            return expr;
        }
        if (XSDUtils.typeIsA(type, "http://www.w3.org/2001/XMLSchema", "short")) {
            return "Number(" + expr + ")";
        }
        this.builder.warn("Unable to produce type convertion expression for " + type.getURI());
        return String.valueOf(expr) + " /* <-- didn't know how to convert */";
    }

    public void initComplexTypeElementProcessing(XSDParticle particle, ASMethod meth) {
        meth.addStmt("var _children:XMLList = thisElement.children()");
        meth.addStmt("var _seq:int = 0");
    }

    public StatementContainer createOptionalElementTest(StatementContainer meth, XSDElementDeclaration elementDecl) {
        String namespaceStr = ASSourceFactory.str(elementDecl.getTargetNamespace());
        String localNameStr = ASSourceFactory.str(elementDecl.getName());
        return meth.newIf("_children[_seq].name()==new QName(" + namespaceStr + ", " + localNameStr + ")");
    }

    public String createInputReadExpr(XSDParticle part, XSDElementDeclaration decl) {
        return "_children[_seq++]";
    }

    public void createOutputWriteExpr(XSDParticle part, XSDElementDeclaration decl, String toWrite, StatementContainer block) {
        block.addStmt("_result." + this.varGen.fieldName(decl) + "=" + toWrite);
    }

    public void buildMultiplyOccuringElementProcessing(XSDElementDeclaration decl, StatementContainer block, String converted) {
        String fieldAccess = "_result." + this.varGen.fieldName(decl);
        block.addStmt(String.valueOf(fieldAccess) + " = new Array()");
        block = block.newWhile("_seq<_children.length() && _children[_seq].name()==new QName(" + ASSourceFactory.str(decl.getTargetNamespace()) + ", " + ASSourceFactory.str(decl.getName()) + ")");
        block.addStmt(String.valueOf(fieldAccess) + ".push(" + converted + ")");
    }

    public void buildListPatternElementProcessing(XSDElementDeclaration decl, XSDElementDeclaration listElement, StatementContainer block, String accessExpr) {
        String fieldAccess = "_result." + this.varGen.fieldName(decl);
        block.addStmt(String.valueOf(fieldAccess) + " = new Array()");
        StatementContainer loop = block.newForEachIn("var _child:XML", String.valueOf(accessExpr) + ".elements()");
        String converted = this.builder.convertedFrom(listElement.getType(), "_child");
        loop.addStmt(String.valueOf(fieldAccess) + ".push(" + converted + ")");
    }

    public StatementContainer buildElementContentTest(StatementContainer code, XSDElementDeclaration firstElement) {
        String namespaceStr = ASSourceFactory.str(firstElement.getTargetNamespace());
        String localNameStr = ASSourceFactory.str(firstElement.getName());
        return code.newIf("_children[_seq].name()==new QName(" + namespaceStr + ", " + localNameStr + ")");
    }

    public void returnConvertedSimpleTypeElement(String name, XSDSimpleTypeDefinition stype, ASMethod meth) {
        meth.addStmt("return " + this.convertSimpleTypeElement(name, stype));
    }

    public void buildAttributeProcessing(ASMethod meth, XSDAttributeDeclaration attrDecl) {
        String accessExpr = "thisElement." + StringUtils.attrAccess(attrDecl);
        accessExpr = this.builder.convertedFrom(attrDecl.getTypeDefinition(), accessExpr);
        meth.addStmt("_result." + this.varGen.fieldName(attrDecl) + " = " + accessExpr);
    }

    public void buildElementProcessing(XSDElementDeclaration decl, XSDTypeDefinition typeDef, String accessExpr, StatementContainer block) {
        String toWrite = this.builder.convertedFrom(typeDef, accessExpr);
        block.addStmt("_result." + this.varGen.fieldName(decl) + "=" + toWrite);
    }
}

