/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.asxsd;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import uk.co.badgersinfoil.asxsd.StringUtils;
import uk.co.badgersinfoil.asxsd.TypeBuilder;
import uk.co.badgersinfoil.asxsd.UnmarshalingCodeGenStrategy;
import uk.co.badgersinfoil.asxsd.VariableNameGenerator;
import uk.co.badgersinfoil.asxsd.XSDUtils;
import uk.co.badgersinfoil.metaas.ASArg;
import uk.co.badgersinfoil.metaas.ASClassType;
import uk.co.badgersinfoil.metaas.ASMethod;
import uk.co.badgersinfoil.metaas.ASProject;
import uk.co.badgersinfoil.metaas.ASSourceFactory;
import uk.co.badgersinfoil.metaas.CompilationUnit;
import uk.co.badgersinfoil.metaas.StatementContainer;
import uk.co.badgersinfoil.metaas.Visibility;

public class UnmarshalerBuilder {
    private TypeBuilder typeBuilder;
    private VariableNameGenerator varGen = new VariableNameGenerator();
    private Map converterClassesByNamespace = new HashMap();
    private Map converterMethodsByQName = new HashMap();
    private ASProject project;
    private UnmarshalingCodeGenStrategy codeGenStrategy = new UnmarshalingCodeGenStrategy(this, this.varGen);

    public UnmarshalerBuilder(ASProject project, TypeBuilder typeBuilder) {
        this.typeBuilder = typeBuilder;
        this.project = project;
    }

    public void processSchema(XSDSchema schema) {
        EList types = schema.getTypeDefinitions();
        Iterator i = types.iterator();
        while (i.hasNext()) {
            XSDTypeDefinition typeDef = (XSDTypeDefinition)i.next();
            if (!(typeDef instanceof XSDComplexTypeDefinition)) continue;
            XSDComplexTypeDefinition ctype = (XSDComplexTypeDefinition)typeDef;
            ASMethod meth = this.createMethodForType(ctype);
            this.buildMethodBody(typeDef, this.typeBuilder.typeNameFor(typeDef), meth);
        }
    }

    private ASMethod createMethodForType(XSDTypeDefinition typeDef) {
        CompilationUnit unit = this.getClassForNamespace(typeDef.getTargetNamespace());
        ASClassType clazz = (ASClassType)unit.getType();
        String typeName = this.typeBuilder.typeNameFor(typeDef);
        String methodName = this.codeGenStrategy.converterMethodNameFor(typeDef);
        ASMethod meth = clazz.newMethod(methodName, Visibility.PUBLIC, typeName);
        meth.setStatic(true);
        return meth;
    }

    private ASMethod createMethodForElement(XSDElementDeclaration elementDecl) {
        CompilationUnit unit = this.getClassForNamespace(elementDecl.getTargetNamespace());
        ASClassType clazz = (ASClassType)unit.getType();
        String typeName = this.typeBuilder.typeNameFor(elementDecl);
        String methodName = this.codeGenStrategy.converterMethodNameFor(elementDecl);
        ASMethod meth = clazz.newMethod(methodName, Visibility.PUBLIC, typeName);
        this.buildMethodBody(elementDecl, typeName, meth);
        meth.setStatic(true);
        return meth;
    }

    private void buildMethodBody(XSDTypeDefinition typeDef, String typeName, ASMethod meth) {
        if (typeDef instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition ctype = (XSDComplexTypeDefinition)typeDef;
            this.codeGenStrategy.addConversionFromParameter(ctype, meth);
            meth.addStmt("var _result:" + typeName + " = new " + typeName + "()");
            XSDElementDeclaration listElement = XSDUtils.getElementIfContainerForList(ctype);
            if (listElement == null) {
                this.processComplexTypeBaseType(ctype, meth);
                this.processAllComplexTypeAttributes(ctype, meth);
                this.processAllComplexTypeElements(ctype, meth);
            } else {
                this.codeGenStrategy.processList(ctype, listElement, meth);
            }
            meth.addStmt("return _result");
        } else {
            XSDSimpleTypeDefinition stype = (XSDSimpleTypeDefinition)typeDef;
            ASArg arg = this.codeGenStrategy.addConvertionFromParameter(stype, meth);
            meth.addStmt("return " + this.convertedFrom(stype.getBaseTypeDefinition(), arg.getName()));
        }
    }

    private void buildMethodBody(XSDElementDeclaration elementDecl, String typeName, ASMethod meth) {
        XSDTypeDefinition typeDef = elementDecl.getType();
        if (typeDef instanceof XSDComplexTypeDefinition) {
            this.buildMethodBody(typeDef, typeName, meth);
        } else {
            ASArg arg = this.codeGenStrategy.addConversionFromParameter(elementDecl, meth);
            XSDSimpleTypeDefinition stype = (XSDSimpleTypeDefinition)typeDef;
            meth.addStmt("return " + this.codeGenStrategy.convertSimpleTypeElement(arg.getName(), stype));
        }
    }

    private CompilationUnit getClassForNamespace(String namespace) {
        CompilationUnit result = (CompilationUnit)this.converterClassesByNamespace.get(namespace);
        if (result == null) {
            result = this.project.newClass(this.codeGenStrategy.converterClassNameForNamespace(namespace));
            this.converterClassesByNamespace.put(namespace, result);
        }
        return result;
    }

    private void processComplexTypeBaseType(XSDComplexTypeDefinition ctype, ASMethod meth) {
        XSDTypeDefinition baseType = ctype.getBaseType();
        if (!XSDUtils.isXSDAnyType(baseType)) {
            this.warn("Base class initialisation for " + baseType.getQName() + " (base class of " + ctype.getQName() + ") not handled; sorry");
        }
    }

    private void processAllComplexTypeAttributes(XSDComplexTypeDefinition ctype, ASMethod meth) {
        EList attrs = ctype.getAttributeContents();
        Iterator i = attrs.iterator();
        while (i.hasNext()) {
            XSDAttributeGroupContent attrContent = (XSDAttributeGroupContent)i.next();
            if (attrContent instanceof XSDAttributeUse) {
                this.processComplexTypeAttribute((XSDAttributeUse)attrContent, meth);
                continue;
            }
            this.warn("unhandled, sorry: " + attrContent);
        }
    }

    private void processComplexTypeAttribute(XSDAttributeUse attrUse, ASMethod meth) {
        XSDAttributeDeclaration attrDecl = attrUse.getAttributeDeclaration();
        String accessExpr = "thisElement." + this.attrAccess(attrDecl);
        accessExpr = this.convertedFrom(attrDecl.getTypeDefinition(), accessExpr);
        meth.addStmt("_result." + this.varGen.fieldName(attrDecl) + " = " + accessExpr);
    }

    private String attrAccess(XSDAttributeDeclaration attrDecl) {
        if (StringUtils.isValidIdent(attrDecl.getName())) {
            return "@" + attrDecl.getName();
        }
        return "@[" + ASSourceFactory.str(attrDecl.getName()) + "]";
    }

    private void processAllComplexTypeElements(XSDComplexTypeDefinition typeDef, ASMethod meth) {
        XSDComplexTypeContent complexContent = typeDef.getContent();
        if (complexContent instanceof XSDParticle) {
            meth.addComment(" process child sequence elements,");
            XSDParticle particle = (XSDParticle)complexContent;
            this.codeGenStrategy.initComplexTypeElementProcessing(particle, meth);
            XSDParticleContent particleContent = particle.getContent();
            this.processParticleContent(particleContent, meth);
        } else {
            this.warn("this kind of complex content not handled, sorry: " + complexContent);
        }
    }

    private void processParticleContent(XSDParticleContent particleContent, StatementContainer meth) {
        if (particleContent instanceof XSDModelGroup) {
            XSDModelGroup modelGroup = (XSDModelGroup)particleContent;
            this.processModelGroup(modelGroup, meth);
        }
    }

    private void processModelGroup(XSDModelGroup modelGroup, StatementContainer code) {
        if (modelGroup.getCompositor().equals(XSDCompositor.SEQUENCE_LITERAL)) {
            this.processComplexTypeSequence(modelGroup, code);
        } else if (modelGroup.getCompositor().equals(XSDCompositor.CHOICE_LITERAL)) {
            this.processComplexTypeChoice(modelGroup, code);
        } else {
            throw new IllegalArgumentException("Unhandled, sorry: " + modelGroup.getCompositor());
        }
    }

    private void processComplexTypeSequence(XSDModelGroup modelGroup, StatementContainer meth) {
        EList particles = modelGroup.getParticles();
        Iterator i = particles.iterator();
        while (i.hasNext()) {
            StatementContainer block = meth;
            XSDParticle part = (XSDParticle)i.next();
            XSDParticleContent partContent = part.getContent();
            if (partContent instanceof XSDElementDeclaration) {
                XSDElementDeclaration elementDecl = (XSDElementDeclaration)partContent;
                if (elementDecl.isElementDeclarationReference()) {
                    elementDecl = elementDecl.getResolvedElementDeclaration();
                }
                if (this.isOptional(part)) {
                    block = this.codeGenStrategy.createOptionalElementTest(meth, elementDecl);
                }
                this.processComplexTypeSequenceElementDeclaration(part, elementDecl, block);
                continue;
            }
            throw new IllegalArgumentException("No supported in <sequence>: " + partContent + ", sorry");
        }
    }

    private boolean isOptional(XSDParticle part) {
        return part.getMinOccurs() == 0 && part.getMaxOccurs() == 1;
    }

    private void processComplexTypeSequenceElementDeclaration(XSDParticle part, XSDElementDeclaration decl, StatementContainer block) {
        String accessExpr = this.codeGenStrategy.createInputReadExpr(part, decl);
        XSDTypeDefinition typeDef = decl.getType();
        String fieldAccess = this.codeGenStrategy.createOutputWriteExpr(part, decl);
        if (typeDef instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition stype = (XSDSimpleTypeDefinition)typeDef;
            accessExpr = this.codeGenStrategy.convertSimpleTypeElement(accessExpr, stype);
            block.addStmt(String.valueOf(fieldAccess) + " = " + accessExpr);
        } else {
            XSDElementDeclaration listElement = XSDUtils.getElementIfContainerForList(decl);
            if (listElement == null) {
                String converted = this.convertedFrom(typeDef, accessExpr);
                if (XSDUtils.isMultiplyOccuring(part)) {
                    this.codeGenStrategy.buildMultiplyOccuringElementProcessing(decl, block, fieldAccess, converted);
                } else {
                    block.addStmt(String.valueOf(fieldAccess) + " = " + converted);
                }
            } else {
                this.codeGenStrategy.buildListPatternElementProcessing(listElement, block, accessExpr, fieldAccess);
            }
        }
    }

    private void processComplexTypeChoice(XSDModelGroup modelGroup, StatementContainer meth) {
        EList particles = modelGroup.getParticles();
        Iterator i = particles.iterator();
        while (i.hasNext()) {
            XSDParticle part = (XSDParticle)i.next();
            XSDParticleContent partContent = part.getContent();
            StatementContainer choiceBlock = this.detectElementContent(partContent, meth);
            this.processParticleContent(partContent, choiceBlock);
        }
    }

    private StatementContainer detectElementContent(XSDParticleContent partContent, StatementContainer code) {
        XSDElementDeclaration firstElement = this.findFirstElementDeclaration(partContent);
        return this.codeGenStrategy.buildElementContentTest(code, firstElement);
    }

    private XSDElementDeclaration findFirstElementDeclaration(XSDParticleContent particleContent) {
        while (true) {
            if (particleContent instanceof XSDElementDeclaration) {
                return (XSDElementDeclaration)particleContent;
            }
            if (!(particleContent instanceof XSDModelGroup)) break;
            XSDModelGroup modelGroup = (XSDModelGroup)particleContent;
            EList particles = modelGroup.getParticles();
            if (particles.size() <= 0) continue;
            XSDParticle part = (XSDParticle)particles.get(0);
            particleContent = part.getContent();
        }
        throw new IllegalArgumentException("unhandled, sorry: " + particleContent);
    }

    String convertedFrom(XSDTypeDefinition typeDef, String expr) {
        if (XSDUtils.isXSDAnyType(typeDef)) {
            return expr;
        }
        return String.valueOf(this.conversionMethodFor(typeDef)) + "(" + expr + ")";
    }

    public String conversionMethodFor(XSDTypeDefinition typeDef) {
        String pkgName;
        if (typeDef.getName() == null) {
            throw new IllegalArgumentException("Anonymous type defs not supported, sorry: " + typeDef);
        }
        QName qName = new QName(typeDef.getTargetNamespace(), typeDef.getName());
        ASMethod convert = (ASMethod)this.converterMethodsByQName.get(qName);
        CompilationUnit unit = this.getClassForNamespace(typeDef.getTargetNamespace());
        if (convert == null) {
            convert = this.createMethodForType(typeDef);
            this.converterMethodsByQName.put(qName, convert);
            if (typeDef.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema")) {
                this.codeGenStrategy.buildBuiltinMethodBody(typeDef, convert);
            } else {
                this.buildMethodBody(typeDef, this.typeBuilder.typeNameFor(typeDef), convert);
            }
        }
        if ((pkgName = unit.getPackageName()) == null) {
            return String.valueOf(unit.getType().getName()) + "." + convert.getName();
        }
        return String.valueOf(pkgName) + "." + unit.getType().getName() + "." + convert.getName();
    }

    public String conversionMethodFor(XSDElementDeclaration elementDecl) {
        String pkgName;
        QName qName = new QName(elementDecl.getTargetNamespace(), "Element_" + elementDecl.getName());
        ASMethod convert = (ASMethod)this.converterMethodsByQName.get(qName);
        CompilationUnit unit = this.getClassForNamespace(elementDecl.getTargetNamespace());
        if (convert == null) {
            convert = this.createMethodForElement(elementDecl);
            this.converterMethodsByQName.put(qName, convert);
        }
        if ((pkgName = unit.getPackageName()) == null) {
            return String.valueOf(unit.getType().getName()) + "." + convert.getName();
        }
        return String.valueOf(pkgName) + "." + unit.getType().getName() + "." + convert.getName();
    }

    void warn(String msg) {
        System.err.println(msg);
    }
}

