/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.asxsd;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import uk.co.badgersinfoil.asxsd.StringUtils;
import uk.co.badgersinfoil.asxsd.XSDUtils;

public class TypeNameGenerator {
    private Map names = new HashMap();

    public String typeName(XSDNamedComponent named) {
        if (named instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)named;
            return this.lookupTypeName(simpleType);
        }
        if (XSDUtils.isXSDAnyType(named)) {
            return "XML";
        }
        return this.getNameFor(new QName(named.getTargetNamespace(), named.getName()));
    }

    private String lookupTypeName(XSDSimpleTypeDefinition simpleType) {
        if (simpleType == null) {
            return null;
        }
        if (simpleType.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema")) {
            if (simpleType.getName().equals("string")) {
                return "String";
            }
            if (simpleType.getName().equals("NMTOKEN")) {
                return "String";
            }
            if (simpleType.getName().equals("double")) {
                return "String";
            }
            if (simpleType.getName().equals("decimal")) {
                return "String";
            }
            if (simpleType.getName().equals("boolean")) {
                return "Boolean";
            }
            if (simpleType.getName().equals("int")) {
                return "int";
            }
            if (simpleType.getName().equals("float")) {
                return "Number";
            }
            if (simpleType.getName().equals("long")) {
                return "String";
            }
            if (simpleType.getName().equals("dateTime")) {
                return "Date";
            }
            if (simpleType.getName().equals("short")) {
                return "int";
            }
            System.err.println("Unhandled type " + simpleType.getURI());
            return null;
        }
        return this.lookupTypeName(simpleType.getBaseTypeDefinition());
    }

    public String getNameFor(QName name) {
        String existing = (String)this.names.get(name);
        if (existing != null) {
            return existing;
        }
        String pkg = StringUtils.toPackageName(name.getNamespaceURI());
        String clazz = this.classNameFor(name.getLocalPart());
        String baseName = String.valueOf(pkg) + "." + clazz;
        int count = 1;
        while (this.names.containsValue(baseName)) {
            String mangled = String.valueOf(baseName) + "_" + count++;
            if (!this.names.containsValue(baseName)) {
                this.names.put(name, baseName);
                return mangled;
            }
            if (count <= 5000) continue;
            throw new Error("Couldn't assign a unique name after 5000 iterations");
        }
        this.names.put(name, baseName);
        return baseName;
    }

    private String classNameFor(String localPart) {
        return StringUtils.sanitize(localPart);
    }
}

