/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.asxsd;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Element;
import uk.co.badgersinfoil.asxsd.TypeDescriptor;
import uk.co.badgersinfoil.asxsd.TypeNameGenerator;
import uk.co.badgersinfoil.asxsd.VariableNameGenerator;
import uk.co.badgersinfoil.asxsd.XSDUtils;
import uk.co.badgersinfoil.metaas.ASClassType;
import uk.co.badgersinfoil.metaas.ASField;
import uk.co.badgersinfoil.metaas.ASProject;
import uk.co.badgersinfoil.metaas.CompilationUnit;
import uk.co.badgersinfoil.metaas.Visibility;

public class TypeBuilder {
    private TypeNameGenerator nameGen;
    private VariableNameGenerator varGen = new VariableNameGenerator();
    private ASProject project;
    private Map representationClassesByQName = new HashMap();

    public TypeBuilder(ASProject project, TypeNameGenerator nameGen) {
        this.nameGen = nameGen;
        this.project = project;
    }

    public String typeNameFor(XSDTypeDefinition typeDef) {
        if (typeDef instanceof XSDComplexTypeDefinition) {
            CompilationUnit unit = this.representationClassForComplexType((XSDComplexTypeDefinition)typeDef);
            if (unit.getPackageName() == null) {
                return unit.getType().getName();
            }
            return String.valueOf(unit.getPackageName()) + "." + unit.getType().getName();
        }
        return this.nameGen.typeName(typeDef);
    }

    public String typeNameFor(XSDElementDeclaration elementDecl) {
        XSDElementDeclaration listElement;
        if (elementDecl.isElementDeclarationReference()) {
            elementDecl = elementDecl.getResolvedElementDeclaration();
        }
        if ((listElement = XSDUtils.getElementIfContainerForList(elementDecl)) != null) {
            return "Array";
        }
        XSDTypeDefinition typeDef = elementDecl.getType();
        if (typeDef != null && typeDef.getName() != null) {
            return this.typeNameFor(typeDef);
        }
        typeDef = elementDecl.getAnonymousTypeDefinition();
        if (typeDef instanceof XSDComplexTypeDefinition) {
            CompilationUnit unit = this.representationClassForComplexType(elementDecl);
            if (unit.getPackageName() == null) {
                return unit.getType().getName();
            }
            return String.valueOf(unit.getPackageName()) + "." + unit.getType().getName();
        }
        return this.nameGen.typeName(typeDef);
    }

    public CompilationUnit representationClassForComplexType(XSDComplexTypeDefinition typeDef) {
        CompilationUnit result = (CompilationUnit)this.representationClassesByQName.get(typeDef.getQName());
        if (result == null) {
            result = this.project.newClass(this.nameGen.typeName(typeDef));
            this.representationClassesByQName.put(typeDef.getQName(), result);
            this.processComplexType(typeDef, result);
        }
        return result;
    }

    public CompilationUnit representationClassForComplexType(XSDElementDeclaration elementDecl) {
        QName qname = new QName(elementDecl.getTargetNamespace(), "Element_" + elementDecl.getName());
        CompilationUnit result = (CompilationUnit)this.representationClassesByQName.get(qname.toString());
        if (result == null) {
            result = this.project.newClass(this.nameGen.getNameFor(qname));
            this.representationClassesByQName.put(qname.toString(), result);
            this.processComplexType((XSDComplexTypeDefinition)elementDecl.getTypeDefinition(), result);
        }
        return result;
    }

    private void processComplexType(XSDComplexTypeDefinition typeDef, CompilationUnit unit) {
        ASClassType clazz = (ASClassType)unit.getType();
        this.processComplexTypeBaseType(typeDef, clazz);
        this.processComplexTypeAnnotation(typeDef, clazz);
        this.processAllComplexTypeAttributes(typeDef, clazz);
        this.processAllComplexTypeElements(typeDef, clazz);
    }

    private void processComplexTypeBaseType(XSDComplexTypeDefinition typeDef, ASClassType clazz) {
        XSDTypeDefinition baseType = typeDef.getBaseType();
        if (!XSDUtils.isXSDAnyType(baseType)) {
            clazz.setSuperclass(this.nameGen.typeName(baseType));
        }
    }

    private void processAllComplexTypeAttributes(XSDComplexTypeDefinition typeDef, ASClassType clazz) {
        EList attrs = typeDef.getAttributeContents();
        Iterator i = attrs.iterator();
        while (i.hasNext()) {
            XSDAttributeGroupContent attrContent = (XSDAttributeGroupContent)i.next();
            if (!(attrContent instanceof XSDAttributeUse)) continue;
            this.processComplexTypeAttribute((XSDAttributeUse)attrContent, clazz);
        }
    }

    private void processComplexTypeAttribute(XSDAttributeUse attrUse, ASClassType clazz) {
        XSDAttributeDeclaration attrDecl = attrUse.getAttributeDeclaration();
        ASField field = clazz.newField(this.varGen.fieldName(attrDecl), Visibility.PUBLIC, this.nameGen.typeName(attrDecl.getTypeDefinition()));
        String doc = this.findDocumentation(attrDecl.getAnnotation());
        if (doc != null) {
            field.setDocComment(doc);
        }
    }

    private void processComplexTypeAnnotation(XSDComplexTypeDefinition typeDef, ASClassType clazz) {
        String doc = this.findDocumentation(typeDef.getAnnotation());
        if (doc != null) {
            clazz.setDocComment("\n" + doc + "\n");
        }
    }

    private String findDocumentation(XSDAnnotation annotation) {
        if (annotation != null) {
            EList docs = annotation.getUserInformation();
            Iterator i = docs.iterator();
            if (i.hasNext()) {
                Element doc = (Element)i.next();
                return this.preProcessComment(doc.getTextContent());
            }
        }
        return null;
    }

    private String preProcessComment(String text) {
        return text.replaceFirst("\\A\\s*", " ").replaceAll("([\n\r])\\s+", "$1 ");
    }

    private void processAllComplexTypeElements(XSDComplexTypeDefinition typeDef, ASClassType clazz) {
        XSDModelGroup modelGroup;
        XSDParticle particle;
        XSDParticleContent particleContent;
        XSDComplexTypeContent complexContent = typeDef.getContent();
        if (complexContent instanceof XSDParticle && (particleContent = (particle = (XSDParticle)complexContent).getContent()) instanceof XSDModelGroup && (modelGroup = (XSDModelGroup)particleContent).getCompositor().equals(XSDCompositor.SEQUENCE_LITERAL)) {
            this.processComplexTypeSequence(typeDef, modelGroup, clazz);
        }
    }

    private void processComplexTypeSequence(XSDComplexTypeDefinition typeDef, XSDModelGroup modelGroup, ASClassType clazz) {
        EList particles = modelGroup.getParticles();
        Iterator i = particles.iterator();
        while (i.hasNext()) {
            XSDParticle part = (XSDParticle)i.next();
            XSDParticleContent partContent = part.getContent();
            if (!(partContent instanceof XSDElementDeclaration)) continue;
            this.processComplexTypeElementDeclaration(part, (XSDElementDeclaration)partContent, clazz);
        }
    }

    private void processComplexTypeElementDeclaration(XSDParticle part, XSDElementDeclaration decl, ASClassType clazz) {
        TypeDescriptor typeDesc;
        if (decl.isElementDeclarationReference()) {
            decl = decl.getResolvedElementDeclaration();
        }
        if ((typeDesc = this.typeDescriptorForElementDecl(part, decl)).getTypeName() == null) {
            System.err.println("no AS type resulted from: " + decl);
        }
        ASField field = clazz.newField(this.varGen.fieldName(decl), Visibility.PUBLIC, typeDesc.getTypeName());
        if (typeDesc.getDocumentation() != null) {
            field.setDocComment(typeDesc.getDocumentation());
        }
    }

    public TypeDescriptor typeDescriptorForElementDecl(XSDParticle part, XSDElementDeclaration decl) {
        XSDElementDeclaration listElement = XSDUtils.getElementIfContainerForList(decl);
        String typeName = null;
        String doc = this.findDocumentation(decl.getAnnotation());
        boolean array = false;
        if (listElement != null) {
            typeName = "Array";
            doc = doc == null ? "" : String.valueOf(doc) + "\n\n";
            doc = String.valueOf(doc) + " Elements of type {@link " + this.typeNameFor(listElement.getType()) + "}";
            array = true;
        } else if (XSDUtils.isMultiplyOccuring(part)) {
            typeName = "Array";
            doc = doc == null ? "" : String.valueOf(doc) + "\n\n";
            if (decl.getType() != null) {
                doc = String.valueOf(doc) + "Elements of type {@link " + this.typeNameFor(decl) + "}\n";
            }
            doc = String.valueOf(doc) + "minOccurs " + this.describeMultiplicity(part.getMinOccurs()) + ", maxOccurs " + this.describeMultiplicity(part.getMaxOccurs());
            array = true;
        } else if (decl.getType() != null && decl.getType().getName() != null) {
            typeName = this.typeNameFor(decl.getType());
        }
        return new TypeDescriptor(typeName, array, doc);
    }

    private String describeMultiplicity(int occurs) {
        if (occurs == -1) {
            return "unbounded";
        }
        return String.valueOf(occurs);
    }
}

