/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.asxsd;

import org.eclipse.emf.common.util.URI;
import org.eclipse.xsd.XSDAttributeDeclaration;
import uk.co.badgersinfoil.metaas.ASSourceFactory;

public class StringUtils {
    public static String toPackageName(String targetNamespace) {
        String path;
        URI uri = URI.createURI(targetNamespace);
        String name = StringUtils.reverseJoin(StringUtils.sanitize(uri.host().split("\\.")), ".");
        if (uri.hasPath() && (path = uri.path().replaceAll("/+", "/").replaceFirst("\\A/", "")).length() > 0) {
            name = String.valueOf(name) + "." + StringUtils.join(StringUtils.sanitize(path.split("/")), ".");
        }
        return name;
    }

    public static String[] sanitize(String[] strings) {
        int i = 0;
        while (i < strings.length) {
            strings[i] = StringUtils.sanitize(strings[i]);
            ++i;
        }
        return strings;
    }

    public static String sanitize(String string) {
        StringBuffer result = new StringBuffer();
        if (!Character.isJavaIdentifierStart(string.charAt(0)) && Character.isJavaIdentifierPart(string.charAt(0))) {
            result.append("_");
        }
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                result.append(c);
            } else {
                result.append("_");
            }
            ++i;
        }
        return result.toString();
    }

    public static String reverseJoin(String[] strings, String delimiter) {
        StringBuffer result = new StringBuffer();
        int i = strings.length - 1;
        while (i >= 0) {
            result.append(strings[i]);
            if (i > 0) {
                result.append(delimiter);
            }
            --i;
        }
        return result.toString();
    }

    public static String join(String[] strings, String delimiter) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            if (i > 0) {
                result.append(delimiter);
            }
            result.append(strings[i]);
            ++i;
        }
        return result.toString();
    }

    public static boolean isValidIdent(String name) {
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierPart(name.charAt(0))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String attrAccess(XSDAttributeDeclaration attrDecl) {
        if (StringUtils.isValidIdent(attrDecl.getName())) {
            return "@" + attrDecl.getName();
        }
        return "@[" + ASSourceFactory.str(attrDecl.getName()) + "]";
    }
}

