/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.asxsd;

import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import uk.co.badgersinfoil.asxsd.MarshalUnmarshalBuilder;
import uk.co.badgersinfoil.asxsd.MarshalUnmarshalCodeGenStrategy;
import uk.co.badgersinfoil.asxsd.StringUtils;
import uk.co.badgersinfoil.asxsd.TypeBuilder;
import uk.co.badgersinfoil.asxsd.VariableNameGenerator;
import uk.co.badgersinfoil.asxsd.XSDUtils;
import uk.co.badgersinfoil.metaas.ASArg;
import uk.co.badgersinfoil.metaas.ASIfStatement;
import uk.co.badgersinfoil.metaas.ASMethod;
import uk.co.badgersinfoil.metaas.StatementContainer;

public class MarshalingCodeGenStrategy
implements MarshalUnmarshalCodeGenStrategy {
    private MarshalUnmarshalBuilder builder;
    private VariableNameGenerator varGen;
    private TypeBuilder typeBuilder;

    public MarshalingCodeGenStrategy(VariableNameGenerator varGen, TypeBuilder typeBuilder) {
        this.varGen = varGen;
        this.typeBuilder = typeBuilder;
    }

    public void setBuilder(MarshalUnmarshalBuilder builder) {
        this.builder = builder;
    }

    public void createElementDeclInit(XSDElementDeclaration elementDecl, ASMethod meth) {
        meth.addStmt("var _result:XML = <" + elementDecl.getName() + "/>");
    }

    public void createTypeDefInit(XSDTypeDefinition typeDef, ASMethod meth) {
        if (typeDef instanceof XSDComplexTypeDefinition) {
            meth.addParam("_result", "XML");
        }
    }

    public String conversionTargetTypeName(XSDTypeDefinition typeDef) {
        if (typeDef instanceof XSDComplexTypeDefinition) {
            return "XML";
        }
        return "String";
    }

    public String conversionTargetTypeName(XSDElementDeclaration elementDecl) {
        return "XML";
    }

    public String converterMethodNameFor(XSDTypeDefinition typeDef) {
        return "marshal" + StringUtils.sanitize(typeDef.getName());
    }

    public String converterMethodNameFor(XSDElementDeclaration elementDecl) {
        return "marshalElement_" + StringUtils.sanitize(elementDecl.getName());
    }

    public String converterClassNameForNamespace(String uri) {
        return String.valueOf(StringUtils.toPackageName(uri)) + ".Marshaler";
    }

    public void addConversionFromParameter(XSDComplexTypeDefinition ctype, ASMethod meth) {
        meth.addParam("thisObject", this.typeBuilder.typeNameFor(ctype));
    }

    public ASArg addConvertionFromParameter(XSDSimpleTypeDefinition stype, ASMethod meth) {
        return meth.addParam("thisObject", this.typeBuilder.typeNameFor(stype));
    }

    public void processList(XSDComplexTypeDefinition ctype, XSDElementDeclaration listElement, ASMethod meth) {
        meth.addComment(" process child sequence elements,");
        String elementType = this.typeBuilder.typeNameFor(listElement);
        String fieldAccess = "_result";
        StatementContainer loop = meth.newForEachIn("var _child:" + elementType, "thisObject");
        String converted = this.builder.convertedFrom(listElement.getType(), "_child");
        loop.addStmt(String.valueOf(fieldAccess) + ".appendChild(" + converted + ")");
    }

    public ASArg addConversionFromParameter(XSDElementDeclaration elementDecl, ASMethod meth) {
        return meth.addParam("thisObject", this.typeBuilder.typeNameFor(elementDecl));
    }

    public String convertSimpleTypeElement(String expr, XSDSimpleTypeDefinition stype) {
        return this.builder.convertedFrom(stype, expr);
    }

    public void buildBuiltinMethodBody(XSDTypeDefinition typeDef, ASMethod meth) {
        if (typeDef instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition stype = (XSDSimpleTypeDefinition)typeDef;
            String paramType = this.typeBuilder.typeNameFor(stype);
            meth.addParam("thisValue", paramType);
            if (XSDUtils.typeIsA(stype, "http://www.w3.org/2001/XMLSchema", "dateTime")) {
                this.buildBuiltinDatatimeConversion(meth, "thisValue", stype);
            } else {
                meth.addStmt("return " + this.doBasicTypeCoercion("thisValue", stype));
            }
        } else {
            throw new IllegalArgumentException("Expected a simpleType " + typeDef);
        }
    }

    private void buildBuiltinDatatimeConversion(ASMethod meth, String expr, XSDSimpleTypeDefinition stype) {
        meth.addStmt("var _result:String = \"\"");
        meth.addStmt("_result += " + expr + ".fullYearUTC");
        meth.addStmt("_result += \"-\"");
        meth.addStmt("_result += " + expr + ".monthUTC+1");
        meth.addStmt("_result += \"-\"");
        meth.addStmt("_result += " + expr + ".dateUTC");
        meth.addStmt("_result += \"T\"");
        meth.addStmt("_result += " + expr + ".hoursUTC");
        meth.addStmt("_result += \":\"");
        meth.addStmt("_result += " + expr + ".minutesUTC");
        meth.addStmt("_result += \":\"");
        meth.addStmt("_result += " + expr + ".secondsUTC");
        ASIfStatement secondsFraction = meth.newIf(expr + ".millisecondsUTC != 0");
        secondsFraction.addStmt("_result += String(" + expr + ".millisecondsUTC/1000).slice(1)");
        meth.addStmt("_result += \" Z\"");
        meth.addStmt("return _result");
    }

    private String doBasicTypeCoercion(String expr, XSDTypeDefinition type) {
        if (XSDUtils.typeIsA(type, "http://www.w3.org/2001/XMLSchema", "boolean")) {
            return "String(" + expr + ")";
        }
        if (XSDUtils.typeIsA(type, "http://www.w3.org/2001/XMLSchema", "int")) {
            return "String(" + expr + ")";
        }
        if (XSDUtils.typeIsA(type, "http://www.w3.org/2001/XMLSchema", "float")) {
            return "String(" + expr + ")";
        }
        if (XSDUtils.typeIsA(type, "http://www.w3.org/2001/XMLSchema", "string")) {
            return expr;
        }
        if (XSDUtils.typeIsA(type, "http://www.w3.org/2001/XMLSchema", "double")) {
            return expr;
        }
        if (XSDUtils.typeIsA(type, "http://www.w3.org/2001/XMLSchema", "decimal")) {
            return expr;
        }
        if (XSDUtils.typeIsA(type, "http://www.w3.org/2001/XMLSchema", "long")) {
            return expr;
        }
        if (XSDUtils.typeIsA(type, "http://www.w3.org/2001/XMLSchema", "short")) {
            return "String(" + expr + ")";
        }
        this.builder.warn("Unable to produce type convertion expression for " + type.getURI());
        return String.valueOf(expr) + " /* <-- didn't know how to convert */";
    }

    public void initComplexTypeElementProcessing(XSDParticle particle, ASMethod meth) {
    }

    public StatementContainer buildElementContentTest(StatementContainer code, XSDElementDeclaration firstElement) {
        String propertyName = this.varGen.fieldName(firstElement);
        return code.newIf("thisObject." + propertyName + " != null");
    }

    public String createInputReadExpr(XSDParticle part, XSDElementDeclaration decl) {
        String propertyName = this.varGen.fieldName(decl);
        return "thisObject." + propertyName;
    }

    public void createOutputWriteExpr(XSDParticle part, XSDElementDeclaration decl, String toWrite, StatementContainer block) {
        String propertyName = this.varGen.fieldName(decl);
        block.addStmt("var " + propertyName + ":XML = <" + decl.getName() + "/>");
        block.addStmt(String.valueOf(propertyName) + ".appendChild(" + toWrite + ")");
        block.addStmt("_result.appendChild(" + propertyName + ")");
    }

    public void buildMultiplyOccuringElementProcessing(XSDElementDeclaration decl, StatementContainer block, String converted) {
        String fieldAccess = "_result";
        String propertyName = this.varGen.fieldName(decl);
        block = block.newForEachIn("_child", propertyName);
        block.addStmt(String.valueOf(fieldAccess) + ".appendChild(" + converted + ")");
    }

    public void buildListPatternElementProcessing(XSDElementDeclaration decl, XSDElementDeclaration listElement, StatementContainer block, String accessExpr) {
        String fieldAccess = "_result";
        String listName = this.varGen.fieldName(decl);
        block.addStmt("var " + listName + ":XML = <" + decl.getName() + "/>");
        String elementType = this.typeBuilder.typeNameFor(listElement);
        StatementContainer loop = block.newForEachIn("var _child:" + elementType, accessExpr);
        String elementVarName = this.varGen.fieldName(listElement);
        loop.addStmt("var " + elementVarName + ":XML = <" + listElement.getName() + "/>");
        loop.addStmt(this.builder.convertedFrom(listElement.getType(), String.valueOf(elementVarName) + ", _child"));
        loop.addStmt(String.valueOf(listName) + ".appendChild(" + elementVarName + ")");
        block.addStmt(String.valueOf(fieldAccess) + ".appendChild(" + listName + ")");
    }

    public StatementContainer createOptionalElementTest(StatementContainer code, XSDElementDeclaration elementDecl) {
        String propertyName = this.varGen.fieldName(elementDecl);
        return code.newIf("thisObject." + propertyName + " != null");
    }

    public void returnConvertedSimpleTypeElement(String name, XSDSimpleTypeDefinition stype, ASMethod meth) {
        meth.addStmt("_result.appendChild(" + this.convertSimpleTypeElement(name, stype) + ")");
        meth.addStmt("return _result");
    }

    public void buildAttributeProcessing(ASMethod meth, XSDAttributeDeclaration attrDecl) {
        String accessExpr = "thisObject." + this.varGen.fieldName(attrDecl);
        accessExpr = this.builder.convertedFrom(attrDecl.getTypeDefinition(), accessExpr);
        meth.addStmt("_result." + StringUtils.attrAccess(attrDecl) + " = " + accessExpr);
    }

    public void buildElementProcessing(XSDElementDeclaration decl, XSDTypeDefinition typeDef, String accessExpr, StatementContainer block) {
        String access = this.varGen.fieldName(decl);
        block.addStmt("var " + access + ":XML = <" + decl.getName() + "/>");
        block.addStmt(this.builder.convertedFrom(typeDef, String.valueOf(access) + ", " + accessExpr));
        block.addStmt("_result.appendChild(" + access + ")");
    }
}

