/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.asxsd;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import uk.co.badgersinfoil.asxsd.MarshalUnmarshalBuilder;
import uk.co.badgersinfoil.asxsd.MarshalingCodeGenStrategy;
import uk.co.badgersinfoil.asxsd.TypeBuilder;
import uk.co.badgersinfoil.asxsd.TypeNameGenerator;
import uk.co.badgersinfoil.asxsd.UnmarshalingCodeGenStrategy;
import uk.co.badgersinfoil.asxsd.VariableNameGenerator;
import uk.co.badgersinfoil.metaas.ASProject;

public class MappingCodeGenerator {
    private TypeNameGenerator nameGen = new TypeNameGenerator();
    private MarshalUnmarshalBuilder unmarshalerBuilder;
    private MarshalUnmarshalBuilder marshalerBuilder;
    private TypeBuilder typeBuilder;

    public MappingCodeGenerator(ASProject project) {
        this.typeBuilder = new TypeBuilder(project, this.nameGen);
        VariableNameGenerator varGen = new VariableNameGenerator();
        UnmarshalingCodeGenStrategy unmarshalStrategy = new UnmarshalingCodeGenStrategy(varGen, this.typeBuilder);
        this.unmarshalerBuilder = new MarshalUnmarshalBuilder(project, unmarshalStrategy);
        MarshalingCodeGenStrategy marshalStrategy = new MarshalingCodeGenStrategy(varGen, this.typeBuilder);
        this.marshalerBuilder = new MarshalUnmarshalBuilder(project, marshalStrategy);
    }

    public void processSchema(XSDSchema schema) throws IOException {
        this.processSchemaCreateTypes(schema);
        this.unmarshalerBuilder.processSchema(schema);
        this.marshalerBuilder.processSchema(schema);
    }

    private void processSchemaCreateTypes(XSDSchema schema) throws IOException {
        EList types = schema.getTypeDefinitions();
        Iterator i = types.iterator();
        while (i.hasNext()) {
            XSDTypeDefinition typeDef = (XSDTypeDefinition)i.next();
            if (!(typeDef instanceof XSDComplexTypeDefinition)) continue;
            this.typeBuilder.representationClassForComplexType((XSDComplexTypeDefinition)typeDef);
        }
    }

    public MarshalUnmarshalBuilder getUnmarshalerBuilder() {
        return this.unmarshalerBuilder;
    }

    public MarshalUnmarshalBuilder getMarshalerBuilder() {
        return this.marshalerBuilder;
    }

    public TypeBuilder getTypeBuilder() {
        return this.typeBuilder;
    }
}

