/*
 * Decompiled with CFR 0.152.
 */
package uk.co.badgersinfoil.asxsd;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import uk.co.badgersinfoil.asxsd.MappingCodeGenerator;
import uk.co.badgersinfoil.metaas.ASProject;
import uk.co.badgersinfoil.metaas.ASSourceFactory;

public class Main {
    public static void main(String[] args) throws IOException {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        String filename = args[0];
        String destDir = args.length > 1 ? args[1] : ".";
        XSDSchema mainSchema = Main.loadSchema(filename);
        ASSourceFactory fact = new ASSourceFactory();
        ASProject project = fact.newEmptyASProject(destDir);
        MappingCodeGenerator generator = new MappingCodeGenerator(project);
        generator.processSchema(mainSchema);
        project.writeAll();
    }

    private static XSDSchema loadSchema(String filename) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        XSDResourceImpl resource = (XSDResourceImpl)resourceSet.createResource(URI.createURI("*.xsd"));
        resource.setURI(URI.createFileURI(filename));
        resource.load(resourceSet.getLoadOptions());
        XSDSchema mainSchema = resource.getSchema();
        return mainSchema;
    }
}

