/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.ecore;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDContentTypeCategory;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDFractionDigitsFacet;
import org.eclipse.xsd.XSDIdentityConstraintDefinition;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDLengthFacet;
import org.eclipse.xsd.XSDMaxExclusiveFacet;
import org.eclipse.xsd.XSDMaxInclusiveFacet;
import org.eclipse.xsd.XSDMaxLengthFacet;
import org.eclipse.xsd.XSDMinExclusiveFacet;
import org.eclipse.xsd.XSDMinInclusiveFacet;
import org.eclipse.xsd.XSDMinLengthFacet;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDPatternFacet;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTotalDigitsFacet;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDVariety;
import org.eclipse.xsd.XSDWhiteSpaceFacet;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.ecore.MapBuilder;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xsd.util.XSDSwitch;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XSDEcoreBuilder
extends MapBuilder {
    protected XSDSchema rootSchema;
    protected List simpleDiagnostics;
    protected List diagnostics;
    protected List xsdSchemas = new UniqueEList();
    protected Map targetNamespaceToEPackageMap = new HashMap();
    protected ExtendedMetaData extendedMetaData;
    protected Map eReferenceToOppositeNameMap = new HashMap();
    protected Map typeToTypeObjectMap = new HashMap();
    protected static final List PRIMITIVES = Arrays.asList("boolean", "byte", "char", "double", "float", "int", "long", "short");
    protected static final String[] PRIMITIVE_WRAPPERS = new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short"};
    protected static final Map ECORE_PRIMITIVE_TYPES = new HashMap();
    protected final List ANY_NAMESPACE_WILDCARD = Arrays.asList("##any");
    protected final List NOT_NULL_WILDCARD = Arrays.asList("!##");
    protected static final Class ecoreResourceFactoryImplClass;

    static {
        ECORE_PRIMITIVE_TYPES.put("EBoolean", "EBooleanObject");
        ECORE_PRIMITIVE_TYPES.put("EByte", "EByteObject");
        ECORE_PRIMITIVE_TYPES.put("EChar", "ECharacterObject");
        ECORE_PRIMITIVE_TYPES.put("EDouble", "EDoubleObject");
        ECORE_PRIMITIVE_TYPES.put("EFloat", "EFloatObject");
        ECORE_PRIMITIVE_TYPES.put("EInt", "EIntegerObject");
        ECORE_PRIMITIVE_TYPES.put("ELong", "ELongObject");
        ECORE_PRIMITIVE_TYPES.put("EShort", "EShortObject");
        Class theEcoreResourceFactoryImplClass = null;
        try {
            theEcoreResourceFactoryImplClass = CommonPlugin.loadClass("org.eclipse.emf.ecore.xmi", "org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl");
        }
        catch (Exception exception) {}
        ecoreResourceFactoryImplClass = theEcoreResourceFactoryImplClass;
    }

    public XSDEcoreBuilder() {
        this(new BasicExtendedMetaData(new EPackageRegistryImpl()));
    }

    public XSDEcoreBuilder(ExtendedMetaData extendedMetaData) {
        this.extendedMetaData = extendedMetaData;
        this.populateTypeToTypeObjectMap(XMLTypePackage.eINSTANCE);
        this.populateTypeToTypeObjectMap(XMLNamespacePackage.eINSTANCE);
    }

    protected void populateTypeToTypeObjectMap(EPackage ePackage) {
        Iterator j = ePackage.getEClassifiers().iterator();
        while (j.hasNext()) {
            EClassifier eClassifier = (EClassifier)j.next();
            String xmlName = this.extendedMetaData.getName(eClassifier);
            if (xmlName == null || !xmlName.endsWith(":Object")) continue;
            this.typeToTypeObjectMap.put(this.extendedMetaData.getType(ePackage, xmlName.substring(0, xmlName.length() - 7)), eClassifier);
        }
    }

    public XSDSchema getSchema() {
        return this.rootSchema;
    }

    public void setValidate(boolean validate) {
        this.diagnostics = validate ? new ArrayList() : null;
    }

    public List getDiagnostics() {
        return this.diagnostics;
    }

    public XSDSchema getRootSchema() {
        return this.rootSchema;
    }

    public Map getTargetNamespaceToEPackageMap() {
        return this.targetNamespaceToEPackageMap;
    }

    public Map getXSDComponentToEModelElementMap() {
        return this.xsdComponentToEModelElementMap;
    }

    public EPackage getEPackage(XSDNamedComponent xsdNamedComponent) {
        String targetNamespace;
        EPackage ePackage;
        XSDSchema containingXSDSchema = xsdNamedComponent.getSchema();
        if (containingXSDSchema != null && !this.xsdSchemas.contains(containingXSDSchema)) {
            this.xsdSchemas.add(containingXSDSchema);
            this.addInput(containingXSDSchema);
            this.validate(containingXSDSchema);
        }
        if ((ePackage = (EPackage)this.targetNamespaceToEPackageMap.get(targetNamespace = containingXSDSchema == null ? xsdNamedComponent.getTargetNamespace() : containingXSDSchema.getTargetNamespace())) == null) {
            ePackage = EcoreFactory.eINSTANCE.createEPackage();
            this.setAnnotations(ePackage, containingXSDSchema);
            this.addOutput(ePackage);
            if (targetNamespace == null) {
                if (containingXSDSchema == null) {
                    containingXSDSchema = this.rootSchema;
                }
                ePackage.setName(this.validName(containingXSDSchema.eResource().getURI().trimFileExtension().lastSegment(), true));
                ePackage.setNsURI(containingXSDSchema.eResource().getURI().toString());
            } else {
                String qualifiedPackageName = this.qualifiedPackageName(targetNamespace);
                ePackage.setName(qualifiedPackageName);
                ePackage.setNsURI(targetNamespace);
            }
            String nsPrefix = ePackage.getName();
            int index = nsPrefix.lastIndexOf(46);
            String string = nsPrefix = index == -1 ? nsPrefix : nsPrefix.substring(index + 1);
            if (nsPrefix.toLowerCase().startsWith("xml")) {
                nsPrefix = "_" + nsPrefix;
            }
            ePackage.setNsPrefix(nsPrefix);
            this.extendedMetaData.setQualified(ePackage, targetNamespace != null);
            this.extendedMetaData.putPackage(targetNamespace, ePackage);
            this.targetNamespaceToEPackageMap.put(targetNamespace, ePackage);
        }
        return ePackage;
    }

    public EClassifier getEClassifier(XSDTypeDefinition xsdTypeDefinition) {
        EClassifier eClassifier = (EClassifier)this.xsdComponentToEModelElementMap.get(xsdTypeDefinition);
        if (eClassifier == null) {
            eClassifier = this.computeEClassifier(xsdTypeDefinition);
            this.map(xsdTypeDefinition, eClassifier);
        }
        return eClassifier;
    }

    public EDataType getEDataType(XSDSimpleTypeDefinition xsdSimpleTypeDefinition) {
        EDataType eDataType = (EDataType)this.xsdComponentToEModelElementMap.get(xsdSimpleTypeDefinition);
        if (eDataType == null) {
            eDataType = this.computeEDataType(xsdSimpleTypeDefinition);
            this.map(xsdSimpleTypeDefinition, eDataType);
        }
        return eDataType;
    }

    public EClass getEClass(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        EClass eClass = (EClass)this.xsdComponentToEModelElementMap.get(xsdComplexTypeDefinition);
        if (eClass == null) {
            eClass = this.computeEClass(xsdComplexTypeDefinition);
            this.map(xsdComplexTypeDefinition, eClass);
        }
        return eClass;
    }

    protected EClassifier getBuiltInEClassifier(String namespace, String name) {
        return "anyType".equals(name) ? EcorePackage.eINSTANCE.getEObject() : this.extendedMetaData.getType(XMLTypePackage.eINSTANCE, name);
    }

    protected EClassifier computeEClassifier(XSDTypeDefinition xsdTypeDefinition) {
        if (xsdTypeDefinition == null) {
            return this.getBuiltInEClassifier(this.rootSchema.getSchemaForSchemaNamespace(), "anySimpleType");
        }
        if (xsdTypeDefinition instanceof XSDSimpleTypeDefinition) {
            return this.computeEDataType((XSDSimpleTypeDefinition)xsdTypeDefinition);
        }
        return this.computeEClass((XSDComplexTypeDefinition)xsdTypeDefinition);
    }

    protected EDataType computeEDataType(XSDSimpleTypeDefinition xsdSimpleTypeDefinition) {
        String explicitInstanceClassName;
        if (xsdSimpleTypeDefinition == null) {
            return (EDataType)this.getBuiltInEClassifier(this.rootSchema.getSchemaForSchemaNamespace(), "anySimpleType");
        }
        if (XSDConstants.isSchemaForSchemaNamespace(xsdSimpleTypeDefinition.getTargetNamespace())) {
            EDataType result;
            String name = xsdSimpleTypeDefinition.getName();
            if (name != null && (result = (EDataType)this.getBuiltInEClassifier(xsdSimpleTypeDefinition.getTargetNamespace(), "anyType".equals(name) ? "anySimpleType" : name)) != null) {
                return result;
            }
        } else if (xsdSimpleTypeDefinition.getContainer() == null) {
            return (EDataType)this.getBuiltInEClassifier(this.rootSchema.getSchemaForSchemaNamespace(), "anySimpleType");
        }
        if ((explicitInstanceClassName = this.getEcoreAttribute(xsdSimpleTypeDefinition, "instanceClass")) != null) {
            EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
            this.setAnnotations(eDataType, xsdSimpleTypeDefinition);
            String aliasName = this.getEcoreAttribute(xsdSimpleTypeDefinition, "name");
            if (aliasName == null) {
                aliasName = this.validAliasName(xsdSimpleTypeDefinition, true);
            }
            eDataType.setName(aliasName);
            this.extendedMetaData.setName(eDataType, xsdSimpleTypeDefinition.getAliasName());
            eDataType.setInstanceClassName(explicitInstanceClassName);
            EPackage ePackage = this.getEPackage(xsdSimpleTypeDefinition);
            XSDEcoreBuilder.addToSortedList(ePackage.getEClassifiers(), eDataType);
            this.checkForPrimitive(xsdSimpleTypeDefinition, eDataType);
            this.handleFacets(xsdSimpleTypeDefinition, eDataType);
            String constraints = this.getEcoreAttribute(xsdSimpleTypeDefinition, "constraints");
            if (constraints != null) {
                EcoreUtil.setAnnotation(eDataType, "http://www.eclipse.org/emf/2002/Ecore", "constraints", constraints);
            }
            if ("false".equals(this.getEcoreAttribute(xsdSimpleTypeDefinition, "serializable"))) {
                eDataType.setSerializable(false);
            }
            return eDataType;
        }
        EEnum eEnum = this.computeEEnum(xsdSimpleTypeDefinition);
        if (eEnum != null) {
            return eEnum;
        }
        XSDSimpleTypeDefinition baseTypeDefinition = xsdSimpleTypeDefinition.getBaseTypeDefinition();
        if (baseTypeDefinition != null) {
            EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
            this.setAnnotations(eDataType, xsdSimpleTypeDefinition);
            String name = this.getEcoreAttribute(xsdSimpleTypeDefinition, "name");
            if (name == null) {
                name = this.validAliasName(xsdSimpleTypeDefinition, true);
            }
            eDataType.setName(name);
            this.extendedMetaData.setName(eDataType, xsdSimpleTypeDefinition.getAliasName());
            EPackage ePackage = this.getEPackage(xsdSimpleTypeDefinition);
            XSDEcoreBuilder.addToSortedList(ePackage.getEClassifiers(), eDataType);
            if (baseTypeDefinition.getVariety() != xsdSimpleTypeDefinition.getVariety()) {
                if (xsdSimpleTypeDefinition.getVariety() == XSDVariety.LIST_LITERAL) {
                    EDataType itemEDataType = this.getEDataType(xsdSimpleTypeDefinition.getItemTypeDefinition());
                    this.extendedMetaData.setItemType(eDataType, itemEDataType);
                    eDataType.setInstanceClassName("java.util.List");
                } else {
                    String instanceClassName = null;
                    ArrayList<EDataType> memberTypes = new ArrayList<EDataType>();
                    Iterator i = xsdSimpleTypeDefinition.getMemberTypeDefinitions().iterator();
                    while (i.hasNext()) {
                        XSDSimpleTypeDefinition memberTypeDefinition = (XSDSimpleTypeDefinition)i.next();
                        EDataType memberEDataType = this.getEDataType(memberTypeDefinition);
                        memberTypes.add(memberEDataType);
                        String memberInstanceClassName = memberEDataType.getInstanceClassName();
                        if (memberInstanceClassName == null && memberEDataType instanceof EEnum) {
                            memberInstanceClassName = "org.eclipse.emf.common.util.Enumerator";
                        }
                        if (instanceClassName == null) {
                            instanceClassName = memberInstanceClassName;
                            continue;
                        }
                        if (instanceClassName == memberInstanceClassName) continue;
                        instanceClassName = "java.lang.Object";
                    }
                    this.extendedMetaData.setMemberTypes(eDataType, memberTypes);
                    eDataType.setInstanceClassName(instanceClassName);
                }
            } else {
                EDataType baseEDataType = this.getEDataType(baseTypeDefinition);
                this.extendedMetaData.setBaseType(eDataType, baseEDataType);
                String instanceClassName = this.getInstanceClassName(xsdSimpleTypeDefinition, baseEDataType);
                eDataType.setInstanceClassName(instanceClassName == null ? "org.eclipse.emf.common.util.Enumerator" : instanceClassName);
            }
            this.checkForPrimitive(xsdSimpleTypeDefinition, eDataType);
            this.handleFacets(xsdSimpleTypeDefinition, eDataType);
            String constraints = this.getEcoreAttribute(xsdSimpleTypeDefinition, "constraints");
            if (constraints != null) {
                EcoreUtil.setAnnotation(eDataType, "http://www.eclipse.org/emf/2002/Ecore", "constraints", constraints);
            }
            if ("false".equals(this.getEcoreAttribute(xsdSimpleTypeDefinition, "serializable"))) {
                eDataType.setSerializable(false);
            }
            return eDataType;
        }
        return (EDataType)this.getBuiltInEClassifier(this.rootSchema.getSchemaForSchemaNamespace(), "anySimpleType");
    }

    protected String getInstanceClassName(XSDTypeDefinition xsdTypeDefinition, EDataType baseEDataType) {
        return baseEDataType.getInstanceClassName();
    }

    protected String validAliasName(XSDTypeDefinition xsdTypeDefinition, boolean isUpperCase) {
        return this.validName(xsdTypeDefinition.getAliasName(), isUpperCase);
    }

    protected static boolean canSupportNull(EDataType eDataType) {
        return !(eDataType instanceof EEnum) && PRIMITIVES.indexOf(eDataType.getInstanceClassName()) == -1;
    }

    protected void checkForPrimitive(XSDSimpleTypeDefinition xsdSimpleTypeDefinition, EDataType eDataType) {
        XSDSimpleTypeDefinition wrapperTypeDefinition;
        String wrapperType;
        if ("http://www.eclipse.org/emf/2002/Ecore".equals(xsdSimpleTypeDefinition.getTargetNamespace()) && (wrapperType = (String)ECORE_PRIMITIVE_TYPES.get(eDataType.getName())) != null && (wrapperTypeDefinition = xsdSimpleTypeDefinition.resolveSimpleTypeDefinition(wrapperType)).getContainer() != null) {
            EDataType eDataTypeObject = (EDataType)this.getEClassifier(wrapperTypeDefinition);
            this.extendedMetaData.setName(eDataTypeObject, String.valueOf(eDataType.getName()) + ":Object");
            this.extendedMetaData.setBaseType(eDataTypeObject, eDataType);
            this.typeToTypeObjectMap.put(eDataType, eDataTypeObject);
            return;
        }
        this.checkForPrimitive(eDataType);
    }

    protected void checkForPrimitive(EDataType eDataType) {
        int index = PRIMITIVES.indexOf(eDataType.getInstanceClassName());
        if (index != -1 || eDataType instanceof EEnum) {
            EDataType eDataTypeObject = EcoreFactory.eINSTANCE.createEDataType();
            eDataTypeObject.setName(String.valueOf(eDataType.getName()) + "Object");
            if (index != -1) {
                eDataTypeObject.setInstanceClassName(PRIMITIVE_WRAPPERS[index]);
            } else {
                eDataTypeObject.setInstanceClassName("org.eclipse.emf.common.util.Enumerator");
            }
            this.extendedMetaData.setName(eDataTypeObject, String.valueOf(this.extendedMetaData.getName(eDataType)) + ":Object");
            XSDEcoreBuilder.addToSortedList(eDataType.getEPackage().getEClassifiers(), eDataTypeObject);
            this.extendedMetaData.setBaseType(eDataTypeObject, eDataType);
            this.typeToTypeObjectMap.put(eDataType, eDataTypeObject);
        }
    }

    protected void handleFacets(XSDSimpleTypeDefinition xsdSimpleTypeDefinition, final EDataType eDataType) {
        final ArrayList enumeration = new ArrayList();
        final ArrayList pattern = new ArrayList();
        Iterator i = xsdSimpleTypeDefinition.getFacetContents().iterator();
        while (i.hasNext()) {
            XSDFacet xsdFacet = (XSDFacet)i.next();
            String ignore = this.getEcoreAttribute(xsdFacet, "ignore");
            if ("true".equalsIgnoreCase(ignore)) continue;
            new XSDSwitch(){

                public Object caseXSDEnumerationFacet(XSDEnumerationFacet xsdEnumerationFacet) {
                    enumeration.add(xsdEnumerationFacet.getLexicalValue());
                    return this;
                }

                public Object caseXSDFractionDigitsFacet(XSDFractionDigitsFacet xsdFractionDigitsFacet) {
                    XSDEcoreBuilder.this.extendedMetaData.setFractionDigitsFacet(eDataType, xsdFractionDigitsFacet.getValue());
                    return this;
                }

                public Object caseXSDLengthFacet(XSDLengthFacet xsdLengthFacet) {
                    XSDEcoreBuilder.this.extendedMetaData.setLengthFacet(eDataType, xsdLengthFacet.getValue());
                    return this;
                }

                public Object caseXSDMaxExclusiveFacet(XSDMaxExclusiveFacet xsdMaxExclusiveFacet) {
                    XSDEcoreBuilder.this.extendedMetaData.setMaxExclusiveFacet(eDataType, xsdMaxExclusiveFacet.getLexicalValue());
                    return this;
                }

                public Object caseXSDMaxInclusiveFacet(XSDMaxInclusiveFacet xsdMaxInclusiveFacet) {
                    XSDEcoreBuilder.this.extendedMetaData.setMaxInclusiveFacet(eDataType, xsdMaxInclusiveFacet.getLexicalValue());
                    return this;
                }

                public Object caseXSDMaxLengthFacet(XSDMaxLengthFacet xsdMaxLengthFacet) {
                    XSDEcoreBuilder.this.extendedMetaData.setMaxLengthFacet(eDataType, xsdMaxLengthFacet.getValue());
                    return this;
                }

                public Object caseXSDMinExclusiveFacet(XSDMinExclusiveFacet xsdMinExclusiveFacet) {
                    XSDEcoreBuilder.this.extendedMetaData.setMinExclusiveFacet(eDataType, xsdMinExclusiveFacet.getLexicalValue());
                    return this;
                }

                public Object caseXSDMinInclusiveFacet(XSDMinInclusiveFacet xsdMinInclusiveFacet) {
                    XSDEcoreBuilder.this.extendedMetaData.setMinInclusiveFacet(eDataType, xsdMinInclusiveFacet.getLexicalValue());
                    return this;
                }

                public Object caseXSDMinLengthFacet(XSDMinLengthFacet xsdMinLengthFacet) {
                    XSDEcoreBuilder.this.extendedMetaData.setMinLengthFacet(eDataType, xsdMinLengthFacet.getValue());
                    return this;
                }

                public Object caseXSDPatternFacet(XSDPatternFacet xsdPatternFacet) {
                    pattern.add(xsdPatternFacet.getLexicalValue());
                    return this;
                }

                public Object caseXSDTotalDigitsFacet(XSDTotalDigitsFacet xsdTotalDigitsFacet) {
                    XSDEcoreBuilder.this.extendedMetaData.setTotalDigitsFacet(eDataType, xsdTotalDigitsFacet.getValue());
                    return this;
                }

                public Object caseXSDWhiteSpaceFacet(XSDWhiteSpaceFacet xsdWhiteSpaceFacet) {
                    XSDEcoreBuilder.this.extendedMetaData.setWhiteSpaceFacet(eDataType, xsdWhiteSpaceFacet.getValue().getValue() + 1);
                    return this;
                }
            }.doSwitch(xsdFacet);
        }
        this.extendedMetaData.setEnumerationFacet(eDataType, enumeration);
        this.extendedMetaData.setPatternFacet(eDataType, pattern);
    }

    protected EEnum computeEEnum(XSDSimpleTypeDefinition xsdSimpleTypeDefinition) {
        if (!xsdSimpleTypeDefinition.getEnumerationFacets().isEmpty() && !"false".equals(this.getEcoreAttribute(xsdSimpleTypeDefinition, "enum"))) {
            EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
            this.setAnnotations(eEnum, xsdSimpleTypeDefinition);
            String name = this.getEcoreAttribute(xsdSimpleTypeDefinition, "name");
            if (name == null) {
                name = this.validAliasName(xsdSimpleTypeDefinition, true);
            }
            eEnum.setName(name);
            this.extendedMetaData.setName(eEnum, xsdSimpleTypeDefinition.getAliasName());
            EPackage ePackage = this.getEPackage(xsdSimpleTypeDefinition);
            XSDEcoreBuilder.addToSortedList(ePackage.getEClassifiers(), eEnum);
            String constraints = this.getEcoreAttribute(xsdSimpleTypeDefinition, "constraints");
            if (constraints != null) {
                EcoreUtil.setAnnotation(eEnum, "http://www.eclipse.org/emf/2002/Ecore", "constraints", constraints);
            }
            ListIterator i = xsdSimpleTypeDefinition.getEnumerationFacets().listIterator();
            while (i.hasNext()) {
                String literal;
                XSDEnumerationFacet xsdEnumerationFacet = (XSDEnumerationFacet)i.next();
                if ("true".equalsIgnoreCase(this.getEcoreAttribute(xsdEnumerationFacet, "ignore")) || (literal = xsdEnumerationFacet.getLexicalValue()) == null || eEnum.getEEnumLiteralByLiteral(literal) != null) continue;
                EEnumLiteral eEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
                this.setAnnotations(eEnumLiteral, xsdEnumerationFacet);
                String literalName = this.getEcoreAttribute(xsdEnumerationFacet, "name");
                if (literalName == null) {
                    literalName = this.validName(literal, 0, "_");
                }
                eEnumLiteral.setName(literalName);
                int value = i.previousIndex();
                String valueLiteral = this.getEcoreAttribute(xsdEnumerationFacet, "value");
                if (valueLiteral != null) {
                    value = Integer.parseInt(valueLiteral);
                }
                eEnumLiteral.setValue(value);
                if (!literalName.equals(literal)) {
                    eEnumLiteral.setLiteral(literal);
                }
                eEnum.getELiterals().add(eEnumLiteral);
                this.map(xsdEnumerationFacet, eEnumLiteral);
            }
            this.checkForPrimitive(eEnum);
            return eEnum;
        }
        return null;
    }

    public EClass computeEClass(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        XSDAnnotation xsdAnnotation;
        EClassifier baseType;
        String aliasName;
        String instanceClassName;
        if (xsdComplexTypeDefinition == null) {
            return (EClass)this.getBuiltInEClassifier(this.rootSchema.getSchemaForSchemaNamespace(), "anyType");
        }
        if (XSDConstants.isSchemaForSchemaNamespace(xsdComplexTypeDefinition.getTargetNamespace())) {
            EClass result;
            String name = xsdComplexTypeDefinition.getName();
            if (name != null && (result = (EClass)this.getBuiltInEClassifier(xsdComplexTypeDefinition.getTargetNamespace(), name)) != null) {
                return result;
            }
        } else if (xsdComplexTypeDefinition.getContainer() == null) {
            return (EClass)this.getBuiltInEClassifier(this.rootSchema.getSchemaForSchemaNamespace(), "anyType");
        }
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        this.setAnnotations(eClass, xsdComplexTypeDefinition);
        this.xsdComponentToEModelElementMap.put(xsdComplexTypeDefinition, eClass);
        if ("true".equals(this.getEcoreAttribute(xsdComplexTypeDefinition, "interface"))) {
            eClass.setInterface(true);
        }
        if ((instanceClassName = this.getEcoreAttribute(xsdComplexTypeDefinition, "instanceClass")) != null) {
            eClass.setInstanceClassName(instanceClassName);
        }
        if ((aliasName = this.getEcoreAttribute(xsdComplexTypeDefinition, "name")) == null) {
            aliasName = this.validAliasName(xsdComplexTypeDefinition, true);
        }
        eClass.setName(aliasName);
        this.extendedMetaData.setName(eClass, xsdComplexTypeDefinition.getAliasName());
        String constraints = this.getEcoreAttribute(xsdComplexTypeDefinition, "constraints");
        if (constraints != null) {
            EcoreUtil.setAnnotation(eClass, "http://www.eclipse.org/emf/2002/Ecore", "constraints", constraints);
        }
        EPackage ePackage = this.getEPackage(xsdComplexTypeDefinition);
        XSDEcoreBuilder.addToSortedList(ePackage.getEClassifiers(), eClass);
        if (xsdComplexTypeDefinition.isAbstract()) {
            eClass.setAbstract(true);
        }
        EClass baseClass = null;
        XSDTypeDefinition baseTypeDefinition = xsdComplexTypeDefinition.getBaseTypeDefinition();
        if (!baseTypeDefinition.isCircular() && (baseType = this.getEClassifier(baseTypeDefinition)) instanceof EClass && baseType != EcorePackage.eINSTANCE.getEObject()) {
            baseClass = (EClass)baseType;
            eClass.getESuperTypes().add(baseClass);
        }
        boolean isRestriction = !eClass.getESuperTypes().isEmpty() && xsdComplexTypeDefinition.getDerivationMethod() == XSDDerivationMethod.RESTRICTION_LITERAL;
        Iterator i = this.getEcoreTypeQNamesAttribute(xsdComplexTypeDefinition, "implements").iterator();
        while (i.hasNext()) {
            EClassifier mixinType;
            XSDTypeDefinition mixin = (XSDTypeDefinition)i.next();
            if (XSDConstants.isURType(mixin) || !((mixinType = this.getEClassifier(mixin)) instanceof EClass) || mixinType == EcorePackage.eINSTANCE.getEObject()) continue;
            eClass.getESuperTypes().add(mixinType);
        }
        if (xsdComplexTypeDefinition.getContentTypeCategory() == XSDContentTypeCategory.SIMPLE_LITERAL) {
            this.extendedMetaData.setContentKind(eClass, 2);
            if (eClass.getEAllStructuralFeatures().isEmpty()) {
                this.createFeature(eClass, "value", this.getEClassifier(xsdComplexTypeDefinition.getSimpleType()), null, 0, 1);
            }
        } else {
            EStructuralFeature globalGroup = null;
            boolean isMixed = xsdComplexTypeDefinition.getContentTypeCategory() == XSDContentTypeCategory.MIXED_LITERAL;
            String featureMapName = this.getEcoreAttribute(xsdComplexTypeDefinition, "featureMap");
            if (eClass.getESuperTypes().isEmpty() ? "true".equals(this.getEcoreAttribute(xsdComplexTypeDefinition, "mixed")) : this.extendedMetaData.getMixedFeature((EClass)eClass.getESuperTypes().get(0)) != null) {
                isMixed = true;
            }
            this.extendedMetaData.setContentKind(eClass, isMixed ? 3 : (xsdComplexTypeDefinition.getContentTypeCategory() == XSDContentTypeCategory.EMPTY_LITERAL ? 1 : 4));
            if (isMixed) {
                EStructuralFeature mixedFeature = this.extendedMetaData.getMixedFeature(eClass);
                if (mixedFeature == null) {
                    if (featureMapName == null) {
                        featureMapName = "mixed";
                    }
                    mixedFeature = this.createFeature(eClass, featureMapName, EcorePackage.eINSTANCE.getEFeatureMapEntry(), null, 0, -1);
                    this.extendedMetaData.setName(mixedFeature, ":mixed");
                }
            } else {
                globalGroup = this.extendedMetaData.getElement(eClass, null, ":group");
                if (globalGroup == null && featureMapName != null && eClass.getESuperTypes().isEmpty()) {
                    globalGroup = this.createFeature(eClass, featureMapName, EcorePackage.eINSTANCE.getEFeatureMapEntry(), null, 0, -1);
                    this.extendedMetaData.setName(globalGroup, ":group");
                    this.extendedMetaData.setFeatureKind(globalGroup, 6);
                }
            }
            if (xsdComplexTypeDefinition.getContent() != null) {
                HashMap<XSDTerm, EStructuralFeature> groups = new HashMap<XSDTerm, EStructuralFeature>();
                List particleInformation = this.collectParticles((XSDParticle)xsdComplexTypeDefinition.getContent());
                Iterator i2 = particleInformation.iterator();
                while (i2.hasNext()) {
                    EffectiveOccurrence effectiveOccurrence = (EffectiveOccurrence)i2.next();
                    XSDParticle xsdParticle = effectiveOccurrence.xsdParticle;
                    EStructuralFeature group = (EStructuralFeature)groups.get(effectiveOccurrence.xsdModelGroup);
                    XSDTerm xsdTerm = xsdParticle.getTerm();
                    EStructuralFeature eStructuralFeature = null;
                    String name = this.getEcoreAttribute(xsdParticle, "name");
                    if (xsdTerm instanceof XSDModelGroup) {
                        if (!isRestriction) {
                            XSDModelGroup xsdModelGroup = (XSDModelGroup)xsdTerm;
                            if (name == null && (name = this.getEcoreAttribute(xsdParticle, "featureMap")) == null && (name = this.getEcoreAttribute(xsdModelGroup, "name")) == null && (name = this.getEcoreAttribute(xsdModelGroup, "featureMap")) == null) {
                                if (xsdModelGroup.getContainer() instanceof XSDModelGroupDefinition) {
                                    XSDModelGroupDefinition xsdModelGroupDefinition = (XSDModelGroupDefinition)xsdModelGroup.getContainer();
                                    name = this.getEcoreAttribute(xsdModelGroupDefinition, "name");
                                    if (name == null) {
                                        name = this.validName(xsdModelGroupDefinition.getName(), true);
                                    }
                                } else {
                                    name = "group";
                                }
                            }
                            eStructuralFeature = this.createFeature(eClass, name, EcorePackage.eINSTANCE.getEFeatureMapEntry(), (XSDComponent)xsdParticle, 0, -1);
                            groups.put(xsdTerm, eStructuralFeature);
                            this.extendedMetaData.setName(eStructuralFeature, String.valueOf(name) + ":" + eClass.getEAllStructuralFeatures().indexOf(eStructuralFeature));
                        }
                    } else if (xsdTerm instanceof XSDWildcard) {
                        if (!isRestriction) {
                            if (name == null && (name = this.getEcoreAttribute(xsdTerm, "name")) == null) {
                                name = "any";
                            }
                            eStructuralFeature = this.createFeature(eClass, name, EcorePackage.eINSTANCE.getEFeatureMapEntry(), (XSDComponent)xsdParticle, effectiveOccurrence.minOccurs, effectiveOccurrence.maxOccurs);
                        }
                    } else {
                        XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdTerm;
                        boolean isRedundant = false;
                        if (isRestriction) {
                            boolean bl = isRedundant = this.extendedMetaData.getElement(baseClass, xsdElementDeclaration.getTargetNamespace(), xsdElementDeclaration.getName()) != null;
                            if (!isRedundant) {
                                group = this.extendedMetaData.getElementWildcardAffiliation(baseClass, xsdElementDeclaration.getTargetNamespace(), xsdElementDeclaration.getName());
                            }
                        }
                        if (!isRedundant) {
                            String groupName;
                            if (name == null && (name = this.getEcoreAttribute(xsdElementDeclaration, "name")) == null) {
                                name = this.validName(xsdElementDeclaration.getName(), true);
                            }
                            if ((groupName = this.getEcoreAttribute(xsdParticle, "featureMap")) == null) {
                                groupName = this.getEcoreAttribute(xsdElementDeclaration, "featureMap");
                            }
                            if (!"".equals(groupName) && (groupName != null || xsdElementDeclaration.isAbstract() || xsdElementDeclaration.getSubstitutionGroup().size() > 1)) {
                                if (groupName == null) {
                                    groupName = String.valueOf(name) + "Group";
                                }
                                eStructuralFeature = this.createFeature(eClass, groupName, EcorePackage.eINSTANCE.getEFeatureMapEntry(), (XSDComponent)xsdParticle, effectiveOccurrence.minOccurs, effectiveOccurrence.maxOccurs);
                                eStructuralFeature.setChangeable(true);
                                this.extendedMetaData.setFeatureKind(eStructuralFeature, 6);
                                this.extendedMetaData.setName(eStructuralFeature, String.valueOf(xsdElementDeclaration.getName()) + ":group");
                                if (group != null) {
                                    this.extendedMetaData.setGroup(eStructuralFeature, group);
                                    eStructuralFeature.setDerived(true);
                                    eStructuralFeature.setTransient(true);
                                    eStructuralFeature.setVolatile(true);
                                } else if (isMixed) {
                                    eStructuralFeature.setDerived(true);
                                    eStructuralFeature.setTransient(true);
                                    eStructuralFeature.setVolatile(true);
                                } else if (globalGroup != null) {
                                    this.extendedMetaData.setGroup(eStructuralFeature, globalGroup);
                                    eStructuralFeature.setDerived(true);
                                    eStructuralFeature.setTransient(true);
                                    eStructuralFeature.setVolatile(true);
                                }
                                group = eStructuralFeature;
                            }
                            if (!(eStructuralFeature = this.createFeature(eClass, xsdElementDeclaration, name, (XSDComponent)xsdParticle, effectiveOccurrence.minOccurs, effectiveOccurrence.maxOccurs)).isChangeable() && group == null && this.getEcoreAttribute(xsdParticle, xsdElementDeclaration, "changeable") == null) {
                                eStructuralFeature.setChangeable(true);
                            }
                        }
                    }
                    if (eStructuralFeature == null) continue;
                    if (group != null) {
                        this.extendedMetaData.setGroup(eStructuralFeature, group);
                        eStructuralFeature.setDerived(true);
                        eStructuralFeature.setTransient(true);
                        eStructuralFeature.setVolatile(true);
                        continue;
                    }
                    if (isMixed) {
                        eStructuralFeature.setDerived(true);
                        eStructuralFeature.setTransient(true);
                        eStructuralFeature.setVolatile(true);
                        continue;
                    }
                    if (globalGroup == null) continue;
                    this.extendedMetaData.setGroup(eStructuralFeature, globalGroup);
                    eStructuralFeature.setDerived(true);
                    eStructuralFeature.setTransient(true);
                    eStructuralFeature.setVolatile(true);
                }
            }
        }
        XSDWildcard baseXSDWildcard = null;
        List baseAttributeUses = Collections.EMPTY_LIST;
        HashMap<String, XSDAttributeUse> baseAttributeURIs = new HashMap<String, XSDAttributeUse>();
        if (baseTypeDefinition instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition complexBaseTypeDefinition = (XSDComplexTypeDefinition)baseTypeDefinition;
            baseXSDWildcard = complexBaseTypeDefinition.getAttributeWildcard();
            baseAttributeUses = complexBaseTypeDefinition.getAttributeUses();
            Iterator i3 = baseAttributeUses.iterator();
            while (i3.hasNext()) {
                XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)i3.next();
                baseAttributeURIs.put(xsdAttributeUse.getAttributeDeclaration().getURI(), xsdAttributeUse);
            }
        }
        Iterator i4 = this.getAttributeUses(xsdComplexTypeDefinition).iterator();
        while (i4.hasNext()) {
            EStructuralFeature attributeWildcardEStructuralFeature;
            XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)i4.next();
            XSDAttributeDeclaration xsdAttributeDeclaration = xsdAttributeUse.getAttributeDeclaration();
            if (baseAttributeURIs.remove(xsdAttributeDeclaration.getURI()) != null) continue;
            String name = this.getEcoreAttribute(xsdAttributeUse, "name");
            if (name == null) {
                name = this.getEcoreAttribute(xsdAttributeDeclaration, "name");
            }
            if (name == null) {
                name = this.validName(xsdAttributeDeclaration.getName(), true);
            }
            EStructuralFeature eStructuralFeature = this.createFeature(eClass, xsdAttributeDeclaration, name, xsdAttributeUse, xsdAttributeUse.isRequired());
            if (!isRestriction || (attributeWildcardEStructuralFeature = this.extendedMetaData.getAttributeWildcardAffiliation(baseClass, xsdAttributeDeclaration.getTargetNamespace(), xsdAttributeDeclaration.getName())) == null) continue;
            this.extendedMetaData.setGroup(eStructuralFeature, attributeWildcardEStructuralFeature);
            eStructuralFeature.setDerived(true);
            eStructuralFeature.setTransient(true);
            eStructuralFeature.setVolatile(true);
        }
        XSDWildcard xsdWildcard = xsdComplexTypeDefinition.getAttributeWildcard();
        if ((xsdWildcard != null && baseXSDWildcard != xsdWildcard || XSDConstants.isURType(xsdComplexTypeDefinition)) && (!isRestriction || XSDConstants.isURType(xsdComplexTypeDefinition))) {
            String name = this.getEcoreAttribute(xsdWildcard, "name");
            if (name == null) {
                name = "anyAttribute";
            }
            this.createFeature(eClass, name, EcorePackage.eINSTANCE.getEFeatureMapEntry(), (XSDComponent)xsdWildcard, 0, -1);
        }
        if (isRestriction) {
            int baseContentKind = this.extendedMetaData.getContentKind((EClass)eClass.getESuperTypes().get(0));
            if (baseContentKind == 3 && xsdComplexTypeDefinition.getContentTypeCategory() == XSDContentTypeCategory.SIMPLE_LITERAL) {
                this.extendedMetaData.setContentKind(eClass, 2);
                EStructuralFeature eStructuralFeature = this.createFeature(eClass, "rawValue", this.getBuiltInEClassifier(xsdComplexTypeDefinition.getSchema().getSchemaForSchemaNamespace(), "string"), null, 0, 1);
                eStructuralFeature.setDerived(true);
                eStructuralFeature.setTransient(true);
                eStructuralFeature.setVolatile(true);
                eStructuralFeature = this.createFeature(eClass, "value", this.getBuiltInEClassifier(xsdComplexTypeDefinition.getSchema().getSchemaForSchemaNamespace(), "anySimpleType"), null, 0, 1);
                eStructuralFeature.setDerived(true);
                eStructuralFeature.setTransient(true);
                eStructuralFeature.setVolatile(true);
                if ("SimpleAnyType".equals(eClass.getName()) && "http://www.eclipse.org/emf/2003/XMLType".equals(eClass.getEPackage().getNsURI())) {
                    eStructuralFeature = this.createFeature(eClass, "instanceType", EcorePackage.eINSTANCE.getEDataType(), null, 1, 1);
                    ((EReference)eStructuralFeature).setResolveProxies(false);
                }
            } else {
                this.extendedMetaData.setContentKind(eClass, baseContentKind);
            }
        }
        if ((xsdAnnotation = xsdComplexTypeDefinition.getAnnotation()) != null) {
            EList applicationInformationList = xsdAnnotation.getApplicationInformation("http://www.eclipse.org/emf/2002/Ecore");
            Iterator i5 = applicationInformationList.iterator();
            while (i5.hasNext()) {
                Element applicationInformation = (Element)i5.next();
                if (!"operations".equals(applicationInformation.getAttributeNS("http://www.eclipse.org/emf/2002/Ecore", "key"))) continue;
                Iterator j = this.getElements(applicationInformation, "operation").iterator();
                while (j.hasNext()) {
                    EOperation eOperation = EcoreFactory.eINSTANCE.createEOperation();
                    Element operation = (Element)j.next();
                    String operationName = operation.getAttributeNS(null, "name");
                    eOperation.setName(operationName);
                    XSDTypeDefinition returnType = this.getEcoreTypeQNameAttribute(xsdComplexTypeDefinition, operation, null, "type");
                    if (returnType != null) {
                        EClassifier returnEType = this.getEClassifier(returnType);
                        eOperation.setEType(returnEType);
                    }
                    List exceptions = this.getEcoreTypeQNamesAttribute(xsdComplexTypeDefinition, operation, null, "exceptions");
                    Iterator k = exceptions.iterator();
                    while (k.hasNext()) {
                        XSDTypeDefinition exceptionTypeDefinition = (XSDTypeDefinition)k.next();
                        eOperation.getEExceptions().add(this.getEClassifier(exceptionTypeDefinition));
                    }
                    k = this.getElements(operation, "parameter").iterator();
                    while (k.hasNext()) {
                        EParameter eParameter = EcoreFactory.eINSTANCE.createEParameter();
                        Element parameter = (Element)k.next();
                        String paramaterName = parameter.getAttributeNS(null, "name");
                        XSDTypeDefinition parameterType = this.getEcoreTypeQNameAttribute(xsdComplexTypeDefinition, parameter, null, "type");
                        EClassifier parameterEType = this.getEClassifier(parameterType);
                        eParameter.setName(paramaterName);
                        eParameter.setEType(parameterEType);
                        this.populateETypedElement(eParameter, parameter);
                        eOperation.getEParameters().add(eParameter);
                    }
                    List body = this.getElements(operation, "body");
                    if (!body.isEmpty()) {
                        EcoreUtil.setAnnotation(eOperation, "http://www.eclipse.org/emf/2002/GenModel", "body", this.getText((Element)body.get(0)));
                    }
                    this.populateETypedElement(eOperation, operation);
                    eClass.getEOperations().add(eOperation);
                }
            }
        }
        return eClass;
    }

    protected void populateETypedElement(ETypedElement eTypedElement, Element element) {
        String upperBound;
        String lowerBound = element.getAttributeNS(null, "lowerBound");
        if (!"".equals(lowerBound)) {
            eTypedElement.setLowerBound(Integer.parseInt(lowerBound));
        }
        if (!"".equals(upperBound = element.getAttributeNS(null, "upperBound"))) {
            eTypedElement.setUpperBound(Integer.parseInt(upperBound));
        }
        if ("false".equals(element.getAttributeNS(null, "unique"))) {
            eTypedElement.setUnique(false);
        }
        if ("false".equals(element.getAttributeNS(null, "ordered"))) {
            eTypedElement.setOrdered(false);
        }
        Iterator l = this.getElements(element, "annotation").iterator();
        while (l.hasNext()) {
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            Element annotation = (Element)l.next();
            if (annotation.hasAttributeNS(null, "source")) {
                eAnnotation.setSource(annotation.getAttributeNS(null, "source"));
            }
            Iterator m = this.getElements(annotation, "detail").iterator();
            while (m.hasNext()) {
                Element detail = (Element)m.next();
                eAnnotation.getDetails().put(detail.hasAttributeNS(null, "key") ? detail.getAttributeNS(null, "key") : null, this.getText(detail));
            }
            eTypedElement.getEAnnotations().add(eAnnotation);
        }
    }

    private String getText(Element element) {
        StringBuffer text = new StringBuffer();
        Node node = element.getFirstChild();
        while (node != null) {
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    text.append(node.getNodeValue());
                }
            }
            node = node.getNextSibling();
        }
        return text.toString();
    }

    private List getElements(Element element, String localName) {
        ArrayList<Element> result = new ArrayList<Element>();
        Node node = element.getFirstChild();
        while (node != null) {
            Element child;
            if (node.getNodeType() == 1 && localName.equals((child = (Element)node).getLocalName()) && child.getNamespaceURI() == null) {
                result.add(child);
            }
            node = node.getNextSibling();
        }
        return result;
    }

    protected boolean useSortedAttributes() {
        return true;
    }

    protected List getAttributeUses(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        if (this.useSortedAttributes()) {
            return xsdComplexTypeDefinition.getAttributeUses();
        }
        ArrayList result = new ArrayList(xsdComplexTypeDefinition.getAttributeUses());
        this.reorderAttributeUses(result, xsdComplexTypeDefinition.getAttributeContents());
        return result;
    }

    protected void reorderAttributeUses(List attributeUses, List attributeContents) {
        Iterator i = attributeContents.iterator();
        while (i.hasNext()) {
            Object attributeContent = i.next();
            if (attributeContent instanceof XSDAttributeUse) {
                int index = attributeUses.indexOf(attributeContent);
                if (index == -1) continue;
                attributeUses.remove(index);
                attributeUses.add(attributeContent);
                continue;
            }
            this.reorderAttributeUses(attributeUses, ((XSDAttributeGroupDefinition)attributeContent).getContents());
        }
    }

    protected List getWildcards(XSDWildcard xsdWildcard) {
        switch (xsdWildcard.getNamespaceConstraintCategory().getValue()) {
            case 0: {
                return this.ANY_NAMESPACE_WILDCARD;
            }
            case 1: {
                String targetNamespace = null;
                XSDSchema containingXSDSchema = xsdWildcard.getSchema();
                if (containingXSDSchema != null) {
                    targetNamespace = containingXSDSchema.getTargetNamespace();
                }
                return targetNamespace == null ? this.NOT_NULL_WILDCARD : Collections.singletonList("!##" + targetNamespace);
            }
            case 2: {
                return xsdWildcard.getNamespaceConstraint();
            }
        }
        throw new UnsupportedOperationException("Unknown XSDNamespaceConstraintCategory: " + xsdWildcard.getNamespaceConstraintCategory().getName());
    }

    protected EStructuralFeature createFeature(EClass eClass, String name, EClassifier type, XSDComponent xsdComponent) {
        return this.createFeature(eClass, name, type, xsdComponent, 0, 1);
    }

    protected EStructuralFeature createFeature(EClass eClass, String name, EClassifier type, XSDComponent xsdComponent, int minOccurs, int maxOccurs) {
        if (xsdComponent != null) {
            XSDSchema containingXSDSchema = xsdComponent.getSchema();
            if (containingXSDSchema != null && !this.xsdSchemas.contains(containingXSDSchema)) {
                this.xsdSchemas.add(containingXSDSchema);
                this.addInput(containingXSDSchema);
                this.validate(containingXSDSchema);
            }
        } else if (this.extendedMetaData.getContentKind(eClass) == 3) {
            if (type == EcorePackage.eINSTANCE.getEFeatureMapEntry()) {
                EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
                this.setAnnotations(eAttribute, xsdComponent);
                eAttribute.setName(String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1));
                eAttribute.setUnique(false);
                eAttribute.setEType(type);
                eAttribute.setLowerBound(minOccurs);
                eAttribute.setUpperBound(maxOccurs);
                eClass.getEStructuralFeatures().add(eAttribute);
                this.extendedMetaData.setFeatureKind(eAttribute, 5);
                this.extendedMetaData.setName(eAttribute, ":" + eAttribute.getName());
                return eAttribute;
            }
            EReference eReference = EcoreFactory.eINSTANCE.createEReference();
            this.setAnnotations(eReference, xsdComponent);
            eReference.setName(name);
            eReference.setEType(EcorePackage.eINSTANCE.getEStringToStringMapEntry());
            eReference.setLowerBound(0);
            eReference.setUpperBound(-1);
            eReference.setContainment(true);
            eReference.setResolveProxies(false);
            eReference.setTransient(true);
            eClass.getEStructuralFeatures().add(eReference);
            this.extendedMetaData.setFeatureKind(eReference, 2);
            return eReference;
        }
        if (type instanceof EClass) {
            EReference eReference = EcoreFactory.eINSTANCE.createEReference();
            this.setAnnotations(eReference, xsdComponent);
            eReference.setName(String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1));
            eReference.setEType(type);
            eReference.setLowerBound(minOccurs);
            eReference.setUpperBound(maxOccurs);
            eClass.getEStructuralFeatures().add(eReference);
            if (xsdComponent == null) {
                this.extendedMetaData.setName(eReference, ":" + eClass.getEAllStructuralFeatures().indexOf(eReference));
                this.extendedMetaData.setFeatureKind(eReference, 1);
            } else {
                this.map(xsdComponent, eReference);
                if (xsdComponent instanceof XSDParticle) {
                    eReference.setContainment(true);
                    eReference.setResolveProxies(false);
                    XSDParticle xsdParticle = (XSDParticle)xsdComponent;
                    XSDTerm xsdTerm = ((XSDParticle)xsdComponent).getTerm();
                    if (xsdTerm instanceof XSDElementDeclaration) {
                        String opposite;
                        XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdTerm;
                        this.extendedMetaData.setFeatureKind(eReference, 4);
                        this.extendedMetaData.setName(eReference, xsdElementDeclaration.getName());
                        this.extendedMetaData.setNamespace(eReference, xsdElementDeclaration.getTargetNamespace());
                        XSDTypeDefinition xsdType = this.getEffectiveTypeDefinition(xsdParticle, xsdElementDeclaration);
                        if (xsdType instanceof XSDSimpleTypeDefinition) {
                            eReference.setContainment(false);
                            eReference.setResolveProxies(!XSDEcoreBuilder.isLocalReferenceType((XSDSimpleTypeDefinition)xsdType));
                        }
                        if (maxOccurs == 1 && xsdElementDeclaration.isNillable()) {
                            eReference.setUnsettable(true);
                        }
                        if (xsdElementDeclaration.isAbstract()) {
                            eReference.setChangeable(false);
                        }
                        if ((opposite = this.getEcoreAttribute(xsdParticle, "opposite")) != null) {
                            this.eReferenceToOppositeNameMap.put(eReference, opposite);
                        }
                    } else if (xsdTerm instanceof XSDWildcard) {
                        XSDWildcard xsdWildcard = (XSDWildcard)xsdTerm;
                        this.extendedMetaData.setFeatureKind(eReference, 5);
                        this.extendedMetaData.setWildcards(eReference, this.getWildcards(xsdWildcard));
                        this.extendedMetaData.setProcessingKind(eReference, xsdWildcard.getProcessContents().getValue() + 1);
                        this.extendedMetaData.setName(eReference, ":" + eClass.getEAllStructuralFeatures().indexOf(eReference));
                    } else {
                        this.extendedMetaData.setFeatureKind(eReference, 6);
                        this.extendedMetaData.setName(eReference, ":" + eClass.getEAllStructuralFeatures().indexOf(eReference));
                    }
                } else if (xsdComponent instanceof XSDElementDeclaration) {
                    XSDTypeDefinition xsdType;
                    XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdComponent;
                    eReference.setContainment(true);
                    eReference.setResolveProxies(false);
                    this.extendedMetaData.setFeatureKind(eReference, 4);
                    this.extendedMetaData.setName(eReference, xsdElementDeclaration.getName());
                    this.extendedMetaData.setNamespace(eReference, xsdElementDeclaration.getTargetNamespace());
                    XSDElementDeclaration substitutionGroupAffiliation = xsdElementDeclaration.getSubstitutionGroupAffiliation();
                    if (substitutionGroupAffiliation != null) {
                        EStructuralFeature affiliation = this.getEStructuralFeature(substitutionGroupAffiliation);
                        this.extendedMetaData.setAffiliation(eReference, affiliation);
                    }
                    if ((xsdType = this.getEffectiveTypeDefinition(null, xsdElementDeclaration)) instanceof XSDSimpleTypeDefinition) {
                        eReference.setResolveProxies(!XSDEcoreBuilder.isLocalReferenceType((XSDSimpleTypeDefinition)xsdType));
                    }
                    if (maxOccurs == 1 && xsdElementDeclaration.isNillable()) {
                        eReference.setUnsettable(true);
                    }
                    if (xsdElementDeclaration.isAbstract()) {
                        eReference.setChangeable(false);
                    }
                } else if (xsdComponent instanceof XSDAttributeUse) {
                    String opposite = this.getEcoreAttribute(xsdComponent, "opposite");
                    if (opposite != null) {
                        this.eReferenceToOppositeNameMap.put(eReference, opposite);
                    }
                    XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)xsdComponent;
                    XSDAttributeDeclaration xsdAttributeDeclaration = xsdAttributeUse.getAttributeDeclaration();
                    this.extendedMetaData.setFeatureKind(eReference, 2);
                    this.extendedMetaData.setName(eReference, xsdAttributeDeclaration.getName());
                    this.extendedMetaData.setNamespace(eReference, xsdAttributeDeclaration.getTargetNamespace());
                    eReference.setResolveProxies(!XSDEcoreBuilder.isLocalReferenceType((XSDSimpleTypeDefinition)this.getEffectiveTypeDefinition(xsdAttributeUse, xsdAttributeDeclaration)));
                } else if (xsdComponent instanceof XSDAttributeDeclaration) {
                    XSDAttributeDeclaration xsdAttributeDeclaration = (XSDAttributeDeclaration)xsdComponent;
                    this.extendedMetaData.setFeatureKind(eReference, 2);
                    this.extendedMetaData.setName(eReference, xsdAttributeDeclaration.getName());
                    this.extendedMetaData.setNamespace(eReference, xsdAttributeDeclaration.getTargetNamespace());
                    eReference.setResolveProxies(!XSDEcoreBuilder.isLocalReferenceType((XSDSimpleTypeDefinition)this.getEffectiveTypeDefinition(null, xsdAttributeDeclaration)));
                }
            }
            return eReference;
        }
        EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
        this.setAnnotations(eAttribute, xsdComponent);
        eAttribute.setName(String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1));
        eAttribute.setUnique(false);
        eAttribute.setEType(type);
        eAttribute.setLowerBound(minOccurs);
        eAttribute.setUpperBound(maxOccurs);
        eClass.getEStructuralFeatures().add(eAttribute);
        if (xsdComponent == null) {
            this.extendedMetaData.setName(eAttribute, ":" + eClass.getEAllStructuralFeatures().indexOf(eAttribute));
            this.extendedMetaData.setFeatureKind(eAttribute, 1);
        } else {
            this.map(xsdComponent, eAttribute);
            if (xsdComponent instanceof XSDAttributeUse) {
                XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)xsdComponent;
                XSDAttributeDeclaration xsdAttributeDeclaration = xsdAttributeUse.getAttributeDeclaration();
                this.extendedMetaData.setFeatureKind(eAttribute, 2);
                this.extendedMetaData.setName(eAttribute, xsdAttributeDeclaration.getName());
                this.extendedMetaData.setNamespace(eAttribute, xsdAttributeDeclaration.getTargetNamespace());
                String defaultValue = this.getEcoreAttribute(xsdComponent, "default");
                if (defaultValue == null) {
                    defaultValue = xsdAttributeUse.getLexicalValue();
                }
                eAttribute.setDefaultValueLiteral(defaultValue);
                this.initialize(eAttribute, (XSDSimpleTypeDefinition)this.getEffectiveTypeDefinition(xsdAttributeUse, xsdAttributeDeclaration));
            } else if (xsdComponent instanceof XSDAttributeDeclaration) {
                XSDAttributeDeclaration xsdAttributeDeclaration = (XSDAttributeDeclaration)xsdComponent;
                this.extendedMetaData.setFeatureKind(eAttribute, 2);
                this.extendedMetaData.setName(eAttribute, xsdAttributeDeclaration.getName());
                this.extendedMetaData.setNamespace(eAttribute, xsdAttributeDeclaration.getTargetNamespace());
                eAttribute.setDefaultValueLiteral(xsdAttributeDeclaration.getLexicalValue());
                this.initialize(eAttribute, (XSDSimpleTypeDefinition)this.getEffectiveTypeDefinition(null, xsdAttributeDeclaration));
            } else if (xsdComponent instanceof XSDParticle) {
                XSDTerm xsdTerm = ((XSDParticle)xsdComponent).getTerm();
                if (xsdTerm instanceof XSDElementDeclaration) {
                    XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdTerm;
                    this.extendedMetaData.setFeatureKind(eAttribute, 4);
                    this.extendedMetaData.setName(eAttribute, xsdElementDeclaration.getName());
                    this.extendedMetaData.setNamespace(eAttribute, xsdElementDeclaration.getTargetNamespace());
                    eAttribute.setDefaultValueLiteral(xsdElementDeclaration.getLexicalValue());
                    XSDTypeDefinition xsdType = this.getEffectiveTypeDefinition(xsdComponent, xsdElementDeclaration);
                    if (xsdType instanceof XSDSimpleTypeDefinition) {
                        this.initialize(eAttribute, (XSDSimpleTypeDefinition)xsdType);
                    }
                    if (xsdElementDeclaration.isNillable()) {
                        if (!XSDEcoreBuilder.canSupportNull((EDataType)type)) {
                            type = (EDataType)this.typeToTypeObjectMap.get(type);
                            eAttribute.setEType(type);
                        }
                        if (maxOccurs == 1) {
                            eAttribute.setUnsettable(true);
                        }
                    }
                    if (xsdElementDeclaration.isAbstract()) {
                        eAttribute.setChangeable(false);
                    }
                } else if (xsdTerm instanceof XSDWildcard) {
                    XSDWildcard xsdWildcard = (XSDWildcard)xsdTerm;
                    this.extendedMetaData.setFeatureKind(eAttribute, 5);
                    this.extendedMetaData.setWildcards(eAttribute, this.getWildcards(xsdWildcard));
                    this.extendedMetaData.setProcessingKind(eAttribute, xsdWildcard.getProcessContents().getValue() + 1);
                    this.extendedMetaData.setName(eAttribute, ":" + eClass.getEAllStructuralFeatures().indexOf(eAttribute));
                } else {
                    this.extendedMetaData.setFeatureKind(eAttribute, 6);
                }
            } else if (xsdComponent instanceof XSDWildcard) {
                XSDWildcard xsdWildcard = (XSDWildcard)xsdComponent;
                this.extendedMetaData.setFeatureKind(eAttribute, 3);
                this.extendedMetaData.setWildcards(eAttribute, this.getWildcards(xsdWildcard));
                this.extendedMetaData.setProcessingKind(eAttribute, xsdWildcard.getProcessContents().getValue() + 1);
                this.extendedMetaData.setName(eAttribute, ":" + eClass.getEAllStructuralFeatures().indexOf(eAttribute));
            } else if (xsdComponent instanceof XSDElementDeclaration) {
                XSDElementDeclaration substitutionGroupAffiliation;
                XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdComponent;
                this.extendedMetaData.setFeatureKind(eAttribute, 4);
                this.extendedMetaData.setName(eAttribute, xsdElementDeclaration.getName());
                this.extendedMetaData.setNamespace(eAttribute, xsdElementDeclaration.getTargetNamespace());
                eAttribute.setDefaultValueLiteral(xsdElementDeclaration.getLexicalValue());
                XSDTypeDefinition xsdType = this.getEffectiveTypeDefinition(null, xsdElementDeclaration);
                if (xsdType instanceof XSDSimpleTypeDefinition) {
                    this.initialize(eAttribute, (XSDSimpleTypeDefinition)xsdType);
                }
                if ((substitutionGroupAffiliation = xsdElementDeclaration.getSubstitutionGroupAffiliation()) != null) {
                    EStructuralFeature affiliation = this.getEStructuralFeature(substitutionGroupAffiliation);
                    this.extendedMetaData.setAffiliation(eAttribute, affiliation);
                }
                if (xsdElementDeclaration.isNillable() && !XSDEcoreBuilder.canSupportNull((EDataType)type)) {
                    type = (EDataType)this.typeToTypeObjectMap.get(type);
                    eAttribute.setEType(type);
                    if (maxOccurs == 1) {
                        eAttribute.setUnsettable(true);
                    }
                }
                if (xsdElementDeclaration.isAbstract()) {
                    eAttribute.setChangeable(false);
                }
            }
        }
        if (maxOccurs == 1 && (type.getDefaultValue() != null || eAttribute.getDefaultValueLiteral() != null)) {
            eAttribute.setUnsettable(true);
        }
        return eAttribute;
    }

    protected XSDTypeDefinition getEffectiveTypeDefinition(XSDComponent xsdComponent, XSDFeature xsdFeature) {
        return xsdFeature.getType();
    }

    protected EStructuralFeature createFeature(EClass eClass, XSDElementDeclaration xsdElementDeclaration, String name, XSDComponent xsdComponent, int minOccurs, int maxOccurs) {
        XSDTypeDefinition elementTypeDefinition = this.getEffectiveTypeDefinition(xsdComponent, xsdElementDeclaration);
        EClassifier eClassifier = this.getEClassifier(elementTypeDefinition);
        XSDTypeDefinition referenceType = this.getEcoreTypeQNameAttribute(xsdComponent, "reference");
        if (referenceType == null) {
            referenceType = this.getEcoreTypeQNameAttribute(xsdElementDeclaration, "reference");
        }
        if (referenceType != null) {
            XSDSimpleTypeDefinition xsdSimpleTypeDefinition;
            EClassifier referenceClassifier = this.getEClassifier(referenceType);
            boolean needsHolder = false;
            if (elementTypeDefinition instanceof XSDSimpleTypeDefinition && (xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)elementTypeDefinition).getVariety() == XSDVariety.LIST_LITERAL) {
                String holderName;
                needsHolder = true;
                EPackage holderPackage = this.getEPackage(xsdElementDeclaration);
                EClass holderClass = (EClass)this.extendedMetaData.getType(holderPackage, holderName = String.valueOf(xsdElementDeclaration.getName()) + ":holder");
                if (holderClass == null) {
                    holderClass = EcoreFactory.eINSTANCE.createEClass();
                    this.setAnnotations(holderClass, xsdElementDeclaration);
                    holderClass.setName(this.validName(holderName, true));
                    this.extendedMetaData.setName(holderClass, holderName);
                    this.extendedMetaData.setContentKind(holderClass, 2);
                    XSDEcoreBuilder.addToSortedList(holderPackage.getEClassifiers(), holderClass);
                    EReference holderReference = (EReference)this.createFeature(holderClass, "value", referenceClassifier, null, 0, -1);
                    holderReference.setResolveProxies(!XSDEcoreBuilder.isLocalReferenceType(xsdSimpleTypeDefinition));
                }
                referenceClassifier = holderClass;
            }
            EStructuralFeature result = this.createFeature(eClass, name, referenceClassifier, xsdComponent, minOccurs, maxOccurs);
            ((EReference)result).setContainment(needsHolder);
            if (needsHolder) {
                ((EReference)result).setUnsettable(false);
                ((EReference)result).setResolveProxies(false);
            }
            this.initialize(result, xsdElementDeclaration, xsdComponent);
            return result;
        }
        EStructuralFeature result = this.createFeature(eClass, name, eClassifier, xsdComponent, minOccurs, maxOccurs);
        this.initialize(result, xsdElementDeclaration, xsdComponent);
        return result;
    }

    protected EStructuralFeature createFeature(EClass eClass, XSDAttributeDeclaration xsdAttributeDeclaration, String name, XSDComponent xsdComponent, boolean isRequired) {
        boolean isMany;
        XSDTypeDefinition referenceType;
        XSDSimpleTypeDefinition attributeTypeDefinition = (XSDSimpleTypeDefinition)this.getEffectiveTypeDefinition(xsdComponent, xsdAttributeDeclaration);
        if (attributeTypeDefinition == null) {
            attributeTypeDefinition = xsdComponent.getSchema().getSchemaForSchema().resolveSimpleTypeDefinition("anySimpleType");
        }
        if ((referenceType = this.getEcoreTypeQNameAttribute(xsdComponent, "reference")) == null) {
            referenceType = this.getEcoreTypeQNameAttribute(xsdAttributeDeclaration, "reference");
        }
        if (referenceType != null) {
            int lowerBound = isRequired ? 1 : 0;
            int upperBound = 1;
            if (attributeTypeDefinition.getVariety() == XSDVariety.LIST_LITERAL) {
                XSDMaxLengthFacet xsdMaxLengthFacet;
                XSDLengthFacet xsdLengthFacet = attributeTypeDefinition.getEffectiveLengthFacet();
                if (isRequired) {
                    if (xsdLengthFacet != null) {
                        lowerBound = xsdLengthFacet.getValue();
                    } else {
                        XSDMinLengthFacet xsdMinLengthFacet = attributeTypeDefinition.getEffectiveMinLengthFacet();
                        if (xsdMinLengthFacet != null) {
                            lowerBound = xsdMinLengthFacet.getValue();
                        }
                    }
                }
                upperBound = xsdLengthFacet != null ? xsdLengthFacet.getValue() : ((xsdMaxLengthFacet = attributeTypeDefinition.getEffectiveMaxLengthFacet()) != null ? xsdMaxLengthFacet.getValue() : -1);
            }
            EClassifier referenceClassifier = this.getEClassifier(referenceType);
            EStructuralFeature result = this.createFeature(eClass, name, referenceClassifier, xsdComponent, lowerBound, upperBound);
            this.initialize(result, xsdAttributeDeclaration, xsdComponent);
            return result;
        }
        boolean bl = isMany = attributeTypeDefinition.getVariety() == XSDVariety.LIST_LITERAL && xsdComponent instanceof XSDAttributeUse && "true".equals(this.getEcoreAttribute(xsdComponent, "many"));
        if (isMany) {
            EDataType eDataType = this.getEDataType(attributeTypeDefinition.getItemTypeDefinition());
            XSDLengthFacet xsdLengthFacet = attributeTypeDefinition.getEffectiveLengthFacet();
            int lowerBound = isRequired ? 1 : 0;
            int upperBound = -1;
            if (isRequired) {
                if (xsdLengthFacet != null) {
                    lowerBound = xsdLengthFacet.getValue();
                } else {
                    XSDMinLengthFacet xsdMinLengthFacet = attributeTypeDefinition.getEffectiveMinLengthFacet();
                    if (xsdMinLengthFacet != null) {
                        lowerBound = xsdMinLengthFacet.getValue();
                    }
                }
            }
            if (xsdLengthFacet != null) {
                upperBound = xsdLengthFacet.getValue();
            } else {
                XSDMaxLengthFacet xsdMaxLengthFacet = attributeTypeDefinition.getEffectiveMaxLengthFacet();
                if (xsdMaxLengthFacet != null) {
                    upperBound = xsdMaxLengthFacet.getValue();
                }
            }
            EStructuralFeature result = this.createFeature(eClass, name, eDataType, xsdComponent, lowerBound, upperBound);
            this.initialize(result, xsdAttributeDeclaration, xsdComponent);
            return result;
        }
        EDataType eDataType = this.getEDataType(attributeTypeDefinition);
        EStructuralFeature result = this.createFeature(eClass, name, eDataType, xsdComponent, isRequired ? 1 : 0, 1);
        this.initialize(result, xsdAttributeDeclaration, xsdComponent);
        return result;
    }

    protected void initialize(EStructuralFeature eStructuralFeature, XSDFeature xsdFeature, XSDComponent xsdComponent) {
        String isSuppressedUnsetVisibility;
        String isSuppressedIsSetVisibility;
        String isSuppressedSetVisibility;
        String isSuppressedGetVisibility;
        String resolveProxies;
        String upperBound;
        String lowerBound;
        String isVolatile;
        String isTransient;
        String derived;
        String changeable;
        String unique;
        String ordered;
        String unsettable = this.getEcoreAttribute(xsdComponent, xsdFeature, "unsettable");
        if (unsettable != null) {
            eStructuralFeature.setUnsettable("true".equals(unsettable));
        }
        if ((ordered = this.getEcoreAttribute(xsdComponent, xsdFeature, "ordered")) != null) {
            eStructuralFeature.setOrdered("true".equals(ordered));
        }
        if ((unique = this.getEcoreAttribute(xsdComponent, xsdFeature, "unique")) != null) {
            eStructuralFeature.setUnique("true".equals(unique));
        }
        if ((changeable = this.getEcoreAttribute(xsdComponent, xsdFeature, "changeable")) != null) {
            eStructuralFeature.setChangeable("true".equals(changeable));
        }
        if ((derived = this.getEcoreAttribute(xsdComponent, xsdFeature, "derived")) != null) {
            eStructuralFeature.setDerived("true".equals(derived));
        }
        if ((isTransient = this.getEcoreAttribute(xsdComponent, xsdFeature, "transient")) != null) {
            eStructuralFeature.setTransient("true".equals(isTransient));
        }
        if ((isVolatile = this.getEcoreAttribute(xsdComponent, xsdFeature, "volatile")) != null) {
            eStructuralFeature.setVolatile("true".equals(isVolatile));
        }
        if ((lowerBound = this.getEcoreAttribute(xsdComponent, xsdFeature, "lowerBound")) != null) {
            eStructuralFeature.setLowerBound(Integer.parseInt(lowerBound));
        }
        if ((upperBound = this.getEcoreAttribute(xsdComponent, xsdFeature, "upperBound")) != null) {
            eStructuralFeature.setUpperBound(Integer.parseInt(upperBound));
        }
        if ((resolveProxies = this.getEcoreAttribute(xsdComponent, xsdFeature, "resolveProxies")) != null && eStructuralFeature instanceof EReference) {
            ((EReference)eStructuralFeature).setResolveProxies("true".equals(resolveProxies));
        }
        if ((isSuppressedGetVisibility = this.getEcoreAttribute(xsdComponent, xsdFeature, "suppressedGetVisibility")) != null) {
            EcoreUtil.setSuppressedVisibility(eStructuralFeature, 0, "true".equals(isSuppressedGetVisibility));
        }
        if ((isSuppressedSetVisibility = this.getEcoreAttribute(xsdComponent, xsdFeature, "suppressedSetVisibility")) != null) {
            EcoreUtil.setSuppressedVisibility(eStructuralFeature, 1, "true".equals(isSuppressedSetVisibility));
        }
        if ((isSuppressedIsSetVisibility = this.getEcoreAttribute(xsdComponent, xsdFeature, "suppressedIsSetVisibility")) != null) {
            EcoreUtil.setSuppressedVisibility(eStructuralFeature, 2, "true".equals(isSuppressedIsSetVisibility));
        }
        if ((isSuppressedUnsetVisibility = this.getEcoreAttribute(xsdComponent, xsdFeature, "suppressedUnsetVisibility")) != null) {
            EcoreUtil.setSuppressedVisibility(eStructuralFeature, 3, "true".equals(isSuppressedUnsetVisibility));
        }
    }

    protected void initialize(EAttribute eAttribute, XSDSimpleTypeDefinition xsdSimpleTypeDefinition) {
        if (XSDConstants.isOrIsDerivedFromID(xsdSimpleTypeDefinition)) {
            eAttribute.setID(true);
        }
        if (eAttribute.getDefaultValueLiteral() == null && xsdSimpleTypeDefinition != null && xsdSimpleTypeDefinition.getEffectiveEnumerationFacet() != null && eAttribute.getEType().getDefaultValue() != null) {
            eAttribute.setDefaultValueLiteral(((XSDEnumerationFacet)xsdSimpleTypeDefinition.getEffectiveEnumerationFacet().getSimpleTypeDefinition().getEnumerationFacets().get(0)).getLexicalValue());
        }
    }

    public List collectParticles(XSDParticle xsdParticle) {
        ArrayList result = new ArrayList();
        this.collectParticlesHelper(result, xsdParticle, 1, 1, null);
        return result;
    }

    public void collectParticlesHelper(List result, XSDParticle xsdParticle, int minOccurs, int maxOccurs, XSDModelGroup target) {
        int particleMaxOccurs = xsdParticle.getMaxOccurs();
        int effectiveMinOccurs = minOccurs * xsdParticle.getMinOccurs();
        int effectiveMaxOccurs = maxOccurs == -1 || particleMaxOccurs == -1 ? -1 : maxOccurs * particleMaxOccurs;
        XSDTerm xsdTerm = xsdParticle.getTerm();
        if (xsdTerm instanceof XSDModelGroup) {
            XSDModelGroup xsdModelGroup = (XSDModelGroup)xsdTerm;
            EList particles = xsdModelGroup.getParticles();
            if (particles.size() == 0) {
                return;
            }
            boolean isIgnored = effectiveMaxOccurs == 1 || particles.size() == 1 && ((XSDParticle)particles.get(0)).getTerm() instanceof XSDModelGroup;
            String featureMapName = this.getEcoreAttribute(xsdParticle, "name");
            if (featureMapName == null && (featureMapName = this.getEcoreAttribute(xsdParticle, "featureMap")) == null && (featureMapName = this.getEcoreAttribute(xsdTerm, "name")) == null) {
                featureMapName = this.getEcoreAttribute(xsdTerm, "featureMap");
            }
            if ("".equals(featureMapName)) {
                isIgnored = true;
            } else if (featureMapName != null) {
                isIgnored = false;
            } else if (target != null) {
                isIgnored = true;
            }
            if (!isIgnored) {
                EffectiveOccurrence effectiveOccurrence = new EffectiveOccurrence(effectiveMinOccurs, effectiveMaxOccurs, xsdParticle, null);
                result.add(effectiveOccurrence);
                target = xsdModelGroup;
            }
            if (xsdModelGroup.getCompositor() == XSDCompositor.CHOICE_LITERAL) {
                effectiveMinOccurs = 0;
            }
            Iterator i = ((XSDModelGroup)xsdTerm).getParticles().iterator();
            while (i.hasNext()) {
                XSDParticle childXSDParticle = (XSDParticle)i.next();
                this.collectParticlesHelper(result, childXSDParticle, effectiveMinOccurs, effectiveMaxOccurs, target);
            }
        } else {
            EffectiveOccurrence effectiveOccurrence = new EffectiveOccurrence(effectiveMinOccurs, effectiveMaxOccurs, xsdParticle, target);
            result.add(effectiveOccurrence);
        }
    }

    protected void fixXMLName(EClassifier eClassifier) {
        EDataType objectType = (EDataType)this.typeToTypeObjectMap.get(eClassifier);
        if (objectType != null) {
            this.extendedMetaData.setName(objectType, String.valueOf(this.extendedMetaData.getName(eClassifier)) + ":Object");
            this.extendedMetaData.setBaseType(objectType, (EDataType)eClassifier);
        }
        if (eClassifier instanceof EDataType) {
            List memberTypes;
            EDataType itemType;
            EDataType eDataType = (EDataType)eClassifier;
            EDataType baseType = this.extendedMetaData.getBaseType(eDataType);
            if (baseType != null && this.extendedMetaData.getName(baseType).endsWith("_._base")) {
                this.extendedMetaData.setName(baseType, String.valueOf(this.extendedMetaData.getName(eClassifier)) + "_._base");
                this.extendedMetaData.setBaseType(eDataType, baseType);
                this.fixXMLName(baseType);
            }
            if ((itemType = this.extendedMetaData.getItemType(eDataType)) != null && this.extendedMetaData.getName(itemType).endsWith("_._item")) {
                this.extendedMetaData.setName(itemType, String.valueOf(this.extendedMetaData.getName(eClassifier)) + "_._item");
                this.extendedMetaData.setItemType(eDataType, itemType);
                this.fixXMLName(itemType);
            }
            if (!(memberTypes = this.extendedMetaData.getMemberTypes(eDataType)).isEmpty()) {
                ListIterator i = memberTypes.listIterator();
                while (i.hasNext()) {
                    EDataType memberType = (EDataType)i.next();
                    if (!this.extendedMetaData.getName(memberType).endsWith("_._member_._" + i.previousIndex())) continue;
                    this.extendedMetaData.setName(memberType, String.valueOf(this.extendedMetaData.getName(eClassifier)) + "_._member_._" + i.previousIndex());
                    this.fixXMLName(memberType);
                }
                this.extendedMetaData.setMemberTypes(eDataType, memberTypes);
            }
        } else {
            EStructuralFeature simpleFeature = this.extendedMetaData.getSimpleFeature((EClass)eClassifier);
            if (simpleFeature != null && this.extendedMetaData.getName(simpleFeature.getEType()).endsWith("_._base")) {
                EDataType baseType = (EDataType)simpleFeature.getEType();
                this.extendedMetaData.setName(baseType, String.valueOf(this.extendedMetaData.getName(eClassifier)) + "_._base");
                this.fixXMLName(baseType);
            }
        }
    }

    protected void resolveNameConflicts() {
        Iterator i = this.targetNamespaceToEPackageMap.values().iterator();
        while (i.hasNext()) {
            EPackage ePackage = (EPackage)i.next();
            HashMap<String, EClassifier> eClassifierMap = new HashMap<String, EClassifier>();
            Iterator j = ePackage.getEClassifiers().iterator();
            while (j.hasNext()) {
                EClassifier eClassifier = (EClassifier)j.next();
                EClassifier otherEClassifier = (EClassifier)eClassifierMap.get(eClassifier.getName().toLowerCase());
                if (otherEClassifier != null) {
                    this.resolveNameConflict(eClassifierMap, eClassifier, "");
                }
                eClassifierMap.put(eClassifier.getName().toLowerCase(), eClassifier);
                String xmlName = this.extendedMetaData.getName(eClassifier);
                otherEClassifier = this.extendedMetaData.getType(ePackage, xmlName);
                if (otherEClassifier != eClassifier && xmlName.endsWith("_._type")) {
                    String baseName = xmlName.substring(0, xmlName.length() - 7);
                    int index = 1;
                    while (this.extendedMetaData.getType(ePackage, String.valueOf(baseName) + "_._" + index + "_._type") != null) {
                        ++index;
                    }
                    this.extendedMetaData.setName(eClassifier, String.valueOf(baseName) + "_._" + index + "_._type");
                    this.fixXMLName(eClassifier);
                }
                if (eClassifier instanceof EClass) {
                    HashMap<String, EStructuralFeature> eFeatureMap = new HashMap<String, EStructuralFeature>();
                    Iterator k = ((EClass)eClassifier).getEAllStructuralFeatures().iterator();
                    while (k.hasNext()) {
                        EStructuralFeature eStructuralFeature = (EStructuralFeature)k.next();
                        this.resolveNameConflict(eFeatureMap, eStructuralFeature, "");
                        eFeatureMap.put(eStructuralFeature.getName().toLowerCase(), eStructuralFeature);
                    }
                    continue;
                }
                if (!(eClassifier instanceof EEnum)) continue;
                HashMap<String, EEnumLiteral> eLiteralMap = new HashMap<String, EEnumLiteral>();
                Iterator k = ((EEnum)eClassifier).getELiterals().iterator();
                while (k.hasNext()) {
                    EEnumLiteral eEnumLiteral = (EEnumLiteral)k.next();
                    this.resolveNameConflict(eLiteralMap, eEnumLiteral, "");
                    eLiteralMap.put(eEnumLiteral.getName().toLowerCase(), eEnumLiteral);
                }
            }
        }
    }

    protected void resolveNameConflict(Map map, ENamedElement eNamedElement, String suffix) {
        String name = eNamedElement.getName();
        if (!name.endsWith(suffix)) {
            name = String.valueOf(name) + suffix;
        }
        if (map.containsKey(name.toLowerCase())) {
            int index = 0;
            while (map.containsKey(String.valueOf(name.toLowerCase()) + ++index)) {
            }
            eNamedElement.setName(String.valueOf(name) + index);
        } else {
            eNamedElement.setName(name);
        }
    }

    protected ResourceSet createResourceSet() {
        ResourceSetImpl result = new ResourceSetImpl();
        result.getLoadOptions().put(XSDResourceImpl.XSD_TRACK_LOCATION, Boolean.TRUE);
        Map extensionToFactoryMap = result.getResourceFactoryRegistry().getExtensionToFactoryMap();
        extensionToFactoryMap.put("wsdl", new XSDResourceFactoryImpl());
        extensionToFactoryMap.put("xsd", new XSDResourceFactoryImpl());
        if (ecoreResourceFactoryImplClass != null) {
            try {
                extensionToFactoryMap.put("ecore", ecoreResourceFactoryImplClass.newInstance());
            }
            catch (Exception exception) {
                XSDPlugin.INSTANCE.log(exception);
            }
        }
        return result;
    }

    public Collection generateResources(URI uri) {
        return this.generateResources(Collections.singleton(uri));
    }

    public Collection generateResources(Collection uris) {
        ResourceSet resourceSet = this.createResourceSet();
        Iterator<Object> i = uris.iterator();
        while (i.hasNext()) {
            URI uri = (URI)i.next();
            Resource resource = resourceSet.getResource(uri, true);
            if (resource.getContents().isEmpty() || !(resource.getContents().get(0) instanceof XSDSchema)) continue;
            this.generate((XSDSchema)resource.getContents().get(0));
        }
        i = this.targetNamespaceToEPackageMap.values().iterator();
        while (i.hasNext()) {
            EPackage ePackage = (EPackage)i.next();
            if (ePackage.eResource() != null) continue;
            Resource ecoreResource = resourceSet.createResource(URI.createURI("*.ecore"));
            ecoreResource.setURI(URI.createURI(ePackage.getNsURI()));
            ecoreResource.getContents().add(ePackage);
        }
        return new ArrayList(resourceSet.getResources());
    }

    public EStructuralFeature getEStructuralFeature(XSDFeature xsdFeature) {
        if ("true".equals(this.getEcoreAttribute(xsdFeature, "ignore"))) {
            return null;
        }
        EStructuralFeature eStructuralFeature = (EStructuralFeature)this.xsdComponentToEModelElementMap.get(xsdFeature);
        if (eStructuralFeature == null) {
            EStructuralFeature result;
            String name;
            EPackage ePackage = this.getEPackage(xsdFeature);
            EClass documentEClass = this.extendedMetaData.getDocumentRoot(ePackage);
            if (documentEClass == null) {
                documentEClass = EcoreFactory.eINSTANCE.createEClass();
                name = this.getEcoreAttribute(xsdFeature.getSchema(), "documentRoot");
                if (name == null) {
                    name = "DocumentRoot";
                }
                documentEClass.setName(name);
                this.extendedMetaData.setDocumentRoot(documentEClass);
                ePackage.getEClassifiers().add(documentEClass);
                this.createFeature(documentEClass, "mixed", EcorePackage.eINSTANCE.getEFeatureMapEntry(), null, 0, -1);
                EStructuralFeature xmlnsPrefixMapFeature = this.createFeature(documentEClass, "xMLNSPrefixMap", EcorePackage.eINSTANCE.getEStringToStringMapEntry(), null, 0, -1);
                this.extendedMetaData.setName(xmlnsPrefixMapFeature, "xmlns:prefix");
                EStructuralFeature xsiSchemaLocationMapFeature = this.createFeature(documentEClass, "xSISchemaLocation", EcorePackage.eINSTANCE.getEStringToStringMapEntry(), null, 0, -1);
                this.extendedMetaData.setName(xsiSchemaLocationMapFeature, "xsi:schemaLocation");
            }
            if ((name = this.getEcoreAttribute(xsdFeature, "name")) == null) {
                name = this.validName(xsdFeature.getName(), true);
            }
            if (xsdFeature instanceof XSDElementDeclaration) {
                result = this.createFeature(documentEClass, (XSDElementDeclaration)xsdFeature, name, (XSDComponent)xsdFeature, 0, -2);
                result.setDerived(true);
                result.setTransient(true);
                result.setVolatile(true);
                return result;
            }
            result = this.createFeature(documentEClass, (XSDAttributeDeclaration)xsdFeature, name, xsdFeature, false);
            return result;
        }
        return eStructuralFeature;
    }

    public Collection generate(URI uri) {
        ResourceSet resourceSet = this.createResourceSet();
        Resource resource = resourceSet.getResource(uri, true);
        if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof XSDSchema) {
            this.generate((XSDSchema)resource.getContents().get(0));
        }
        ArrayList result = new ArrayList(this.targetNamespaceToEPackageMap.values());
        result.remove(XMLNamespacePackage.eINSTANCE);
        if (this.mapper != null) {
            result.add(this.mapper.getRoot());
        }
        return result;
    }

    public Collection generate(Collection uris) {
        if (this.simpleDiagnostics == null) {
            this.simpleDiagnostics = new ArrayList();
        }
        ResourceSet resourceSet = this.createResourceSet();
        Iterator i = uris.iterator();
        while (i.hasNext()) {
            Resource resource = resourceSet.getResource((URI)i.next(), true);
            Iterator j = resource.getContents().iterator();
            while (j.hasNext()) {
                Object object = j.next();
                if (!(object instanceof XSDSchema)) continue;
                this.generate((XSDSchema)object);
            }
        }
        ArrayList result = new ArrayList(this.targetNamespaceToEPackageMap.values());
        result.remove(XMLNamespacePackage.eINSTANCE);
        if (this.mapper != null) {
            result.add(this.mapper.getRoot());
        }
        result.add(this.simpleDiagnostics);
        return result;
    }

    public void generate(XSDSchema xsdSchema) {
        Iterator<Object> i;
        this.rootSchema = xsdSchema;
        if (this.xsdSchemas.add(xsdSchema)) {
            this.addInput(xsdSchema);
            this.validate(xsdSchema);
        }
        ArrayList visitedElementDeclarations = new ArrayList();
        ArrayList elementDeclarations = new ArrayList(xsdSchema.getElementDeclarations());
        ArrayList visitedAttributeDeclarations = new ArrayList();
        ArrayList attributeDeclarations = new ArrayList(xsdSchema.getAttributeDeclarations());
        ArrayList visitedTypeDefinitions = new ArrayList();
        ArrayList typeDefinitions = new ArrayList(xsdSchema.getTypeDefinitions());
        while (!(elementDeclarations.isEmpty() && attributeDeclarations.isEmpty() && typeDefinitions.isEmpty())) {
            i = elementDeclarations.iterator();
            while (i.hasNext()) {
                XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)i.next();
                this.getEStructuralFeature(xsdElementDeclaration);
            }
            visitedElementDeclarations.addAll(elementDeclarations);
            elementDeclarations = new ArrayList(xsdSchema.getElementDeclarations());
            elementDeclarations.removeAll(visitedElementDeclarations);
            i = attributeDeclarations.iterator();
            while (i.hasNext()) {
                XSDAttributeDeclaration xsdAttributeDeclaration = (XSDAttributeDeclaration)i.next();
                if (XSDConstants.isSchemaInstanceNamespace(xsdAttributeDeclaration.getTargetNamespace())) continue;
                this.getEStructuralFeature(xsdAttributeDeclaration);
            }
            visitedAttributeDeclarations.addAll(attributeDeclarations);
            attributeDeclarations = new ArrayList(xsdSchema.getAttributeDeclarations());
            attributeDeclarations.removeAll(visitedAttributeDeclarations);
            i = typeDefinitions.iterator();
            while (i.hasNext()) {
                XSDTypeDefinition xsdTypeDefinition = (XSDTypeDefinition)i.next();
                this.getEClassifier(xsdTypeDefinition);
            }
            visitedTypeDefinitions.addAll(typeDefinitions);
            typeDefinitions = new ArrayList(xsdSchema.getTypeDefinitions());
            typeDefinitions.removeAll(visitedTypeDefinitions);
        }
        this.resolveNameConflicts();
        i = this.xsdSchemas.iterator();
        while (i.hasNext()) {
            String packageNsPrefix;
            XSDSchema generatedXSDSchema = (XSDSchema)i.next();
            EPackage ePackage = (EPackage)this.targetNamespaceToEPackageMap.get(generatedXSDSchema.getTargetNamespace());
            if (ePackage == null) continue;
            String packageName = this.getEcoreAttribute(generatedXSDSchema, "package");
            if (packageName != null) {
                ePackage.setName(packageName);
            }
            if ((packageNsPrefix = this.getEcoreAttribute(generatedXSDSchema, "nsPrefix")) == null) continue;
            ePackage.setNsPrefix(packageNsPrefix);
        }
        i = this.eReferenceToOppositeNameMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            EReference eReference = (EReference)entry.getKey();
            String opposite = (String)entry.getValue();
            EClass oppositeEClass = eReference.getEReferenceType();
            if (eReference.getEOpposite() == null) {
                EStructuralFeature eOppositeFeature = oppositeEClass.getEStructuralFeature(opposite);
                if (eOppositeFeature == null) {
                    Iterator j = oppositeEClass.getEAllStructuralFeatures().iterator();
                    while (j.hasNext()) {
                        EStructuralFeature feature = (EStructuralFeature)j.next();
                        if (!opposite.equals(this.extendedMetaData.getName(feature))) continue;
                        eOppositeFeature = feature;
                        break;
                    }
                }
                if (eOppositeFeature instanceof EReference) {
                    EReference eOpposite = (EReference)eOppositeFeature;
                    eOpposite.setEOpposite(eReference);
                    eReference.setEOpposite(eOpposite);
                }
            }
            if (eReference.getEOpposite() != null || !eReference.isContainment()) continue;
            EReference eOpposite = EcoreFactory.eINSTANCE.createEReference();
            eOpposite.setName(opposite);
            eOpposite.setEType(eReference.getEContainingClass());
            eOpposite.setLowerBound(0);
            eOpposite.setEOpposite(eReference);
            eReference.setEOpposite(eOpposite);
            eOpposite.setTransient(true);
            oppositeEClass.getEStructuralFeatures().add(eOpposite);
        }
        this.eReferenceToOppositeNameMap.clear();
    }

    protected String getEcoreAttribute(XSDConcreteComponent xsdConcreteComponent1, XSDConcreteComponent xsdConcreteComponent2, String attribute) {
        String result = this.getEcoreAttribute(xsdConcreteComponent1, attribute);
        if (result == null) {
            result = this.getEcoreAttribute(xsdConcreteComponent2, attribute);
        }
        return result;
    }

    protected String getEcoreAttribute(XSDConcreteComponent xsdConcreteComponent, String attribute) {
        if (xsdConcreteComponent == null) {
            return null;
        }
        Element element = xsdConcreteComponent.getElement();
        return this.getEcoreAttribute(element, attribute);
    }

    protected String getEcoreAttribute(Element element, String attribute) {
        return element != null && element.hasAttributeNS("http://www.eclipse.org/emf/2002/Ecore", attribute) ? element.getAttributeNS("http://www.eclipse.org/emf/2002/Ecore", attribute) : null;
    }

    protected XSDTypeDefinition getEcoreTypeQNameAttribute(XSDConcreteComponent xsdConcreteComponent, String attribute) {
        Element element = xsdConcreteComponent.getElement();
        return element == null ? null : this.getEcoreTypeQNameAttribute(xsdConcreteComponent, element, "http://www.eclipse.org/emf/2002/Ecore", attribute);
    }

    protected XSDTypeDefinition getEcoreTypeQNameAttribute(XSDConcreteComponent xsdConcreteComponent, Element element, String namespace, String attribute) {
        String qName;
        XSDTypeDefinition result;
        if (element != null && element.hasAttributeNS(namespace, attribute) && (result = xsdConcreteComponent.resolveTypeDefinitionURI(XSDConstants.lookupQName(element, qName = element.getAttributeNS(namespace, attribute)))).getContainer() != null) {
            return result;
        }
        return null;
    }

    protected List getEcoreTypeQNamesAttribute(XSDConcreteComponent xsdConcreteComponent, String attribute) {
        Element element = xsdConcreteComponent.getElement();
        return element == null ? Collections.EMPTY_LIST : this.getEcoreTypeQNamesAttribute(xsdConcreteComponent, element, "http://www.eclipse.org/emf/2002/Ecore", attribute);
    }

    protected List getEcoreTypeQNamesAttribute(XSDConcreteComponent xsdConcreteComponent, Element element, String namespace, String attribute) {
        ArrayList<XSDTypeDefinition> result = new ArrayList<XSDTypeDefinition>();
        if (element != null && element.hasAttributeNS(namespace, attribute)) {
            StringTokenizer stringTokenizer = new StringTokenizer(element.getAttributeNS(namespace, attribute));
            while (stringTokenizer.hasMoreTokens()) {
                String qName = stringTokenizer.nextToken();
                XSDTypeDefinition xsdTypeDefinition = xsdConcreteComponent.resolveTypeDefinitionURI(XSDConstants.lookupQName(element, qName));
                if (xsdTypeDefinition.getContainer() == null) continue;
                result.add(xsdTypeDefinition);
            }
        }
        return result;
    }

    public static List sortNamedComponents(Collection eNamedElements) {
        Object[] objects = eNamedElements.toArray();
        Arrays.sort(objects, Comparator.INSTANCE);
        return Arrays.asList(objects);
    }

    public static void addToSortedList(List eNamedElements, ENamedElement eNamedElement) {
        int index = Collections.binarySearch(eNamedElements, eNamedElement, Comparator.INSTANCE);
        if (index < 0) {
            eNamedElements.add(-(index + 1), eNamedElement);
        } else if (eNamedElements.get(index) != eNamedElement) {
            eNamedElements.add(index, eNamedElement);
        }
    }

    public static boolean isLocalReferenceType(XSDSimpleTypeDefinition xsdSimpleTypeDefinition) {
        while (xsdSimpleTypeDefinition != null) {
            if (XSDConstants.isAnySimpleType(xsdSimpleTypeDefinition)) {
                return false;
            }
            String name = xsdSimpleTypeDefinition.getName();
            if (XSDConstants.isSchemaForSchemaNamespace(xsdSimpleTypeDefinition.getTargetNamespace()) && ("IDREF".equals(name) || "IDREFS".equals(name))) {
                return true;
            }
            xsdSimpleTypeDefinition = xsdSimpleTypeDefinition.getBaseTypeDefinition();
        }
        return false;
    }

    protected void setAnnotations(EModelElement eModelElement, XSDConcreteComponent xsdComponent) {
        ArrayList<XSDAnnotation> xsdAnnotations = new ArrayList<XSDAnnotation>();
        ArrayList<Element> elements = new ArrayList<Element>();
        boolean append = true;
        if (xsdComponent instanceof XSDParticle) {
            xsdComponent = ((XSDParticle)xsdComponent).getContent();
        }
        if (xsdComponent != null) {
            elements.add(xsdComponent.getElement());
        }
        if (xsdComponent instanceof XSDAttributeDeclaration) {
            xsdAnnotations.add(((XSDAttributeDeclaration)xsdComponent).getAnnotation());
        } else if (xsdComponent instanceof XSDAttributeUse) {
            XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)xsdComponent;
            xsdAnnotations.add(xsdAttributeUse.getContent().getAnnotation());
            XSDAttributeDeclaration xsdAttributeDeclaration = xsdAttributeUse.getAttributeDeclaration();
            xsdAnnotations.add(xsdAttributeDeclaration.getAnnotation());
            elements.add(xsdAttributeDeclaration.getElement());
            append = false;
        } else if (xsdComponent instanceof XSDElementDeclaration) {
            XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdComponent;
            xsdAnnotations.add(xsdElementDeclaration.getAnnotation());
            if (xsdElementDeclaration.isElementDeclarationReference()) {
                XSDElementDeclaration resolvedElementDeclaration = xsdElementDeclaration.getResolvedElementDeclaration();
                xsdAnnotations.add(resolvedElementDeclaration.getAnnotation());
                elements.add(resolvedElementDeclaration.getElement());
            }
            append = false;
        } else if (xsdComponent instanceof XSDAttributeGroupDefinition) {
            xsdAnnotations.add(((XSDAttributeGroupDefinition)xsdComponent).getAnnotation());
        } else if (xsdComponent instanceof XSDFacet) {
            xsdAnnotations.add(((XSDFacet)xsdComponent).getAnnotation());
        } else if (xsdComponent instanceof XSDIdentityConstraintDefinition) {
            xsdAnnotations.add(((XSDIdentityConstraintDefinition)xsdComponent).getAnnotation());
        } else if (xsdComponent instanceof XSDModelGroup) {
            xsdAnnotations.add(((XSDModelGroup)xsdComponent).getAnnotation());
        } else if (xsdComponent instanceof XSDModelGroupDefinition) {
            xsdAnnotations.add(((XSDModelGroupDefinition)xsdComponent).getAnnotation());
        } else if (xsdComponent instanceof XSDSchema) {
            xsdAnnotations.addAll(((XSDSchema)xsdComponent).getAnnotations());
        } else if (xsdComponent instanceof XSDTypeDefinition) {
            xsdAnnotations.addAll(((XSDTypeDefinition)xsdComponent).getAnnotations());
        } else if (xsdComponent instanceof XSDWildcard) {
            xsdAnnotations.add(((XSDWildcard)xsdComponent).getAnnotation());
        }
        boolean first = true;
        Iterator i = xsdAnnotations.iterator();
        while (i.hasNext()) {
            XSDAnnotation xsdAnnotation = (XSDAnnotation)i.next();
            if (xsdAnnotation != null && !"true".equals(this.getEcoreAttribute(xsdAnnotation, "ignore"))) {
                Element element;
                Iterator j = xsdAnnotation.getUserInformation().iterator();
                while (j.hasNext()) {
                    element = (Element)j.next();
                    if ("true".equals(this.getEcoreAttribute(element, "ignore")) || this.ignore(element)) continue;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    XSDResourceImpl.serialize((OutputStream)byteArrayOutputStream, element, "UTF-8");
                    try {
                        String documentation = byteArrayOutputStream.toString("UTF8");
                        int start = documentation.indexOf("?>");
                        start = documentation.indexOf(">", start + 2);
                        int end = documentation.lastIndexOf("</");
                        String documentationBody = end == -1 ? null : documentation.substring(start + 1, end);
                        String existingDocumentation = EcoreUtil.getDocumentation(eModelElement);
                        if (existingDocumentation != null) {
                            if (!first && !append) continue;
                            documentationBody = String.valueOf(existingDocumentation) + System.getProperty("line.separator") + documentationBody;
                        }
                        EcoreUtil.setDocumentation(eModelElement, documentationBody);
                    }
                    catch (UnsupportedEncodingException exception) {
                        throw new WrappedException(exception);
                    }
                }
                j = xsdAnnotation.getApplicationInformation().iterator();
                while (j.hasNext()) {
                    element = (Element)j.next();
                    if ("true".equals(this.getEcoreAttribute(element, "ignore")) || this.ignore(element)) continue;
                    String sourceURI = element.hasAttributeNS(null, "source") ? element.getAttributeNS(null, "source") : null;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    XSDResourceImpl.serialize((OutputStream)byteArrayOutputStream, element, "UTF-8");
                    try {
                        EAnnotation eAnnotation;
                        String existingApplicationInformation;
                        String applicationInformation = byteArrayOutputStream.toString("UTF8");
                        int start = applicationInformation.indexOf("?>");
                        start = applicationInformation.indexOf(">", start + 2);
                        int end = applicationInformation.lastIndexOf("</");
                        String applicationInformationBody = end == -1 ? null : applicationInformation.substring(start + 1, end);
                        String key = this.getEcoreAttribute(element, "key");
                        if (key == null) {
                            key = "appinfo";
                        }
                        String string = existingApplicationInformation = (eAnnotation = eModelElement.getEAnnotation(sourceURI)) == null ? null : (String)eAnnotation.getDetails().get(key);
                        if (existingApplicationInformation != null) {
                            if (!first && !append) continue;
                            applicationInformationBody = String.valueOf(existingApplicationInformation) + System.getProperty("line.separator") + applicationInformationBody;
                        }
                        if (eAnnotation == null) {
                            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                            eAnnotation.setSource(sourceURI);
                            eModelElement.getEAnnotations().add(eAnnotation);
                        }
                        eAnnotation.getDetails().put(key, applicationInformationBody);
                    }
                    catch (UnsupportedEncodingException exception) {
                        throw new WrappedException(exception);
                    }
                }
            }
            first = false;
        }
        first = true;
        i = elements.iterator();
        while (i.hasNext()) {
            Element element = (Element)i.next();
            if (element != null) {
                NamedNodeMap attributes = element.getAttributes();
                int j = 0;
                int length = attributes.getLength();
                while (j < length) {
                    Attr attribute = (Attr)attributes.item(j);
                    if (!this.ignore(attribute)) {
                        String sourceURI = attribute.getNamespaceURI();
                        EAnnotation eAnnotation = eModelElement.getEAnnotation(sourceURI);
                        if (eAnnotation == null) {
                            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                            eAnnotation.setSource(sourceURI);
                            eModelElement.getEAnnotations().add(eAnnotation);
                        }
                        if (first || append || eAnnotation.getDetails().get(attribute.getLocalName()) == null) {
                            eAnnotation.getDetails().put(attribute.getLocalName(), attribute.getValue());
                        }
                    }
                    ++j;
                }
            }
            first = false;
        }
    }

    protected boolean ignore(Element element) {
        return "http://www.eclipse.org/emf/2002/Ecore".equals(element.getAttributeNS(null, "source")) && "operations".equals(element.getAttributeNS("http://www.eclipse.org/emf/2002/Ecore", "key"));
    }

    protected boolean ignore(Attr attribute) {
        String namespaceURI = attribute.getNamespaceURI();
        return namespaceURI == null || "http://www.w3.org/2000/xmlns/".equals(namespaceURI) || "http://www.w3.org/2001/XMLSchema-instance".equals(namespaceURI) || "http://www.eclipse.org/emf/2002/Ecore".equals(namespaceURI);
    }

    protected void validate(XSDSchema xsdSchema) {
        Iterator i = xsdSchema.getContents().iterator();
        while (i.hasNext()) {
            Object content = i.next();
            if (!(content instanceof XSDImport)) continue;
            XSDImport xsdImport = (XSDImport)content;
            xsdImport.resolveTypeDefinition(xsdImport.getNamespace(), "");
        }
        if (this.simpleDiagnostics != null || this.diagnostics != null) {
            xsdSchema.validate();
            if (!xsdSchema.getAllDiagnostics().isEmpty()) {
                if (this.simpleDiagnostics != null) {
                    i = xsdSchema.getAllDiagnostics().iterator();
                    while (i.hasNext()) {
                        XSDDiagnostic xsdDiagnostic = (XSDDiagnostic)i.next();
                        ArrayList<String> tuple = new ArrayList<String>();
                        tuple.add(xsdDiagnostic.getSeverity().toString());
                        String localizedSeverity = XSDPlugin.INSTANCE.getString("_UI_XSDDiagnosticSeverity_" + xsdDiagnostic.getSeverity());
                        tuple.add(XSDPlugin.INSTANCE.getString("_UI_DiagnosticFileLineColumn_message", new Object[]{String.valueOf(localizedSeverity) + ": " + xsdDiagnostic.getMessage() + " ", xsdDiagnostic.getLocationURI(), new Integer(xsdDiagnostic.getLine()), new Integer(xsdDiagnostic.getColumn())}));
                        this.simpleDiagnostics.add(tuple);
                    }
                }
                if (this.diagnostics != null) {
                    this.diagnostics.addAll(xsdSchema.getAllDiagnostics());
                }
            }
        }
    }

    public static class EffectiveOccurrence {
        public int minOccurs;
        public int maxOccurs;
        public XSDParticle xsdParticle;
        public XSDModelGroup xsdModelGroup;

        public EffectiveOccurrence(int minOccurs, int maxOccurs, XSDParticle xsdParticle, XSDModelGroup xsdModelGroup) {
            this.minOccurs = minOccurs;
            this.maxOccurs = maxOccurs;
            this.xsdParticle = xsdParticle;
            this.xsdModelGroup = xsdModelGroup;
        }
    }

    public static class Comparator
    implements java.util.Comparator {
        public static Comparator INSTANCE = new Comparator();
        protected XSDPlugin.StringComparator collator = XSDPlugin.INSTANCE.getComparator();

        public boolean equals(Object that) {
            return this == that;
        }

        public int compare(Object o1, Object o2) {
            ENamedElement eNamedElement1 = (ENamedElement)o1;
            ENamedElement eNamedElement2 = (ENamedElement)o2;
            String name1 = eNamedElement1.getName();
            String name2 = eNamedElement2.getName();
            if (name1 == null && name2 == null) {
                return 0;
            }
            if (name1 == null) {
                return 1;
            }
            if (name2 == null) {
                return -1;
            }
            int result = this.collator.compare(name1, name2);
            return result;
        }
    }
}

