/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.wst.wsdl.WSDLPlugin;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.internal.impl.DefinitionImpl;
import org.eclipse.wst.wsdl.internal.util.XSDSchemaLocatorAdapterFactory;
import org.eclipse.wst.wsdl.util.WSDLConstants;
import org.eclipse.wst.wsdl.util.WSDLDiagnostic;
import org.eclipse.wst.wsdl.util.WSDLParser;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WSDLResourceImpl
extends ResourceImpl {
    private boolean useExtensionFactories = true;
    private boolean continueOnLoadError = true;
    public static final String USE_EXTENSION_FACTORIES = "USE_EXTENSION_FACTORIES";
    public static final String CONTINUE_ON_LOAD_ERROR = "CONTINUE_ON_LOAD_ERROR";
    public static final String WSDL_ENCODING = "WSDL_ENCODING";
    public static final String WSDL_PROGRESS_MONITOR = "WSDL_PROGRESS_MONITOR";
    public static final String TRACK_LOCATION = "TRACK_LOCATION";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public WSDLResourceImpl(URI uri) {
        super(uri);
    }

    protected void doSave(OutputStream os, Map options) throws IOException {
        Definition definition = this.getDefinition();
        if (definition != null) {
            Document document = definition.getDocument();
            if (document == null) {
                ((DefinitionImpl)definition).updateDocument();
                document = definition.getDocument();
            }
            if (definition.getElement() == null) {
                ((DefinitionImpl)definition).updateElement();
            }
            WSDLResourceImpl.doSerialize(os, document, options == null ? null : (String)options.get(WSDL_ENCODING));
        }
    }

    public Definition getDefinition() {
        return this.getContents().size() == 1 && this.getContents().get(0) instanceof Definition ? (Definition)this.getContents().get(0) : null;
    }

    private static void doSerialize(OutputStream outputStream, Document document, String encoding) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            if (encoding != null) {
                transformer.setOutputProperty("encoding", encoding);
            }
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        }
        catch (TransformerException exception) {
            WSDLPlugin.INSTANCE.log(exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doLoad(InputSource inputSource, Map options) throws IOException {
        Object continueOnError;
        Object bindings;
        Object monitor;
        IProgressMonitor progressMonitor = null;
        Object v0 = monitor = options == null ? null : options.get(WSDL_PROGRESS_MONITOR);
        if (monitor != null) {
            progressMonitor = monitor;
            progressMonitor.setTaskName(WSDLPlugin.INSTANCE.getString("_UI_ResourceLoad_progress"));
            progressMonitor.subTask(this.getURI().toString());
        }
        Object v1 = bindings = options == null ? null : options.get(USE_EXTENSION_FACTORIES);
        if (bindings != null && bindings instanceof Boolean) {
            this.useExtensionFactories = bindings;
        }
        Object v2 = continueOnError = options == null ? null : options.get(CONTINUE_ON_LOAD_ERROR);
        if (continueOnError != null && continueOnError instanceof Boolean) {
            this.continueOnLoadError = continueOnError;
        }
        Document doc = null;
        try {
            boolean trackLocation = options != null && Boolean.TRUE.equals(options.get(TRACK_LOCATION));
            doc = trackLocation ? this.getDocumentUsingSAX(inputSource) : WSDLResourceImpl.getDocument(inputSource, new InternalErrorHandler());
            if (doc != null && doc.getDocumentElement() != null) {
                if (!this.findDefinition(doc.getDocumentElement())) {
                    if (!this.continueOnLoadError) throw new IOException(WSDLPlugin.getPlugin().getString("_ERROR_INVALID_WSDL"));
                    this.handleDefinitionElement(doc.getDocumentElement());
                }
            } else {
                this.handleDefinitionElement(null);
            }
        }
        catch (IOException exception) {
            if (!this.continueOnLoadError) throw exception;
            WSDLPlugin.INSTANCE.log(exception);
            this.handleDefinitionElement(null);
        }
        Definition definition = null;
        Iterator i = this.getContents().iterator();
        while (i.hasNext()) {
            definition = (Definition)i.next();
            Types types = definition.getETypes();
            if (types == null) continue;
            XSDSchemaExtensibilityElement el = null;
            Iterator j = types.getEExtensibilityElements().iterator();
            while (j.hasNext()) {
                el = (XSDSchemaExtensibilityElement)j.next();
                XSDSchema schema = el.getSchema();
                if (schema == null) continue;
                schema.setSchemaLocation(this.getURI().toString());
            }
        }
        if (progressMonitor == null) return;
        progressMonitor.worked(1);
    }

    protected void doLoad(InputStream inputStream, Map options) throws IOException {
        InputSource inputSource;
        InputSource inputSource2 = inputSource = inputStream instanceof URIConverter.ReadableInputStream ? new InputSource(((URIConverter.ReadableInputStream)inputStream).asReader()) : new InputSource(inputStream);
        if (this.getURI() != null) {
            String id = this.getURI().toString();
            inputSource.setPublicId(id);
            inputSource.setSystemId(id);
        }
        this.doLoad(inputSource, options);
    }

    private Document getDocumentUsingSAX(InputSource inputSource) {
        WSDLParser wsdlParser = new WSDLParser();
        wsdlParser.parse(inputSource);
        Collection errors = wsdlParser.getDiagnostics();
        if (errors != null) {
            Iterator iterator = errors.iterator();
            while (iterator.hasNext()) {
                WSDLDiagnostic wsdlDiagnostic = (WSDLDiagnostic)iterator.next();
                switch (wsdlDiagnostic.getSeverity().getValue()) {
                    case 0: 
                    case 1: {
                        this.getErrors().add(wsdlDiagnostic);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.getWarnings().add(wsdlDiagnostic);
                    }
                }
            }
        }
        Document doc = wsdlParser.getDocument();
        return doc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Document getDocument(InputSource inputSource, ErrorHandler errorHandler) throws IOException {
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Document document;
                Thread thread = Thread.currentThread();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.wst.wsdl.internal.util.WSDLResourceFactoryImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                thread.setContextClassLoader(clazz.getClassLoader());
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setValidating(false);
                try {
                    documentBuilderFactory.setAttribute("http://apache.org/xml/features/dom/defer-node-expansion", Boolean.FALSE);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                documentBuilder.setErrorHandler(errorHandler);
                Document document2 = document = documentBuilder.parse(inputSource);
                Object var6_9 = null;
                Thread.currentThread().setContextClassLoader(previousClassLoader);
                return document2;
            }
            catch (ParserConfigurationException exception) {
                throw new Resource.IOWrappedException(exception);
            }
            catch (SAXException exception) {
                throw new Resource.IOWrappedException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            Thread.currentThread().setContextClassLoader(previousClassLoader);
            throw throwable;
        }
    }

    private boolean findDefinition(Element element) {
        if (WSDLConstants.nodeType(element) == 1) {
            this.handleDefinitionElement(element);
            return true;
        }
        boolean result = false;
        return result;
    }

    private void handleDefinitionElement(Element element) {
        Definition definition = null;
        if (element == null) {
            definition = WSDLFactory.eINSTANCE.createDefinition();
            ((DefinitionImpl)definition).setUseExtensionFactories(this.useExtensionFactories);
        } else {
            definition = DefinitionImpl.createDefinition(element, this.getURI().toString(), this.useExtensionFactories);
        }
        this.getContents().add(definition);
        ((DefinitionImpl)definition).reconcileReferences(true);
    }

    public static void serialize(OutputStream outputStream, Document document) {
        WSDLResourceImpl.serialize(outputStream, document, null);
    }

    public static void serialize(OutputStream outputStream, Document document, String encoding) {
        WSDLResourceImpl.doSerialize(outputStream, document, encoding);
    }

    public static void serialize(OutputStream outputStream, Element element) {
        WSDLResourceImpl.serialize(outputStream, element, null);
    }

    public static void serialize(OutputStream outputStream, Element element, String encoding) {
        try {
            WSDLResourceImpl.doSerialize(outputStream, element, encoding);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void doSerialize(OutputStream outputStream, Element element, String encoding) throws IOException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            if (encoding != null) {
                transformer.setOutputProperty("encoding", encoding);
            }
            transformer.transform(new DOMSource(element), new StreamResult(outputStream));
        }
        catch (TransformerException exception) {
            WSDLPlugin.INSTANCE.log(exception);
        }
    }

    public void attached(EObject eObject) {
        XSDSchemaLocator xsdSchemaLocator;
        super.attached(eObject);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.xsd.util.XSDSchemaLocator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((xsdSchemaLocator = (XSDSchemaLocator)((Object)EcoreUtil.getRegisteredAdapter(this, (Object)clazz))) == null) {
            this.getResourceSet().getAdapterFactories().add(new XSDSchemaLocatorAdapterFactory());
        }
        if (eObject instanceof DefinitionImpl) {
            DefinitionImpl definition = (DefinitionImpl)eObject;
            definition.setInlineSchemaLocations(this);
        }
    }

    private class InternalErrorHandler
    implements ErrorHandler {
        private InternalErrorHandler() {
        }

        public void error(SAXParseException e) {
            System.out.println("WSDL PARSE ERROR: " + e);
        }

        public void fatalError(SAXParseException e) {
            System.out.println("WSDL PARSE FATAL ERROR: " + e);
        }

        public void warning(SAXParseException e) {
            System.out.println("WSDL PARSE WARNING: " + e);
        }
    }
}

