/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENamedElementImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class EClassifierImpl
extends ENamedElementImpl
implements EClassifier,
BasicExtendedMetaData.EClassifierExtendedMetaData.Holder {
    protected int metaObjectID = -1;
    protected static final String INSTANCE_CLASS_NAME_EDEFAULT = null;
    protected String instanceClassName = INSTANCE_CLASS_NAME_EDEFAULT;
    protected String generatedInstanceClassName;
    protected static final Class INSTANCE_CLASS_EDEFAULT = null;
    protected static final Object DEFAULT_VALUE_EDEFAULT = null;
    protected Class instanceClass = INSTANCE_CLASS_EDEFAULT;
    EPackage ePackage;
    protected BasicExtendedMetaData.EClassifierExtendedMetaData eClassifierExtendedMetaData;
    static /* synthetic */ Class class$0;

    protected EClassifierImpl() {
    }

    protected EClass eStaticClass() {
        return EcorePackage.Literals.ECLASSIFIER;
    }

    public int getClassifierID() {
        return this.metaObjectID;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getEAnnotations()).basicAdd(otherEnd, msgs);
            }
            case 5: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.eBasicSetContainer(otherEnd, 5, msgs);
            }
        }
        return this.eDynamicInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getEAnnotations()).basicRemove(otherEnd, msgs);
            }
            case 5: {
                return this.eBasicSetContainer(null, 5, msgs);
            }
        }
        return this.eDynamicInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID) {
            case 5: {
                InternalEObject internalEObject = this.eInternalContainer();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.emf.ecore.EPackage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return internalEObject.eInverseRemove(this, 5, clazz, msgs);
            }
        }
        return this.eDynamicBasicRemoveFromContainer(msgs);
    }

    public void setClassifierID(int id) {
        this.metaObjectID = id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInstance(Object object) {
        if (object == null) return false;
        Class instanceClass = this.getInstanceClass();
        if (instanceClass != null) {
            if (!instanceClass.isPrimitive()) return instanceClass.isInstance(object);
            if (instanceClass == Boolean.TYPE) {
                return object instanceof Boolean;
            }
            if (instanceClass == Integer.TYPE) {
                return object instanceof Integer;
            }
            if (instanceClass == Float.TYPE) {
                return object instanceof Float;
            }
            if (instanceClass == Byte.TYPE) {
                return object instanceof Byte;
            }
            if (instanceClass == Character.TYPE) {
                return object instanceof Character;
            }
            if (instanceClass == Double.TYPE) {
                return object instanceof Double;
            }
            if (instanceClass == Short.TYPE) {
                return object instanceof Short;
            }
            if (instanceClass != Long.TYPE) return false;
            return object instanceof Long;
        }
        if (!(object instanceof EObject)) return false;
        return this.dynamicIsInstance((EObject)object);
    }

    protected boolean dynamicIsInstance(EObject eObject) {
        return eObject.eClass() == this;
    }

    public String getInstanceClassNameGen() {
        return this.instanceClassName;
    }

    public String getInstanceClassName() {
        return this.getInstanceClassNameGen() != null ? this.getInstanceClassNameGen() : this.generatedInstanceClassName;
    }

    public void setGeneratedInstanceClass(boolean isGenerated) {
        if (isGenerated) {
            if (this.generatedInstanceClassName == null) {
                this.generatedInstanceClassName = this.instanceClassName;
                this.instanceClassName = null;
            }
        } else if (this.generatedInstanceClassName != null) {
            this.instanceClassName = this.generatedInstanceClassName;
            this.generatedInstanceClassName = null;
        }
    }

    public void setInstanceClassName(String value) {
        if (this.instanceClassName == null && this.generatedInstanceClassName != null) {
            this.instanceClassName = this.generatedInstanceClassName;
            this.generatedInstanceClassName = null;
        }
        this.setInstanceClassNameGen(value == null ? null : value.intern());
        if (this.instanceClass != null) {
            this.setInstanceClassGen(null);
        }
    }

    public void setInstanceClassNameGen(String newInstanceClassName) {
        String oldInstanceClassName = this.instanceClassName;
        this.instanceClassName = newInstanceClassName;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldInstanceClassName, (Object)this.instanceClassName));
        }
    }

    public Class getInstanceClass() {
        if (this.instanceClass == null && (this.instanceClassName != null || this.generatedInstanceClassName != null)) {
            try {
                this.setInstanceClassGen(this.getClassForName(this.getInstanceClassName()));
            }
            catch (ClassNotFoundException e) {
                Class primitiveClass = this.getPrimitiveOrArrayClass();
                if (primitiveClass != null) {
                    this.setInstanceClassGen(primitiveClass);
                }
                throw new WrappedException(e);
            }
        }
        return this.getInstanceClassGen();
    }

    protected Class getClassForName(String name) throws ClassNotFoundException {
        EPackage p = this.getEPackage();
        return p != null ? Class.forName(name, true, p.getClass().getClassLoader()) : Class.forName(name);
    }

    protected Class getPrimitiveOrArrayClass() {
        String className = this.getInstanceClassName();
        int arrayIndex = className.indexOf(91);
        if (arrayIndex != -1) {
            String componentClassName = className.substring(0, arrayIndex);
            StringBuffer result = new StringBuffer();
            do {
                result.append('[');
                ++arrayIndex;
            } while ((arrayIndex = className.indexOf(91, arrayIndex)) != -1);
            if (componentClassName.equals("boolean")) {
                result.append('Z');
            } else if (componentClassName.equals("byte")) {
                result.append('B');
            } else if (componentClassName.equals("char")) {
                result.append('C');
            } else if (componentClassName.equals("double")) {
                result.append('D');
            } else if (componentClassName.equals("float")) {
                result.append('F');
            } else if (componentClassName.equals("int")) {
                result.append('I');
            } else if (componentClassName.equals("long")) {
                result.append('J');
            } else if (componentClassName.equals("short")) {
                result.append('S');
            } else {
                result.append('L');
                result.append(componentClassName);
                result.append(';');
            }
            try {
                return this.getClassForName(result.toString());
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        } else {
            if (className.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (className.equals("byte")) {
                return Byte.TYPE;
            }
            if (className.equals("char")) {
                return Character.TYPE;
            }
            if (className.equals("double")) {
                return Double.TYPE;
            }
            if (className.equals("float")) {
                return Float.TYPE;
            }
            if (className.equals("int")) {
                return Integer.TYPE;
            }
            if (className.equals("long")) {
                return Long.TYPE;
            }
            if (className.equals("short")) {
                return Short.TYPE;
            }
        }
        return null;
    }

    public Class getInstanceClassGen() {
        return this.instanceClass;
    }

    public void setInstanceClass(Class value) {
        block5: {
            if (value == null) {
                this.setInstanceClassNameGen(null);
            } else {
                if (value.isArray()) {
                    String indices = "[]";
                    Class<?> component = value.getComponentType();
                    while (true) {
                        if (!component.isArray()) {
                            this.setInstanceClassNameGen((String.valueOf(component.getName()) + indices).intern());
                            break block5;
                        }
                        indices = String.valueOf(indices) + "[]";
                        component = component.getComponentType();
                    }
                }
                this.setInstanceClassNameGen(value.getName().intern());
            }
        }
        this.setInstanceClassGen(value);
    }

    public void setInstanceClassGen(Class newInstanceClass) {
        this.instanceClass = newInstanceClass;
    }

    public Object getDefaultValue() {
        return null;
    }

    public EPackage getEPackageGen() {
        if (this.eContainerFeatureID != 5) {
            return null;
        }
        return (EPackage)this.eContainer();
    }

    public EPackage getEPackage() {
        if (this.ePackage != null) {
            return this.ePackage;
        }
        EPackage result = this.getEPackageGen();
        if (result != null && !result.eIsProxy()) {
            this.ePackage = result;
        }
        return result;
    }

    protected void eBasicSetContainer(InternalEObject newContainer, int newContainerFeatureID) {
        this.ePackage = null;
        super.eBasicSetContainer(newContainer, newContainerFeatureID);
    }

    public EPackage basicGetEPackage() {
        if (this.eContainerFeatureID != 5) {
            return null;
        }
        return (EPackage)((Object)this.eInternalContainer());
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (instanceClassName: ");
        result.append(this.instanceClassName);
        result.append(')');
        return result.toString();
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getEAnnotations();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getInstanceClassName();
            }
            case 3: {
                return this.getInstanceClass();
            }
            case 4: {
                return this.getDefaultValue();
            }
            case 5: {
                if (resolve) {
                    return this.getEPackage();
                }
                return this.basicGetEPackage();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getEAnnotations().clear();
                this.getEAnnotations().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setInstanceClassName((String)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getEAnnotations().clear();
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setInstanceClassName(INSTANCE_CLASS_NAME_EDEFAULT);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.eAnnotations != null && !this.eAnnotations.isEmpty();
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return INSTANCE_CLASS_NAME_EDEFAULT == null ? this.instanceClassName != null : !INSTANCE_CLASS_NAME_EDEFAULT.equals(this.instanceClassName);
            }
            case 3: {
                return INSTANCE_CLASS_EDEFAULT == null ? this.getInstanceClass() != null : !INSTANCE_CLASS_EDEFAULT.equals(this.getInstanceClass());
            }
            case 4: {
                return DEFAULT_VALUE_EDEFAULT == null ? this.getDefaultValue() != null : !DEFAULT_VALUE_EDEFAULT.equals(this.getDefaultValue());
            }
            case 5: {
                return this.basicGetEPackage() != null;
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    public BasicExtendedMetaData.EClassifierExtendedMetaData getExtendedMetaData() {
        return this.eClassifierExtendedMetaData;
    }

    public void setExtendedMetaData(BasicExtendedMetaData.EClassifierExtendedMetaData eClassifierExtendedMetaData) {
        this.eClassifierExtendedMetaData = eClassifierExtendedMetaData;
    }
}

