/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.Transition;
import org.antlr.misc.IntSet;
import org.antlr.tool.Grammar;

public class RandomPhrase {
    protected static Random random;

    protected static void randomPhrase(Grammar grammar, List list, String string) {
        NFAState nFAState = grammar.getRuleStartState(string);
        NFAState nFAState2 = grammar.getRuleStopState(string);
        Stack<NFAState> stack = new Stack<NFAState>();
        while (nFAState != nFAState2 || stack.size() != 0) {
            if (nFAState.getNumberOfTransitions() == 0) {
                return;
            }
            if (nFAState.isAcceptState()) {
                NFAState nFAState3 = (NFAState)stack.pop();
                RuleClosureTransition ruleClosureTransition = (RuleClosureTransition)nFAState3.transition(0);
                nFAState = ruleClosureTransition.getFollowState();
                continue;
            }
            if (nFAState.getNumberOfTransitions() == 1) {
                Transition transition = nFAState.transition(0);
                if (transition instanceof RuleClosureTransition) {
                    stack.push(nFAState);
                    int n = ((RuleClosureTransition)transition).getRuleIndex();
                } else if (!transition.label.isEpsilon()) {
                    list.add(RandomPhrase.getTokenType(transition.label));
                }
                nFAState = (NFAState)transition.target;
                continue;
            }
            int n = nFAState.getDecisionNumber();
            if (n == 0) {
                System.out.println("weird: no decision number but a choice node");
                continue;
            }
            int n2 = grammar.getNumberOfAltsForDecisionNFA(nFAState);
            int n3 = random.nextInt(n2) + 1;
            NFAState nFAState4 = grammar.getNFAStateForAltOfDecision(nFAState, n3);
            Transition transition = nFAState4.transition(0);
            nFAState = (NFAState)transition.target;
        }
    }

    protected static Integer getTokenType(Label label) {
        if (label.isSet()) {
            IntSet intSet = label.getSet();
            List list = intSet.toList();
            int n = random.nextInt(list.size());
            return (Integer)list.get(n);
        }
        return new Integer(label.getAtom());
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        String string = stringArray[0];
        String string2 = stringArray[1];
        long l = System.currentTimeMillis();
        if (stringArray.length == 3) {
            object = stringArray[2];
            l = Integer.parseInt((String)object);
        }
        random = new Random(l);
        object = new Grammar(null, string, new BufferedReader(new FileReader(string)));
        ((Grammar)object).createNFAs();
        List list = ((Grammar)object).checkAllRulesForLeftRecursion();
        if (list.size() > 0) {
            return;
        }
        if (((Grammar)object).getRule(string2) == null) {
            System.out.println("undefined start rule " + string2);
            return;
        }
        String string3 = ((Grammar)object).getLexerGrammar();
        Grammar grammar = new Grammar();
        grammar.importTokenVocabulary((Grammar)object);
        if (string3 != null) {
            grammar.setGrammarContent(string3);
        } else {
            System.err.println("no lexer grammar found in " + string);
        }
        grammar.createNFAs();
        list = grammar.checkAllRulesForLeftRecursion();
        if (list.size() > 0) {
            return;
        }
        ArrayList arrayList = new ArrayList(100);
        RandomPhrase.randomPhrase((Grammar)object, arrayList, string2);
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object2;
            Integer n = (Integer)arrayList.get(i);
            int n2 = n;
            String string4 = ((Grammar)object).getTokenDisplayName(n2);
            if (Character.isUpperCase(string4.charAt(0))) {
                object2 = new ArrayList(10);
                RandomPhrase.randomPhrase(grammar, object2, string4);
                System.out.print(" ");
                for (int j = 0; j < object2.size(); ++j) {
                    Integer n3 = (Integer)object2.get(j);
                    System.out.print((char)n3.intValue());
                }
                continue;
            }
            object2 = string4.substring(1, string4.length() - 1);
            System.out.print(" " + (String)object2);
        }
        System.out.println();
    }
}

