/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test.unit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.antlr.test.unit.FailedAssertionException;

public abstract class TestSuite {
    public String testName = null;
    int failures = 0;
    int successes = 0;

    public void assertTrue(boolean bl) throws FailedAssertionException {
        this.assertTrue(bl, null);
    }

    public void assertEqual(Object object, Object object2) throws FailedAssertionException {
        if (object == null && object2 != null) {
            throw new FailedAssertionException("expecting \"" + object2 + "\"; found null");
        }
        if (object != null && object2 == null) {
            throw new FailedAssertionException("expecting null; found \"" + object);
        }
        if (object == null && object2 == null) {
            return;
        }
        this.assertTrue(object.equals(object2), "expecting \"" + object2 + "\"; found \"" + object + "\"");
    }

    public void assertEqual(int n, int n2) throws FailedAssertionException {
        this.assertTrue(n == n2, "expecting \"" + n2 + "\"; found \"" + n + "\"");
    }

    public void assertTrue(boolean bl, String string) throws FailedAssertionException {
        if (!bl) {
            if (string != null) {
                throw new FailedAssertionException(string);
            }
            throw new FailedAssertionException("assertTrue failed");
        }
    }

    public void time(String string, int n) throws Exception {
        System.gc();
        long l = System.currentTimeMillis();
        System.out.print("TIME: " + string);
        for (int i = 1; i <= n; ++i) {
            this.invokeTest(string);
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        System.out.println("; n=" + n + " " + l3 + "ms (" + (double)l3 / (double)n * 1000.0 + " microsec/eval)");
    }

    public void runTest(String string) {
        try {
            System.out.println("TEST: " + string);
            this.invokeTest(string);
            ++this.successes;
        }
        catch (InvocationTargetException invocationTargetException) {
            ++this.failures;
            try {
                throw invocationTargetException.getCause();
            }
            catch (FailedAssertionException failedAssertionException) {
                System.err.println(string + " failed: " + failedAssertionException.getMessage());
            }
            catch (Throwable throwable) {
                System.err.print("exception during test " + string + ":");
                throwable.printStackTrace();
            }
        }
    }

    public void invokeTest(String string) throws InvocationTargetException {
        this.testName = string;
        try {
            Class<?> clazz = this.getClass();
            Method method = clazz.getMethod(string, null);
            method.invoke((Object)this, (Object[])null);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("no permission to exec test " + string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("no such test " + string);
        }
    }

    public int getFailures() {
        return this.failures;
    }

    public int getSuccesses() {
        return this.successes;
    }
}

