/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.test.unit.TestSuite;

public class TestTreeNodeStream
extends TestSuite {
    public void testSingleNode() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        String string = " 101";
        String string2 = commonTreeNodeStream.toNodesOnlyString();
        this.assertEqual(string2, string);
        string = " 101";
        string2 = commonTreeNodeStream.toString();
        this.assertEqual(string2, string);
    }

    public void test4Nodes() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        commonTree.addChild(new CommonTree(new CommonToken(102)));
        commonTree.getChild(0).addChild(new CommonTree(new CommonToken(103)));
        commonTree.addChild(new CommonTree(new CommonToken(104)));
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        String string = " 101 102 103 104";
        String string2 = commonTreeNodeStream.toNodesOnlyString();
        this.assertEqual(string2, string);
        string = " 101 2 102 2 103 3 104 3";
        string2 = commonTreeNodeStream.toString();
        this.assertEqual(string2, string);
    }

    public void testList() throws Exception {
        CommonTree commonTree = new CommonTree((Token)null);
        CommonTree commonTree2 = new CommonTree(new CommonToken(101));
        commonTree2.addChild(new CommonTree(new CommonToken(102)));
        commonTree2.getChild(0).addChild(new CommonTree(new CommonToken(103)));
        commonTree2.addChild(new CommonTree(new CommonToken(104)));
        CommonTree commonTree3 = new CommonTree(new CommonToken(105));
        commonTree.addChild(commonTree2);
        commonTree.addChild(commonTree3);
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        String string = " 101 102 103 104 105";
        String string2 = commonTreeNodeStream.toNodesOnlyString();
        this.assertEqual(string2, string);
        string = " 101 2 102 2 103 3 104 3 105";
        string2 = commonTreeNodeStream.toString();
        this.assertEqual(string2, string);
    }

    public void testFlatList() throws Exception {
        CommonTree commonTree = new CommonTree((Token)null);
        commonTree.addChild(new CommonTree(new CommonToken(101)));
        commonTree.addChild(new CommonTree(new CommonToken(102)));
        commonTree.addChild(new CommonTree(new CommonToken(103)));
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        String string = " 101 102 103";
        String string2 = commonTreeNodeStream.toNodesOnlyString();
        this.assertEqual(string2, string);
        string = " 101 102 103";
        string2 = commonTreeNodeStream.toString();
        this.assertEqual(string2, string);
    }

    public void testListWithOneNode() throws Exception {
        CommonTree commonTree = new CommonTree((Token)null);
        commonTree.addChild(new CommonTree(new CommonToken(101)));
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        String string = " 101";
        String string2 = commonTreeNodeStream.toNodesOnlyString();
        this.assertEqual(string2, string);
        string = " 101";
        string2 = commonTreeNodeStream.toString();
        this.assertEqual(string2, string);
    }

    public void testAoverB() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        commonTree.addChild(new CommonTree(new CommonToken(102)));
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        String string = " 101 102";
        String string2 = commonTreeNodeStream.toNodesOnlyString();
        this.assertEqual(string2, string);
        string = " 101 2 102 3";
        string2 = commonTreeNodeStream.toString();
        this.assertEqual(string2, string);
    }

    public void testLT() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        commonTree.addChild(new CommonTree(new CommonToken(102)));
        commonTree.getChild(0).addChild(new CommonTree(new CommonToken(103)));
        commonTree.addChild(new CommonTree(new CommonToken(104)));
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        this.assertEqual(((Tree)commonTreeNodeStream.LT(1)).getType(), 101);
        this.assertEqual(((Tree)commonTreeNodeStream.LT(2)).getType(), 2);
        this.assertEqual(((Tree)commonTreeNodeStream.LT(3)).getType(), 102);
        this.assertEqual(((Tree)commonTreeNodeStream.LT(4)).getType(), 2);
        this.assertEqual(((Tree)commonTreeNodeStream.LT(5)).getType(), 103);
        this.assertEqual(((Tree)commonTreeNodeStream.LT(6)).getType(), 3);
        this.assertEqual(((Tree)commonTreeNodeStream.LT(7)).getType(), 104);
        this.assertEqual(((Tree)commonTreeNodeStream.LT(8)).getType(), 3);
        this.assertEqual(((Tree)commonTreeNodeStream.LT(9)).getType(), -1);
        this.assertEqual(((Tree)commonTreeNodeStream.LT(100)).getType(), -1);
    }

    public void testMarkRewindEntire() throws Exception {
        int n;
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        CommonTree commonTree2 = new CommonTree(new CommonToken(102));
        commonTree.addChild(commonTree2);
        commonTree2.addChild(new CommonTree(new CommonToken(103)));
        CommonTree commonTree3 = new CommonTree(new CommonToken(106));
        commonTree3.addChild(new CommonTree(new CommonToken(107)));
        commonTree2.addChild(commonTree3);
        commonTree.addChild(new CommonTree(new CommonToken(104)));
        commonTree.addChild(new CommonTree(new CommonToken(105)));
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        int n2 = commonTreeNodeStream.mark();
        for (n = 1; n <= 13; ++n) {
            commonTreeNodeStream.LT(1);
            commonTreeNodeStream.consume();
        }
        this.assertEqual(((Tree)commonTreeNodeStream.LT(1)).getType(), -1);
        this.assertEqual(((Tree)commonTreeNodeStream.LT(-1)).getType(), 3);
        commonTreeNodeStream.rewind(n2);
        for (n = 1; n <= 13; ++n) {
            commonTreeNodeStream.LT(1);
            commonTreeNodeStream.consume();
        }
        this.assertEqual(((Tree)commonTreeNodeStream.LT(1)).getType(), -1);
        this.assertEqual(((Tree)commonTreeNodeStream.LT(-1)).getType(), 3);
    }

    public void testMarkRewindInMiddle() throws Exception {
        int n;
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        CommonTree commonTree2 = new CommonTree(new CommonToken(102));
        commonTree.addChild(commonTree2);
        commonTree2.addChild(new CommonTree(new CommonToken(103)));
        CommonTree commonTree3 = new CommonTree(new CommonToken(106));
        commonTree3.addChild(new CommonTree(new CommonToken(107)));
        commonTree2.addChild(commonTree3);
        commonTree.addChild(new CommonTree(new CommonToken(104)));
        commonTree.addChild(new CommonTree(new CommonToken(105)));
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        for (n = 1; n <= 7; ++n) {
            commonTreeNodeStream.consume();
        }
        this.assertEqual(((Tree)commonTreeNodeStream.LT(1)).getType(), 107);
        n = commonTreeNodeStream.mark();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.rewind(n);
        this.assertEqual(((Tree)commonTreeNodeStream.LT(1)).getType(), 107);
        commonTreeNodeStream.consume();
        this.assertEqual(((Tree)commonTreeNodeStream.LT(1)).getType(), 3);
        commonTreeNodeStream.consume();
        this.assertEqual(((Tree)commonTreeNodeStream.LT(1)).getType(), 3);
        commonTreeNodeStream.consume();
        this.assertEqual(((Tree)commonTreeNodeStream.LT(1)).getType(), 104);
        commonTreeNodeStream.consume();
        this.assertEqual(((Tree)commonTreeNodeStream.LT(1)).getType(), 105);
        commonTreeNodeStream.consume();
        this.assertEqual(((Tree)commonTreeNodeStream.LT(1)).getType(), 3);
        commonTreeNodeStream.consume();
        this.assertEqual(((Tree)commonTreeNodeStream.LT(1)).getType(), -1);
        this.assertEqual(((Tree)commonTreeNodeStream.LT(-1)).getType(), 3);
    }

    public void testMarkRewindNested() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        CommonTree commonTree2 = new CommonTree(new CommonToken(102));
        commonTree.addChild(commonTree2);
        commonTree2.addChild(new CommonTree(new CommonToken(103)));
        CommonTree commonTree3 = new CommonTree(new CommonToken(106));
        commonTree3.addChild(new CommonTree(new CommonToken(107)));
        commonTree2.addChild(commonTree3);
        commonTree.addChild(new CommonTree(new CommonToken(104)));
        commonTree.addChild(new CommonTree(new CommonToken(105)));
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        int n = commonTreeNodeStream.mark();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        int n2 = commonTreeNodeStream.mark();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.rewind(n2);
        this.assertEqual(((Tree)commonTreeNodeStream.LT(1)).getType(), 102);
        commonTreeNodeStream.consume();
        this.assertEqual(((Tree)commonTreeNodeStream.LT(1)).getType(), 2);
        commonTreeNodeStream.consume();
        commonTreeNodeStream.rewind(n);
        this.assertEqual(((Tree)commonTreeNodeStream.LT(1)).getType(), 101);
        commonTreeNodeStream.consume();
        this.assertEqual(((Tree)commonTreeNodeStream.LT(1)).getType(), 2);
        commonTreeNodeStream.consume();
        this.assertEqual(((Tree)commonTreeNodeStream.LT(1)).getType(), 102);
        commonTreeNodeStream.consume();
        this.assertEqual(((Tree)commonTreeNodeStream.LT(1)).getType(), 2);
    }

    public void testSeek() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        CommonTree commonTree2 = new CommonTree(new CommonToken(102));
        commonTree.addChild(commonTree2);
        commonTree2.addChild(new CommonTree(new CommonToken(103)));
        CommonTree commonTree3 = new CommonTree(new CommonToken(106));
        commonTree3.addChild(new CommonTree(new CommonToken(107)));
        commonTree2.addChild(commonTree3);
        commonTree.addChild(new CommonTree(new CommonToken(104)));
        commonTree.addChild(new CommonTree(new CommonToken(105)));
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.seek(7);
        this.assertEqual(((Tree)commonTreeNodeStream.LT(1)).getType(), 107);
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        this.assertEqual(((Tree)commonTreeNodeStream.LT(1)).getType(), 104);
    }

    public void testSeekFromStart() throws Exception {
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        CommonTree commonTree2 = new CommonTree(new CommonToken(102));
        commonTree.addChild(commonTree2);
        commonTree2.addChild(new CommonTree(new CommonToken(103)));
        CommonTree commonTree3 = new CommonTree(new CommonToken(106));
        commonTree3.addChild(new CommonTree(new CommonToken(107)));
        commonTree2.addChild(commonTree3);
        commonTree.addChild(new CommonTree(new CommonToken(104)));
        commonTree.addChild(new CommonTree(new CommonToken(105)));
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        commonTreeNodeStream.seek(7);
        this.assertEqual(((Tree)commonTreeNodeStream.LT(1)).getType(), 107);
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        commonTreeNodeStream.consume();
        this.assertEqual(((Tree)commonTreeNodeStream.LT(1)).getType(), 104);
    }

    public void testBufferOverflow() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        CommonTree commonTree = new CommonTree(new CommonToken(101));
        stringBuffer.append(" 101");
        stringBuffer2.append(" 101");
        stringBuffer2.append(" ");
        stringBuffer2.append(2);
        for (int i = 0; i <= 15; ++i) {
            commonTree.addChild(new CommonTree(new CommonToken(102 + i)));
            stringBuffer.append(" ");
            stringBuffer.append(102 + i);
            stringBuffer2.append(" ");
            stringBuffer2.append(102 + i);
        }
        stringBuffer2.append(" ");
        stringBuffer2.append(3);
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        String string = stringBuffer.toString();
        String string2 = commonTreeNodeStream.toNodesOnlyString();
        this.assertEqual(string2, string);
        string = stringBuffer2.toString();
        string2 = commonTreeNodeStream.toString();
        this.assertEqual(string2, string);
    }

    public void testBufferWrap() throws Exception {
        int n;
        int n2 = 10;
        CommonTree commonTree = new CommonTree((Token)null);
        for (int i = 0; i < 5 + n2; ++i) {
            commonTree.addChild(new CommonTree(new CommonToken(i + 1)));
        }
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        for (n = 1; n <= n2; ++n) {
            Tree tree = (Tree)commonTreeNodeStream.LT(1);
            this.assertEqual(tree.getType(), n);
            commonTreeNodeStream.consume();
        }
        n = 5 - n2;
        int n3 = 4;
        this.assertTrue(n3 < n2, "bad test code; wrapBy must be less than N");
        for (int i = 1; i <= n + n3; ++i) {
            Tree tree = (Tree)commonTreeNodeStream.LT(i);
            this.assertEqual(tree.getType(), n2 + i);
        }
    }
}

