/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.test.unit.TestSuite;
import org.antlr.tool.Grammar;
import org.antlr.tool.Interpreter;

public class TestTokenRewriteStream
extends TestSuite {
    public void testInsertBeforeIndex0() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(0, "0");
        String string = tokenRewriteStream.toString();
        String string2 = "0abc";
        this.assertEqual(string, string2);
    }

    public void testInsertAfterLastIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertAfter(2, "x");
        String string = tokenRewriteStream.toString();
        String string2 = "abcx";
        this.assertEqual(string, string2);
    }

    public void test2InsertBeforeAfterMiddleIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(1, "x");
        tokenRewriteStream.insertAfter(1, "x");
        String string = tokenRewriteStream.toString();
        String string2 = "axbxc";
        this.assertEqual(string, string2);
    }

    public void testReplaceIndex0() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(0, "x");
        String string = tokenRewriteStream.toString();
        String string2 = "xbc";
        this.assertEqual(string, string2);
    }

    public void testReplaceLastIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, "x");
        String string = tokenRewriteStream.toString();
        String string2 = "abx";
        this.assertEqual(string, string2);
    }

    public void testReplaceMiddleIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(1, "x");
        String string = tokenRewriteStream.toString();
        String string2 = "axc";
        this.assertEqual(string, string2);
    }

    public void test2ReplaceMiddleIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(1, "x");
        tokenRewriteStream.replace(1, "y");
        String string = tokenRewriteStream.toString();
        String string2 = "ayc";
        this.assertEqual(string, string2);
    }

    public void testReplaceThenDeleteMiddleIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(1, "x");
        tokenRewriteStream.delete(1);
        String string = tokenRewriteStream.toString();
        String string2 = "ac";
        this.assertEqual(string, string2);
    }

    public void testReplaceThenInsertSameIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(0, "x");
        tokenRewriteStream.insertBefore(0, "0");
        String string = tokenRewriteStream.toString();
        String string2 = "0xbc";
        this.assertEqual(string, string2);
    }

    public void testReplaceThen2InsertSameIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(0, "x");
        tokenRewriteStream.insertBefore(0, "y");
        tokenRewriteStream.insertBefore(0, "z");
        String string = tokenRewriteStream.toString();
        String string2 = "zyxbc";
        this.assertEqual(string, string2);
    }

    public void testInsertThenReplaceSameIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(0, "0");
        tokenRewriteStream.replace(0, "x");
        String string = tokenRewriteStream.toString();
        String string2 = "0xbc";
        this.assertEqual(string, string2);
    }

    public void test2InsertMiddleIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(1, "x");
        tokenRewriteStream.insertBefore(1, "y");
        String string = tokenRewriteStream.toString();
        String string2 = "ayxbc";
        this.assertEqual(string, string2);
    }

    public void test2InsertThenReplaceIndex0() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(0, "x");
        tokenRewriteStream.insertBefore(0, "y");
        tokenRewriteStream.replace(0, "z");
        String string = tokenRewriteStream.toString();
        String string2 = "yxzbc";
        this.assertEqual(string, string2);
    }

    public void testReplaceThenInsertBeforeLastIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, "x");
        tokenRewriteStream.insertBefore(2, "y");
        String string = tokenRewriteStream.toString();
        String string2 = "abyx";
        this.assertEqual(string, string2);
    }

    public void testInsertThenReplaceLastIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(2, "y");
        tokenRewriteStream.replace(2, "x");
        String string = tokenRewriteStream.toString();
        String string2 = "abyx";
        this.assertEqual(string, string2);
    }

    public void testReplaceThenInsertAfterLastIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, "x");
        tokenRewriteStream.insertAfter(2, "y");
        String string = tokenRewriteStream.toString();
        String string2 = "abxy";
        this.assertEqual(string, string2);
    }

    public void testReplaceRangeThenInsertInMiddle() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 4, "x");
        tokenRewriteStream.insertBefore(3, "y");
        String string = tokenRewriteStream.toString();
        String string2 = "abxba";
        this.assertEqual(string, string2);
    }

    public void testReplaceRangeThenInsertAtLeftEdge() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 4, "x");
        tokenRewriteStream.insertBefore(2, "y");
        String string = tokenRewriteStream.toString();
        String string2 = "abyxba";
        this.assertEqual(string, string2);
    }

    public void testReplaceRangeThenInsertAtRightEdge() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 4, "x");
        tokenRewriteStream.insertBefore(4, "y");
        String string = tokenRewriteStream.toString();
        String string2 = "abxba";
        this.assertEqual(string, string2);
    }

    public void testReplaceRangeThenInsertAfterRightEdge() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 4, "x");
        tokenRewriteStream.insertAfter(4, "y");
        String string = tokenRewriteStream.toString();
        String string2 = "abxyba";
        this.assertEqual(string, string2);
    }

    public void testReplaceAll() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(0, 6, "x");
        String string = tokenRewriteStream.toString();
        String string2 = "x";
        this.assertEqual(string, string2);
    }

    public void testReplaceSubsetThenFetch() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 4, "xyz");
        String string = tokenRewriteStream.toString(0, 6);
        String string2 = "abxyzba";
        this.assertEqual(string, string2);
    }

    public void testReplaceThenReplaceSuperset() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 4, "xyz");
        tokenRewriteStream.replace(2, 5, "foo");
        String string = tokenRewriteStream.toString();
        String string2 = "abfooa";
        this.assertEqual(string, string2);
    }

    public void testReplaceThenReplaceLowerIndexedSuperset() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 4, "xyz");
        tokenRewriteStream.replace(1, 3, "foo");
        String string = tokenRewriteStream.toString();
        String string2 = "afoocba";
        this.assertEqual(string, string2);
    }

    public void testReplaceSingleMiddleThenOverlappingSuperset() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 2, "xyz");
        tokenRewriteStream.replace(0, 3, "foo");
        String string = tokenRewriteStream.toString();
        String string2 = "fooa";
        this.assertEqual(string, string2);
    }
}

