/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.test.TestCompileAndExecSupport;
import org.antlr.test.unit.TestSuite;

public class TestSemanticPredicateEvaluation
extends TestSuite {
    public void testSimpleCyclicDFAWithPredicate() throws Exception {
        String string = "grammar foo;\na : {false}? 'x'* 'y' {System.out.println(\"alt1\");}\n  | {true}?  'x'* 'y' {System.out.println(\"alt2\");}\n  ;\n";
        String string2 = TestCompileAndExecSupport.execParser("foo.g", string, "foo", "fooLexer", "a", "xxxy", false);
        String string3 = "alt2\n";
        this.assertEqual(string2, string3);
    }

    public void testSimpleCyclicDFAWithInstanceVarPredicate() throws Exception {
        String string = "grammar foo;\n@members {boolean v=true;}\na : {false}? 'x'* 'y' {System.out.println(\"alt1\");}\n  | {v}?     'x'* 'y' {System.out.println(\"alt2\");}\n  ;\n";
        String string2 = TestCompileAndExecSupport.execParser("foo.g", string, "foo", "fooLexer", "a", "xxxy", false);
        String string3 = "alt2\n";
        this.assertEqual(string2, string3);
    }

    public void testPredicateValidation() throws Exception {
        String string = "grammar foo;\n@members {\npublic void reportError(RecognitionException e) {\n    System.out.println(\"error: \"+e.toString());\n}\n}\n\na : {false}? 'x'\n  ;\n";
        String string2 = TestCompileAndExecSupport.execParser("foo.g", string, "foo", "fooLexer", "a", "x", false);
        String string3 = "error: FailedPredicateException(a,{false}?)\n";
        this.assertEqual(string2, string3);
    }

    public void testLexerPreds() throws Exception {
        String string = "grammar foo;@lexer::members {boolean p=false;}\na : (A|B)+ ;\nA : {p}? 'a'  {System.out.println(\"token 1\");} ;\nB : {!p}? 'a' {System.out.println(\"token 2\");} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("foo.g", string, "foo", "fooLexer", "a", "a", false);
        String string3 = "token 2\n";
        this.assertEqual(string2, string3);
    }

    public void testLexerPreds2() throws Exception {
        String string = "grammar foo;@lexer::members {boolean p=true;}\na : (A|B)+ ;\nA : {p}? 'a' {System.out.println(\"token 1\");} ;\nB : ('a'|'b')+ {System.out.println(\"token 2\");} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("foo.g", string, "foo", "fooLexer", "a", "a", false);
        String string3 = "token 1\n";
        this.assertEqual(string2, string3);
    }

    public void testLexerPredInExitBranch() throws Exception {
        String string = "grammar foo;@lexer::members {boolean p=true;}\na : (A|B)+ ;\nA : ('a' {System.out.print(\"1\");})*\n    {p}?\n    ('a' {System.out.print(\"2\");})* ;\n";
        String string2 = TestCompileAndExecSupport.execParser("foo.g", string, "foo", "fooLexer", "a", "aaa", false);
        String string3 = "222\n";
        this.assertEqual(string2, string3);
    }

    public void testLexerPredInExitBranch2() throws Exception {
        String string = "grammar foo;@lexer::members {boolean p=true;}\na : (A|B)+ ;\nA : ({p}? 'a' {System.out.print(\"1\");})*\n    ('a' {System.out.print(\"2\");})* ;\n";
        String string2 = TestCompileAndExecSupport.execParser("foo.g", string, "foo", "fooLexer", "a", "aaa", false);
        String string3 = "111\n";
        this.assertEqual(string2, string3);
    }

    public void testLexerPredInExitBranch3() throws Exception {
        String string = "grammar foo;@lexer::members {boolean p=true;}\na : (A|B)+ ;\nA : ({p}? 'a' {System.out.print(\"1\");} | )\n    ('a' {System.out.print(\"2\");})* ;\n";
        String string2 = TestCompileAndExecSupport.execParser("foo.g", string, "foo", "fooLexer", "a", "aaa", false);
        String string3 = "122\n";
        this.assertEqual(string2, string3);
    }

    public void testLexerPredInExitBranch4() throws Exception {
        String string = "grammar foo;a : (A|B)+ ;\nA @init {int n=0;} : ({n<2}? 'a' {System.out.print(n++);})+\n    ('a' {System.out.print(\"x\");})* ;\n";
        String string2 = TestCompileAndExecSupport.execParser("foo.g", string, "foo", "fooLexer", "a", "aaaaa", false);
        String string3 = "01xxx\n";
        this.assertEqual(string2, string3);
    }

    public void testLexerPredsInCyclicDFA() throws Exception {
        String string = "grammar foo;@lexer::members {boolean p=false;}\na : (A|B)+ ;\nA : {p}? ('a')+ 'x'  {System.out.println(\"token 1\");} ;\nB :      ('a')+ 'x' {System.out.println(\"token 2\");} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("foo.g", string, "foo", "fooLexer", "a", "aax", false);
        String string3 = "token 2\n";
        this.assertEqual(string2, string3);
    }

    public void testLexerPredsInCyclicDFA2() throws Exception {
        String string = "grammar foo;@lexer::members {boolean p=false;}\na : (A|B)+ ;\nA : {p}? ('a')+ 'x' ('y')? {System.out.println(\"token 1\");} ;\nB :      ('a')+ 'x' {System.out.println(\"token 2\");} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("foo.g", string, "foo", "fooLexer", "a", "aax", false);
        String string3 = "token 2\n";
        this.assertEqual(string2, string3);
    }

    public void testGatedPred() throws Exception {
        String string = "grammar foo;a : (A|B)+ ;\nA : {true}?=> 'a' {System.out.println(\"token 1\");} ;\nB : {false}?=>('a'|'b')+ {System.out.println(\"token 2\");} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("foo.g", string, "foo", "fooLexer", "a", "aa", false);
        String string3 = "token 1\ntoken 1\n";
        this.assertEqual(string2, string3);
    }

    public void testGatedPred2() throws Exception {
        String string = "grammar foo;\n@lexer::members {boolean sig=false;}\na : (A|B)+ ;\nA : 'a' {System.out.print(\"A\"); sig=true;} ;\nB : 'b' ;\nC : {sig}?=> ('a'|'b') {System.out.print(\"C\");} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("foo.g", string, "foo", "fooLexer", "a", "aa", false);
        String string3 = "AC\n";
        this.assertEqual(string2, string3);
    }

    public void testPredWithActionTranslation() throws Exception {
        String string = "grammar foo;\na : b[2] ;\nb[int i]\n  : {$i==1}?   'a' {System.out.println(\"alt 1\");}\n  | {$b.i==2}? 'a' {System.out.println(\"alt 2\");}\n  ;\n";
        String string2 = TestCompileAndExecSupport.execParser("foo.g", string, "foo", "fooLexer", "a", "aa", false);
        String string3 = "alt 2\n";
        this.assertEqual(string2, string3);
    }

    public void _test() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na :  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc 34", false);
        String string3 = "\n";
        this.assertEqual(string2, string3);
    }
}

