/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.Tool;
import org.antlr.codegen.CodeGenerator;
import org.antlr.test.ErrorQueue;
import org.antlr.test.TestCompileAndExecSupport;
import org.antlr.test.unit.FailedAssertionException;
import org.antlr.test.unit.TestSuite;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarSemanticsMessage;
import org.antlr.tool.Message;

public class TestRewriteAST
extends TestSuite {
    protected boolean debug = false;

    public void testDelete() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc 34", this.debug);
        String string3 = "";
        this.assertEqual(string2, string3);
    }

    public void testSingleToken() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID -> ID;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc", this.debug);
        String string3 = "abc\n";
        this.assertEqual(string2, string3);
    }

    public void testSingleCharLiteral() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : 'c' -> 'c';\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "c", this.debug);
        String string3 = "c\n";
        this.assertEqual(string2, string3);
    }

    public void testSingleStringLiteral() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : 'ick' -> 'ick';\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "ick", this.debug);
        String string3 = "ick\n";
        this.assertEqual(string2, string3);
    }

    public void testSingleRule() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : b -> b;\nb : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc", this.debug);
        String string3 = "abc\n";
        this.assertEqual(string2, string3);
    }

    public void testReorderTokens() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> INT ID;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc 34", this.debug);
        String string3 = "34 abc\n";
        this.assertEqual(string2, string3);
    }

    public void testReorderTokenAndRule() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : b INT -> INT b;\nb : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc 34", this.debug);
        String string3 = "34 abc\n";
        this.assertEqual(string2, string3);
    }

    public void testTokenTree() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> ^(INT ID);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc 34", this.debug);
        String string3 = "(34 abc)\n";
        this.assertEqual(string2, string3);
    }

    public void testTokenTreeAfterOtherStuff() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : 'void' ID INT -> 'void' ^(INT ID);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "void abc 34", this.debug);
        String string3 = "void (34 abc)\n";
        this.assertEqual(string2, string3);
    }

    public void testNestedTokenTreeWithOuterLoop() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {DUH;}\na : ID INT ID INT -> ^( DUH ID ^( DUH INT) )+ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a 1 b 2", this.debug);
        String string3 = "(DUH a (DUH 1)) (DUH b (DUH 2))\n";
        this.assertEqual(string2, string3);
    }

    public void testOptionalSingleToken() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID -> ID? ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc", this.debug);
        String string3 = "abc\n";
        this.assertEqual(string2, string3);
    }

    public void testClosureSingleToken() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID ID -> ID* ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a b", this.debug);
        String string3 = "a b\n";
        this.assertEqual(string2, string3);
    }

    public void testPositiveClosureSingleToken() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID ID -> ID+ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a b", this.debug);
        String string3 = "a b\n";
        this.assertEqual(string2, string3);
    }

    public void testOptionalSingleRule() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : b -> b?;\nb : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc", this.debug);
        String string3 = "abc\n";
        this.assertEqual(string2, string3);
    }

    public void testClosureSingleRule() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : b b -> b*;\nb : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a b", this.debug);
        String string3 = "a b\n";
        this.assertEqual(string2, string3);
    }

    public void testClosureOfLabel() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : x+=b x+=b -> $x*;\nb : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a b", this.debug);
        String string3 = "a b\n";
        this.assertEqual(string2, string3);
    }

    public void testOptionalLabelNoListLabel() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : (x=ID)? -> $x?;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a", this.debug);
        String string3 = "a\n";
        this.assertEqual(string2, string3);
    }

    public void testPositiveClosureSingleRule() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : b b -> b+;\nb : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a b", this.debug);
        String string3 = "a b\n";
        this.assertEqual(string2, string3);
    }

    public void testSinglePredicateT() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID -> {true}? ID -> ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc", this.debug);
        String string3 = "abc\n";
        this.assertEqual(string2, string3);
    }

    public void testSinglePredicateF() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID -> {false}? ID -> ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc", this.debug);
        String string3 = "";
        this.assertEqual(string2, string3);
    }

    public void testMultiplePredicate() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> {false}? ID\n           -> {true}? INT\n           -> \n  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a 2", this.debug);
        String string3 = "2\n";
        this.assertEqual(string2, string3);
    }

    public void testMultiplePredicateTrees() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> {false}? ^(ID INT)\n           -> {true}? ^(INT ID)\n           -> ID\n  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a 2", this.debug);
        String string3 = "(2 a)\n";
        this.assertEqual(string2, string3);
    }

    public void testSimpleTree() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : op INT -> ^(op INT);\nop : '+'|'-' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "-34", this.debug);
        String string3 = "(- 34)\n";
        this.assertEqual(string2, string3);
    }

    public void testSimpleTree2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : op INT -> ^(INT op);\nop : '+'|'-' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "+ 34", this.debug);
        String string3 = "(34 +)\n";
        this.assertEqual(string2, string3);
    }

    public void testQueueingOfTokens() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : 'int' ID (',' ID)* ';' -> ^('int' ID+) ;\nop : '+'|'-' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "int a,b,c;", this.debug);
        String string3 = "(int a b c)\n";
        this.assertEqual(string2, string3);
    }

    public void testNestedTrees() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : 'var' (ID ':' type ';')+ -> ^('var' ^(':' ID type)+) ;\ntype : 'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "var a:int; b:float;", this.debug);
        String string3 = "(var (: a int) (: b float))\n";
        this.assertEqual(string2, string3);
    }

    public void testImaginaryTokenCopy() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {VAR;}\na : ID (',' ID)*-> ^(VAR ID)+ ;\ntype : 'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a,b,c", this.debug);
        String string3 = "(VAR a) (VAR b) (VAR c)\n";
        this.assertEqual(string2, string3);
    }

    public void testImaginaryTokenCopySetText() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {VAR;}\na : ID (',' ID)*-> ^(VAR[\"var\"] ID)+ ;\ntype : 'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a,b,c", this.debug);
        String string3 = "(var a) (var b) (var c)\n";
        this.assertEqual(string2, string3);
    }

    public void testImaginaryTokenNoCopyFromToken() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : lc='{' ID+ '}' -> ^(BLOCK[$lc] ID+) ;\ntype : 'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "{a b c}", this.debug);
        String string3 = "({ a b c)\n";
        this.assertEqual(string2, string3);
    }

    public void testImaginaryTokenNoCopyFromTokenSetText() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : lc='{' ID+ '}' -> ^(BLOCK[$lc,\"block\"] ID+) ;\ntype : 'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "{a b c}", this.debug);
        String string3 = "(block a b c)\n";
        this.assertEqual(string2, string3);
    }

    public void testMixedRewriteAndAutoAST() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : b b^ ;\nb : ID INT -> INT ID\n  | INT\n  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a 1 2", this.debug);
        String string3 = "(2 1 a)\n";
        this.assertEqual(string2, string3);
    }

    public void testSubruleWithRewrite() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : b b ;\nb : (ID INT -> INT ID | INT INT -> INT+ )\n  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a 1 2 3", this.debug);
        String string3 = "1 a 2 3\n";
        this.assertEqual(string2, string3);
    }

    public void testSubruleWithRewriteReferencingPreviousElement() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {TYPE;}\na : b b ;\nb : 'int'\n    ( ID -> ^(TYPE 'int' ID)\n    | ID '=' INT -> ^(TYPE 'int' ID INT)\n    )\n    ';'\n  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "int a; int b=3;", this.debug);
        String string3 = "(TYPE int a) (TYPE int b 3)\n";
        this.assertEqual(string2, string3);
    }

    public void testNestedRewriteShutsOffAutoAST() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : b b ;\nb : ID ( ID (last=ID -> $last)+ ) ';'\n  | INT\n  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a b c d; 42", this.debug);
        String string3 = "d 42\n";
        this.assertEqual(string2, string3);
    }

    public void testRewriteActions() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : atom -> ^({adaptor.create(INT,\"9\")} atom) ;\natom : INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "3", this.debug);
        String string3 = "(9 3)\n";
        this.assertEqual(string2, string3);
    }

    public void testRewriteActions2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : atom -> {adaptor.create(INT,\"9\")} atom ;\natom : INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "3", this.debug);
        String string3 = "9 3\n";
        this.assertEqual(string2, string3);
    }

    public void testRefToOldValue() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : (atom -> atom) (op='+' r=atom -> ^($op $a $r) )* ;\natom : INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "3+4+5", this.debug);
        String string3 = "(+ (+ 3 4) 5)\n";
        this.assertEqual(string2, string3);
    }

    public void testCopySemanticsForRules() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : atom -> ^(atom atom) ;\natom : INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "3", this.debug);
        String string3 = "(3 3)\n";
        this.assertEqual(string2, string3);
    }

    public void testComplicatedMelange() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : A A b=B B b=B c+=C C c+=C D {$D.text;} -> A+ B+ C+ D ;\ntype : 'int' | 'float' ;\nA : 'a' ;\nB : 'b' ;\nC : 'c' ;\nD : 'd' ;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a a b b b c c c d", this.debug);
        String string3 = "a a b b b c c c d\n";
        this.assertEqual(string2, string3);
    }

    public void testRuleListLabel() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x+=b x+=b -> $x+;\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a b", this.debug);
        String string3 = "a b\n";
        this.assertEqual(string2, string3);
    }

    public void testOptional() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x=b (y=b)? -> $x $y?;\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a", this.debug);
        String string3 = "a\n";
        this.assertEqual(string2, string3);
    }

    public void testOptional2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x=ID (y=b)? -> $x $y?;\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a b", this.debug);
        String string3 = "a b\n";
        this.assertEqual(string2, string3);
    }

    public void testOptional3() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x=ID (y=b)? -> ($x $y)?;\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a b", this.debug);
        String string3 = "a b\n";
        this.assertEqual(string2, string3);
    }

    public void testOptional4() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x+=ID (y=b)? -> ($x $y)?;\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a b", this.debug);
        String string3 = "a b\n";
        this.assertEqual(string2, string3);
    }

    public void testArbitraryExprType() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x+=b x+=b -> {new Object()};\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "a b", this.debug);
        String string3 = "[not sure what this should be!]\n";
        this.assertEqual(string2, string3);
    }

    public void testUnknownRule() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "grammar T;\noptions {output=AST;}\na : INT -> ugh ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        Grammar grammar = new Grammar(string);
        Tool tool = new Tool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 106;
        String string2 = "ugh";
        Object var8_8 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string2, var8_8);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testKnownRuleButNotInLHS() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "grammar T;\noptions {output=AST;}\na : INT -> b ;\nb : 'b' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        Grammar grammar = new Grammar(string);
        Tool tool = new Tool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 136;
        String string2 = "b";
        Object var8_8 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string2, var8_8);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testUnknownToken() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "grammar T;\noptions {output=AST;}\na : INT -> ICK ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        Grammar grammar = new Grammar(string);
        Tool tool = new Tool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 135;
        String string2 = "ICK";
        Object var8_8 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string2, var8_8);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testUnknownLabel() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "grammar T;\noptions {output=AST;}\na : INT -> $foo ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        Grammar grammar = new Grammar(string);
        Tool tool = new Tool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 137;
        String string2 = "foo";
        Object var8_8 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string2, var8_8);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testUnknownCharLiteralToken() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "grammar T;\noptions {output=AST;}\na : INT -> 'a' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        Grammar grammar = new Grammar(string);
        Tool tool = new Tool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 135;
        String string2 = "'a'";
        Object var8_8 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string2, var8_8);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testUnknownStringLiteralToken() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "grammar T;\noptions {output=AST;}\na : INT -> 'foo' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        Grammar grammar = new Grammar(string);
        Tool tool = new Tool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 135;
        String string2 = "'foo'";
        Object var8_8 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string2, var8_8);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    protected void checkError(ErrorQueue errorQueue, GrammarSemanticsMessage grammarSemanticsMessage) throws FailedAssertionException {
        Message message = null;
        for (int i = 0; i < errorQueue.errors.size(); ++i) {
            Message message2 = (Message)errorQueue.errors.get(i);
            if (message2.msgID != grammarSemanticsMessage.msgID) continue;
            message = message2;
        }
        this.assertTrue(errorQueue.errors.size() > 0, "no error; " + grammarSemanticsMessage.msgID + " expected");
        this.assertTrue(errorQueue.errors.size() <= 1, "too many errors; " + errorQueue.errors);
        this.assertTrue(message != null, "couldn't find expected error: " + grammarSemanticsMessage.msgID);
        this.assertTrue(message instanceof GrammarSemanticsMessage, "error is not a GrammarSemanticsMessage");
        this.assertEqual(message.arg, grammarSemanticsMessage.arg);
        this.assertEqual(message.arg2, grammarSemanticsMessage.arg2);
        ErrorManager.resetErrorState();
    }
}

