/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.test.TestCompileAndExecSupport;
import org.antlr.test.unit.TestSuite;

public class TestLexer
extends TestSuite {
    protected boolean debug = false;

    public void testSetText() throws Exception {
        String string = "grammar P;\na : A {System.out.println(input);} ;\nA : '\\\\' 't' {setText(\"\t\");} ;\nWS : (' '|'\\n') {channel=99;} ;";
        String string2 = TestCompileAndExecSupport.execParser("P.g", string, "P", "PLexer", "a", "\\t", this.debug);
        String string3 = "\t\n";
        this.assertEqual(string2, string3);
    }

    public void testRefToRuleDoesNotSetTokenNorEmitAnother() throws Exception {
        String string = "grammar P;\na : A EOF {System.out.println(input);} ;\nA : '-' I ;\nI : '0'..'9'+ ;\nWS : (' '|'\\n') {channel=99;} ;";
        String string2 = TestCompileAndExecSupport.execParser("P.g", string, "P", "PLexer", "a", "-34", this.debug);
        String string3 = "-34\n";
        this.assertEqual(string2, string3);
    }

    public void testRefToFragment() throws Exception {
        String string = "grammar P;\na : A {System.out.println(input);} ;\nA : '-' I ;\nfragment I : '0'..'9'+ ;\nWS : (' '|'\\n') {channel=99;} ;";
        String string2 = TestCompileAndExecSupport.execParser("P.g", string, "P", "PLexer", "a", "-34", this.debug);
        String string3 = "-34\n";
        this.assertEqual(string2, string3);
    }

    public void testMultipleRefToFragment() throws Exception {
        String string = "grammar P;\na : A EOF {System.out.println(input);} ;\nA : I '.' I ;\nfragment I : '0'..'9'+ ;\nWS : (' '|'\\n') {channel=99;} ;";
        String string2 = TestCompileAndExecSupport.execParser("P.g", string, "P", "PLexer", "a", "3.14159", this.debug);
        String string3 = "3.14159\n";
        this.assertEqual(string2, string3);
    }
}

