/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.antlr.Tool;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.tool.Grammar;

public class TestCompileAndExecSupport {
    public static final String jikes = "/usr/bin/jikes";
    public static final String pathSep = System.getProperty("path.separator");
    public static final String CLASSPATH = System.getProperty("java.class.path");
    public static final String tmpdir = System.getProperty("java.io.tmpdir");

    public static boolean compile(String string) {
        String string2 = "javac";
        String string3 = "-classpath";
        if (jikes != null) {
            string2 = jikes;
            string3 = "-bootclasspath";
        }
        String string4 = string2 + " -d " + tmpdir + " " + string3 + " " + tmpdir + pathSep + CLASSPATH + " " + string;
        File file = new File(tmpdir);
        try {
            int n;
            Process process = Runtime.getRuntime().exec(string4, null, file);
            StreamVacuum streamVacuum = new StreamVacuum(process.getInputStream());
            StreamVacuum streamVacuum2 = new StreamVacuum(process.getErrorStream());
            streamVacuum.start();
            streamVacuum2.start();
            process.waitFor();
            if (streamVacuum.toString().length() > 0) {
                System.err.println("compile stderr from: " + string4);
                System.err.println(streamVacuum);
            }
            if (streamVacuum2.toString().length() > 0) {
                System.err.println("compile stderr from: " + string4);
                System.err.println(streamVacuum2);
            }
            return (n = process.exitValue()) == 0;
        }
        catch (Exception exception) {
            System.err.println("can't exec compilation");
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public static void antlr(String string, String string2, boolean bl) {
        TestCompileAndExecSupport.writeFile(tmpdir, string, string2);
        try {
            Grammar grammar = new Grammar(string2);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (bl) {
                arrayList.add("-debug");
            }
            arrayList.add("-o");
            arrayList.add(tmpdir);
            arrayList.add(new File(tmpdir, grammar.name + ".g").toString());
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            Tool tool = new Tool(stringArray);
            tool.process();
        }
        catch (Exception exception) {
            System.err.println("problems building grammar: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    public static String execParser(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        TestCompileAndExecSupport.eraseFiles(".class");
        TestCompileAndExecSupport.eraseFiles(".java");
        TestCompileAndExecSupport.rawGenerateAndBuildRecognizer(string, string2, string3, string4, bl);
        TestCompileAndExecSupport.writeFile(tmpdir, "input", string6);
        boolean bl2 = string2.indexOf("output=AST") >= 0;
        boolean bl3 = string2.indexOf("output=template") >= 0;
        return TestCompileAndExecSupport.rawExecRecognizer(string3, null, string4, string5, null, bl2, bl3, bl);
    }

    public static String execTreeParser(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        return TestCompileAndExecSupport.execTreeParser(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, false);
    }

    public static String execTreeParser(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl) {
        TestCompileAndExecSupport.eraseFiles(".class");
        TestCompileAndExecSupport.eraseFiles(".java");
        TestCompileAndExecSupport.rawGenerateAndBuildRecognizer(string, string2, string3, string7, bl);
        TestCompileAndExecSupport.rawGenerateAndBuildRecognizer(string4, string5, string6, string7, bl);
        TestCompileAndExecSupport.writeFile(tmpdir, "input", string10);
        boolean bl2 = string2.indexOf("output=AST") >= 0;
        boolean bl3 = string2.indexOf("output=template") >= 0;
        return TestCompileAndExecSupport.rawExecRecognizer(string3, string6, string7, string8, string9, bl2, bl3, bl);
    }

    protected static void rawGenerateAndBuildRecognizer(String string, String string2, String string3, String string4, boolean bl) {
        TestCompileAndExecSupport.antlr(string, string2, bl);
        if (string4 != null) {
            TestCompileAndExecSupport.compile(string3 + ".java " + string4 + ".java");
        } else {
            TestCompileAndExecSupport.compile(string3 + ".java");
        }
    }

    protected static String rawExecRecognizer(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            TestCompileAndExecSupport.writeTreeTestFile(string, string2, string3, string4, string5, bl3);
        } else if (bl2) {
            TestCompileAndExecSupport.writeTemplateTestFile(string, string3, string4, bl3);
        } else {
            TestCompileAndExecSupport.writeTestFile(string, string3, string4, bl3);
        }
        TestCompileAndExecSupport.compile("Test.java");
        try {
            String string6 = "java -classpath " + CLASSPATH + pathSep + tmpdir + " Test /tmp/input";
            Process process = Runtime.getRuntime().exec(string6, null, new File(tmpdir));
            StreamVacuum streamVacuum = new StreamVacuum(process.getInputStream());
            StreamVacuum streamVacuum2 = new StreamVacuum(process.getErrorStream());
            streamVacuum.start();
            streamVacuum2.start();
            process.waitFor();
            streamVacuum.join();
            streamVacuum2.join();
            String string7 = null;
            string7 = streamVacuum.toString();
            if (streamVacuum2.toString().length() > 0) {
                System.err.println("exec parser stderr: " + streamVacuum2);
            }
            return string7;
        }
        catch (Exception exception) {
            System.err.println("can't exec parser");
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static void writeFile(String string, String string2, String string3) {
        try {
            File file = new File(string, string2);
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string3);
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("can't write file");
            iOException.printStackTrace(System.err);
        }
    }

    public static void writeTestFile(String string, String string2, String string3, boolean bl) {
        StringTemplate stringTemplate = new StringTemplate("import org.antlr.runtime.*;\nimport org.antlr.runtime.tree.*;\nimport org.antlr.runtime.debug.*;\n\nclass Profiler2 extends Profiler {\n    public void terminate() { ; }\n}\npublic class Test {\n    public static void main(String[] args) throws Exception {\n        CharStream input = new ANTLRFileStream(args[0]);\n        $lexerName$ lex = new $lexerName$(input);\n        CommonTokenStream tokens = new CommonTokenStream(lex);\n        $createParser$\n        parser.$parserStartRuleName$();\n    }\n}");
        StringTemplate stringTemplate2 = new StringTemplate("        Profiler2 profiler = new Profiler2();\n        $parserName$ parser = new $parserName$(tokens,profiler);\n        profiler.setParser(parser);\n");
        if (!bl) {
            stringTemplate2 = new StringTemplate("        $parserName$ parser = new $parserName$(tokens);\n");
        }
        stringTemplate.setAttribute("createParser", stringTemplate2);
        stringTemplate.setAttribute("parserName", string);
        stringTemplate.setAttribute("lexerName", string2);
        stringTemplate.setAttribute("parserStartRuleName", string3);
        TestCompileAndExecSupport.writeFile(tmpdir, "Test.java", stringTemplate.toString());
    }

    public static void writeTreeTestFile(String string, String string2, String string3, String string4, String string5, boolean bl) {
        StringTemplate stringTemplate = new StringTemplate("import org.antlr.runtime.*;\nimport org.antlr.runtime.tree.*;\nimport org.antlr.runtime.debug.*;\n\nclass Profiler2 extends Profiler {\n    public void terminate() { ; }\n}\npublic class Test {\n    public static void main(String[] args) throws Exception {\n        CharStream input = new ANTLRFileStream(args[0]);\n        $lexerName$ lex = new $lexerName$(input);\n        CommonTokenStream tokens = new CommonTokenStream(lex);\n        $createParser$\n        $parserName$.$parserStartRuleName$_return r = parser.$parserStartRuleName$();\n        $if(!treeParserStartRuleName)$\n        if ( r.tree!=null )\n            System.out.println(((Tree)r.tree).toStringTree());\n        $else$\n        CommonTreeNodeStream nodes = new CommonTreeNodeStream((Tree)r.tree);\n        $treeParserName$ walker = new $treeParserName$(nodes);\n        walker.$treeParserStartRuleName$();\n        $endif$\n    }\n}");
        StringTemplate stringTemplate2 = new StringTemplate("        Profiler2 profiler = new Profiler2();\n        $parserName$ parser = new $parserName$(tokens,profiler);\n        profiler.setParser(parser);\n");
        if (!bl) {
            stringTemplate2 = new StringTemplate("        $parserName$ parser = new $parserName$(tokens);\n");
        }
        stringTemplate.setAttribute("createParser", stringTemplate2);
        stringTemplate.setAttribute("parserName", string);
        stringTemplate.setAttribute("treeParserName", string2);
        stringTemplate.setAttribute("lexerName", string3);
        stringTemplate.setAttribute("parserStartRuleName", string4);
        stringTemplate.setAttribute("treeParserStartRuleName", string5);
        TestCompileAndExecSupport.writeFile(tmpdir, "Test.java", stringTemplate.toString());
    }

    public static void writeTemplateTestFile(String string, String string2, String string3, boolean bl) {
        StringTemplate stringTemplate = new StringTemplate("import org.antlr.runtime.*;\nimport org.antlr.stringtemplate.*;\nimport org.antlr.stringtemplate.language.*;\nimport org.antlr.runtime.debug.*;\nimport java.io.*;\n\nclass Profiler2 extends Profiler {\n    public void terminate() { ; }\n}\npublic class Test {\n    static String templates =\n    \t\t\"group test;\"+    \t\t\"foo(x,y) ::= \\\"<x> <y>\\\"\";\n    static StringTemplateGroup group =    \t\tnew StringTemplateGroup(new StringReader(templates),\t\t\t\t\tAngleBracketTemplateLexer.class);    public static void main(String[] args) throws Exception {\n        CharStream input = new ANTLRFileStream(args[0]);\n        $lexerName$ lex = new $lexerName$(input);\n        CommonTokenStream tokens = new CommonTokenStream(lex);\n        $createParser$\n\t\t parser.setTemplateLib(group);\n        $parserName$.$parserStartRuleName$_return r = parser.$parserStartRuleName$();\n        if ( r.st!=null )\n            System.out.print(r.st.toString());\n\t \t else\n            System.out.print(\"\");\n    }\n}");
        StringTemplate stringTemplate2 = new StringTemplate("        Profiler2 profiler = new Profiler2();\n        $parserName$ parser = new $parserName$(tokens,profiler);\n        profiler.setParser(parser);\n");
        if (!bl) {
            stringTemplate2 = new StringTemplate("        $parserName$ parser = new $parserName$(tokens);\n");
        }
        stringTemplate.setAttribute("createParser", stringTemplate2);
        stringTemplate.setAttribute("parserName", string);
        stringTemplate.setAttribute("lexerName", string2);
        stringTemplate.setAttribute("parserStartRuleName", string3);
        TestCompileAndExecSupport.writeFile(tmpdir, "Test.java", stringTemplate.toString());
    }

    public static void eraseFiles(String string) {
        File file = new File(tmpdir);
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(string)) continue;
            new File(tmpdir + "/" + stringArray[i]).delete();
        }
    }

    public static class StreamVacuum
    implements Runnable {
        StringBuffer buf = new StringBuffer();
        BufferedReader in;
        Thread sucker;

        public StreamVacuum(InputStream inputStream) {
            this.in = new BufferedReader(new InputStreamReader(inputStream));
        }

        public void start() {
            this.sucker = new Thread(this);
            this.sucker.start();
        }

        public void run() {
            try {
                String string = this.in.readLine();
                while (string != null) {
                    this.buf.append(string);
                    this.buf.append('\n');
                    string = this.in.readLine();
                }
            }
            catch (IOException iOException) {
                System.err.println("can't read output from process");
            }
        }

        public void join() throws InterruptedException {
            this.sucker.join();
        }

        public String toString() {
            return this.buf.toString();
        }
    }
}

