/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.antlr.stringtemplate.test.FailedAssertionException;

public abstract class TestSuite {
    public String testName = null;
    int failures = 0;
    int successes = 0;

    public void assertEqual(Object result, Object expecting) throws FailedAssertionException {
        if (result == null && expecting != null) {
            throw new FailedAssertionException("expecting \"" + expecting + "\"; found null");
        }
        this.assertTrue(result.equals(expecting), "expecting \"" + expecting + "\"; found \"" + result + "\"");
    }

    public void assertEqual(int result, int expecting) throws FailedAssertionException {
        this.assertTrue(result == expecting, "expecting \"" + expecting + "\"; found \"" + result + "\"");
    }

    public void assertTrue(boolean test) throws FailedAssertionException {
        if (!test) {
            throw new FailedAssertionException();
        }
    }

    public void assertTrue(boolean test, String message) throws FailedAssertionException {
        if (!test) {
            if (message != null) {
                throw new FailedAssertionException(message);
            }
            throw new FailedAssertionException("assertTrue failed");
        }
    }

    public void time(String name, int n) throws Throwable {
        System.gc();
        long start = System.currentTimeMillis();
        System.out.print("TIME: " + name);
        for (int i = 1; i <= n; ++i) {
            this.invokeTest(name);
        }
        long finish = System.currentTimeMillis();
        long t = finish - start;
        System.out.println("; n=" + n + " " + t + "ms (" + (double)t / (double)n * 1000.0 + " microsec/eval)");
    }

    public void runTest(String name) {
        try {
            System.out.println("TEST: " + name);
            this.invokeTest(name);
            ++this.successes;
        }
        catch (InvocationTargetException ite) {
            ++this.failures;
            try {
                throw ite.getCause();
            }
            catch (FailedAssertionException fae) {
                System.err.println(name + " failed: " + fae.getMessage());
            }
            catch (Throwable e) {
                System.err.print("exception during test " + name + ":");
                e.printStackTrace();
            }
        }
    }

    public void invokeTest(String name) throws InvocationTargetException {
        this.testName = name;
        try {
            Class<?> c = this.getClass();
            Method m = c.getMethod(name, null);
            m.invoke((Object)this, (Object[])null);
        }
        catch (IllegalAccessException iae) {
            System.err.println("no permission to exec test " + name);
        }
        catch (NoSuchMethodException nsme) {
            System.err.println("no such test " + name);
        }
    }

    public int getFailures() {
        return this.failures;
    }

    public int getSuccesses() {
        return this.successes;
    }
}

