/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate.test;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.antlr.stringtemplate.AttributeRenderer;
import org.antlr.stringtemplate.PathGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupInterface;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.antlr.stringtemplate.test.TestRig;
import org.antlr.stringtemplate.test.TestSuite;

public class TestStringTemplate
extends TestSuite {
    final String newline = System.getProperty("line.separator");

    public void runTests() throws Throwable {
        TestRig.runAllTests(this.getClass(), this);
    }

    public void testInterfaceFileFormat() throws Exception {
        String groupI = "interface test;" + this.newline + "t();" + this.newline + "bold(item);" + this.newline + "optional duh(a,b,c);" + this.newline;
        StringTemplateGroupInterface I = new StringTemplateGroupInterface(new StringReader(groupI));
        String expecting = "interface test;\nt();\nbold(item);\noptional duh(a, b, c);\n";
        this.assertEqual(I.toString(), expecting);
    }

    public void testNoGroupLoader() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        String tmpdir = System.getProperty("java.io.tmpdir");
        String templates = "group testG implements blort;" + this.newline + "t() ::= <<foo>>" + this.newline + "bold(item) ::= <<foo>>" + this.newline + "duh(a,b,c) ::= <<foo>>" + this.newline;
        TestStringTemplate.writeFile(tmpdir, "testG.stg", templates);
        StringTemplateGroup group = new StringTemplateGroup((Reader)new FileReader(tmpdir + "/testG.stg"), errors);
        String expecting = "no group loader registered";
        this.assertEqual(((Object)errors).toString(), expecting);
    }

    public void testCannotFindInterfaceFile() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        String tmpdir = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(tmpdir, errors));
        String templates = "group testG implements blort;" + this.newline + "t() ::= <<foo>>" + this.newline + "bold(item) ::= <<foo>>" + this.newline + "duh(a,b,c) ::= <<foo>>" + this.newline;
        TestStringTemplate.writeFile(tmpdir, "testG.stg", templates);
        StringTemplateGroup group = new StringTemplateGroup((Reader)new FileReader(tmpdir + "/testG.stg"), errors);
        String expecting = "no such interface file blort.sti";
        this.assertEqual(((Object)errors).toString(), expecting);
    }

    public void testMultiDirGroupLoading() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (!new File(tmpdir + "/sub").exists() && !new File(tmpdir + "/sub").mkdir()) {
            System.err.println("can't make subdir in test");
            return;
        }
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(tmpdir + ":" + tmpdir + "/sub", errors));
        String templates = "group testG2;" + this.newline + "t() ::= <<foo>>" + this.newline + "bold(item) ::= <<foo>>" + this.newline + "duh(a,b,c) ::= <<foo>>" + this.newline;
        TestStringTemplate.writeFile(tmpdir + "/sub", "testG2.stg", templates);
        StringTemplateGroup group = StringTemplateGroup.loadGroup("testG2");
        String expecting = "group testG2;\nbold(item) ::= <<foo>>\nduh(a,b,c) ::= <<foo>>\nt() ::= <<foo>>\n";
        this.assertEqual(group.toString(), expecting);
    }

    public void testGroupSatisfiesSingleInterface() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        String tmpdir = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(tmpdir, errors));
        String groupI = "interface testI;" + this.newline + "t();" + this.newline + "bold(item);" + this.newline + "optional duh(a,b,c);" + this.newline;
        TestStringTemplate.writeFile(tmpdir, "testI.sti", groupI);
        String templates = "group testG implements testI;" + this.newline + "t() ::= <<foo>>" + this.newline + "bold(item) ::= <<foo>>" + this.newline + "duh(a,b,c) ::= <<foo>>" + this.newline;
        TestStringTemplate.writeFile(tmpdir, "testG.stg", templates);
        StringTemplateGroup group = new StringTemplateGroup((Reader)new FileReader(tmpdir + "/testG.stg"), errors);
        String expecting = "";
        this.assertEqual(((Object)errors).toString(), expecting);
    }

    public void testGroupExtendsSuperGroup() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        String tmpdir = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(tmpdir, errors));
        String superGroup = "group superG;" + this.newline + "bold(item) ::= <<*$item$*>>;\n" + this.newline;
        TestStringTemplate.writeFile(tmpdir, "superG.stg", superGroup);
        String templates = "group testG : superG;" + this.newline + "main(x) ::= <<$bold(x)$>>" + this.newline;
        TestStringTemplate.writeFile(tmpdir, "testG.stg", templates);
        StringTemplateGroup group = new StringTemplateGroup(new FileReader(tmpdir + "/testG.stg"), DefaultTemplateLexer.class, errors);
        StringTemplate st = group.getInstanceOf("main");
        st.setAttribute("x", "foo");
        String expecting = "*foo*";
        this.assertEqual(st.toString(), expecting);
    }

    public void testMissingInterfaceTemplate() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        String tmpdir = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(tmpdir, errors));
        String groupI = "interface testI;" + this.newline + "t();" + this.newline + "bold(item);" + this.newline + "optional duh(a,b,c);" + this.newline;
        TestStringTemplate.writeFile(tmpdir, "testI.sti", groupI);
        String templates = "group testG implements testI;" + this.newline + "t() ::= <<foo>>" + this.newline + "duh(a,b,c) ::= <<foo>>" + this.newline;
        TestStringTemplate.writeFile(tmpdir, "testG.stg", templates);
        StringTemplateGroup group = new StringTemplateGroup((Reader)new FileReader(tmpdir + "/testG.stg"), errors);
        String expecting = "group testG does not satisfy interface testI: missing templates [bold]";
        this.assertEqual(((Object)errors).toString(), expecting);
    }

    public void testMissingOptionalInterfaceTemplate() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        String tmpdir = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(tmpdir, errors));
        String groupI = "interface testI;" + this.newline + "t();" + this.newline + "bold(item);" + this.newline + "optional duh(a,b,c);" + this.newline;
        TestStringTemplate.writeFile(tmpdir, "testI.sti", groupI);
        String templates = "group testG implements testI;" + this.newline + "t() ::= <<foo>>" + this.newline + "bold(item) ::= <<foo>>";
        TestStringTemplate.writeFile(tmpdir, "testG.stg", templates);
        StringTemplateGroup group = new StringTemplateGroup((Reader)new FileReader(tmpdir + "/testG.stg"), errors);
        String expecting = "";
        this.assertEqual(((Object)errors).toString(), expecting);
    }

    public void testMismatchedInterfaceTemplate() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        String tmpdir = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(tmpdir, errors));
        String groupI = "interface testI;" + this.newline + "t();" + this.newline + "bold(item);" + this.newline + "optional duh(a,b,c);" + this.newline;
        TestStringTemplate.writeFile(tmpdir, "testI.sti", groupI);
        String templates = "group testG implements testI;" + this.newline + "t() ::= <<foo>>" + this.newline + "bold(item) ::= <<foo>>" + this.newline + "duh(a,c) ::= <<foo>>" + this.newline;
        TestStringTemplate.writeFile(tmpdir, "testG.stg", templates);
        StringTemplateGroup group = new StringTemplateGroup((Reader)new FileReader(tmpdir + "/testG.stg"), errors);
        String expecting = "group testG does not satisfy interface testI: mismatched arguments on these templates [optional duh(a, b, c)]";
        this.assertEqual(((Object)errors).toString(), expecting);
    }

    public void testGroupFileFormat() throws Exception {
        String templates = "group test;" + this.newline + "t() ::= \"literal template\"" + this.newline + "bold(item) ::= \"<b>$item$</b>\"" + this.newline + "duh() ::= <<" + this.newline + "xx" + this.newline + ">>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        String expecting = "group test;" + this.newline + "bold(item) ::= <<<b>$item$</b>>>" + this.newline + "duh() ::= <<xx>>" + this.newline + "t() ::= <<literal template>>" + this.newline;
        this.assertEqual(group.toString(), expecting);
        StringTemplate a = group.getInstanceOf("t");
        expecting = "literal template";
        this.assertEqual(a.toString(), expecting);
        StringTemplate b = group.getInstanceOf("bold");
        b.setAttribute("item", "dork");
        expecting = "<b>dork</b>";
        this.assertEqual(b.toString(), expecting);
    }

    public void testEscapedTemplateDelimiters() throws Exception {
        String templates = "group test;" + this.newline + "t() ::= <<$\"literal\":{a|$a$\\}}$ template\n>>" + this.newline + "bold(item) ::= <<<b>$item$</b\\>>>" + this.newline + "duh() ::= <<" + this.newline + "xx" + this.newline + ">>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        String expecting = "group test;" + this.newline + "bold(item) ::= <<<b>$item$</b>>>" + this.newline + "duh() ::= <<xx>>" + this.newline + "t() ::= <<$\"literal\":{a|$a$\\}}$ template>>" + this.newline;
        this.assertEqual(group.toString(), expecting);
        StringTemplate b = group.getInstanceOf("bold");
        b.setAttribute("item", "dork");
        expecting = "<b>dork</b>";
        this.assertEqual(b.toString(), expecting);
        StringTemplate a = group.getInstanceOf("t");
        expecting = "literal} template";
        this.assertEqual(a.toString(), expecting);
    }

    public void testTemplateParameterDecls() throws Exception {
        String templates = "group test;" + this.newline + "t() ::= \"no args but ref $foo$\"" + this.newline + "t2(item) ::= \"decl but not used is ok\"" + this.newline + "t3(a,b,c,d) ::= <<$a$ $d$>>" + this.newline + "t4(a,b,c,d) ::= <<$a$ $b$ $c$ $d$>>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate a = group.getInstanceOf("t");
        String error = null;
        try {
            a.setAttribute("foo", "x");
        }
        catch (NoSuchElementException e) {
            error = e.getMessage();
        }
        String expecting = "no such attribute: foo in template context [t]";
        this.assertEqual(error, expecting);
        a = group.getInstanceOf("t2");
        a.setAttribute("item", "x");
        a = group.getInstanceOf("t3");
        a.setAttribute("b", "x");
    }

    public void testTemplateRedef() throws Exception {
        String templates = "group test;" + this.newline + "a() ::= \"x\"" + this.newline + "b() ::= \"y\"" + this.newline + "a() ::= \"z\"" + this.newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), errors);
        String expecting = "redefinition of template: a";
        this.assertEqual(((Object)errors).toString(), expecting);
    }

    public void testMissingInheritedAttribute() throws Exception {
        String templates = "group test;" + this.newline + "page(title,font) ::= <<" + this.newline + "<html>" + this.newline + "<body>" + this.newline + "$title$<br>" + this.newline + "$body()$" + this.newline + "</body>" + this.newline + "</html>" + this.newline + ">>" + this.newline + "body() ::= \"<font face=$font$>my body</font>\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate t = group.getInstanceOf("page");
        t.setAttribute("title", "my title");
        t.setAttribute("font", "Helvetica");
        t.toString();
    }

    public void testFormalArgumentAssignment() throws Exception {
        String templates = "group test;" + this.newline + "page() ::= <<$body(font=\"Times\")$>>" + this.newline + "body(font) ::= \"<font face=$font$>my body</font>\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate t = group.getInstanceOf("page");
        String expecting = "<font face=Times>my body</font>";
        this.assertEqual(t.toString(), expecting);
    }

    public void testUndefinedArgumentAssignment() throws Exception {
        String templates = "group test;" + this.newline + "page(x) ::= <<$body(font=x)$>>" + this.newline + "body() ::= \"<font face=$font$>my body</font>\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate t = group.getInstanceOf("page");
        t.setAttribute("x", "Times");
        String error = "";
        try {
            t.toString();
        }
        catch (NoSuchElementException iae) {
            error = iae.getMessage();
        }
        String expecting = "template body has no such attribute: font in template context [page <invoke body arg context>]";
        this.assertEqual(error, expecting);
    }

    public void testFormalArgumentAssignmentInApply() throws Exception {
        String templates = "group test;" + this.newline + "page(name) ::= <<$name:bold(font=\"Times\")$>>" + this.newline + "bold(font) ::= \"<font face=$font$><b>$it$</b></font>\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate t = group.getInstanceOf("page");
        t.setAttribute("name", "Ter");
        String expecting = "<font face=Times><b>Ter</b></font>";
        this.assertEqual(t.toString(), expecting);
    }

    public void testUndefinedArgumentAssignmentInApply() throws Exception {
        String templates = "group test;" + this.newline + "page(name,x) ::= <<$name:bold(font=x)$>>" + this.newline + "bold() ::= \"<font face=$font$><b>$it$</b></font>\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate t = group.getInstanceOf("page");
        t.setAttribute("x", "Times");
        t.setAttribute("name", "Ter");
        String error = "";
        try {
            t.toString();
        }
        catch (NoSuchElementException iae) {
            error = iae.getMessage();
        }
        String expecting = "template bold has no such attribute: font in template context [page <invoke bold arg context>]";
        this.assertEqual(error, expecting);
    }

    public void testUndefinedAttributeReference() throws Exception {
        String templates = "group test;" + this.newline + "page() ::= <<$bold()$>>" + this.newline + "bold() ::= \"$name$\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate t = group.getInstanceOf("page");
        String error = "";
        try {
            t.toString();
        }
        catch (NoSuchElementException iae) {
            error = iae.getMessage();
        }
        String expecting = "no such attribute: name in template context [page bold]";
        this.assertEqual(error, expecting);
    }

    public void testUndefinedDefaultAttributeReference() throws Exception {
        String templates = "group test;" + this.newline + "page() ::= <<$bold()$>>" + this.newline + "bold() ::= \"$it$\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate t = group.getInstanceOf("page");
        String error = "";
        try {
            t.toString();
        }
        catch (NoSuchElementException nse) {
            error = nse.getMessage();
        }
        String expecting = "no such attribute: it in template context [page bold]";
        this.assertEqual(error, expecting);
    }

    public void testAngleBracketsWithGroupFile() throws Exception {
        String templates = "group test;" + this.newline + "a(s) ::= \"<s:{case <i> : <it> break;}>\"" + this.newline + "b(t) ::= \"<t; separator=\\\",\\\">\"" + this.newline + "c(t) ::= << <t; separator=\",\"> >>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate t = group.getInstanceOf("a");
        t.setAttribute("s", "Test");
        String expecting = "case 1 : Test break;";
        this.assertEqual(t.toString(), expecting);
    }

    public void testAngleBracketsNoGroup() throws Exception {
        StringTemplate st = new StringTemplate("Tokens : <rules; separator=\"|\"> ;", AngleBracketTemplateLexer.class);
        st.setAttribute("rules", "A");
        st.setAttribute("rules", "B");
        String expecting = "Tokens : A|B ;";
        this.assertEqual(st.toString(), expecting);
    }

    public void testRegionRef() throws Exception {
        String templates = "group test;" + this.newline + "a() ::= \"X$@r()$Y\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate st = group.getInstanceOf("a");
        String result = st.toString();
        String expecting = "XY";
        this.assertEqual(result, expecting);
    }

    public void testEmbeddedRegionRef() throws Exception {
        String templates = "group test;" + this.newline + "a() ::= \"X$@r$blort$@end$Y\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate st = group.getInstanceOf("a");
        String result = st.toString();
        String expecting = "XblortY";
        this.assertEqual(result, expecting);
    }

    public void testRegionRefAngleBrackets() throws Exception {
        String templates = "group test;" + this.newline + "a() ::= \"X<@r()>Y\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("a");
        String result = st.toString();
        String expecting = "XY";
        this.assertEqual(result, expecting);
    }

    public void testEmbeddedRegionRefAngleBrackets() throws Exception {
        String templates = "group test;" + this.newline + "a() ::= \"X<@r>blort<@end>Y\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("a");
        String result = st.toString();
        String expecting = "XblortY";
        this.assertEqual(result, expecting);
    }

    public void testEmbeddedRegionRefWithNewlinesAngleBrackets() throws Exception {
        String templates = "group test;" + this.newline + "a() ::= \"X<@r>" + this.newline + "blort" + this.newline + "<@end>" + this.newline + "Y\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("a");
        String result = st.toString();
        String expecting = "XblortY";
        this.assertEqual(result, expecting);
    }

    public void testRegionRefWithDefAngleBrackets() throws Exception {
        String templates = "group test;" + this.newline + "a() ::= \"X<@r()>Y\"" + this.newline + "@a.r() ::= \"foo\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("a");
        String result = st.toString();
        String expecting = "XfooY";
        this.assertEqual(result, expecting);
    }

    public void testRegionRefWithDefInConditional() throws Exception {
        String templates = "group test;" + this.newline + "a(v) ::= \"X<if(v)>A<@r()>B<endif>Y\"" + this.newline + "@a.r() ::= \"foo\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("a");
        st.setAttribute("v", "true");
        String result = st.toString();
        String expecting = "XAfooBY";
        this.assertEqual(result, expecting);
    }

    public void testRegionRefWithImplicitDefInConditional() throws Exception {
        String templates = "group test;" + this.newline + "a(v) ::= \"X<if(v)>A<@r>yo<@end>B<endif>Y\"" + this.newline + "@a.r() ::= \"foo\"" + this.newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), errors);
        StringTemplate st = group.getInstanceOf("a");
        st.setAttribute("v", "true");
        String result = st.toString();
        String expecting = "XAyoBY";
        this.assertEqual(result, expecting);
        String err_result = ((Object)errors).toString();
        String err_expecting = "group test line 3: redefinition of template region: @a.r";
        this.assertEqual(err_result, err_expecting);
    }

    public void testRegionOverride() throws Exception {
        String templates1 = "group super;" + this.newline + "a() ::= \"X<@r()>Y\"" + "@a.r() ::= \"foo\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates1));
        String templates2 = "group sub;" + this.newline + "@a.r() ::= \"foo\"" + this.newline;
        StringTemplateGroup subGroup = new StringTemplateGroup(new StringReader(templates2), AngleBracketTemplateLexer.class, null, group);
        StringTemplate st = subGroup.getInstanceOf("a");
        String result = st.toString();
        String expecting = "XfooY";
        this.assertEqual(result, expecting);
    }

    public void testRegionOverrideRefSuperRegion() throws Exception {
        String templates1 = "group super;" + this.newline + "a() ::= \"X<@r()>Y\"" + "@a.r() ::= \"foo\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates1));
        String templates2 = "group sub;" + this.newline + "@a.r() ::= \"A<@super.r()>B\"" + this.newline;
        StringTemplateGroup subGroup = new StringTemplateGroup(new StringReader(templates2), AngleBracketTemplateLexer.class, null, group);
        StringTemplate st = subGroup.getInstanceOf("a");
        String result = st.toString();
        String expecting = "XAfooBY";
        this.assertEqual(result, expecting);
    }

    public void testRegionOverrideRefSuperRegion3Levels() throws Exception {
        String templates1 = "group super;" + this.newline + "a() ::= \"X<@r()>Y\"" + "@a.r() ::= \"foo\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates1));
        String templates2 = "group sub;" + this.newline + "@a.r() ::= \"<@super.r()>2\"" + this.newline;
        StringTemplateGroup subGroup = new StringTemplateGroup(new StringReader(templates2), AngleBracketTemplateLexer.class, null, group);
        String templates3 = "group subsub;" + this.newline + "@a.r() ::= \"<@super.r()>3\"" + this.newline;
        StringTemplateGroup subSubGroup = new StringTemplateGroup(new StringReader(templates3), AngleBracketTemplateLexer.class, null, subGroup);
        StringTemplate st = subSubGroup.getInstanceOf("a");
        String result = st.toString();
        String expecting = "Xfoo23Y";
        this.assertEqual(result, expecting);
    }

    public void testRegionOverrideRefSuperImplicitRegion() throws Exception {
        String templates1 = "group super;" + this.newline + "a() ::= \"X<@r>foo<@end>Y\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates1));
        String templates2 = "group sub;" + this.newline + "@a.r() ::= \"A<@super.r()>\"" + this.newline;
        StringTemplateGroup subGroup = new StringTemplateGroup(new StringReader(templates2), AngleBracketTemplateLexer.class, null, group);
        StringTemplate st = subGroup.getInstanceOf("a");
        String result = st.toString();
        String expecting = "XAfooY";
        this.assertEqual(result, expecting);
    }

    public void testEmbeddedRegionRedefError() throws Exception {
        String templates = "group test;" + this.newline + "a() ::= \"X<@r>dork<@end>Y\"" + "@a.r() ::= \"foo\"" + this.newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), errors);
        StringTemplate st = group.getInstanceOf("a");
        st.toString();
        String result = ((Object)errors).toString();
        String expecting = "group test line 2: redefinition of template region: @a.r";
        this.assertEqual(result, expecting);
    }

    public void testImplicitRegionRedefError() throws Exception {
        String templates = "group test;" + this.newline + "a() ::= \"X<@r()>Y\"" + this.newline + "@a.r() ::= \"foo\"" + this.newline + "@a.r() ::= \"bar\"" + this.newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), errors);
        StringTemplate st = group.getInstanceOf("a");
        st.toString();
        String result = ((Object)errors).toString();
        String expecting = "group test line 4: redefinition of template region: @a.r";
        this.assertEqual(result, expecting);
    }

    public void testImplicitOverriddenRegionRedefError() throws Exception {
        String templates1 = "group super;" + this.newline + "a() ::= \"X<@r()>Y\"" + "@a.r() ::= \"foo\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates1));
        String templates2 = "group sub;" + this.newline + "@a.r() ::= \"foo\"" + this.newline + "@a.r() ::= \"bar\"" + this.newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup subGroup = new StringTemplateGroup(new StringReader(templates2), AngleBracketTemplateLexer.class, errors, group);
        StringTemplate st = subGroup.getInstanceOf("a");
        String result = ((Object)errors).toString();
        String expecting = "group sub line 3: redefinition of template region: @a.r";
        this.assertEqual(result, expecting);
    }

    public void testUnknownRegionDefError() throws Exception {
        String templates = "group test;" + this.newline + "a() ::= \"X<@r()>Y\"" + this.newline + "@a.q() ::= \"foo\"" + this.newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), errors);
        StringTemplate st = group.getInstanceOf("a");
        st.toString();
        String result = ((Object)errors).toString();
        String expecting = "group test line 3: template a has no region called q";
        this.assertEqual(result, expecting);
    }

    public void testSuperRegionRefError() throws Exception {
        String templates1 = "group super;" + this.newline + "a() ::= \"X<@r()>Y\"" + "@a.r() ::= \"foo\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates1));
        String templates2 = "group sub;" + this.newline + "@a.r() ::= \"A<@super.q()>B\"" + this.newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup subGroup = new StringTemplateGroup(new StringReader(templates2), AngleBracketTemplateLexer.class, errors, group);
        StringTemplate st = subGroup.getInstanceOf("a");
        String result = ((Object)errors).toString();
        String expecting = "template a has no region called q";
        this.assertEqual(result, expecting);
    }

    public void testMissingEndRegionError() throws Exception {
        String templates = "group test;" + this.newline + "a() ::= \"X$@r$foo\"" + this.newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates), DefaultTemplateLexer.class, errors, null);
        StringTemplate st = group.getInstanceOf("a");
        st.toString();
        String result = ((Object)errors).toString();
        String expecting = "missing region r $@end$ tag";
        this.assertEqual(result, expecting);
    }

    public void testMissingEndRegionErrorAngleBrackets() throws Exception {
        String templates = "group test;" + this.newline + "a() ::= \"X<@r>foo\"" + this.newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), errors);
        StringTemplate st = group.getInstanceOf("a");
        st.toString();
        String result = ((Object)errors).toString();
        String expecting = "missing region r <@end> tag";
        this.assertEqual(result, expecting);
    }

    public void testSimpleInheritance() throws Exception {
        StringTemplateGroup supergroup = new StringTemplateGroup("super");
        StringTemplateGroup subgroup = new StringTemplateGroup("sub");
        StringTemplate bold = supergroup.defineTemplate("bold", "<b>$it$</b>");
        subgroup.setSuperGroup(supergroup);
        ErrorBuffer errors = new ErrorBuffer();
        subgroup.setErrorListener(errors);
        supergroup.setErrorListener(errors);
        StringTemplate duh = new StringTemplate(subgroup, "$name:bold()$");
        duh.setAttribute("name", "Terence");
        String expecting = "<b>Terence</b>";
        this.assertEqual(duh.toString(), expecting);
    }

    public void testOverrideInheritance() throws Exception {
        StringTemplateGroup supergroup = new StringTemplateGroup("super");
        StringTemplateGroup subgroup = new StringTemplateGroup("sub");
        supergroup.defineTemplate("bold", "<b>$it$</b>");
        subgroup.defineTemplate("bold", "<strong>$it$</strong>");
        subgroup.setSuperGroup(supergroup);
        ErrorBuffer errors = new ErrorBuffer();
        subgroup.setErrorListener(errors);
        supergroup.setErrorListener(errors);
        StringTemplate duh = new StringTemplate(subgroup, "$name:bold()$");
        duh.setAttribute("name", "Terence");
        String expecting = "<strong>Terence</strong>";
        this.assertEqual(duh.toString(), expecting);
    }

    public void testMultiLevelInheritance() throws Exception {
        StringTemplateGroup rootgroup = new StringTemplateGroup("root");
        StringTemplateGroup level1 = new StringTemplateGroup("level1");
        StringTemplateGroup level2 = new StringTemplateGroup("level2");
        rootgroup.defineTemplate("bold", "<b>$it$</b>");
        level1.setSuperGroup(rootgroup);
        level2.setSuperGroup(level1);
        ErrorBuffer errors = new ErrorBuffer();
        rootgroup.setErrorListener(errors);
        level1.setErrorListener(errors);
        level2.setErrorListener(errors);
        StringTemplate duh = new StringTemplate(level2, "$name:bold()$");
        duh.setAttribute("name", "Terence");
        String expecting = "<b>Terence</b>";
        this.assertEqual(duh.toString(), expecting);
    }

    public void testComplicatedInheritance() throws Exception {
        String basetemplates = "group base;" + this.newline + "decls() ::= \"D<labels()>\"" + this.newline + "labels() ::= \"L\"" + this.newline;
        StringTemplateGroup base = new StringTemplateGroup(new StringReader(basetemplates));
        String subtemplates = "group sub;" + this.newline + "decls() ::= \"<super.decls()>\"" + this.newline + "labels() ::= \"SL\"" + this.newline;
        StringTemplateGroup sub = new StringTemplateGroup(new StringReader(subtemplates));
        sub.setSuperGroup(base);
        StringTemplate st = sub.getInstanceOf("decls");
        String expecting = "DSL";
        String result = st.toString();
        this.assertEqual(result, expecting);
    }

    public void test3LevelSuperRef() throws Exception {
        String templates1 = "group super;" + this.newline + "r() ::= \"foo\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates1));
        String templates2 = "group sub;" + this.newline + "r() ::= \"<super.r()>2\"" + this.newline;
        StringTemplateGroup subGroup = new StringTemplateGroup(new StringReader(templates2), AngleBracketTemplateLexer.class, null, group);
        String templates3 = "group subsub;" + this.newline + "r() ::= \"<super.r()>3\"" + this.newline;
        StringTemplateGroup subSubGroup = new StringTemplateGroup(new StringReader(templates3), AngleBracketTemplateLexer.class, null, subGroup);
        StringTemplate st = subSubGroup.getInstanceOf("r");
        String result = st.toString();
        String expecting = "foo23";
        this.assertEqual(result, expecting);
    }

    public void testExprInParens() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate bold = group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate duh = new StringTemplate(group, "$(\"blort: \"+(list)):bold()$");
        duh.setAttribute("list", "a");
        duh.setAttribute("list", "b");
        duh.setAttribute("list", "c");
        String expecting = "<b>blort: abc</b>";
        this.assertEqual(duh.toString(), expecting);
    }

    public void testMultipleAdditions() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        group.defineTemplate("link", "<a href=\"$url$\"><b>$title$</b></a>");
        StringTemplate duh = new StringTemplate(group, "$link(url=\"/member/view?ID=\"+ID+\"&x=y\"+foo, title=\"the title\")$");
        duh.setAttribute("ID", "3321");
        duh.setAttribute("foo", "fubar");
        String expecting = "<a href=\"/member/view?ID=3321&x=yfubar\"><b>the title</b></a>";
        this.assertEqual(duh.toString(), expecting);
    }

    public void testCollectionAttributes() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate bold = group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate t = new StringTemplate(group, "$data$, $data:bold()$, $list:bold():bold()$, $array$, $a2$, $a3$, $a4$");
        Vector<String> v = new Vector<String>();
        v.addElement("1");
        v.addElement("2");
        v.addElement("3");
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        list.add("c");
        t.setAttribute("data", v);
        t.setAttribute("list", list);
        t.setAttribute("array", (Object)new String[]{"x", "y"});
        t.setAttribute("a2", (Object)new int[]{10, 20});
        t.setAttribute("a3", (Object)new float[]{1.2f, 1.3f});
        t.setAttribute("a4", (Object)new double[]{8.7, 9.2});
        String expecting = "123, <b>1</b><b>2</b><b>3</b>, <b><b>a</b></b><b><b>b</b></b><b><b>c</b></b>, xy, 1020, 1.21.3, 8.79.2";
        this.assertEqual(t.toString(), expecting);
    }

    public void testParenthesizedExpression() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate bold = group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate t = new StringTemplate(group, "$(f+l):bold()$");
        t.setAttribute("f", "Joe");
        t.setAttribute("l", "Schmoe");
        String expecting = "<b>JoeSchmoe</b>";
        this.assertEqual(t.toString(), expecting);
    }

    public void testApplyTemplateNameExpression() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate bold = group.defineTemplate("foobar", "foo$attr$bar");
        StringTemplate t = new StringTemplate(group, "$data:(name+\"bar\")()$");
        t.setAttribute("data", "Ter");
        t.setAttribute("data", "Tom");
        t.setAttribute("name", "foo");
        String expecting = "fooTerbarfooTombar";
        this.assertEqual(t.toString(), expecting);
    }

    public void testApplyTemplateNameTemplateEval() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate foobar = group.defineTemplate("foobar", "foo$it$bar");
        StringTemplate a = group.defineTemplate("a", "$it$bar");
        StringTemplate t = new StringTemplate(group, "$data:(\"foo\":a())()$");
        t.setAttribute("data", "Ter");
        t.setAttribute("data", "Tom");
        String expecting = "fooTerbarfooTombar";
        this.assertEqual(t.toString(), expecting);
    }

    public void testTemplateNameExpression() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate foo = group.defineTemplate("foo", "hi there!");
        StringTemplate t = new StringTemplate(group, "$(name)()$");
        t.setAttribute("name", "foo");
        String expecting = "hi there!";
        this.assertEqual(t.toString(), expecting);
    }

    public void testMissingEndDelimiter() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "stuff $a then more junk etc...");
        String expectingError = "problem parsing template 'anonymous': line 1:31: expecting '$', found '<EOF>'";
        this.assertTrue(((Object)errors).toString().startsWith(expectingError));
    }

    public void testSetButNotRefd() throws Exception {
        StringTemplate.setLintMode(true);
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate t = new StringTemplate(group, "$a$ then $b$ and $c$ refs.");
        t.setAttribute("a", "Terence");
        t.setAttribute("b", "Terence");
        t.setAttribute("cc", "Terence");
        String newline = System.getProperty("line.separator");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        String expectingError = "anonymous: set but not used: cc";
        String result = t.toString();
        StringTemplate.setLintMode(false);
        this.assertEqual(((Object)errors).toString(), expectingError);
    }

    public void testNullTemplateApplication() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "$names:bold(x=it)$");
        t.setAttribute("names", "Terence");
        Object expecting = null;
        String result = null;
        String error = null;
        try {
            result = t.toString();
        }
        catch (IllegalArgumentException iae) {
            error = iae.getMessage();
        }
        this.assertEqual(error, "Can't find template bold.st; context is [anonymous]");
    }

    public void testNullTemplateToMultiValuedApplication() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "$names:bold(x=it)$");
        t.setAttribute("names", "Terence");
        t.setAttribute("names", "Tom");
        Object expecting = null;
        String result = null;
        String error = null;
        try {
            result = t.toString();
        }
        catch (IllegalArgumentException iae) {
            error = iae.getMessage();
        }
        this.assertEqual(error, "Can't find template bold.st; context is [anonymous]");
    }

    public void testChangingAttrValueTemplateApplicationToVector() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate bold = group.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate t = new StringTemplate(group, "$names:bold(x=it)$");
        t.setAttribute("names", "Terence");
        t.setAttribute("names", "Tom");
        String expecting = "<b>Terence</b><b>Tom</b>";
        this.assertEqual(t.toString(), expecting);
    }

    public void testChangingAttrValueRepeatedTemplateApplicationToVector() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate bold = group.defineTemplate("bold", "<b>$item$</b>");
        StringTemplate italics = group.defineTemplate("italics", "<i>$it$</i>");
        StringTemplate members = new StringTemplate(group, "$members:bold(item=it):italics(it=it)$");
        members.setAttribute("members", "Jim");
        members.setAttribute("members", "Mike");
        members.setAttribute("members", "Ashar");
        String expecting = "<i><b>Jim</b></i><i><b>Mike</b></i><i><b>Ashar</b></i>";
        this.assertEqual(members.toString(), expecting);
    }

    public void testAlternatingTemplateApplication() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate listItem = group.defineTemplate("listItem", "<li>$it$</li>");
        StringTemplate bold = group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate italics = group.defineTemplate("italics", "<i>$it$</i>");
        StringTemplate item = new StringTemplate(group, "$item:bold(),italics():listItem()$");
        item.setAttribute("item", "Jim");
        item.setAttribute("item", "Mike");
        item.setAttribute("item", "Ashar");
        String expecting = "<li><b>Jim</b></li><li><i>Mike</i></li><li><b>Ashar</b></li>";
        this.assertEqual(item.toString(), expecting);
    }

    public void testExpressionAsRHSOfAssignment() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate hostname = group.defineTemplate("hostname", "$machine$.jguru.com");
        StringTemplate bold = group.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate t = new StringTemplate(group, "$bold(x=hostname(machine=\"www\"))$");
        String expecting = "<b>www.jguru.com</b>";
        this.assertEqual(t.toString(), expecting);
    }

    public void testTemplateApplicationAsRHSOfAssignment() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate hostname = group.defineTemplate("hostname", "$machine$.jguru.com");
        StringTemplate bold = group.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate italics = group.defineTemplate("italics", "<i>$it$</i>");
        StringTemplate t = new StringTemplate(group, "$bold(x=hostname(machine=\"www\"):italics())$");
        String expecting = "<b><i>www.jguru.com</i></b>";
        this.assertEqual(t.toString(), expecting);
    }

    public void testParameterAndAttributeScoping() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate italics = group.defineTemplate("italics", "<i>$x$</i>");
        StringTemplate bold = group.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate t = new StringTemplate(group, "$bold(x=italics(x=name))$");
        t.setAttribute("name", "Terence");
        String expecting = "<b><i>Terence</i></b>";
        this.assertEqual(t.toString(), expecting);
    }

    public void testComplicatedSeparatorExpr() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate bold = group.defineTemplate("bulletSeparator", "</li>$foo$<li>");
        StringTemplate t = new StringTemplate(group, "<ul>$name; separator=bulletSeparator(foo=\" \")+\"&nbsp;\"$</ul>");
        t.setAttribute("name", "Ter");
        t.setAttribute("name", "Tom");
        t.setAttribute("name", "Mel");
        String expecting = "<ul>Ter</li> <li>&nbsp;Tom</li> <li>&nbsp;Mel</ul>";
        this.assertEqual(t.toString(), expecting);
    }

    public void testAttributeRefButtedUpAgainstEndifAndWhitespace() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate a = new StringTemplate(group, "$if (!firstName)$$email$$endif$");
        a.setAttribute("email", "parrt@jguru.com");
        String expecting = "parrt@jguru.com";
        this.assertEqual(a.toString(), expecting);
    }

    public void testStringCatenationOnSingleValuedAttributeViaTemplateLiteral() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate bold = group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate b = new StringTemplate(group, "$bold(it={$name$ Parr})$");
        b.setAttribute("name", "Terence");
        String expecting = "<b>Terence Parr</b>";
        this.assertEqual(b.toString(), expecting);
    }

    public void testStringCatenationOpOnArg() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate bold = group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate b = new StringTemplate(group, "$bold(it=name+\" Parr\")$");
        b.setAttribute("name", "Terence");
        String expecting = "<b>Terence Parr</b>";
        this.assertEqual(b.toString(), expecting);
    }

    public void testStringCatenationOpOnArgWithEqualsInString() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate bold = group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate b = new StringTemplate(group, "$bold(it=name+\" Parr=\")$");
        b.setAttribute("name", "Terence");
        String expecting = "<b>Terence Parr=</b>";
        this.assertEqual(b.toString(), expecting);
    }

    public void testApplyingTemplateFromDiskWithPrecompiledIF() throws Exception {
        String newline = System.getProperty("line.separator");
        FileWriter fw = new FileWriter("/tmp/page.st");
        fw.write("<html><head>" + newline);
        fw.write("</head>" + newline);
        fw.write("<body>" + newline);
        fw.write("$if(member)$User: $member:terse()$$endif$" + newline);
        fw.write("</body>" + newline);
        fw.write("</head>" + newline);
        fw.close();
        fw = new FileWriter("/tmp/terse.st");
        fw.write("$it.firstName$ $it.lastName$ (<tt>$it.email$</tt>)" + newline);
        fw.close();
        StringTemplateGroup group = new StringTemplateGroup("dummy", "/tmp");
        StringTemplate a = group.getInstanceOf("page");
        a.setAttribute("member", new Connector());
        String expecting = "<html><head>" + newline + "</head>" + newline + "<body>" + newline + "User: Terence Parr (<tt>parrt@jguru.com</tt>)" + newline + "</body>" + newline + "</head>";
        this.assertEqual(a.toString(), expecting);
    }

    public void testMultiValuedAttributeWithAnonymousTemplateUsingIndexVariableI() throws Exception {
        StringTemplateGroup tgroup = new StringTemplateGroup("dummy", ".");
        StringTemplate t = new StringTemplate(tgroup, " List:" + this.newline + "  " + this.newline + "foo" + this.newline + this.newline + "$names:{<br>$i$. $it$" + this.newline + "}$");
        t.setAttribute("names", "Terence");
        t.setAttribute("names", "Jim");
        t.setAttribute("names", "Sriram");
        String newline = System.getProperty("line.separator");
        String expecting = " List:" + newline + "  " + newline + "foo" + newline + newline + "<br>1. Terence" + newline + "<br>2. Jim" + newline + "<br>3. Sriram" + newline;
        this.assertEqual(t.toString(), expecting);
    }

    public void testFindTemplateInCLASSPATH() throws Exception {
        StringTemplateGroup mgroup = new StringTemplateGroup("method stuff", AngleBracketTemplateLexer.class);
        StringTemplate m = mgroup.getInstanceOf("org/antlr/stringtemplate/test/method");
        m.setAttribute("visibility", "public");
        m.setAttribute("name", "foobar");
        m.setAttribute("returnType", "void");
        m.setAttribute("statements", "i=1;");
        m.setAttribute("statements", "x=i;");
        String newline = System.getProperty("line.separator");
        String expecting = "public void foobar() {" + newline + "\t// start of a body" + newline + "\ti=1;" + newline + "\tx=i;" + newline + "\t// end of a body" + newline + "}";
        this.assertEqual(m.toString(), expecting);
    }

    public void testApplyTemplateToSingleValuedAttribute() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate bold = group.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate name = new StringTemplate(group, "$name:bold(x=name)$");
        name.setAttribute("name", "Terence");
        this.assertEqual(name.toString(), "<b>Terence</b>");
    }

    public void testStringLiteralAsAttribute() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate bold = group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate name = new StringTemplate(group, "$\"Terence\":bold()$");
        this.assertEqual(name.toString(), "<b>Terence</b>");
    }

    public void testApplyTemplateToSingleValuedAttributeWithDefaultAttribute() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate bold = group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate name = new StringTemplate(group, "$name:bold()$");
        name.setAttribute("name", "Terence");
        this.assertEqual(name.toString(), "<b>Terence</b>");
    }

    public void testApplyAnonymousTemplateToSingleValuedAttribute() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate item = new StringTemplate(group, "$item:{<li>$it$</li>}$");
        item.setAttribute("item", "Terence");
        this.assertEqual(item.toString(), "<li>Terence</li>");
    }

    public void testApplyAnonymousTemplateToMultiValuedAttribute() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate list = new StringTemplate(group, "<ul>$items$</ul>");
        StringTemplate item = new StringTemplate(group, "$item:{<li>$it$</li>}; separator=\",\"$");
        item.setAttribute("item", "Terence");
        item.setAttribute("item", "Jim");
        item.setAttribute("item", "John");
        list.setAttribute("items", item);
        this.assertEqual(list.toString(), "<ul><li>Terence</li>,<li>Jim</li>,<li>John</li></ul>");
    }

    public void testApplyAnonymousTemplateToAggregateAttribute() throws Exception {
        StringTemplate st = new StringTemplate("$items:{$it.lastName$, $it.firstName$\n}$");
        st.setAttribute("items.{ firstName ,lastName}", "Ter", "Parr");
        st.setAttribute("items.{firstName, lastName }", "Tom", "Burns");
        String expecting = "Parr, Ter" + this.newline + "Burns, Tom" + this.newline;
        this.assertEqual(st.toString(), expecting);
    }

    public void testRepeatedApplicationOfTemplateToSingleValuedAttribute() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate search = group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate item = new StringTemplate(group, "$item:bold():bold()$");
        item.setAttribute("item", "Jim");
        this.assertEqual(item.toString(), "<b><b>Jim</b></b>");
    }

    public void testRepeatedApplicationOfTemplateToMultiValuedAttributeWithSeparator() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate search = group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate item = new StringTemplate(group, "$item:bold():bold(); separator=\",\"$");
        item.setAttribute("item", "Jim");
        item.setAttribute("item", "Mike");
        item.setAttribute("item", "Ashar");
        this.assertEqual(item.toString(), "<b><b>Jim</b></b>,<b><b>Mike</b></b>,<b><b>Ashar</b></b>");
    }

    public void testMultiValuedAttributeWithSeparator() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".", AngleBracketTemplateLexer.class);
        StringTemplate query = new StringTemplate(group, "SELECT <distinct> <column; separator=\", \"> FROM <table>;");
        query.setAttribute("column", "name");
        query.setAttribute("column", "email");
        query.setAttribute("table", "User");
        this.assertEqual(query.toString(), "SELECT  name, email FROM User;");
    }

    public void testSingleValuedAttributes() throws Exception {
        StringTemplate query = new StringTemplate("SELECT $column$ FROM $table$;");
        query.setAttribute("column", "name");
        query.setAttribute("table", "User");
        this.assertEqual(query.toString(), "SELECT name FROM User;");
    }

    public void testIFTemplate() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".", AngleBracketTemplateLexer.class);
        StringTemplate t = new StringTemplate(group, "SELECT <column> FROM PERSON <if(cond)>WHERE ID=<id><endif>;");
        t.setAttribute("column", "name");
        t.setAttribute("cond", "true");
        t.setAttribute("id", "231");
        this.assertEqual(t.toString(), "SELECT name FROM PERSON WHERE ID=231;");
    }

    public void testIFCondWithParensTemplate() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".", AngleBracketTemplateLexer.class);
        StringTemplate t = new StringTemplate(group, "<if(map.(type))><type> <prop>=<map.(type)>;<endif>");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("int", "0");
        t.setAttribute("map", map);
        t.setAttribute("prop", "x");
        t.setAttribute("type", "int");
        this.assertEqual(t.toString(), "int x=0;");
    }

    public void testIFCondWithParensDollarDelimsTemplate() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate t = new StringTemplate(group, "$if(map.(type))$$type$ $prop$=$map.(type)$;$endif$");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("int", "0");
        t.setAttribute("map", map);
        t.setAttribute("prop", "x");
        t.setAttribute("type", "int");
        this.assertEqual(t.toString(), "int x=0;");
    }

    public void testIFBoolean() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate t = new StringTemplate(group, "$if(b)$x$endif$ $if(!b)$y$endif$");
        t.setAttribute("b", new Boolean(true));
        this.assertEqual(t.toString(), "x ");
        t = t.getInstanceOf();
        t.setAttribute("b", new Boolean(false));
        this.assertEqual(t.toString(), " y");
    }

    public void testNestedIFTemplate() throws Exception {
        String newline = System.getProperty("line.separator");
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".", AngleBracketTemplateLexer.class);
        StringTemplate t = new StringTemplate(group, "ack<if(a)>" + newline + "foo" + newline + "<if(!b)>stuff<endif>" + newline + "<if(b)>no<endif>" + newline + "junk" + newline + "<endif>");
        t.setAttribute("a", "blort");
        String expecting = "ackfoo" + newline + "stuff" + newline + "junk";
        this.assertEqual(t.toString(), expecting);
    }

    public void testObjectPropertyReference() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        String newline = System.getProperty("line.separator");
        StringTemplate t = new StringTemplate(group, "<b>Name: $p.firstName$ $p.lastName$</b><br>" + newline + "<b>Email: $p.email$</b><br>" + newline + "$p.bio$");
        t.setAttribute("p", new Connector());
        String expecting = "<b>Name: Terence Parr</b><br>" + newline + "<b>Email: parrt@jguru.com</b><br>" + newline + "Superhero by night...";
        this.assertEqual(t.toString(), expecting);
    }

    public void testApplyRepeatedAnonymousTemplateWithForeignTemplateRefToMultiValuedAttribute() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        group.defineTemplate("link", "<a href=\"$url$\"><b>$title$</b></a>");
        StringTemplate duh = new StringTemplate(group, "start|$p:{$link(url=\"/member/view?ID=\"+it.ID, title=it.firstName)$ $if(it.canEdit)$canEdit$endif$}:{$it$<br>\n}$|end");
        duh.setAttribute("p", new Connector());
        duh.setAttribute("p", new Connector2());
        String newline = System.getProperty("line.separator");
        String expecting = "start|<a href=\"/member/view?ID=1\"><b>Terence</b></a> <br>" + newline + "<a href=\"/member/view?ID=2\"><b>Tom</b></a> canEdit<br>" + newline + "|end";
        this.assertEqual(duh.toString(), expecting);
    }

    public void testRecursion() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".", AngleBracketTemplateLexer.class);
        group.defineTemplate("tree", "<if(it.firstChild)>( <it.text> <it.children:tree(); separator=\" \"> )<else><it.text><endif>");
        StringTemplate tree = group.getInstanceOf("tree");
        Tree root = new Tree("a");
        root.addChild(new Tree("b"));
        Tree subtree = new Tree("c");
        subtree.addChild(new Tree("d"));
        root.addChild(subtree);
        root.addChild(new Tree("e"));
        tree.setAttribute("it", root);
        String expecting = "( a b ( c d ) e )";
        this.assertEqual(tree.toString(), expecting);
    }

    public void testNestedAnonymousTemplates() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        String newline = System.getProperty("line.separator");
        StringTemplate t = new StringTemplate(group, "$A:{" + newline + "<i>$it:{" + newline + "<b>$it$</b>" + newline + "}$</i>" + newline + "}$");
        t.setAttribute("A", "parrt");
        String expecting = newline + "<i>" + newline + "<b>parrt</b>" + newline + "</i>" + newline;
        this.assertEqual(t.toString(), expecting);
    }

    public void testAnonymousTemplateAccessToEnclosingAttributes() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        String newline = System.getProperty("line.separator");
        StringTemplate t = new StringTemplate(group, "$A:{" + newline + "<i>$it:{" + newline + "<b>$it$, $B$</b>" + newline + "}$</i>" + newline + "}$");
        t.setAttribute("A", "parrt");
        t.setAttribute("B", "tombu");
        String expecting = newline + "<i>" + newline + "<b>parrt, tombu</b>" + newline + "</i>" + newline;
        this.assertEqual(t.toString(), expecting);
    }

    public void testNestedAnonymousTemplatesAgain() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        String newline = System.getProperty("line.separator");
        StringTemplate t = new StringTemplate(group, "<table>" + newline + "$names:{<tr>$it:{<td>$it:{<b>$it$</b>}$</td>}$</tr>}$" + newline + "</table>" + newline);
        t.setAttribute("names", "parrt");
        t.setAttribute("names", "tombu");
        String expecting = "<table>" + newline + "<tr><td><b>parrt</b></td></tr><tr><td><b>tombu</b></td></tr>" + newline + "</table>" + newline;
        this.assertEqual(t.toString(), expecting);
    }

    public void testEscapes() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        String newline = System.getProperty("line.separator");
        group.defineTemplate("foo", "$x$ && $it$");
        StringTemplate t = new StringTemplate(group, "$A:foo(x=\"dog\\\"\\\"\")$");
        StringTemplate u = new StringTemplate(group, "$A:foo(x=\"dog\\\"g\")$");
        StringTemplate v = new StringTemplate(group, "$A:{$it:foo(x=\"\\{dog\\}\\\"\")$ is cool}$");
        t.setAttribute("A", "ick");
        u.setAttribute("A", "ick");
        v.setAttribute("A", "ick");
        String expecting = "dog\"\" && ick";
        this.assertEqual(t.toString(), expecting);
        expecting = "dog\"g && ick";
        this.assertEqual(u.toString(), expecting);
        expecting = "{dog}\" && ick is cool";
        this.assertEqual(v.toString(), expecting);
    }

    public void testEscapesOutsideExpressions() throws Exception {
        StringTemplate b = new StringTemplate("It\\'s ok...\\$; $a:{\\'hi\\', $it$}$");
        b.setAttribute("a", "Ter");
        String expecting = "It\\'s ok...$; \\'hi\\', Ter";
        String result = b.toString();
        this.assertEqual(result, expecting);
    }

    public void testElseClause() throws Exception {
        StringTemplate e = new StringTemplate("$if(title)$" + this.newline + "foo" + this.newline + "$else$" + this.newline + "bar" + this.newline + "$endif$");
        e.setAttribute("title", "sample");
        String expecting = "foo";
        this.assertEqual(e.toString(), expecting);
        e = e.getInstanceOf();
        expecting = "bar";
        this.assertEqual(e.toString(), expecting);
    }

    public void testNestedIF() throws Exception {
        StringTemplate e = new StringTemplate("$if(title)$" + this.newline + "foo" + this.newline + "$else$" + this.newline + "$if(header)$" + this.newline + "bar" + this.newline + "$else$" + this.newline + "blort" + this.newline + "$endif$" + this.newline + "$endif$");
        e.setAttribute("title", "sample");
        String expecting = "foo";
        this.assertEqual(e.toString(), expecting);
        e = e.getInstanceOf();
        e.setAttribute("header", "more");
        expecting = "bar";
        this.assertEqual(e.toString(), expecting);
        e = e.getInstanceOf();
        expecting = "blort";
        this.assertEqual(e.toString(), expecting);
    }

    public void testEmbeddedMultiLineIF() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate main = new StringTemplate(group, "$sub$");
        StringTemplate sub = new StringTemplate(group, "begin" + this.newline + "$if(foo)$" + this.newline + "$foo$" + this.newline + "$else$" + this.newline + "blort" + this.newline + "$endif$" + this.newline);
        sub.setAttribute("foo", "stuff");
        main.setAttribute("sub", sub);
        String expecting = "begin" + this.newline + "stuff";
        this.assertEqual(main.toString(), expecting);
        main = new StringTemplate(group, "$sub$");
        sub = sub.getInstanceOf();
        main.setAttribute("sub", sub);
        expecting = "begin" + this.newline + "blort";
        this.assertEqual(main.toString(), expecting);
    }

    public void testSimpleIndentOfAttributeList() throws Exception {
        String templates = "group test;" + this.newline + "list(names) ::= <<" + "  $names; separator=\"\n\"$" + this.newline + ">>" + this.newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates), DefaultTemplateLexer.class, errors);
        StringTemplate t = group.getInstanceOf("list");
        t.setAttribute("names", "Terence");
        t.setAttribute("names", "Jim");
        t.setAttribute("names", "Sriram");
        String expecting = "  Terence" + this.newline + "  Jim" + this.newline + "  Sriram";
        this.assertEqual(t.toString(), expecting);
    }

    public void testIndentOfMultilineAttributes() throws Exception {
        String templates = "group test;" + this.newline + "list(names) ::= <<" + "  $names; separator=\"\n\"$" + this.newline + ">>" + this.newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates), DefaultTemplateLexer.class, errors);
        StringTemplate t = group.getInstanceOf("list");
        t.setAttribute("names", "Terence\nis\na\nmaniac");
        t.setAttribute("names", "Jim");
        t.setAttribute("names", "Sriram\nis\ncool");
        String expecting = "  Terence" + this.newline + "  is" + this.newline + "  a" + this.newline + "  maniac" + this.newline + "  Jim" + this.newline + "  Sriram" + this.newline + "  is" + this.newline + "  cool";
        this.assertEqual(t.toString(), expecting);
    }

    public void testIndentOfMultipleBlankLines() throws Exception {
        String templates = "group test;" + this.newline + "list(names) ::= <<" + "  $names$" + this.newline + ">>" + this.newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates), DefaultTemplateLexer.class, errors);
        StringTemplate t = group.getInstanceOf("list");
        t.setAttribute("names", "Terence\n\nis a maniac");
        String expecting = "  Terence" + this.newline + "" + this.newline + "  is a maniac";
        this.assertEqual(t.toString(), expecting);
    }

    public void testIndentBetweenLeftJustifiedLiterals() throws Exception {
        String templates = "group test;" + this.newline + "list(names) ::= <<" + "Before:" + this.newline + "  $names; separator=\"\\n\"$" + this.newline + "after" + this.newline + ">>" + this.newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates), DefaultTemplateLexer.class, errors);
        StringTemplate t = group.getInstanceOf("list");
        t.setAttribute("names", "Terence");
        t.setAttribute("names", "Jim");
        t.setAttribute("names", "Sriram");
        String expecting = "Before:" + this.newline + "  Terence" + this.newline + "  Jim" + this.newline + "  Sriram" + this.newline + "after";
        this.assertEqual(t.toString(), expecting);
    }

    public void testNestedIndent() throws Exception {
        String templates = "group test;" + this.newline + "method(name,stats) ::= <<" + "void $name$() {" + this.newline + "\t$stats; separator=\"\\n\"$" + this.newline + "}" + this.newline + ">>" + this.newline + "ifstat(expr,stats) ::= <<" + this.newline + "if ($expr$) {" + this.newline + "  $stats; separator=\"\\n\"$" + this.newline + "}" + ">>" + this.newline + "assign(lhs,expr) ::= <<$lhs$=$expr$;>>" + this.newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates), DefaultTemplateLexer.class, errors);
        StringTemplate t = group.getInstanceOf("method");
        t.setAttribute("name", "foo");
        StringTemplate s1 = group.getInstanceOf("assign");
        s1.setAttribute("lhs", "x");
        s1.setAttribute("expr", "0");
        StringTemplate s2 = group.getInstanceOf("ifstat");
        s2.setAttribute("expr", "x>0");
        StringTemplate s2a = group.getInstanceOf("assign");
        s2a.setAttribute("lhs", "y");
        s2a.setAttribute("expr", "x+y");
        StringTemplate s2b = group.getInstanceOf("assign");
        s2b.setAttribute("lhs", "z");
        s2b.setAttribute("expr", "4");
        s2.setAttribute("stats", s2a);
        s2.setAttribute("stats", s2b);
        t.setAttribute("stats", s1);
        t.setAttribute("stats", s2);
        String expecting = "void foo() {" + this.newline + "\tx=0;" + this.newline + "\tif (x>0) {" + this.newline + "\t  y=x+y;" + this.newline + "\t  z=4;" + this.newline + "\t}" + this.newline + "}";
        this.assertEqual(t.toString(), expecting);
    }

    public void testAlternativeWriter() throws Exception {
        final StringBuffer buf = new StringBuffer();
        StringTemplateWriter w = new StringTemplateWriter(){

            public void pushIndentation(String indent) {
            }

            public String popIndentation() {
                return null;
            }

            public void pushAnchorPoint() {
            }

            public void popAnchorPoint() {
            }

            public void setLineWidth(int lineWidth) {
            }

            public int write(String str, String wrap) throws IOException {
                return 0;
            }

            public int write(String str) throws IOException {
                buf.append(str);
                return str.length();
            }

            public int writeWrapSeparator(String wrap) throws IOException {
                return 0;
            }

            public int writeSeparator(String str) throws IOException {
                return this.write(str);
            }
        };
        StringTemplateGroup group = new StringTemplateGroup("test");
        group.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate name = new StringTemplate(group, "$name:bold(x=name)$");
        name.setAttribute("name", "Terence");
        name.write(w);
        this.assertEqual(buf.toString(), "<b>Terence</b>");
    }

    public void testApplyAnonymousTemplateToMapAndSet() throws Exception {
        StringTemplate st = new StringTemplate("$items:{<li>$it$</li>}$");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("a", "1");
        m.put("b", "2");
        m.put("c", "3");
        st.setAttribute("items", m);
        String expecting = "<li>1</li><li>3</li><li>2</li>";
        this.assertEqual(st.toString(), expecting);
        st = st.getInstanceOf();
        HashSet<String> s = new HashSet<String>();
        s.add("1");
        s.add("2");
        s.add("3");
        st.setAttribute("items", s);
        expecting = "<li>3</li><li>2</li><li>1</li>";
        this.assertEqual(st.toString(), expecting);
    }

    public void testDumpMapAndSet() throws Exception {
        StringTemplate st = new StringTemplate("$items; separator=\",\"$");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("a", "1");
        m.put("b", "2");
        m.put("c", "3");
        st.setAttribute("items", m);
        String expecting = "1,3,2";
        this.assertEqual(st.toString(), expecting);
        st = st.getInstanceOf();
        HashSet<String> s = new HashSet<String>();
        s.add("1");
        s.add("2");
        s.add("3");
        st.setAttribute("items", s);
        expecting = "3,2,1";
        this.assertEqual(st.toString(), expecting);
    }

    public void testApplyAnonymousTemplateToArrayAndMapProperty() throws Exception {
        StringTemplate st = new StringTemplate("$x.values:{<li>$it$</li>}$");
        st.setAttribute("x", new Connector3());
        String expecting = "<li>1</li><li>2</li><li>3</li>";
        this.assertEqual(st.toString(), expecting);
        st = new StringTemplate("$x.stuff:{<li>$it$</li>}$");
        st.setAttribute("x", new Connector3());
        expecting = "<li>1</li><li>2</li>";
        this.assertEqual(st.toString(), expecting);
    }

    public void testSuperTemplateRef() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("super");
        StringTemplateGroup subGroup = new StringTemplateGroup("sub");
        subGroup.setSuperGroup(group);
        group.defineTemplate("page", "$font()$:text");
        group.defineTemplate("font", "Helvetica");
        subGroup.defineTemplate("font", "$super.font()$ and Times");
        StringTemplate st = subGroup.getInstanceOf("page");
        String expecting = "Helvetica and Times:text";
        this.assertEqual(st.toString(), expecting);
    }

    public void testApplySuperTemplateRef() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("super");
        StringTemplateGroup subGroup = new StringTemplateGroup("sub");
        subGroup.setSuperGroup(group);
        group.defineTemplate("bold", "<b>$it$</b>");
        subGroup.defineTemplate("bold", "<strong>$it$</strong>");
        subGroup.defineTemplate("page", "$name:super.bold()$");
        StringTemplate st = subGroup.getInstanceOf("page");
        st.setAttribute("name", "Ter");
        String expecting = "<b>Ter</b>";
        this.assertEqual(st.toString(), expecting);
    }

    public void testLazyEvalOfSuperInApplySuperTemplateRef() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("base");
        StringTemplateGroup subGroup = new StringTemplateGroup("sub");
        subGroup.setSuperGroup(group);
        group.defineTemplate("bold", "<b>$it$</b>");
        subGroup.defineTemplate("bold", "<strong>$it$</strong>");
        group.defineTemplate("page", "$name:super.bold()$");
        StringTemplate st = subGroup.getInstanceOf("page");
        st.setAttribute("name", "Ter");
        String error = null;
        try {
            st.toString();
        }
        catch (IllegalArgumentException iae) {
            error = iae.getMessage();
        }
        String expectingError = "base has no super group; invalid template: super.bold";
        this.assertEqual(error, expectingError);
    }

    public void testTemplatePolymorphism() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("super");
        StringTemplateGroup subGroup = new StringTemplateGroup("sub");
        subGroup.setSuperGroup(group);
        group.defineTemplate("bold", "<b>$it$</b>");
        group.defineTemplate("page", "$name:bold()$");
        subGroup.defineTemplate("bold", "<strong>$it$</strong>");
        StringTemplate st = subGroup.getInstanceOf("page");
        st.setAttribute("name", "Ter");
        String expecting = "<strong>Ter</strong>";
        this.assertEqual(st.toString(), expecting);
    }

    public void testListOfEmbeddedTemplateSeesEnclosingAttributes() throws Exception {
        String templates = "group test;" + this.newline + "output(cond,items) ::= <<page: $items$>>" + this.newline + "mybody() ::= <<$font()$stuff>>" + this.newline + "font() ::= <<$if(cond)$this$else$that$endif$>>";
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates), DefaultTemplateLexer.class, errors);
        StringTemplate outputST = group.getInstanceOf("output");
        StringTemplate bodyST1 = group.getInstanceOf("mybody");
        StringTemplate bodyST2 = group.getInstanceOf("mybody");
        StringTemplate bodyST3 = group.getInstanceOf("mybody");
        outputST.setAttribute("items", bodyST1);
        outputST.setAttribute("items", bodyST2);
        outputST.setAttribute("items", bodyST3);
        String expecting = "page: thatstuffthatstuffthatstuff";
        this.assertEqual(outputST.toString(), expecting);
    }

    public void testInheritArgumentFromRecursiveTemplateApplication() throws Exception {
        String templates = "group test;" + this.newline + "block(stats) ::= \"<stats>\"" + "ifstat(stats) ::= \"IF true then <stats>\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("block");
        b.setAttribute("stats", group.getInstanceOf("ifstat"));
        b.setAttribute("stats", group.getInstanceOf("ifstat"));
        String expecting = "IF true then IF true then ";
        String result = b.toString();
        this.assertEqual(result, expecting);
    }

    public void testDeliberateRecursiveTemplateApplication() throws Exception {
        String templates = "group test;" + this.newline + "block(stats) ::= \"<stats>\"" + "ifstat(stats) ::= \"IF true then <stats>\"" + this.newline;
        StringTemplate.setLintMode(true);
        StringTemplate.resetTemplateCounter();
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("block");
        StringTemplate ifstat = group.getInstanceOf("ifstat");
        b.setAttribute("stats", ifstat);
        ifstat.setAttribute("stats", b);
        String expectingError = "infinite recursion to <ifstat([stats])@4> referenced in <block([stats])@3>; stack trace:" + this.newline + "<ifstat([stats])@4>, attributes=[stats=<block()@3>]>" + this.newline + "<block([stats])@3>, attributes=[stats=<ifstat()@4>], references=[stats]>" + this.newline + "<ifstat([stats])@4> (start of recursive cycle)" + this.newline + "...";
        String errors = "";
        try {
            String result = b.toString();
        }
        catch (IllegalStateException ise) {
            errors = ise.getMessage();
        }
        StringTemplate.setLintMode(false);
        this.assertEqual(errors, expectingError);
    }

    public void testImmediateTemplateAsAttributeLoop() throws Exception {
        String templates = "group test;" + this.newline + "block(stats) ::= \"{<stats>}\"";
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("block");
        b.setAttribute("stats", group.getInstanceOf("block"));
        String expecting = "{{}}";
        String result = b.toString();
        this.assertEqual(result, expecting);
    }

    public void testTemplateAlias() throws Exception {
        String templates = "group test;" + this.newline + "page(name) ::= \"name is <name>\"" + "other ::= page" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("other");
        b.setAttribute("name", "Ter");
        String expecting = "name is Ter";
        String result = b.toString();
        this.assertEqual(result, expecting);
    }

    public void testTemplateGetPropertyGetsAttribute() throws Exception {
        String templates = "group test;" + this.newline + "Cfile(funcs) ::= <<" + this.newline + "#include \\<stdio.h>" + this.newline + "<funcs:{public void <it.name>(<it.args>);}; separator=\"\\n\">" + this.newline + "<funcs; separator=\"\\n\">" + this.newline + ">>" + this.newline + "func(name,args,body) ::= <<" + this.newline + "public void <name>(<args>) {<body>}" + this.newline + ">>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("Cfile");
        StringTemplate f1 = group.getInstanceOf("func");
        StringTemplate f2 = group.getInstanceOf("func");
        f1.setAttribute("name", "f");
        f1.setAttribute("args", "");
        f1.setAttribute("body", "i=1;");
        f2.setAttribute("name", "g");
        f2.setAttribute("args", "int arg");
        f2.setAttribute("body", "y=1;");
        b.setAttribute("funcs", f1);
        b.setAttribute("funcs", f2);
        String expecting = "#include <stdio.h>" + this.newline + "public void f();" + this.newline + "public void g(int arg);" + this.newline + "public void f() {i=1;}" + this.newline + "public void g(int arg) {y=1;}";
        this.assertEqual(b.toString(), expecting);
    }

    public void testComplicatedIndirectTemplateApplication() throws Exception {
        String templates = "group Java;" + this.newline + "" + this.newline + "file(variables) ::= <<" + "<variables:{ v | <v.decl:(v.format)()>}; separator=\"\\n\">" + this.newline + ">>" + this.newline + "intdecl(decl) ::= \"int <decl.name> = 0;\"" + this.newline + "intarray(decl) ::= \"int[] <decl.name> = null;\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate f = group.getInstanceOf("file");
        f.setAttribute("variables.{decl,format}", new Decl("i", "int"), "intdecl");
        f.setAttribute("variables.{decl,format}", new Decl("a", "int-array"), "intarray");
        String expecting = "int i = 0;" + this.newline + "int[] a = null;";
        this.assertEqual(f.toString(), expecting);
    }

    public void testIndirectTemplateApplication() throws Exception {
        String templates = "group dork;" + this.newline + "" + this.newline + "test(name) ::= <<" + "<(name)()>" + this.newline + ">>" + this.newline + "first() ::= \"the first\"" + this.newline + "second() ::= \"the second\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate f = group.getInstanceOf("test");
        f.setAttribute("name", "first");
        String expecting = "the first";
        this.assertEqual(f.toString(), expecting);
    }

    public void testIndirectTemplateWithArgsApplication() throws Exception {
        String templates = "group dork;" + this.newline + "" + this.newline + "test(name) ::= <<" + "<(name)(a=\"foo\")>" + this.newline + ">>" + this.newline + "first(a) ::= \"the first: <a>\"" + this.newline + "second(a) ::= \"the second <a>\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate f = group.getInstanceOf("test");
        f.setAttribute("name", "first");
        String expecting = "the first: foo";
        this.assertEqual(f.toString(), expecting);
    }

    public void testNullIndirectTemplateApplication() throws Exception {
        String templates = "group dork;" + this.newline + "" + this.newline + "test(names) ::= <<" + "<names:(ind)()>" + this.newline + ">>" + this.newline + "ind() ::= \"[<it>]\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate f = group.getInstanceOf("test");
        f.setAttribute("names", "me");
        f.setAttribute("names", "you");
        String expecting = "";
        this.assertEqual(f.toString(), expecting);
    }

    public void testNullIndirectTemplate() throws Exception {
        String templates = "group dork;" + this.newline + "" + this.newline + "test(name) ::= <<" + "<(name)()>" + this.newline + ">>" + this.newline + "first() ::= \"the first\"" + this.newline + "second() ::= \"the second\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate f = group.getInstanceOf("test");
        String expecting = "";
        this.assertEqual(f.toString(), expecting);
    }

    public void testHashMapPropertyFetch() throws Exception {
        StringTemplate a = new StringTemplate("$stuff.prop$");
        HashMap<String, String> map = new HashMap<String, String>();
        a.setAttribute("stuff", map);
        map.put("prop", "Terence");
        String results = a.toString();
        String expecting = "Terence";
        this.assertEqual(results, expecting);
    }

    public void testHashMapPropertyFetchEmbeddedStringTemplate() throws Exception {
        StringTemplate a = new StringTemplate("$stuff.prop$");
        HashMap<String, StringTemplate> map = new HashMap<String, StringTemplate>();
        a.setAttribute("stuff", map);
        a.setAttribute("title", "ST rocks");
        map.put("prop", new StringTemplate("embedded refers to $title$"));
        String results = a.toString();
        String expecting = "embedded refers to ST rocks";
        this.assertEqual(results, expecting);
    }

    public void testEmbeddedComments() throws Exception {
        StringTemplate st = new StringTemplate("Foo $! ignore !$bar" + this.newline);
        String expecting = "Foo bar" + this.newline;
        String result = st.toString();
        this.assertEqual(result, expecting);
        st = new StringTemplate("Foo $! ignore" + this.newline + " and a line break!$" + this.newline + "bar" + this.newline);
        expecting = "Foo " + this.newline + "bar" + this.newline;
        result = st.toString();
        this.assertEqual(result, expecting);
        st = new StringTemplate("$! start of line $ and $! ick" + this.newline + "!$boo" + this.newline);
        expecting = "boo" + this.newline;
        result = st.toString();
        this.assertEqual(result, expecting);
        st = new StringTemplate("$! start of line !$" + this.newline + "$! another to ignore !$" + this.newline + "$! ick" + this.newline + "!$boo" + this.newline);
        expecting = "boo" + this.newline;
        result = st.toString();
        this.assertEqual(result, expecting);
        st = new StringTemplate("$! back !$$! to back !$" + this.newline + "$! ick" + this.newline + "!$boo" + this.newline);
        expecting = this.newline + "boo" + this.newline;
        result = st.toString();
        this.assertEqual(result, expecting);
    }

    public void testEmbeddedCommentsAngleBracketed() throws Exception {
        StringTemplate st = new StringTemplate("Foo <! ignore !>bar" + this.newline, AngleBracketTemplateLexer.class);
        String expecting = "Foo bar" + this.newline;
        String result = st.toString();
        this.assertEqual(result, expecting);
        st = new StringTemplate("Foo <! ignore" + this.newline + " and a line break!>" + this.newline + "bar" + this.newline, AngleBracketTemplateLexer.class);
        expecting = "Foo " + this.newline + "bar" + this.newline;
        result = st.toString();
        this.assertEqual(result, expecting);
        st = new StringTemplate("<! start of line $ and <! ick" + this.newline + "!>boo" + this.newline, AngleBracketTemplateLexer.class);
        expecting = "boo" + this.newline;
        result = st.toString();
        this.assertEqual(result, expecting);
        st = new StringTemplate("<! start of line !><! another to ignore !><! ick" + this.newline + "!>boo" + this.newline, AngleBracketTemplateLexer.class);
        expecting = "boo" + this.newline;
        result = st.toString();
        this.assertEqual(result, expecting);
        st = new StringTemplate("<! back !><! to back !>" + this.newline + "<! ick" + this.newline + "!>boo" + this.newline, AngleBracketTemplateLexer.class);
        expecting = this.newline + "boo" + this.newline;
        result = st.toString();
        this.assertEqual(result, expecting);
    }

    public void testCharLiterals() throws Exception {
        StringTemplate st = new StringTemplate("Foo <\\n><\\t> bar" + this.newline, AngleBracketTemplateLexer.class);
        String expecting = "Foo " + this.newline + "\t bar" + this.newline;
        String result = st.toString();
        this.assertEqual(result, expecting);
        st = new StringTemplate("Foo $\\n$$\\t$ bar" + this.newline);
        expecting = "Foo " + this.newline + "\t bar" + this.newline;
        result = st.toString();
        this.assertEqual(result, expecting);
        st = new StringTemplate("Foo$\\ $bar$\\n$");
        expecting = "Foo bar" + this.newline;
        result = st.toString();
        this.assertEqual(result, expecting);
    }

    public void testEmptyIteratedValueGetsSeparator() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "$names; separator=\",\"$");
        t.setAttribute("names", "Terence");
        t.setAttribute("names", "");
        t.setAttribute("names", "");
        t.setAttribute("names", "Tom");
        t.setAttribute("names", "Frank");
        t.setAttribute("names", "");
        String expecting = "Terence,,,Tom,Frank,";
        String result = t.toString();
        this.assertEqual(result, expecting);
    }

    public void testEmptyIteratedConditionalValueGetsSeparator() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "$users:{$if(it.ok)$$it.name$$endif$}; separator=\",\"$");
        t.setAttribute("users.{name,ok}", "Terence", new Boolean(true));
        t.setAttribute("users.{name,ok}", "Tom", new Boolean(false));
        t.setAttribute("users.{name,ok}", "Frank", new Boolean(true));
        t.setAttribute("users.{name,ok}", "Johnny", new Boolean(false));
        String expecting = "Terence,,Frank,";
        String result = t.toString();
        this.assertEqual(result, expecting);
    }

    public void testEmptyIteratedConditionalWithElseValueGetsSeparator() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "$users:{$if(it.ok)$$it.name$$else$$endif$}; separator=\",\"$");
        t.setAttribute("users.{name,ok}", "Terence", new Boolean(true));
        t.setAttribute("users.{name,ok}", "Tom", new Boolean(false));
        t.setAttribute("users.{name,ok}", "Frank", new Boolean(true));
        t.setAttribute("users.{name,ok}", "Johnny", new Boolean(false));
        String expecting = "Terence,,Frank,";
        String result = t.toString();
        this.assertEqual(result, expecting);
    }

    public void testWhiteSpaceAtEndOfTemplate() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("group");
        StringTemplate pageST = group.getInstanceOf("org/antlr/stringtemplate/test/page");
        StringTemplate listST = group.getInstanceOf("org/antlr/stringtemplate/test/users_list");
        listST.setAttribute("users", new Connector());
        listST.setAttribute("users", new Connector2());
        pageST.setAttribute("title", "some title");
        pageST.setAttribute("body", listST);
        String expecting = "some title" + this.newline + "Terence parrt@jguru.comTom tombu@jguru.com";
        String result = pageST.toString();
        this.assertEqual(result, expecting);
    }

    public void testSizeZeroButNonNullListGetsNoOutput() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "begin\n$duh.users:{name: $it$}; separator=\", \"$\nend\n");
        t.setAttribute("duh", new Duh());
        String expecting = "begin\nend\n";
        String result = t.toString();
        this.assertEqual(result, expecting);
    }

    public void testNullListGetsNoOutput() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "begin\n$users:{name: $it$}; separator=\", \"$\nend\n");
        String expecting = "begin\nend\n";
        String result = t.toString();
        this.assertEqual(result, expecting);
    }

    public void testEmptyListGetsNoOutput() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "begin\n$users:{name: $it$}; separator=\", \"$\nend\n");
        t.setAttribute("users", new ArrayList());
        String expecting = "begin\nend\n";
        String result = t.toString();
        this.assertEqual(result, expecting);
    }

    public void testEmptyListNoIteratorGetsNoOutput() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "begin\n$users; separator=\", \"$\nend\n");
        t.setAttribute("users", new ArrayList());
        String expecting = "begin\nend\n";
        String result = t.toString();
        this.assertEqual(result, expecting);
    }

    public void testEmptyExprAsFirstLineGetsNoOutput() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate t = new StringTemplate(group, "$users$\nend\n");
        String expecting = "end\n";
        String result = t.toString();
        this.assertEqual(result, expecting);
    }

    public void testSizeZeroOnLineByItselfGetsNoOutput() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "begin\n$name$\n$users:{name: $it$}$\n$users:{name: $it$}; separator=\", \"$\nend\n");
        String expecting = "begin\nend\n";
        String result = t.toString();
        this.assertEqual(result, expecting);
    }

    public void testSizeZeroOnLineWithIndentGetsNoOutput() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "begin\n  $name$\n\t$users:{name: $it$}$\n\t$users:{name: $it$$\\n$}$\nend\n");
        String expecting = "begin\nend\n";
        String result = t.toString();
        this.assertEqual(result, expecting);
    }

    public void testSimpleAutoIndent() throws Exception {
        StringTemplate a = new StringTemplate("$title$: {\n\t$name; separator=\"\n\"$\n}");
        a.setAttribute("title", "foo");
        a.setAttribute("name", "Terence");
        a.setAttribute("name", "Frank");
        String results = a.toString();
        String expecting = "foo: {\n\tTerence\n\tFrank\n}";
        this.assertEqual(results, expecting);
    }

    public void testComputedPropertyName() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "variable property $propName$=$v.(propName)$");
        t.setAttribute("v", new Decl("i", "int"));
        t.setAttribute("propName", "type");
        String expecting = "variable property type=int";
        String result = t.toString();
        this.assertEqual(((Object)errors).toString(), "");
        this.assertEqual(result, expecting);
    }

    public void testNonNullButEmptyIteratorTestsFalse() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate t = new StringTemplate(group, "$if(users)$\nUsers: $users:{$it.name$ }$\n$endif$");
        t.setAttribute("users", new LinkedList());
        String expecting = "";
        String result = t.toString();
        this.assertEqual(result, expecting);
    }

    public void testDoNotInheritAttributesThroughFormalArgs() throws Exception {
        String templates = "group test;" + this.newline + "method(name) ::= \"<stat()>\"" + this.newline + "stat(name) ::= \"x=y; // <name>\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("method");
        b.setAttribute("name", "foo");
        String expecting = "x=y; // ";
        String result = b.toString();
        this.assertEqual(result, expecting);
    }

    public void testArgEvaluationContext() throws Exception {
        String templates = "group test;" + this.newline + "method(name) ::= \"<stat(name=name)>\"" + this.newline + "stat(name) ::= \"x=y; // <name>\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("method");
        b.setAttribute("name", "foo");
        String expecting = "x=y; // foo";
        String result = b.toString();
        this.assertEqual(result, expecting);
    }

    public void testPassThroughAttributes() throws Exception {
        String templates = "group test;" + this.newline + "method(name) ::= \"<stat(...)>\"" + this.newline + "stat(name) ::= \"x=y; // <name>\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("method");
        b.setAttribute("name", "foo");
        String expecting = "x=y; // foo";
        String result = b.toString();
        this.assertEqual(result, expecting);
    }

    public void testPassThroughAttributes2() throws Exception {
        String templates = "group test;" + this.newline + "method(name) ::= <<" + this.newline + "<stat(value=\"34\",...)>" + this.newline + ">>" + this.newline + "stat(name,value) ::= \"x=<value>; // <name>\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("method");
        b.setAttribute("name", "foo");
        String expecting = "x=34; // foo";
        String result = b.toString();
        this.assertEqual(result, expecting);
    }

    public void testDefaultArgument() throws Exception {
        String templates = "group test;" + this.newline + "method(name) ::= <<" + this.newline + "<stat(...)>" + this.newline + ">>" + this.newline + "stat(name,value=\"99\") ::= \"x=<value>; // <name>\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("method");
        b.setAttribute("name", "foo");
        String expecting = "x=99; // foo";
        String result = b.toString();
        this.assertEqual(result, expecting);
    }

    public void testDefaultArgument2() throws Exception {
        String templates = "group test;" + this.newline + "stat(name,value=\"99\") ::= \"x=<value>; // <name>\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("stat");
        b.setAttribute("name", "foo");
        String expecting = "x=99; // foo";
        String result = b.toString();
        this.assertEqual(result, expecting);
    }

    public void testDefaultArgumentAsTemplate() throws Exception {
        String templates = "group test;" + this.newline + "method(name,size) ::= <<" + this.newline + "<stat(...)>" + this.newline + ">>" + this.newline + "stat(name,value={<name>}) ::= \"x=<value>; // <name>\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("method");
        b.setAttribute("name", "foo");
        b.setAttribute("size", "2");
        String expecting = "x=foo; // foo";
        String result = b.toString();
        this.assertEqual(result, expecting);
    }

    public void testDefaultArgumentAsTemplate2() throws Exception {
        String templates = "group test;" + this.newline + "method(name,size) ::= <<" + this.newline + "<stat(...)>" + this.newline + ">>" + this.newline + "stat(name,value={ [<name>] }) ::= \"x=<value>; // <name>\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("method");
        b.setAttribute("name", "foo");
        b.setAttribute("size", "2");
        String expecting = "x= [foo] ; // foo";
        String result = b.toString();
        this.assertEqual(result, expecting);
    }

    public void testDoNotUseDefaultArgument() throws Exception {
        String templates = "group test;" + this.newline + "method(name) ::= <<" + this.newline + "<stat(value=\"34\",...)>" + this.newline + ">>" + this.newline + "stat(name,value=\"99\") ::= \"x=<value>; // <name>\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("method");
        b.setAttribute("name", "foo");
        String expecting = "x=34; // foo";
        String result = b.toString();
        this.assertEqual(result, expecting);
    }

    public void testArgumentsAsTemplates() throws Exception {
        String templates = "group test;" + this.newline + "method(name,size) ::= <<" + this.newline + "<stat(value={<size>})>" + this.newline + ">>" + this.newline + "stat(value) ::= \"x=<value>;\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("method");
        b.setAttribute("name", "foo");
        b.setAttribute("size", "34");
        String expecting = "x=34;";
        String result = b.toString();
        this.assertEqual(result, expecting);
    }

    public void testArgumentsAsTemplatesDefaultDelimiters() throws Exception {
        String templates = "group test;" + this.newline + "method(name,size) ::= <<" + this.newline + "$stat(value={$size$})$" + this.newline + ">>" + this.newline + "stat(value) ::= \"x=$value$;\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate b = group.getInstanceOf("method");
        b.setAttribute("name", "foo");
        b.setAttribute("size", "34");
        String expecting = "x=34;";
        String result = b.toString();
        this.assertEqual(result, expecting);
    }

    public void testDefaultArgsWhenNotInvoked() throws Exception {
        String templates = "group test;" + this.newline + "b(name=\"foo\") ::= \".<name>.\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("b");
        String expecting = ".foo.";
        String result = b.toString();
        this.assertEqual(result, expecting);
    }

    public void testRendererForST() throws Exception {
        StringTemplate st = new StringTemplate("date: <created>", AngleBracketTemplateLexer.class);
        st.setAttribute("created", new GregorianCalendar(2005, 6, 5));
        st.registerRenderer(GregorianCalendar.class, new DateRenderer());
        String expecting = "date: 2005.07.05";
        String result = st.toString();
        this.assertEqual(result, expecting);
    }

    public void testEmbeddedRendererSeesEnclosing() throws Exception {
        StringTemplate outer = new StringTemplate("X: <x>", AngleBracketTemplateLexer.class);
        StringTemplate st = new StringTemplate("date: <created>", AngleBracketTemplateLexer.class);
        st.setAttribute("created", new GregorianCalendar(2005, 6, 5));
        outer.setAttribute("x", st);
        outer.registerRenderer(GregorianCalendar.class, new DateRenderer());
        String expecting = "X: date: 2005.07.05";
        String result = outer.toString();
        this.assertEqual(result, expecting);
    }

    public void testRendererForGroup() throws Exception {
        String templates = "group test;" + this.newline + "dateThing(created) ::= \"date: <created>\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("dateThing");
        st.setAttribute("created", new GregorianCalendar(2005, 6, 5));
        group.registerRenderer(GregorianCalendar.class, new DateRenderer());
        String expecting = "date: 2005.07.05";
        String result = st.toString();
        this.assertEqual(result, expecting);
    }

    public void testOverriddenRenderer() throws Exception {
        String templates = "group test;" + this.newline + "dateThing(created) ::= \"date: <created>\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("dateThing");
        st.setAttribute("created", new GregorianCalendar(2005, 6, 5));
        group.registerRenderer(GregorianCalendar.class, new DateRenderer());
        st.registerRenderer(GregorianCalendar.class, new DateRenderer2());
        String expecting = "date: 07/05/2005";
        String result = st.toString();
        this.assertEqual(result, expecting);
    }

    public void testMap() throws Exception {
        String templates = "group test;" + this.newline + "typeInit ::= [\"int\":\"0\", \"float\":\"0.0\"] " + this.newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("var");
        st.setAttribute("type", "int");
        st.setAttribute("name", "x");
        String expecting = "int x = 0;";
        String result = st.toString();
        this.assertEqual(result, expecting);
    }

    public void testMapValuesAreTemplates() throws Exception {
        String templates = "group test;" + this.newline + "typeInit ::= [\"int\":\"0<w>\", \"float\":\"0.0<w>\"] " + this.newline + "var(type,w,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("var");
        st.setAttribute("w", "L");
        st.setAttribute("type", "int");
        st.setAttribute("name", "x");
        String expecting = "int x = 0L;";
        String result = st.toString();
        this.assertEqual(result, expecting);
    }

    public void testMapMissingDefaultValueIsEmpty() throws Exception {
        String templates = "group test;" + this.newline + "typeInit ::= [\"int\":\"0\", \"float\":\"0.0\"] " + this.newline + "var(type,w,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("var");
        st.setAttribute("w", "L");
        st.setAttribute("type", "double");
        st.setAttribute("name", "x");
        String expecting = "double x = ;";
        String result = st.toString();
        this.assertEqual(result, expecting);
    }

    public void testMapHiddenByFormalArg() throws Exception {
        String templates = "group test;" + this.newline + "typeInit ::= [\"int\":\"0\", \"float\":\"0.0\"] " + this.newline + "var(typeInit,type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("var");
        st.setAttribute("type", "int");
        st.setAttribute("name", "x");
        String expecting = "int x = ;";
        String result = st.toString();
        this.assertEqual(result, expecting);
    }

    public void testMapEmptyValueAndAngleBracketStrings() throws Exception {
        String templates = "group test;" + this.newline + "typeInit ::= [\"int\":\"0\", \"float\":, \"double\":<<0.0L>>] " + this.newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("var");
        st.setAttribute("type", "float");
        st.setAttribute("name", "x");
        String expecting = "float x = ;";
        String result = st.toString();
        this.assertEqual(result, expecting);
    }

    public void testMapDefaultValue() throws Exception {
        String templates = "group test;" + this.newline + "typeInit ::= [\"int\":\"0\", \"default\":\"null\"] " + this.newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("var");
        st.setAttribute("type", "UserRecord");
        st.setAttribute("name", "x");
        String expecting = "UserRecord x = null;";
        String result = st.toString();
        this.assertEqual(result, expecting);
    }

    public void testMapEmptyDefaultValue() throws Exception {
        String templates = "group test;" + this.newline + "typeInit ::= [\"int\":\"0\", \"default\":] " + this.newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("var");
        st.setAttribute("type", "UserRecord");
        st.setAttribute("name", "x");
        String expecting = "UserRecord x = ;";
        String result = st.toString();
        this.assertEqual(result, expecting);
    }

    public void testMapEmptyDefaultValueIsKey() throws Exception {
        String templates = "group test;" + this.newline + "typeInit ::= [\"int\":\"0\", \"default\":key] " + this.newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("var");
        st.setAttribute("type", "UserRecord");
        st.setAttribute("name", "x");
        String expecting = "UserRecord x = UserRecord;";
        String result = st.toString();
        this.assertEqual(result, expecting);
    }

    public void testMapViaEnclosingTemplates() throws Exception {
        String templates = "group test;" + this.newline + "typeInit ::= [\"int\":\"0\", \"float\":\"0.0\"] " + this.newline + "intermediate(type,name) ::= \"<var(...)>\"" + this.newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("intermediate");
        st.setAttribute("type", "int");
        st.setAttribute("name", "x");
        String expecting = "int x = 0;";
        String result = st.toString();
        this.assertEqual(result, expecting);
    }

    public void testMapViaEnclosingTemplates2() throws Exception {
        String templates = "group test;" + this.newline + "typeInit ::= [\"int\":\"0\", \"float\":\"0.0\"] " + this.newline + "intermediate(stuff) ::= \"<stuff>\"" + this.newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate interm = group.getInstanceOf("intermediate");
        StringTemplate var = group.getInstanceOf("var");
        var.setAttribute("type", "int");
        var.setAttribute("name", "x");
        interm.setAttribute("stuff", var);
        String expecting = "int x = 0;";
        String result = interm.toString();
        this.assertEqual(result, expecting);
    }

    public void testEmptyGroupTemplate() throws Exception {
        String templates = "group test;" + this.newline + "foo() ::= \"\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("foo");
        String expecting = "";
        String result = a.toString();
        this.assertEqual(result, expecting);
    }

    public void testEmptyStringAndEmptyAnonTemplateAsParameterUsingAngleBracketLexer() throws Exception {
        String templates = "group test;" + this.newline + "top() ::= <<<x(a=\"\", b={})\\>>>" + this.newline + "x(a,b) ::= \"a=<a>, b=<b>\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("top");
        String expecting = "a=, b=";
        String result = a.toString();
        this.assertEqual(result, expecting);
    }

    public void testEmptyStringAndEmptyAnonTemplateAsParameterUsingDollarLexer() throws Exception {
        String templates = "group test;" + this.newline + "top() ::= <<$x(a=\"\", b={})$>>" + this.newline + "x(a,b) ::= \"a=$a$, b=$b$\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate a = group.getInstanceOf("top");
        String expecting = "a=, b=";
        String result = a.toString();
        this.assertEqual(result, expecting);
    }

    public void test8BitEuroChars() throws Exception {
        StringTemplate e = new StringTemplate("Danish: \u00c5 char");
        e = e.getInstanceOf();
        String expecting = "Danish: \u00c5 char";
        this.assertEqual(e.toString(), expecting);
    }

    public void testFirstOp() throws Exception {
        StringTemplate e = new StringTemplate("$first(names)$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("names", "Sriram");
        String expecting = "Ter";
        this.assertEqual(e.toString(), expecting);
    }

    public void testRestOp() throws Exception {
        StringTemplate e = new StringTemplate("$rest(names); separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("names", "Sriram");
        String expecting = "Tom, Sriram";
        this.assertEqual(e.toString(), expecting);
    }

    public void testLastOp() throws Exception {
        StringTemplate e = new StringTemplate("$last(names)$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("names", "Sriram");
        String expecting = "Sriram";
        this.assertEqual(e.toString(), expecting);
    }

    public void testCombinedOp() throws Exception {
        StringTemplate e = new StringTemplate("$[first(mine),rest(yours)]; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("mine", "1");
        e.setAttribute("mine", "2");
        e.setAttribute("mine", "3");
        e.setAttribute("yours", "a");
        e.setAttribute("yours", "b");
        String expecting = "1, b";
        this.assertEqual(e.toString(), expecting);
    }

    public void testCatListAndSingleAttribute() throws Exception {
        StringTemplate e = new StringTemplate("$[mine,yours]; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("mine", "1");
        e.setAttribute("mine", "2");
        e.setAttribute("mine", "3");
        e.setAttribute("yours", "a");
        String expecting = "1, 2, 3, a";
        this.assertEqual(e.toString(), expecting);
    }

    public void testCatListAndEmptyAttributes() throws Exception {
        StringTemplate e = new StringTemplate("$[x,mine,y,yours,z]; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("mine", "1");
        e.setAttribute("mine", "2");
        e.setAttribute("mine", "3");
        e.setAttribute("yours", "a");
        String expecting = "1, 2, 3, a";
        this.assertEqual(e.toString(), expecting);
    }

    public void testNestedOp() throws Exception {
        StringTemplate e = new StringTemplate("$first(rest(names))$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("names", "Sriram");
        String expecting = "Tom";
        this.assertEqual(e.toString(), expecting);
    }

    public void testFirstWithOneAttributeOp() throws Exception {
        StringTemplate e = new StringTemplate("$first(names)$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        String expecting = "Ter";
        this.assertEqual(e.toString(), expecting);
    }

    public void testLastWithOneAttributeOp() throws Exception {
        StringTemplate e = new StringTemplate("$last(names)$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        String expecting = "Ter";
        this.assertEqual(e.toString(), expecting);
    }

    public void testLastWithLengthOneListAttributeOp() throws Exception {
        StringTemplate e = new StringTemplate("$last(names)$");
        e = e.getInstanceOf();
        e.setAttribute("names", new ArrayList(){
            {
                this.add("Ter");
            }
        });
        String expecting = "Ter";
        this.assertEqual(e.toString(), expecting);
    }

    public void testRestWithOneAttributeOp() throws Exception {
        StringTemplate e = new StringTemplate("$rest(names)$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        String expecting = "";
        this.assertEqual(e.toString(), expecting);
    }

    public void testRestWithLengthOneListAttributeOp() throws Exception {
        StringTemplate e = new StringTemplate("$rest(names)$");
        e = e.getInstanceOf();
        e.setAttribute("names", new ArrayList(){
            {
                this.add("Ter");
            }
        });
        String expecting = "";
        this.assertEqual(e.toString(), expecting);
    }

    public void testRepeatedRestOp() throws Exception {
        StringTemplate e = new StringTemplate("$rest(names)$, $rest(names)$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        String expecting = "Tom, Tom";
        this.assertEqual(e.toString(), expecting);
    }

    public void testRepeatedRestOpAsArg() throws Exception {
        String templates = "group test;" + this.newline + "root(names) ::= \"$other(rest(names))$\"" + this.newline + "other(x) ::= \"$x$, $x$\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate e = group.getInstanceOf("root");
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        String expecting = "Tom, Tom";
        this.assertEqual(e.toString(), expecting);
    }

    public void testIncomingLists() throws Exception {
        StringTemplate e = new StringTemplate("$rest(names)$, $rest(names)$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        String expecting = "Tom, Tom";
        this.assertEqual(e.toString(), expecting);
    }

    public void testIncomingListsAreNotModified() throws Exception {
        StringTemplate e = new StringTemplate("$names; separator=\", \"$");
        e = e.getInstanceOf();
        ArrayList<String> names = new ArrayList<String>();
        names.add("Ter");
        names.add("Tom");
        e.setAttribute("names", names);
        e.setAttribute("names", "Sriram");
        String expecting = "Ter, Tom, Sriram";
        this.assertEqual(e.toString(), expecting);
        this.assertEqual(names.size(), 2);
    }

    public void testIncomingListsAreNotModified2() throws Exception {
        StringTemplate e = new StringTemplate("$names; separator=\", \"$");
        e = e.getInstanceOf();
        ArrayList<String> names = new ArrayList<String>();
        names.add("Ter");
        names.add("Tom");
        e.setAttribute("names", "Sriram");
        e.setAttribute("names", names);
        String expecting = "Sriram, Ter, Tom";
        this.assertEqual(e.toString(), expecting);
        this.assertEqual(names.size(), 2);
    }

    public void testIncomingArraysAreOk() throws Exception {
        StringTemplate e = new StringTemplate("$names; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("names", (Object)new String[]{"Ter", "Tom"});
        e.setAttribute("names", "Sriram");
        String expecting = "Ter, Tom, Sriram";
        this.assertEqual(e.toString(), expecting);
    }

    public void testApplyTemplateWithSingleFormalArgs() throws Exception {
        String templates = "group test;" + this.newline + "test(names) ::= <<<names:bold(item=it); separator=\", \"> >>" + this.newline + "bold(item) ::= <<*<item>*>>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate e = group.getInstanceOf("test");
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        String expecting = "*Ter*, *Tom* ";
        String result = e.toString();
        this.assertEqual(result, expecting);
    }

    public void testApplyTemplateWithNoFormalArgs() throws Exception {
        String templates = "group test;" + this.newline + "test(names) ::= <<<names:bold(); separator=\", \"> >>" + this.newline + "bold() ::= <<*<it>*>>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), AngleBracketTemplateLexer.class);
        StringTemplate e = group.getInstanceOf("test");
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        String expecting = "*Ter*, *Tom* ";
        String result = e.toString();
        this.assertEqual(result, expecting);
    }

    public void testAnonTemplateArgs() throws Exception {
        StringTemplate e = new StringTemplate("$names:{n| $n$}; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        String expecting = "Ter, Tom";
        this.assertEqual(e.toString(), expecting);
    }

    public void testAnonTemplateWithArgHasNoITArg() throws Exception {
        StringTemplate e = new StringTemplate("$names:{n| $n$:$it$}; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        String error = null;
        try {
            e.toString();
        }
        catch (NoSuchElementException nse) {
            error = nse.getMessage();
        }
        String expecting = "no such attribute: it in template context [anonymous anonymous]";
        this.assertEqual(error, expecting);
    }

    public void testAnonTemplateArgs2() throws Exception {
        StringTemplate e = new StringTemplate("$names:{n| .$n$.}:{ n | _$n$_}; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        String expecting = "_.Ter._, _.Tom._";
        this.assertEqual(e.toString(), expecting);
    }

    public void testFirstWithCatAttribute() throws Exception {
        StringTemplate e = new StringTemplate("$first([names,phones])$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("phones", "1");
        e.setAttribute("phones", "2");
        String expecting = "Ter";
        this.assertEqual(e.toString(), expecting);
    }

    public void testJustCat() throws Exception {
        StringTemplate e = new StringTemplate("$[names,phones]$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("phones", "1");
        e.setAttribute("phones", "2");
        String expecting = "TerTom12";
        this.assertEqual(e.toString(), expecting);
    }

    public void testCat2Attributes() throws Exception {
        StringTemplate e = new StringTemplate("$[names,phones]; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("phones", "1");
        e.setAttribute("phones", "2");
        String expecting = "Ter, Tom, 1, 2";
        this.assertEqual(e.toString(), expecting);
    }

    public void testCat2AttributesWithApply() throws Exception {
        StringTemplate e = new StringTemplate("$[names,phones]:{a|$a$.}$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("phones", "1");
        e.setAttribute("phones", "2");
        String expecting = "Ter.Tom.1.2.";
        this.assertEqual(e.toString(), expecting);
    }

    public void testCat3Attributes() throws Exception {
        StringTemplate e = new StringTemplate("$[names,phones,salaries]; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("phones", "1");
        e.setAttribute("phones", "2");
        e.setAttribute("salaries", "big");
        e.setAttribute("salaries", "huge");
        String expecting = "Ter, Tom, 1, 2, big, huge";
        this.assertEqual(e.toString(), expecting);
    }

    public void testListAsTemplateArgument() throws Exception {
        String templates = "group test;" + this.newline + "test(names,phones) ::= \"<foo([names,phones])>\"" + this.newline + "foo(items) ::= \"<items:{a | *<a>*}>\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), AngleBracketTemplateLexer.class);
        StringTemplate e = group.getInstanceOf("test");
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("phones", "1");
        e.setAttribute("phones", "2");
        String expecting = "*Ter**Tom**1**2*";
        String result = e.toString();
        this.assertEqual(result, expecting);
    }

    public void testSingleExprTemplateArgument() throws Exception {
        String templates = "group test;" + this.newline + "test(name) ::= \"<bold(name)>\"" + this.newline + "bold(item) ::= \"*<item>*\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), AngleBracketTemplateLexer.class);
        StringTemplate e = group.getInstanceOf("test");
        e.setAttribute("name", "Ter");
        String expecting = "*Ter*";
        String result = e.toString();
        this.assertEqual(result, expecting);
    }

    public void testSingleExprTemplateArgumentInApply() throws Exception {
        String templates = "group test;" + this.newline + "test(names,x) ::= \"<names:bold(x)>\"" + this.newline + "bold(item) ::= \"*<item>*\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), AngleBracketTemplateLexer.class);
        StringTemplate e = group.getInstanceOf("test");
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("x", "ick");
        String expecting = "*ick**ick*";
        String result = e.toString();
        this.assertEqual(result, expecting);
    }

    public void testSoleFormalTemplateArgumentInMultiApply() throws Exception {
        String templates = "group test;" + this.newline + "test(names) ::= \"<names:bold(),italics()>\"" + this.newline + "bold(x) ::= \"*<x>*\"" + this.newline + "italics(y) ::= \"_<y>_\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), AngleBracketTemplateLexer.class);
        StringTemplate e = group.getInstanceOf("test");
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        String expecting = "*Ter*_Tom_";
        String result = e.toString();
        this.assertEqual(result, expecting);
    }

    public void testSingleExprTemplateArgumentError() throws Exception {
        String templates = "group test;" + this.newline + "test(name) ::= \"<bold(name)>\"" + this.newline + "bold(item,ick) ::= \"*<item>*\"" + this.newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates), AngleBracketTemplateLexer.class, errors);
        StringTemplate e = group.getInstanceOf("test");
        e.setAttribute("name", "Ter");
        String result = e.toString();
        String expecting = "template bold must have exactly one formal arg in template context [test <invoke bold arg context>]";
        this.assertEqual(((Object)errors).toString(), expecting);
    }

    public void testInvokeIndirectTemplateWithSingleFormalArgs() throws Exception {
        String templates = "group test;" + this.newline + "test(templateName,arg) ::= \"<(templateName)(arg)>\"" + this.newline + "bold(x) ::= <<*<x>*>>" + this.newline + "italics(y) ::= <<_<y>_>>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate e = group.getInstanceOf("test");
        e.setAttribute("templateName", "italics");
        e.setAttribute("arg", "Ter");
        String expecting = "_Ter_";
        String result = e.toString();
        this.assertEqual(result, expecting);
    }

    public void testParallelAttributeIteration() throws Exception {
        StringTemplate e = new StringTemplate("$names,phones,salaries:{n,p,s | $n$@$p$: $s$\n}$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("phones", "1");
        e.setAttribute("phones", "2");
        e.setAttribute("salaries", "big");
        e.setAttribute("salaries", "huge");
        String expecting = "Ter@1: big" + this.newline + "Tom@2: huge" + this.newline;
        this.assertEqual(e.toString(), expecting);
    }

    public void testParallelAttributeIterationHasI() throws Exception {
        StringTemplate e = new StringTemplate("$names,phones,salaries:{n,p,s | $i0$. $n$@$p$: $s$\n}$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("phones", "1");
        e.setAttribute("phones", "2");
        e.setAttribute("salaries", "big");
        e.setAttribute("salaries", "huge");
        String expecting = "0. Ter@1: big" + this.newline + "1. Tom@2: huge" + this.newline;
        this.assertEqual(e.toString(), expecting);
    }

    public void testParallelAttributeIterationWithDifferentSizes() throws Exception {
        StringTemplate e = new StringTemplate("$names,phones,salaries:{n,p,s | $n$@$p$: $s$}; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("names", "Sriram");
        e.setAttribute("phones", "1");
        e.setAttribute("phones", "2");
        e.setAttribute("salaries", "big");
        String expecting = "Ter@1: big, Tom@2: , Sriram@: ";
        this.assertEqual(e.toString(), expecting);
    }

    public void testParallelAttributeIterationWithSingletons() throws Exception {
        StringTemplate e = new StringTemplate("$names,phones,salaries:{n,p,s | $n$@$p$: $s$}; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("phones", "1");
        e.setAttribute("salaries", "big");
        String expecting = "Ter@1: big";
        this.assertEqual(e.toString(), expecting);
    }

    public void testParallelAttributeIterationWithMismatchArgListSizes() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplate e = new StringTemplate("$names,phones,salaries:{n,p | $n$@$p$}; separator=\", \"$");
        e.setErrorListener(errors);
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("phones", "1");
        e.setAttribute("phones", "2");
        e.setAttribute("salaries", "big");
        String expecting = "Ter@1, Tom@2";
        this.assertEqual(e.toString(), expecting);
        String errorExpecting = "number of arguments [n, p] mismatch between attribute list and anonymous template in context [anonymous]";
        this.assertEqual(((Object)errors).toString(), errorExpecting);
    }

    public void testParallelAttributeIterationWithMissingArgs() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplate e = new StringTemplate("$names,phones,salaries:{$n$@$p$}; separator=\", \"$");
        e.setErrorListener(errors);
        e = e.getInstanceOf();
        e.setAttribute("names", "Tom");
        e.setAttribute("phones", "2");
        e.setAttribute("salaries", "big");
        e.toString();
        String errorExpecting = "missing arguments in anonymous template in context [anonymous]";
        this.assertEqual(((Object)errors).toString(), errorExpecting);
    }

    public void testParallelAttributeIterationWithDifferentSizesTemplateRefInsideToo() throws Exception {
        String templates = "group test;" + this.newline + "page(names,phones,salaries) ::= " + this.newline + "\t<<$names,phones,salaries:{n,p,s | $value(n)$@$value(p)$: $value(s)$}; separator=\", \"$>>" + this.newline + "value(x=\"n/a\") ::= \"$x$\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate p = group.getInstanceOf("page");
        p.setAttribute("names", "Ter");
        p.setAttribute("names", "Tom");
        p.setAttribute("names", "Sriram");
        p.setAttribute("phones", "1");
        p.setAttribute("phones", "2");
        p.setAttribute("salaries", "big");
        String expecting = "Ter@1: big, Tom@2: n/a, Sriram@n/a: n/a";
        this.assertEqual(p.toString(), expecting);
    }

    public void testAnonTemplateOnLeftOfApply() throws Exception {
        StringTemplate e = new StringTemplate("${foo}:{($it$)}$");
        String expecting = "(foo)";
        this.assertEqual(e.toString(), expecting);
    }

    public void testOverrideThroughConditional() throws Exception {
        String templates = "group base;" + this.newline + "body(ick) ::= \"<if(ick)>ick<f()><else><f()><endif>\"" + "f() ::= \"foo\"" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        String templates2 = "group sub;" + this.newline + "f() ::= \"bar\"" + this.newline;
        StringTemplateGroup subgroup = new StringTemplateGroup(new StringReader(templates2), AngleBracketTemplateLexer.class, null, group);
        StringTemplate b = subgroup.getInstanceOf("body");
        String expecting = "bar";
        String result = b.toString();
        this.assertEqual(result, expecting);
    }

    public void testNonPublicPropertyAccess() throws Exception {
        StringTemplate st = new StringTemplate("$x.foo$:$x.bar$");
        Object o = new Object(){
            public int foo = 9;

            public int getBar() {
                return 34;
            }
        };
        st.setAttribute("x", o);
        String expecting = "9:34";
        this.assertEqual(st.toString(), expecting);
    }

    public void testIndexVar() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        String newline = System.getProperty("line.separator");
        StringTemplate t = new StringTemplate(group, "$A:{$i$. $it$}; separator=\"\\n\"$");
        t.setAttribute("A", "parrt");
        t.setAttribute("A", "tombu");
        String expecting = "1. parrt" + newline + "2. tombu";
        this.assertEqual(t.toString(), expecting);
    }

    public void testIndex0Var() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        String newline = System.getProperty("line.separator");
        StringTemplate t = new StringTemplate(group, "$A:{$i0$. $it$}; separator=\"\\n\"$");
        t.setAttribute("A", "parrt");
        t.setAttribute("A", "tombu");
        String expecting = "0. parrt" + newline + "1. tombu";
        this.assertEqual(t.toString(), expecting);
    }

    public void testIndexVarWithMultipleExprs() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        String newline = System.getProperty("line.separator");
        StringTemplate t = new StringTemplate(group, "$A,B:{a,b|$i$. $a$@$b$}; separator=\"\\n\"$");
        t.setAttribute("A", "parrt");
        t.setAttribute("A", "tombu");
        t.setAttribute("B", "x5707");
        t.setAttribute("B", "x5000");
        String expecting = "1. parrt@x5707" + newline + "2. tombu@x5000";
        this.assertEqual(t.toString(), expecting);
    }

    public void testIndex0VarWithMultipleExprs() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        String newline = System.getProperty("line.separator");
        StringTemplate t = new StringTemplate(group, "$A,B:{a,b|$i0$. $a$@$b$}; separator=\"\\n\"$");
        t.setAttribute("A", "parrt");
        t.setAttribute("A", "tombu");
        t.setAttribute("B", "x5707");
        t.setAttribute("B", "x5000");
        String expecting = "0. parrt@x5707" + newline + "1. tombu@x5000";
        this.assertEqual(t.toString(), expecting);
    }

    public void testArgumentContext() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate main = group.defineTemplate("main", "$foo(t={Hi, $name$}, name=\"parrt\")$");
        StringTemplate foo = group.defineTemplate("foo", "$t$");
        String expecting = "Hi, parrt";
        this.assertEqual(main.toString(), expecting);
    }

    public void testNoDotsInAttributeNames() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate t = new StringTemplate(group, "$user.Name$");
        String error = null;
        try {
            t.setAttribute("user.Name", "Kunle");
        }
        catch (IllegalArgumentException e) {
            error = e.getMessage();
        }
        String expecting = "cannot have '.' in attribute names";
        this.assertEqual(error, expecting);
    }

    public void testNoDotsInTemplateNames() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        String templates = "group test;" + this.newline + "a.b() ::= <<foo>>" + this.newline;
        Object error = null;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates), DefaultTemplateLexer.class, errors);
        String expecting = "template group parse error: line 2:1: unexpected token:";
        this.assertTrue(((Object)errors).toString().startsWith(expecting));
    }

    public void testLineWrap() throws Exception {
        String templates = "group test;" + this.newline + "array(values) ::= <<int[] a = { <values; anchor, wrap=\"\\n\", separator=\",\"> };>>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("array");
        a.setAttribute("values", (Object)new int[]{3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 2, 1, 6, 32, 5, 6, 77, 4, 9, 20, 2, 1, 4, 63, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 6, 32, 5, 6, 77, 3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 1, 6, 32, 5});
        String expecting = "int[] a = { 3,9,20,2,1,4,6,32,5,6,77,888,\n            2,1,6,32,5,6,77,4,9,20,2,1,4,\n            63,9,20,2,1,4,6,32,5,6,77,6,\n            32,5,6,77,3,9,20,2,1,4,6,32,\n            5,6,77,888,1,6,32,5 };";
        this.assertEqual(a.toString(40), expecting);
    }

    public void testFortranLineWrap() throws Exception {
        String templates = "group test;" + this.newline + "func(args) ::= <<       FUNCTION line( <args; wrap=\"\\n      c\", separator=\",\"> )\\>>>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("func");
        a.setAttribute("args", (Object)new String[]{"a", "b", "c", "d", "e", "f"});
        String expecting = "       FUNCTION line( a,b,c,d,\n      ce,f )>";
        this.assertEqual(a.toString(30), expecting);
    }

    public void testLineWrapWithDiffAnchor() throws Exception {
        String templates = "group test;" + this.newline + "array(values) ::= <<int[] a = { <{1,9,2,<values; wrap, separator=\",\">}; anchor> };>>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("array");
        a.setAttribute("values", (Object)new int[]{3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 2, 1, 6, 32, 5, 6, 77, 4, 9, 20, 2, 1, 4, 63, 9, 20, 2, 1, 4, 6});
        String expecting = "int[] a = { 1,9,2,3,9,20,2,1,4,\n            6,32,5,6,77,888,2,\n            1,6,32,5,6,77,4,9,\n            20,2,1,4,63,9,20,2,\n            1,4,6 };";
        this.assertEqual(a.toString(30), expecting);
    }

    public void testLineWrapEdgeCase() throws Exception {
        String templates = "group test;" + this.newline + "duh(chars) ::= <<<chars; wrap=\"\\n\"\\>>>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("duh");
        a.setAttribute("chars", (Object)new String[]{"a", "b", "c", "d", "e"});
        String expecting = "abc\nde";
        this.assertEqual(a.toString(3), expecting);
    }

    public void testLineWrapLastCharIsNewline() throws Exception {
        String templates = "group test;" + this.newline + "duh(chars) ::= <<<chars; wrap=\"\\n\"\\>>>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("duh");
        a.setAttribute("chars", (Object)new String[]{"a", "b", "\n", "d", "e"});
        String expecting = "ab\nde";
        this.assertEqual(a.toString(3), expecting);
    }

    public void testLineWrapCharAfterWrapIsNewline() throws Exception {
        String templates = "group test;" + this.newline + "duh(chars) ::= <<<chars; wrap=\"\\n\"\\>>>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("duh");
        a.setAttribute("chars", (Object)new String[]{"a", "b", "c", "\n", "d", "e"});
        String expecting = "abc\n\nde";
        this.assertEqual(a.toString(3), expecting);
    }

    public void testLineWrapForAnonTemplate() throws Exception {
        String templates = "group test;" + this.newline + "duh(data) ::= <<!<data:{v|[<v>]}; wrap>!>>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("duh");
        a.setAttribute("data", (Object)new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        String expecting = "![1][2][3]\n[4][5][6]\n[7][8][9]!";
        this.assertEqual(a.toString(9), expecting);
    }

    public void testLineWrapForAnonTemplateAnchored() throws Exception {
        String templates = "group test;" + this.newline + "duh(data) ::= <<!<data:{v|[<v>]}; anchor, wrap>!>>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("duh");
        a.setAttribute("data", (Object)new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        String expecting = "![1][2][3]\n [4][5][6]\n [7][8][9]!";
        this.assertEqual(a.toString(9), expecting);
    }

    public void testLineWrapForAnonTemplateComplicatedWrap() throws Exception {
        String templates = "group test;" + this.newline + "top(s) ::= <<  <s>.>>" + "str(data) ::= <<!<data:{v|[<v>]}; wrap=\"!+\\n!\">!>>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate t = group.getInstanceOf("top");
        StringTemplate s = group.getInstanceOf("str");
        s.setAttribute("data", (Object)new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        t.setAttribute("s", s);
        String expecting = "  ![1][2]!+\n  ![3][4]!+\n  ![5][6]!+\n  ![7][8]!+\n  ![9]!.";
        this.assertEqual(t.toString(9), expecting);
    }

    public void testIndentBeyondLineWidth() throws Exception {
        String templates = "group test;" + this.newline + "duh(chars) ::= <<    <chars; wrap=\"\\n\"\\>>>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("duh");
        a.setAttribute("chars", (Object)new String[]{"a", "b", "c", "d", "e"});
        String expecting = "    a\n    b\n    c\n    d\n    e";
        this.assertEqual(a.toString(2), expecting);
    }

    public void testIndentedExpr() throws Exception {
        String templates = "group test;" + this.newline + "duh(chars) ::= <<    <chars; wrap=\"\\n\"\\>>>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("duh");
        a.setAttribute("chars", (Object)new String[]{"a", "b", "c", "d", "e"});
        String expecting = "    ab\n    cd\n    e";
        this.assertEqual(a.toString(6), expecting);
    }

    public void testNestedIndentedExpr() throws Exception {
        String templates = "group test;" + this.newline + "top(d) ::= <<  <d>!>>" + this.newline + "duh(chars) ::= <<  <chars; wrap=\"\\n\"\\>>>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate top = group.getInstanceOf("top");
        StringTemplate duh = group.getInstanceOf("duh");
        duh.setAttribute("chars", (Object)new String[]{"a", "b", "c", "d", "e"});
        top.setAttribute("d", duh);
        String expecting = "    ab\n    cd\n    e!";
        this.assertEqual(top.toString(6), expecting);
    }

    public void testNestedWithIndentAndTrackStartOfExpr() throws Exception {
        String templates = "group test;" + this.newline + "top(d) ::= <<  <d>!>>" + this.newline + "duh(chars) ::= <<x: <chars; anchor, wrap=\"\\n\"\\>>>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate top = group.getInstanceOf("top");
        StringTemplate duh = group.getInstanceOf("duh");
        duh.setAttribute("chars", (Object)new String[]{"a", "b", "c", "d", "e"});
        top.setAttribute("d", duh);
        String expecting = "  x: ab\n     cd\n     e!";
        this.assertEqual(top.toString(7), expecting);
    }

    public void testLineDoesNotWrapDueToLiteral() throws Exception {
        String templates = "group test;" + this.newline + "m(args,body) ::= <<public void foo(<args; wrap=\"\\n\",separator=\", \">) throws Ick { <body> }>>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("m");
        a.setAttribute("args", (Object)new String[]{"a", "b", "c"});
        a.setAttribute("body", "i=3;");
        int n = "public void foo(a, b, c".length();
        String expecting = "public void foo(a, b, c) throws Ick { i=3; }";
        this.assertEqual(a.toString(n), expecting);
    }

    public void testSingleValueWrap() throws Exception {
        String templates = "group test;" + this.newline + "m(args,body) ::= <<{ <body; anchor, wrap=\"\\n\"> }>>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate m = group.getInstanceOf("m");
        m.setAttribute("body", "i=3;");
        String expecting = "{ \n  i=3; }";
        this.assertEqual(m.toString(2), expecting);
    }

    public void testLineWrapInNestedExpr() throws Exception {
        String templates = "group test;" + this.newline + "top(arrays) ::= <<Arrays: <arrays>done>>" + this.newline + "array(values) ::= <<int[] a = { <values; anchor, wrap=\"\\n\", separator=\",\"> };<\\n\\>>>" + this.newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate top = group.getInstanceOf("top");
        StringTemplate a = group.getInstanceOf("array");
        a.setAttribute("values", (Object)new int[]{3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 2, 1, 6, 32, 5, 6, 77, 4, 9, 20, 2, 1, 4, 63, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 6, 32, 5, 6, 77, 3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 1, 6, 32, 5});
        top.setAttribute("arrays", a);
        top.setAttribute("arrays", a);
        String expecting = "Arrays: int[] a = { 3,9,20,2,1,4,6,32,5,\n                    6,77,888,2,1,6,32,5,\n                    6,77,4,9,20,2,1,4,63,\n                    9,20,2,1,4,6,32,5,6,\n                    77,6,32,5,6,77,3,9,20,\n                    2,1,4,6,32,5,6,77,888,\n                    1,6,32,5 };\nint[] a = { 3,9,20,2,1,4,6,32,5,6,77,888,\n            2,1,6,32,5,6,77,4,9,20,2,1,4,\n            63,9,20,2,1,4,6,32,5,6,77,6,\n            32,5,6,77,3,9,20,2,1,4,6,32,\n            5,6,77,888,1,6,32,5 };\ndone";
        this.assertEqual(top.toString(40), expecting);
    }

    public void testEscapeEscape() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate t = group.defineTemplate("t", "\\\\$v$");
        t.setAttribute("v", "Joe");
        String expecting = "\\Joe";
        this.assertEqual(t.toString(), expecting);
    }

    public void testEscapeEscapeNestedAngle() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate t = group.defineTemplate("t", "<v:{a|\\\\<a>}>");
        t.setAttribute("v", "Joe");
        String expecting = "\\Joe";
        this.assertEqual(t.toString(), expecting);
    }

    public void testListOfIntArrays() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate t = group.defineTemplate("t", "<data:array()>");
        group.defineTemplate("array", "[<it:element(); separator=\",\">]");
        group.defineTemplate("element", "<it>");
        ArrayList<int[]> data = new ArrayList<int[]>();
        data.add(new int[]{1, 2, 3});
        data.add(new int[]{10, 20, 30});
        t.setAttribute("data", data);
        String expecting = "[1,2,3][10,20,30]";
        this.assertEqual(t.toString(), expecting);
    }

    public void testNullOptionSingleNullValue() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate t = group.defineTemplate("t", "<data; null=\"0\">");
        String expecting = "0";
        this.assertEqual(t.toString(), expecting);
    }

    public void testNullOptionHasEmptyNullValue() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate t = group.defineTemplate("t", "<data; null=\"\", separator=\", \">");
        ArrayList<Integer> data = new ArrayList<Integer>();
        data.add(null);
        data.add(new Integer(1));
        t.setAttribute("data", data);
        String expecting = ", 1";
        this.assertEqual(t.toString(), expecting);
    }

    public void testNullOptionSingleNullValueInList() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate t = group.defineTemplate("t", "<data; null=\"0\">");
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(null);
        t.setAttribute("data", data);
        String expecting = "0";
        this.assertEqual(t.toString(), expecting);
    }

    public void testNullValueInList() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate t = group.defineTemplate("t", "<data; null=\"-1\", separator=\", \">");
        ArrayList<Integer> data = new ArrayList<Integer>();
        data.add(null);
        data.add(new Integer(1));
        data.add(null);
        data.add(new Integer(3));
        data.add(new Integer(4));
        data.add(null);
        t.setAttribute("data", data);
        String expecting = "-1, 1, -1, 3, 4, -1";
        this.assertEqual(t.toString(), expecting);
    }

    public void testNullValueInListWithTemplateApply() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate t = group.defineTemplate("t", "<data:array(); null=\"-1\", separator=\", \">");
        group.defineTemplate("array", "<it>");
        ArrayList<Integer> data = new ArrayList<Integer>();
        data.add(new Integer(0));
        data.add(null);
        data.add(new Integer(2));
        data.add(null);
        t.setAttribute("data", data);
        String expecting = "0, -1, 2, -1";
        this.assertEqual(t.toString(), expecting);
    }

    public void testNullValueInListWithTemplateApplyNullFirstValue() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate t = group.defineTemplate("t", "<data:array(); null=\"-1\", separator=\", \">");
        group.defineTemplate("array", "<it>");
        ArrayList<Integer> data = new ArrayList<Integer>();
        data.add(null);
        data.add(new Integer(0));
        data.add(null);
        data.add(new Integer(2));
        t.setAttribute("data", data);
        String expecting = "-1, 0, -1, 2";
        this.assertEqual(t.toString(), expecting);
    }

    public void testNullSingleValueInListWithTemplateApply() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate t = group.defineTemplate("t", "<data:array(); null=\"-1\", separator=\", \">");
        group.defineTemplate("array", "<it>");
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(null);
        t.setAttribute("data", data);
        String expecting = "-1";
        this.assertEqual(t.toString(), expecting);
    }

    public void testNullSingleValueWithTemplateApply() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate t = group.defineTemplate("t", "<data:array(); null=\"-1\", separator=\", \">");
        group.defineTemplate("array", "<it>");
        String expecting = "-1";
        this.assertEqual(t.toString(), expecting);
    }

    public static void writeFile(String dir, String fileName, String content) {
        try {
            File f = new File(dir, fileName);
            FileWriter w = new FileWriter(f);
            BufferedWriter bw = new BufferedWriter(w);
            bw.write(content);
            bw.close();
            w.close();
        }
        catch (IOException ioe) {
            System.err.println("can't write file");
            ioe.printStackTrace(System.err);
        }
    }

    public static class NonPublicProperty {
    }

    public class DateRenderer2
    implements AttributeRenderer {
        public String toString(Object o) {
            SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy");
            return f.format(((Calendar)o).getTime());
        }
    }

    public class DateRenderer
    implements AttributeRenderer {
        public String toString(Object o) {
            SimpleDateFormat f = new SimpleDateFormat("yyyy.MM.dd");
            return f.format(((Calendar)o).getTime());
        }
    }

    static class Duh {
        public List users = new ArrayList();

        Duh() {
        }
    }

    public static class Decl {
        String name;
        String type;

        public Decl(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }

    public class Connector3 {
        public int[] getValues() {
            return new int[]{1, 2, 3};
        }

        public Map getStuff() {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("a", "1");
            m.put("b", "2");
            return m;
        }
    }

    public static class Tree {
        protected List children = new LinkedList();
        protected String text;

        public Tree(String t) {
            this.text = t;
        }

        public String getText() {
            return this.text;
        }

        public void addChild(Tree c) {
            this.children.add(c);
        }

        public Tree getFirstChild() {
            if (this.children.size() == 0) {
                return null;
            }
            return (Tree)this.children.get(0);
        }

        public List getChildren() {
            return this.children;
        }
    }

    public class Connector2 {
        public int getID() {
            return 2;
        }

        public String getFirstName() {
            return "Tom";
        }

        public String getLastName() {
            return "Burns";
        }

        public String getEmail() {
            return "tombu@jguru.com";
        }

        public String getBio() {
            return "Superhero by day...";
        }

        public Boolean getCanEdit() {
            return new Boolean(true);
        }
    }

    public class Connector {
        public int getID() {
            return 1;
        }

        public String getFirstName() {
            return "Terence";
        }

        public String getLastName() {
            return "Parr";
        }

        public String getEmail() {
            return "parrt@jguru.com";
        }

        public String getBio() {
            return "Superhero by night...";
        }

        public boolean getCanEdit() {
            return false;
        }
    }

    static class ErrorBuffer
    implements StringTemplateErrorListener {
        StringBuffer errorOutput = new StringBuffer(500);
        int n = 0;

        ErrorBuffer() {
        }

        public void error(String msg, Throwable e) {
            ++this.n;
            if (this.n > 1) {
                this.errorOutput.append('\n');
            }
            if (e != null) {
                StringWriter duh = new StringWriter();
                e.printStackTrace(new PrintWriter(duh));
                this.errorOutput.append(msg + ": " + duh.toString());
            } else {
                this.errorOutput.append(msg);
            }
        }

        public void warning(String msg) {
            ++this.n;
            this.errorOutput.append(msg);
        }

        public boolean equals(Object o) {
            String me = this.toString();
            String them = o.toString();
            return me.equals(them);
        }

        public String toString() {
            return this.errorOutput.toString();
        }
    }
}

