/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate.test;

import java.lang.reflect.Method;
import org.antlr.stringtemplate.test.TestSuite;

public class TestRig {
    protected Class testCaseClass = null;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Please pass in a test to run; must be class with runTests() method");
        }
        String className = args[0];
        TestSuite test = null;
        try {
            Class<?> c;
            try {
                c = Class.forName(className);
                test = (TestSuite)c.newInstance();
            }
            catch (Exception e) {
                System.out.println("Cannot load class: " + className);
                e.printStackTrace();
                return;
            }
            if (args.length > 1) {
                String testName = args[1];
                test.runTest(testName);
            } else {
                try {
                    Method m = c.getMethod("runTests", null);
                    m.invoke((Object)test, (Object[])null);
                }
                catch (NoSuchMethodException nsme) {
                    TestRig.runAllTests(c, test);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception during test " + test.testName);
            e.printStackTrace();
        }
        System.out.println();
        System.out.println("successes: " + test.getSuccesses());
        System.out.println("failures: " + test.getFailures());
    }

    public static void runAllTests(Class c, TestSuite test) {
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method testMethod = methods[i];
            if (!testMethod.getName().startsWith("test")) continue;
            test.runTest(testMethod.getName());
        }
    }
}

