/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.FailedPredicateException;
import org.antlr.runtime.MismatchedNotSetException;
import org.antlr.runtime.MismatchedRangeException;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;

public abstract class Lexer
extends BaseRecognizer
implements TokenSource {
    protected CharStream input;
    protected Token token;
    protected int tokenStartCharIndex = -1;
    protected String text;
    protected int ruleNestingLevel;

    public Lexer() {
    }

    public Lexer(CharStream charStream) {
        this.input = charStream;
    }

    public Token nextToken() {
        while (true) {
            this.token = null;
            this.tokenStartCharIndex = this.getCharIndex();
            if (this.input.LA(1) == -1) {
                return Token.EOF_TOKEN;
            }
            try {
                this.mTokens();
                if (this.token == Token.SKIP_TOKEN) continue;
                return this.token;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                this.recover(recognitionException);
                continue;
            }
            break;
        }
    }

    public void skip() {
        this.token = Token.SKIP_TOKEN;
    }

    public abstract void mTokens() throws RecognitionException;

    public void setCharStream(CharStream charStream) {
        this.input = charStream;
        this.token = null;
        this.tokenStartCharIndex = -1;
        this.ruleNestingLevel = 0;
    }

    public void emit(Token token) {
        this.token = token;
    }

    public Token emit(int n, int n2, int n3, int n4, int n5, int n6) {
        CommonToken commonToken = new CommonToken(this.input, n, n4, n5, n6);
        ((Token)commonToken).setLine(n2);
        ((Token)commonToken).setText(this.text);
        ((Token)commonToken).setCharPositionInLine(n3);
        this.emit(commonToken);
        return commonToken;
    }

    public void match(String string) throws MismatchedTokenException {
        for (int i = 0; i < string.length(); ++i) {
            if (this.input.LA(1) != string.charAt(i)) {
                if (this.backtracking > 0) {
                    this.failed = true;
                    return;
                }
                MismatchedTokenException mismatchedTokenException = new MismatchedTokenException(string.charAt(i), this.input);
                this.recover(mismatchedTokenException);
                throw mismatchedTokenException;
            }
            this.input.consume();
            this.failed = false;
        }
    }

    public void matchAny() {
        this.input.consume();
    }

    public void match(int n) throws MismatchedTokenException {
        if (this.input.LA(1) != n) {
            if (this.backtracking > 0) {
                this.failed = true;
                return;
            }
            MismatchedTokenException mismatchedTokenException = new MismatchedTokenException(n, this.input);
            this.recover(mismatchedTokenException);
            throw mismatchedTokenException;
        }
        this.input.consume();
        this.failed = false;
    }

    public void matchRange(int n, int n2) throws MismatchedRangeException {
        if (this.input.LA(1) < n || this.input.LA(1) > n2) {
            if (this.backtracking > 0) {
                this.failed = true;
                return;
            }
            MismatchedRangeException mismatchedRangeException = new MismatchedRangeException(n, n2, this.input);
            this.recover(mismatchedRangeException);
            throw mismatchedRangeException;
        }
        this.input.consume();
        this.failed = false;
    }

    public int getLine() {
        return this.input.getLine();
    }

    public int getCharPositionInLine() {
        return this.input.getCharPositionInLine();
    }

    public int getCharIndex() {
        return this.input.index();
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        return this.input.substring(this.tokenStartCharIndex, this.getCharIndex() - 1);
    }

    public void setText(String string) {
        this.text = string;
    }

    public void reportError(RecognitionException recognitionException) {
        Lexer.displayRecognitionError(this.getClass().getName(), recognitionException);
    }

    public static void displayRecognitionError(String string, RecognitionException recognitionException) {
        System.err.print(Lexer.getRuleInvocationStack(recognitionException, string) + ": line " + recognitionException.line + ":" + recognitionException.charPositionInLine + " ");
        if (recognitionException instanceof MismatchedTokenException) {
            MismatchedTokenException mismatchedTokenException = (MismatchedTokenException)recognitionException;
            System.err.println("mismatched char: '" + (char)recognitionException.c + "' on line " + recognitionException.line + "; expecting char '" + (char)mismatchedTokenException.expecting + "'");
        } else if (recognitionException instanceof NoViableAltException) {
            NoViableAltException noViableAltException = (NoViableAltException)recognitionException;
            System.err.println(noViableAltException.grammarDecisionDescription + " state " + noViableAltException.stateNumber + " (decision=" + noViableAltException.decisionNumber + ") no viable alt line " + recognitionException.line + ":" + recognitionException.charPositionInLine + "; char='" + (char)recognitionException.c + "'");
        } else if (recognitionException instanceof EarlyExitException) {
            EarlyExitException earlyExitException = (EarlyExitException)recognitionException;
            System.err.println("required (...)+ loop (decision=" + earlyExitException.decisionNumber + ") did not match anything; on line " + recognitionException.line + ":" + recognitionException.charPositionInLine + " char=" + (char)recognitionException.c + "'");
        } else if (recognitionException instanceof MismatchedSetException) {
            MismatchedSetException mismatchedSetException = (MismatchedSetException)recognitionException;
            System.err.println("mismatched char: '" + (char)recognitionException.c + "' on line " + recognitionException.line + ":" + recognitionException.charPositionInLine + "; expecting set " + mismatchedSetException.expecting);
        } else if (recognitionException instanceof MismatchedNotSetException) {
            MismatchedSetException mismatchedSetException = (MismatchedSetException)recognitionException;
            System.err.println("mismatched char: '" + (char)recognitionException.c + "' on line " + recognitionException.line + ":" + recognitionException.charPositionInLine + "; expecting set " + mismatchedSetException.expecting);
        } else if (recognitionException instanceof MismatchedRangeException) {
            MismatchedRangeException mismatchedRangeException = (MismatchedRangeException)recognitionException;
            System.err.println("mismatched char: '" + (char)recognitionException.c + "' on line " + recognitionException.line + ":" + recognitionException.charPositionInLine + "; expecting set '" + (char)mismatchedRangeException.a + "'..'" + (char)mismatchedRangeException.b + "'");
        } else if (recognitionException instanceof FailedPredicateException) {
            FailedPredicateException failedPredicateException = (FailedPredicateException)recognitionException;
            System.err.println("rule " + failedPredicateException.ruleName + " failed predicate: {" + failedPredicateException.predicateText + "}?");
        }
    }

    public void recover(RecognitionException recognitionException) {
        this.input.consume();
    }
}

