/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.FailedPredicateException;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.MismatchedNotSetException;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.MismatchedTreeNodeException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RuleReturnScope;
import org.antlr.runtime.Token;
import org.antlr.stringtemplate.StringTemplate;

public abstract class BaseRecognizer {
    public static final int MEMO_RULE_FAILED = -2;
    public static final int MEMO_RULE_UNKNOWN = -1;
    public static final int INITIAL_FOLLOW_STACK_SIZE = 100;
    protected BitSet[] following = new BitSet[100];
    protected int _fsp = -1;
    protected boolean errorRecovery = false;
    protected int lastErrorIndex = -1;
    protected boolean failed = false;
    protected int backtracking = 0;
    protected Map[] ruleMemo;

    public void reset() {
    }

    public void match(IntStream intStream, int n, BitSet bitSet) throws RecognitionException {
        if (intStream.LA(1) == n) {
            intStream.consume();
            this.errorRecovery = false;
            this.failed = false;
            return;
        }
        if (this.backtracking > 0) {
            this.failed = true;
            return;
        }
        this.mismatch(intStream, n, bitSet);
    }

    public void matchAny(IntStream intStream) {
        this.errorRecovery = false;
        this.failed = false;
        intStream.consume();
    }

    protected void mismatch(IntStream intStream, int n, BitSet bitSet) throws RecognitionException {
        MismatchedTokenException mismatchedTokenException = new MismatchedTokenException(n, intStream);
        this.recoverFromMismatchedToken(intStream, mismatchedTokenException, n, bitSet);
    }

    public void reportError(RecognitionException recognitionException) {
        if (this.errorRecovery) {
            return;
        }
        this.errorRecovery = true;
        BaseRecognizer.displayRecognitionError(this.getClass().getName(), this.getTokenNames(), recognitionException);
    }

    public static void displayRecognitionError(String string, String[] stringArray, RecognitionException recognitionException) {
        System.err.print(BaseRecognizer.getRuleInvocationStack(recognitionException, string) + ": line " + recognitionException.line + ":" + recognitionException.charPositionInLine + " ");
        if (recognitionException instanceof MismatchedTokenException) {
            MismatchedTokenException mismatchedTokenException = (MismatchedTokenException)recognitionException;
            String string2 = "<unknown>";
            string2 = mismatchedTokenException.expecting == -1 ? "EOF" : stringArray[mismatchedTokenException.expecting];
            System.err.println("mismatched token: " + recognitionException.token + "; expecting type " + string2);
        } else if (recognitionException instanceof MismatchedTreeNodeException) {
            MismatchedTreeNodeException mismatchedTreeNodeException = (MismatchedTreeNodeException)recognitionException;
            String string3 = "<unknown>";
            string3 = mismatchedTreeNodeException.expecting == -1 ? "EOF" : stringArray[mismatchedTreeNodeException.expecting];
            System.err.println("mismatched tree node: " + mismatchedTreeNodeException.foundNode + "; expecting type " + string3);
        } else if (recognitionException instanceof NoViableAltException) {
            NoViableAltException noViableAltException = (NoViableAltException)recognitionException;
            System.err.println("state " + noViableAltException.stateNumber + " (decision=" + noViableAltException.decisionNumber + ") no viable alt; token=" + recognitionException.token);
        } else if (recognitionException instanceof EarlyExitException) {
            EarlyExitException earlyExitException = (EarlyExitException)recognitionException;
            System.err.println("required (...)+ loop (decision=" + earlyExitException.decisionNumber + ") did not match anything; token=" + recognitionException.token);
        } else if (recognitionException instanceof MismatchedSetException) {
            MismatchedSetException mismatchedSetException = (MismatchedSetException)recognitionException;
            System.err.println("mismatched token: " + recognitionException.token + "; expecting set " + mismatchedSetException.expecting);
        } else if (recognitionException instanceof MismatchedNotSetException) {
            MismatchedNotSetException mismatchedNotSetException = (MismatchedNotSetException)recognitionException;
            System.err.println("mismatched token: " + recognitionException.token + "; expecting set " + mismatchedNotSetException.expecting);
        } else if (recognitionException instanceof FailedPredicateException) {
            FailedPredicateException failedPredicateException = (FailedPredicateException)recognitionException;
            System.err.println("rule " + failedPredicateException.ruleName + " failed predicate: {" + failedPredicateException.predicateText + "}?");
        }
    }

    public void recover(IntStream intStream, RecognitionException recognitionException) {
        if (this.lastErrorIndex == intStream.index()) {
            intStream.consume();
        }
        this.lastErrorIndex = intStream.index();
        BitSet bitSet = this.computeErrorRecoverySet();
        this.beginResync();
        this.consumeUntil(intStream, bitSet);
        this.endResync();
    }

    public void beginResync() {
    }

    public void endResync() {
    }

    protected BitSet computeErrorRecoverySet() {
        return this.combineFollows(false);
    }

    protected BitSet computeContextSensitiveRuleFOLLOW() {
        return this.combineFollows(true);
    }

    protected BitSet combineFollows(boolean bl) {
        int n = this._fsp;
        BitSet bitSet = new BitSet();
        for (int i = n; i >= 0; --i) {
            BitSet bitSet2 = this.following[i];
            bitSet.orInPlace(bitSet2);
            if (bl && !bitSet2.member(1)) break;
        }
        bitSet.remove(1);
        return bitSet;
    }

    public void recoverFromMismatchedToken(IntStream intStream, RecognitionException recognitionException, int n, BitSet bitSet) throws RecognitionException {
        if (intStream.LA(2) == n) {
            this.reportError(recognitionException);
            this.beginResync();
            intStream.consume();
            this.endResync();
            intStream.consume();
            return;
        }
        if (!this.recoverFromMismatchedElement(intStream, recognitionException, bitSet)) {
            throw recognitionException;
        }
    }

    public void recoverFromMismatchedSet(IntStream intStream, RecognitionException recognitionException, BitSet bitSet) throws RecognitionException {
        if (!this.recoverFromMismatchedElement(intStream, recognitionException, bitSet)) {
            throw recognitionException;
        }
    }

    protected boolean recoverFromMismatchedElement(IntStream intStream, RecognitionException recognitionException, BitSet bitSet) {
        if (bitSet == null) {
            return false;
        }
        if (bitSet.member(1)) {
            BitSet bitSet2 = this.computeContextSensitiveRuleFOLLOW();
            bitSet = bitSet.or(bitSet2);
            bitSet.remove(1);
        }
        if (bitSet.member(intStream.LA(1))) {
            this.reportError(recognitionException);
            return true;
        }
        return false;
    }

    public void consumeUntil(IntStream intStream, int n) {
        int n2 = intStream.LA(1);
        while (n2 != -1 && n2 != n) {
            intStream.consume();
            n2 = intStream.LA(1);
        }
    }

    public void consumeUntil(IntStream intStream, BitSet bitSet) {
        int n = intStream.LA(1);
        while (n != -1 && !bitSet.member(n)) {
            intStream.consume();
            n = intStream.LA(1);
        }
    }

    protected void pushFollow(BitSet bitSet) {
        if (this._fsp + 1 >= this.following.length) {
            BitSet[] bitSetArray = new BitSet[this.following.length * 2];
            System.arraycopy(this.following, 0, bitSetArray, 0, this.following.length - 1);
            this.following = bitSetArray;
        }
        this.following[++this._fsp] = bitSet;
    }

    public List getRuleInvocationStack() {
        String string = this.getClass().getName();
        return BaseRecognizer.getRuleInvocationStack(new Throwable(), string);
    }

    public static List getRuleInvocationStack(Throwable throwable, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = 0;
        for (n = stackTraceElementArray.length - 1; n >= 0; --n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n];
            if (stackTraceElement.getClassName().startsWith("org.antlr.runtime.") || stackTraceElement.getMethodName().equals("nextToken") || !stackTraceElement.getClassName().equals(string)) continue;
            arrayList.add(stackTraceElement.getMethodName());
        }
        return arrayList;
    }

    public int getBacktrackingLevel() {
        return this.backtracking;
    }

    public String[] getTokenNames() {
        return null;
    }

    public String getGrammarFileName() {
        return null;
    }

    public List toStrings(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(((Token)list.get(i)).getText());
        }
        return arrayList;
    }

    public List toTemplates(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<StringTemplate> arrayList = new ArrayList<StringTemplate>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(((RuleReturnScope)list.get(i)).getTemplate());
        }
        return arrayList;
    }

    public int getRuleMemoization(int n, int n2) {
        Integer n3;
        if (this.ruleMemo[n] == null) {
            this.ruleMemo[n] = new HashMap();
        }
        if ((n3 = (Integer)this.ruleMemo[n].get(new Integer(n2))) == null) {
            return -1;
        }
        return n3;
    }

    public boolean alreadyParsedRule(IntStream intStream, int n) {
        int n2 = this.getRuleMemoization(n, intStream.index());
        if (n2 == -1) {
            return false;
        }
        if (n2 == -2) {
            this.failed = true;
        } else {
            intStream.seek(n2 + 1);
        }
        return true;
    }

    public void memoize(IntStream intStream, int n, int n2) {
        int n3;
        int n4 = n3 = this.failed ? -2 : intStream.index() - 1;
        if (this.ruleMemo[n] != null) {
            this.ruleMemo[n].put(new Integer(n2), new Integer(n3));
        }
    }

    public int getRuleMemoizationCacheSize() {
        int n = 0;
        for (int i = 0; this.ruleMemo != null && i < this.ruleMemo.length; ++i) {
            Map map = this.ruleMemo[i];
            if (map == null) continue;
            n += map.size();
        }
        return n;
    }
}

