/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFAConfiguration;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.State;
import org.antlr.analysis.Transition;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;

public class DecisionProbe {
    public DFA dfa;
    protected Set statesWithSyntacticallyAmbiguousAltsSet = new HashSet();
    protected Map stateToSyntacticallyAmbiguousTokensRuleAltsMap = new HashMap();
    protected Set statesResolvedWithSemanticPredicatesSet = new HashSet();
    protected Map stateToAltSetWithSemanticPredicatesMap = new HashMap();
    protected Map stateToIncompletelyCoveredAltsMap = new HashMap();
    protected Set danglingStates = new HashSet();
    protected Set altsWithProblem = new HashSet();
    protected boolean nonRegularDecision = false;
    protected Map stateToRecursiveOverflowConfigurationsMap = new HashMap();
    protected Map stateToLeftRecursiveConfigurationsMap = new HashMap();
    protected boolean terminated = false;
    protected Map stateReachable;
    public static final Integer REACHABLE_BUSY = new Integer(-1);
    public static final Integer REACHABLE_NO = new Integer(0);
    public static final Integer REACHABLE_YES = new Integer(1);
    protected Set statesVisitedAtInputDepth;
    protected Set statesVisitedDuringSampleSequence;
    public static boolean verbose = false;

    public DecisionProbe(DFA dFA) {
        this.dfa = dFA;
    }

    public String getDescription() {
        return this.dfa.getNFADecisionStartState().getDescription();
    }

    public boolean isReduced() {
        return this.dfa.isReduced();
    }

    public boolean isCyclic() {
        return this.dfa.isCyclic();
    }

    public boolean isDeterministic() {
        if (this.danglingStates.size() == 0 && this.statesWithSyntacticallyAmbiguousAltsSet.size() == 0 && this.dfa.getUnreachableAlts().size() == 0) {
            return true;
        }
        if (this.statesWithSyntacticallyAmbiguousAltsSet.size() > 0) {
            Iterator iterator = this.statesWithSyntacticallyAmbiguousAltsSet.iterator();
            while (iterator.hasNext()) {
                DFAState dFAState = (DFAState)iterator.next();
                if (this.statesResolvedWithSemanticPredicatesSet.contains(dFAState)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean analysisAborted() {
        return this.terminated;
    }

    public boolean analysisOverflowed() {
        return this.stateToRecursiveOverflowConfigurationsMap.size() > 0;
    }

    public boolean nonRegularDecision() {
        return this.nonRegularDecision;
    }

    public int getNumberOfStates() {
        return this.dfa.getNumberOfStates();
    }

    public List getUnreachableAlts() {
        return this.dfa.getUnreachableAlts();
    }

    public Set getDanglingStates() {
        return this.danglingStates;
    }

    public Set getNonDeterministicAlts() {
        return this.altsWithProblem;
    }

    public List getNonDeterministicAltsForState(DFAState dFAState) {
        Set set = dFAState.getNondeterministicAlts();
        if (set == null) {
            return null;
        }
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(set);
        Collections.sort(linkedList);
        return linkedList;
    }

    public Set getDFAStatesWithSyntacticallyAmbiguousAlts() {
        return this.statesWithSyntacticallyAmbiguousAltsSet;
    }

    public Set getDisabledAlternatives(DFAState dFAState) {
        return dFAState.getDisabledAlternatives();
    }

    public void removeRecursiveOverflowState(DFAState dFAState) {
        Integer n = new Integer(dFAState.stateNumber);
        this.stateToRecursiveOverflowConfigurationsMap.remove(n);
    }

    public List getSampleNonDeterministicInputSequence(DFAState dFAState) {
        Set set = this.getDFAPathStatesToTarget(dFAState);
        this.statesVisitedDuringSampleSequence = new HashSet();
        ArrayList arrayList = new ArrayList();
        this.getSampleInputSequenceUsingStateSet(this.dfa.startState, dFAState, set, arrayList);
        return arrayList;
    }

    public String getInputSequenceDisplay(List list) {
        Grammar grammar = this.dfa.nfa.grammar;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Label label = (Label)iterator.next();
            stringBuffer.append(label.toString(grammar));
            if (!iterator.hasNext() || grammar.type == 1) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public List getNFAPathStatesForAlt(int n, int n2, List list) {
        NFAState nFAState;
        NFAState nFAState2 = this.dfa.getNFADecisionStartState();
        LinkedList<NFAState> linkedList = new LinkedList<NFAState>();
        for (int i = n; i <= n2; ++i) {
            nFAState = this.dfa.nfa.grammar.getNFAStateForAltOfDecision(nFAState2, i);
            linkedList.add(nFAState);
        }
        NFAState nFAState3 = this.dfa.nfa.grammar.getNFAStateForAltOfDecision(nFAState2, n2);
        nFAState = (NFAState)nFAState3.transition((int)0).target;
        linkedList.add(nFAState);
        this.statesVisitedAtInputDepth = new HashSet();
        this.getNFAPath(nFAState, 0, list, linkedList);
        return linkedList;
    }

    public SemanticContext getSemanticContextForAlt(DFAState dFAState, int n) {
        Map map = (Map)this.stateToAltSetWithSemanticPredicatesMap.get(dFAState);
        if (map == null) {
            return null;
        }
        return (SemanticContext)map.get(new Integer(n));
    }

    public Set getNondeterministicStatesResolvedWithSemanticPredicate() {
        return this.statesResolvedWithSemanticPredicatesSet;
    }

    public List getIncompletelyCoveredAlts(DFAState dFAState) {
        return (List)this.stateToIncompletelyCoveredAltsMap.get(dFAState);
    }

    public void issueWarnings() {
        Object object;
        Object object2;
        Object object3;
        if (this.analysisAborted()) {
            if (!this.dfa.getAutoBacktrackMode()) {
                ErrorManager.analysisAborted(this);
            }
            return;
        }
        if (this.nonRegularDecision && !this.dfa.getAutoBacktrackMode()) {
            ErrorManager.nonRegularDecision(this);
        }
        this.issueRecursionWarnings();
        Set set = this.getNondeterministicStatesResolvedWithSemanticPredicate();
        Set set2 = this.getDFAStatesWithSyntacticallyAmbiguousAlts();
        if (set2.size() > 0) {
            object3 = set2.iterator();
            while (object3.hasNext()) {
                object2 = (DFAState)object3.next();
                if (set == null || !set.contains(object2)) {
                    ErrorManager.nondeterminism(this, (DFAState)object2);
                }
                if ((object = this.getIncompletelyCoveredAlts((DFAState)object2)) == null || object.size() <= 0) continue;
                ErrorManager.insufficientPredicates(this, (List)object);
            }
        }
        if ((object3 = this.getDanglingStates()).size() > 0) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (DFAState)object2.next();
                ErrorManager.danglingState(this, (DFAState)object);
            }
        }
        if (!this.nonRegularDecision && (object2 = this.dfa.getUnreachableAlts()) != null && object2.size() > 0) {
            ErrorManager.unreachableAlts(this, (List)object2);
        }
    }

    protected void issueRecursionWarnings() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Set set = this.stateToRecursiveOverflowConfigurationsMap.keySet();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        this.computeAltToProblemMaps(set, this.stateToRecursiveOverflowConfigurationsMap, hashMap, hashMap2);
        Set set2 = hashMap.keySet();
        ArrayList arrayList = new ArrayList(set2);
        Collections.sort(arrayList);
        Object object6 = arrayList.iterator();
        while (object6.hasNext()) {
            object5 = (Integer)object6.next();
            object4 = (Map)hashMap.get(object5);
            object3 = object4.keySet();
            object2 = object4.values();
            object = (DFAState)hashMap2.get(object5);
            ErrorManager.recursionOverflow(this, (DFAState)object, (Integer)object5, object3, object2);
        }
        object6 = this.stateToLeftRecursiveConfigurationsMap.keySet();
        object5 = this.getUnaliasedDFAStateSet((Set)object6);
        hashMap = new HashMap();
        hashMap2 = new HashMap();
        this.computeAltToProblemMaps((Set)object5, this.stateToLeftRecursiveConfigurationsMap, hashMap, hashMap2);
        set2 = hashMap.keySet();
        arrayList = new ArrayList(set2);
        Collections.sort(arrayList);
        object4 = arrayList.iterator();
        while (object4.hasNext()) {
            object3 = (Integer)object4.next();
            object2 = (Map)hashMap.get(object3);
            object = object2.keySet();
            Collection collection = object2.values();
            ErrorManager.leftRecursion(this, (Integer)object3, (Collection)object, collection);
        }
    }

    private void computeAltToProblemMaps(Set set, Map map, Map map2, Map map3) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            List list = (List)map.get(n);
            for (int i = 0; i < list.size(); ++i) {
                HashSet<NFAState> hashSet;
                NFAConfiguration nFAConfiguration = (NFAConfiguration)list.get(i);
                NFAState nFAState = this.dfa.nfa.getState(nFAConfiguration.state);
                Transition transition = nFAState.transition(0);
                RuleClosureTransition ruleClosureTransition = (RuleClosureTransition)transition;
                String string = ((NFAState)ruleClosureTransition.target).getEnclosingRule();
                Integer n2 = new Integer(nFAConfiguration.alt);
                HashMap<String, HashSet<NFAState>> hashMap = (HashMap<String, HashSet<NFAState>>)map2.get(n2);
                if (hashMap == null) {
                    hashMap = new HashMap<String, HashSet<NFAState>>();
                    map2.put(n2, hashMap);
                }
                if ((hashSet = (HashSet<NFAState>)hashMap.get(string)) == null) {
                    hashSet = new HashSet<NFAState>();
                    hashMap.put(string, hashSet);
                }
                hashSet.add(nFAState);
                if (map3.get(n2) != null) continue;
                DFAState dFAState = this.dfa.getState(n);
                map3.put(n2, dFAState);
            }
        }
    }

    private Set getUnaliasedDFAStateSet(Set set) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            DFAState dFAState = this.dfa.getState(n);
            hashSet.add(new Integer(dFAState.stateNumber));
        }
        return hashSet;
    }

    public void reportDanglingState(DFAState dFAState) {
        this.danglingStates.add(dFAState);
    }

    public void reportEarlyTermination() {
        this.terminated = true;
        this.dfa.nfa.grammar.setOfDFAWhoseConversionTerminatedEarly.add(this.dfa);
    }

    public void reportNonRegularDecision(DFA dFA) {
        this.nonRegularDecision = true;
        this.altsWithProblem.addAll(dFA.recursiveAltSet.toList());
    }

    public void reportRecursiveOverflow(DFAState dFAState, NFAConfiguration nFAConfiguration) {
        Integer n = new Integer(dFAState.stateNumber);
        ArrayList<NFAConfiguration> arrayList = (ArrayList<NFAConfiguration>)this.stateToRecursiveOverflowConfigurationsMap.get(n);
        if (arrayList == null) {
            arrayList = new ArrayList<NFAConfiguration>();
            arrayList.add(nFAConfiguration);
            this.stateToRecursiveOverflowConfigurationsMap.put(n, arrayList);
        } else {
            arrayList.add(nFAConfiguration);
        }
    }

    public void reportLeftRecursion(DFAState dFAState, NFAConfiguration nFAConfiguration) {
        Integer n = new Integer(dFAState.stateNumber);
        ArrayList<NFAConfiguration> arrayList = (ArrayList<NFAConfiguration>)this.stateToLeftRecursiveConfigurationsMap.get(n);
        if (arrayList == null) {
            arrayList = new ArrayList<NFAConfiguration>();
            arrayList.add(nFAConfiguration);
            this.stateToLeftRecursiveConfigurationsMap.put(n, arrayList);
        } else {
            arrayList.add(nFAConfiguration);
        }
    }

    public void reportNondeterminism(DFAState dFAState) {
        this.altsWithProblem.addAll(dFAState.getNondeterministicAlts());
        this.statesWithSyntacticallyAmbiguousAltsSet.add(dFAState);
        this.dfa.nfa.grammar.setOfNondeterministicDecisionNumbers.add(new Integer(this.dfa.getDecisionNumber()));
    }

    public void reportLexerRuleNondeterminism(DFAState dFAState, Set set) {
        this.stateToSyntacticallyAmbiguousTokensRuleAltsMap.put(dFAState, set);
    }

    public void reportNondeterminismResolvedWithSemanticPredicate(DFAState dFAState) {
        this.statesResolvedWithSemanticPredicatesSet.add(dFAState);
        this.dfa.nfa.grammar.setOfNondeterministicDecisionNumbersResolvedWithPredicates.add(new Integer(this.dfa.getDecisionNumber()));
    }

    public void reportAltPredicateContext(DFAState dFAState, Map map) {
        HashMap hashMap = new HashMap();
        hashMap.putAll(map);
        this.stateToAltSetWithSemanticPredicatesMap.put(dFAState, hashMap);
    }

    public void reportIncompletelyCoveredAlts(DFAState dFAState, List list) {
        this.stateToIncompletelyCoveredAltsMap.put(dFAState, list);
    }

    protected boolean reachesState(DFAState dFAState, DFAState dFAState2, Set set) {
        if (dFAState == dFAState2) {
            set.add(dFAState2);
            this.stateReachable.put(dFAState, REACHABLE_YES);
            return true;
        }
        DFAState dFAState3 = dFAState;
        this.stateReachable.put(dFAState3, REACHABLE_BUSY);
        for (int i = 0; i < dFAState3.getNumberOfTransitions(); ++i) {
            Transition transition = dFAState3.transition(i);
            DFAState dFAState4 = (DFAState)transition.target;
            Integer n = (Integer)this.stateReachable.get(dFAState4);
            if (n == REACHABLE_BUSY) continue;
            if (n == REACHABLE_YES) {
                this.stateReachable.put(dFAState3, REACHABLE_YES);
                return true;
            }
            if (n == REACHABLE_NO || !this.reachesState(dFAState4, dFAState2, set)) continue;
            set.add(dFAState3);
            this.stateReachable.put(dFAState3, REACHABLE_YES);
            return true;
        }
        this.stateReachable.put(dFAState3, REACHABLE_NO);
        return false;
    }

    protected Set getDFAPathStatesToTarget(DFAState dFAState) {
        HashSet hashSet = new HashSet();
        this.stateReachable = new HashMap();
        boolean bl = this.reachesState(this.dfa.startState, dFAState, hashSet);
        return hashSet;
    }

    protected void getSampleInputSequenceUsingStateSet(State state, State state2, Set set, List list) {
        this.statesVisitedDuringSampleSequence.add(state);
        for (int i = 0; i < state.getNumberOfTransitions(); ++i) {
            Transition transition = state.transition(i);
            DFAState dFAState = (DFAState)transition.target;
            if (!set.contains(dFAState) || this.statesVisitedDuringSampleSequence.contains(dFAState)) continue;
            list.add(transition.label);
            if (dFAState != state2) {
                this.getSampleInputSequenceUsingStateSet(dFAState, state2, set, list);
            }
            return;
        }
        list.add(new Label(-5));
    }

    protected boolean getNFAPath(NFAState nFAState, int n, List list, List list2) {
        String string = this.getStateLabelIndexKey(nFAState.stateNumber, n);
        if (this.statesVisitedAtInputDepth.contains(string)) {
            return false;
        }
        this.statesVisitedAtInputDepth.add(string);
        for (int i = 0; i < nFAState.getNumberOfTransitions(); ++i) {
            boolean bl;
            Transition transition = nFAState.transition(i);
            NFAState nFAState2 = (NFAState)transition.target;
            Label label = (Label)list.get(n);
            if (transition.label.isEpsilon()) {
                list2.add(nFAState2);
                bl = this.getNFAPath(nFAState2, n, list, list2);
                if (bl) {
                    this.statesVisitedAtInputDepth.remove(string);
                    return true;
                }
                list2.remove(list2.size() - 1);
                continue;
            }
            if (!transition.label.matches(label)) continue;
            list2.add(nFAState2);
            if (n == list.size() - 1) {
                this.statesVisitedAtInputDepth.remove(string);
                return true;
            }
            bl = this.getNFAPath(nFAState2, n + 1, list, list2);
            if (bl) {
                this.statesVisitedAtInputDepth.remove(string);
                return true;
            }
            list2.remove(list2.size() - 1);
        }
        this.statesVisitedAtInputDepth.remove(string);
        return false;
    }

    protected String getStateLabelIndexKey(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append('_');
        stringBuffer.append(n2);
        return stringBuffer.toString();
    }

    public String getTokenNameForTokensRuleAlt(int n) {
        NFAState nFAState = this.dfa.getNFADecisionStartState();
        NFAState nFAState2 = this.dfa.nfa.grammar.getNFAStateForAltOfDecision(nFAState, n);
        NFAState nFAState3 = (NFAState)nFAState2.transition((int)0).target;
        RuleClosureTransition ruleClosureTransition = (RuleClosureTransition)nFAState3.transition(0);
        NFAState nFAState4 = (NFAState)ruleClosureTransition.target;
        return nFAState4.getEnclosingRule();
    }
}

